/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.action;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.HeapDumpAnalysisSupport;
import com.intellij.diagnostic.hprof.action.AnalysisRunnableKt;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diagnostic/hprof/action/ShowReportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "reportText", "", "heapProperties", "Lcom/intellij/diagnostic/report/HeapReportProperties;", "<init>", "(Ljava/lang/String;Lcom/intellij/diagnostic/report/HeapReportProperties;)V", "textArea", "Ljavax/swing/JTextArea;", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createDefaultActions", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAnalysisRunnable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalysisRunnable.kt\ncom/intellij/diagnostic/hprof/action/ShowReportDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class ShowReportDialog
extends DialogWrapper {
    @NotNull
    private final JTextArea textArea;

    public ShowReportDialog(@NotNull String reportText, @NotNull HeapReportProperties heapProperties) {
        Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
        Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
        super(false);
        this.textArea = new JTextArea(30, 130);
        this.textArea.setText(AnalysisRunnableKt.getHeapDumpReportText(reportText, heapProperties));
        this.textArea.setEditable(false);
        this.textArea.setCaretPosition(0);
        this.init();
        this.setTitle(DiagnosticBundle.message("heap.dump.analysis.report.dialog.title", new Object[0]));
        this.setModal(true);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel pane2 = new JPanel(new BorderLayout(0, 5));
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        String vendorName = ApplicationInfoImpl.getShadowInstance().getShortCompanyName();
        Object[] objectArray = new Object[]{productName, vendorName};
        JLabel header = new JLabel(DiagnosticBundle.message("heap.dump.analysis.report.dialog.header", objectArray));
        pane2.add((Component)header, "First");
        pane2.add((Component)new JBScrollPane((Component)this.textArea), "Center");
        JEditorPane $this$createCenterPanel_u24lambda_u240 = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setOpaque(false);
        $this$createCenterPanel_u24lambda_u240.setFocusable(false);
        $this$createCenterPanel_u24lambda_u240.addHyperlinkListener(ShowReportDialog::createCenterPanel$lambda$0$0);
        Object[] objectArray2 = new Object[]{ApplicationInfo.getInstance().getShortCompanyName(), HeapDumpAnalysisSupport.Companion.getInstance().getPrivacyPolicyUrl()};
        $this$createCenterPanel_u24lambda_u240.setText(DiagnosticBundle.message("heap.dump.analysis.report.dialog.footer", objectArray2));
        pane2.add((Component)$this$createCenterPanel_u24lambda_u240, "Last");
        return pane2;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        return actionArray;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", DiagnosticBundle.message("heap.dump.analysis.report.dialog.action.send", new Object[0]));
        this.getCancelAction().putValue("Name", DiagnosticBundle.message("heap.dump.analysis.report.dialog.action.dont.send", new Object[0]));
    }

    private static final void createCenterPanel$lambda$0$0(HyperlinkEvent it) {
        block1: {
            if (!Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) break block1;
            URL uRL = it.getURL();
            if (uRL != null) {
                URL p0 = uRL;
                boolean bl = false;
                BrowserUtil.browse((URL)p0);
            }
        }
    }
}

