/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CloseAllEditorsAction
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseAllEditorsAction.$$$reportNull$$$0(0);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, () -> {
            EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
            if (window != null) {
                for (VirtualFile file2 : window.getFileList()) {
                    window.closeFile(file2);
                }
                return;
            }
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project2);
            VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
            for (VirtualFile openFile2 : fileEditorManager.getSiblings(selectedFile)) {
                fileEditorManager.closeFile(openFile2);
            }
        }, IdeBundle.message((String)"command.close.all.editors", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseAllEditorsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = event.getPresentation();
        EditorWindow editorWindow = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        if (editorWindow != null && editorWindow.inSplitter()) {
            presentation2.setText(IdeBundle.messagePointer((String)"action.close.all.editors.in.tab.group", (Object[])new Object[0]));
        } else {
            presentation2.setText(ActionsBundle.messagePointer((String)"action.CloseAllEditors.text", (Object[])new Object[0]));
        }
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation2.setEnabled(false);
            return;
        }
        presentation2.setEnabled(FileEditorManager.getInstance((Project)project2).getSelectedFiles().length > 0);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CloseAllEditorsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CloseAllEditorsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CloseAllEditorsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

