/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/actions/ToggleZenModeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "toggleDistractionFreeModeAction", "Lcom/intellij/ide/actions/ToggleDistractionFreeModeAction;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "applyZenMode", "state", "", "Companion", "intellij.platform.ide.impl"})
public final class ToggleZenModeAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToggleDistractionFreeModeAction toggleDistractionFreeModeAction = new ToggleDistractionFreeModeAction();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!ToggleZenModeAction.Companion.isFullScreenApplicable()) {
            e.getPresentation().setVisible(false);
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setText(Companion.isZenModeEnabled(project2) ? ActionsBundle.message((String)"action.ToggleZenMode.exit", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ToggleZenMode.enter", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        this.applyZenMode(e, !Companion.isZenModeEnabled(project3));
    }

    private final void applyZenMode(AnActionEvent e, boolean state2) {
        IdeFrameEx frame;
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (DistractionFreeModeController.isDistractionFreeModeEnabled() != state2) {
            this.toggleDistractionFreeModeAction.actionPerformed(e);
        }
        if (ToggleZenModeAction.Companion.isFullScreenApplicable() && (frame = ToggleZenModeAction.Companion.getFrame(project3)) != null && frame.isInFullScreen() != state2) {
            frame.toggleFullScreen(state2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0013\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b*\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/actions/ToggleZenModeAction$Companion;", "", "<init>", "()V", "isFullScreenApplicable", "", "getFrame", "Lcom/intellij/openapi/wm/ex/IdeFrameEx;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/project/Project;", "isZenModeEnabled", "project", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFullScreenApplicable() {
            return WindowManager.getInstance().isFullScreenSupportedInCurrentOS();
        }

        private final IdeFrameEx getFrame(Project $this$getFrame) {
            return WindowManagerEx.getInstanceEx().findFrameHelper($this$getFrame);
        }

        public final boolean isZenModeEnabled(@NotNull Project project2) {
            IdeFrameEx frame;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (!DistractionFreeModeController.isDistractionFreeModeEnabled()) {
                return false;
            }
            return !this.isFullScreenApplicable() || (frame = this.getFrame(project2)) == null || frame.isInFullScreen();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

