/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.ui.HtmlRtfPane;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\n2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001aH\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/gdpr/AgreementUi;", "Lcom/intellij/openapi/ui/DialogWrapper;", "htmlText", "", "exitOnCancel", "", "useRtfPane", "<init>", "(Ljava/lang/String;ZZ)V", "bottomPanel", "Ljavax/swing/JPanel;", "htmlRtfPane", "Lcom/intellij/ide/gdpr/ui/HtmlRtfPane;", "viewer", "Ljavax/swing/JEditorPane;", "declineButton", "Ljavax/swing/JButton;", "acceptButton", "buttonsEastGap", "", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createButtonsPanel", "buttons", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "getPreferredFocusedComponent", "doCancelAction", "", "createHtmlEditorPane", "Ljavax/swing/JTextPane;", "intellij.platform.ide.impl"})
final class AgreementUi
extends DialogWrapper {
    @NotNull
    private final String htmlText;
    private final boolean exitOnCancel;
    private final boolean useRtfPane;
    @JvmField
    @Nullable
    public JPanel bottomPanel;
    @JvmField
    @Nullable
    public HtmlRtfPane htmlRtfPane;
    @JvmField
    @Nullable
    public JEditorPane viewer;
    @JvmField
    @Nullable
    public JButton declineButton;
    @JvmField
    @Nullable
    public JButton acceptButton;
    private final int buttonsEastGap;

    public AgreementUi(@NlsSafe @NotNull String htmlText, boolean exitOnCancel, boolean useRtfPane) {
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        super(true);
        this.htmlText = htmlText;
        this.exitOnCancel = exitOnCancel;
        this.useRtfPane = useRtfPane;
        this.buttonsEastGap = JBUI.scale((int)15);
        this.init();
    }

    @NotNull
    protected Border createContentPaneBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.emptyBottom((int)12);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"emptyBottom(...)");
        return (Border)jBEmptyBorder;
    }

    @NotNull
    protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        JPanel jPanel = DialogWrapper.layoutButtonsPanel(buttons);
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"layoutButtonsPanel(...)");
        JPanel buttonsPanel = jPanel;
        buttonsPanel.setBorder((Border)JBUI.Borders.emptyRight((int)22));
        return buttonsPanel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JTextPane jTextPane;
        JPanel centerPanel = new JPanel(new BorderLayout(0, 0));
        if (this.useRtfPane) {
            HtmlRtfPane htmlRtfPane = this.htmlRtfPane = new HtmlRtfPane();
            Intrinsics.checkNotNull((Object)htmlRtfPane);
            jTextPane = htmlRtfPane.create(this.htmlText);
        } else {
            jTextPane = this.createHtmlEditorPane(this.htmlText);
        }
        JTextPane viewer = jTextPane;
        this.viewer = viewer;
        viewer.setCaretPosition(0);
        viewer.setEditable(false);
        viewer.setBorder((Border)JBUI.Borders.empty((int)30, (int)30, (int)30, (int)60));
        JBScrollPane scrollPane = new JBScrollPane((Component)viewer, 20, 31);
        Color color = UIManager.getColor("DialogWrapper.southPanelDivider");
        if (color == null) {
            Color color2 = JBColor.border();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"border(...)");
        }
        CustomLineBorder line = new CustomLineBorder(color, 0, 0, 1, 0);
        scrollPane.setBorder((Border)new CompoundBorder((Border)line, (Border)JBUI.Borders.empty()));
        centerPanel.add((Component)scrollPane, "Center");
        BorderLayout borderLayout = new BorderLayout();
        this.bottomPanel = new JPanel(borderLayout){

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new JPanel.AccessibleJPanel(this){

                        public AccessibleRole getAccessibleRole() {
                            return AccessibilityUtils.GROUPED_ELEMENTS;
                        }
                    };
                }
                return this.accessibleContext;
            }
        };
        JBUI.Borders.empty((int)16, (int)30, (int)8, (int)30).wrap((JComponent)this.bottomPanel);
        JPanel jPanel = this.bottomPanel;
        Intrinsics.checkNotNull((Object)jPanel);
        centerPanel.add((Component)jPanel, "South");
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)600, (int)356));
        return centerPanel;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        this.declineButton = new JButton(IdeBundle.message((String)"gdpr.exit.button", (Object[])new Object[0]));
        this.acceptButton = new JButton(IdeBundle.message((String)"gdpr.continue.button", (Object[])new Object[0]));
        panel2.add((Component)buttonPanel, "East");
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalStrut(JBUI.scale((int)5)));
        buttonPanel.add(this.declineButton);
        buttonPanel.add(Box.createHorizontalStrut(JBUI.scale((int)5)));
        buttonPanel.add(this.acceptButton);
        buttonPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)this.buttonsEastGap, (int)5)));
        JButton jButton = this.declineButton;
        Intrinsics.checkNotNull((Object)jButton);
        jButton.setEnabled(true);
        JButton jButton2 = this.acceptButton;
        Intrinsics.checkNotNull((Object)jButton2);
        jButton2.setEnabled(true);
        this.getRootPane().setDefaultButton(this.acceptButton);
        return panel2;
    }

    @Nullable
    public JEditorPane getPreferredFocusedComponent() {
        return this.viewer;
    }

    public void doCancelAction() {
        super.doCancelAction();
        if (this.exitOnCancel) {
            ApplicationEx application = ApplicationManagerEx.getApplicationEx();
            if (application == null) {
                System.exit(11);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            application.exit(3, 11);
        }
    }

    private final JTextPane createHtmlEditorPane(@NlsSafe String htmlText) {
        JTextPane jTextPane;
        JTextPane $this$createHtmlEditorPane_u24lambda_u240 = jTextPane = new JTextPane();
        boolean bl = false;
        $this$createHtmlEditorPane_u24lambda_u240.setContentType("text/html");
        $this$createHtmlEditorPane_u24lambda_u240.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        $this$createHtmlEditorPane_u24lambda_u240.setEditorKit(new HTMLEditorKitBuilder().withGapsBetweenParagraphs().build());
        $this$createHtmlEditorPane_u24lambda_u240.setText(htmlText);
        Document document2 = $this$createHtmlEditorPane_u24lambda_u240.getDocument();
        Intrinsics.checkNotNull((Object)document2, (String)"null cannot be cast to non-null type javax.swing.text.html.HTMLDocument");
        StyleSheet styleSheet = ((HTMLDocument)document2).getStyleSheet();
        styleSheet.addRule("body {font-family: \"Segoe UI\", Tahoma, sans-serif;}");
        styleSheet.addRule("body {font-size:" + JBUI.Fonts.label() + "pt;}");
        return jTextPane;
    }
}

