/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.ThirdPartyPluginsWithoutConsentFile;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

public class HeadlessPluginsInstaller
implements ApplicationStarter {
    private static final Logger LOG = Logger.getInstance(HeadlessPluginsInstaller.class);
    private static final String COMMAND_NAME = "installPlugins";

    public int getRequiredModality() {
        return 3;
    }

    public void main(@NotNull List<String> args) {
        if (args == null) {
            HeadlessPluginsInstaller.$$$reportNull$$$0(0);
        }
        if (args.size() == 1) {
            HeadlessPluginsInstaller.printUsageHint();
            System.exit(0);
        }
        try {
            LinkedHashSet<PluginId> pluginIds = new LinkedHashSet<PluginId>();
            LinkedHashSet<String> customRepositories = new LinkedHashSet<String>();
            ArrayList<Path> projectPaths = new ArrayList<Path>();
            boolean giveConsentToUseThirdPartyPlugins = false;
            for (int i2 = 1; i2 < args.size(); ++i2) {
                String arg = args.get(i2);
                if ("-h".equals(arg) || "--help".equals(arg)) {
                    HeadlessPluginsInstaller.printUsageHint();
                    continue;
                }
                if ("--give-consent-to-use-third-party-plugins".equals(arg)) {
                    giveConsentToUseThirdPartyPlugins = true;
                    continue;
                }
                if (arg.startsWith("--for-project=")) {
                    projectPaths.add(Path.of(arg.replace("--for-project=", ""), new String[0]));
                    continue;
                }
                if (arg.contains("://")) {
                    customRepositories.add(arg);
                    continue;
                }
                pluginIds.add(PluginId.getId((String)arg));
            }
            HeadlessPluginsInstaller.collectProjectRequiredPlugins(pluginIds, projectPaths);
            if (!customRepositories.isEmpty()) {
                RepositoryHelper.amendPluginHostsProperty(customRepositories);
            }
            HeadlessPluginsInstaller.logInfo("plugin repositories: " + String.valueOf(RepositoryHelper.getPluginHosts()));
            Collection<PluginNode> installed = HeadlessPluginsInstaller.installPlugins(pluginIds, giveConsentToUseThirdPartyPlugins);
            System.exit(installed.size() == pluginIds.size() ? 0 : 1);
        }
        catch (Throwable t) {
            LOG.error(t);
            System.exit(1);
        }
    }

    private static void printUsageHint() {
        System.out.printf("Usage: %s pluginId* repository* (--for-project=<project-path>)* [--give-consent-to-use-third-party-plugins]\n\nInstalls plugins with `pluginId` from the Marketplace or provided `repository`-es.\nIf `--for-project` is specified, also installs the required plugins for a project located at <project-path>.\nIf `--give-consent-to-use-third-party-plugins` is specified, installed third-party plugins will be approved automatically.\nWithout this option, if a third-party plugin is installed, a user will be asked to approve it when the IDE starts.%n", COMMAND_NAME);
    }

    private static void collectProjectRequiredPlugins(Collection<PluginId> collector, List<Path> projectPaths) {
        OpenProjectTask options2 = OpenProjectTaskKt.OpenProjectTask(builder -> {
            builder.setShowWelcomeScreen(false);
            builder.setRunConversionBeforeOpen(false);
            return Unit.INSTANCE;
        });
        for (Path path : projectPaths) {
            Project project2 = ProjectUtil.openOrImport(path, options2);
            if (project2 == null) {
                LOG.error("Cannot open a project at " + String.valueOf(path));
                System.exit(1);
            }
            for (DependencyOnPlugin dependency : ExternalDependenciesManager.getInstance(project2).getDependencies(DependencyOnPlugin.class)) {
                collector.add(PluginId.getId((String)dependency.getPluginId()));
            }
            ProjectManagerEx.getInstanceEx().forceCloseProject(project2);
        }
    }

    @NotNull
    public static Collection<PluginNode> installPlugins(@NotNull Set<PluginId> pluginIds) {
        if (pluginIds == null) {
            HeadlessPluginsInstaller.$$$reportNull$$$0(1);
        }
        return HeadlessPluginsInstaller.installPlugins(pluginIds, false);
    }

    @NotNull
    private static Collection<PluginNode> installPlugins(@NotNull Set<PluginId> pluginIds, boolean giveConsentToUseThirdPartyPlugins) {
        if (pluginIds == null) {
            HeadlessPluginsInstaller.$$$reportNull$$$0(2);
        }
        HeadlessPluginsInstaller.logInfo("looking up plugins: " + String.valueOf(pluginIds));
        Collection<PluginNode> plugins2 = RepositoryHelper.loadPlugins(pluginIds);
        if (!giveConsentToUseThirdPartyPlugins && !PluginManagerMain.checkThirdPartyPluginsAllowed(plugins2)) {
            HeadlessPluginsInstaller.logInfo("3rd-party plugins rejected");
            List<PluginNode> list2 = Collections.emptyList();
            if (list2 == null) {
                HeadlessPluginsInstaller.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (plugins2.size() < pluginIds.size()) {
            HashSet<PluginId> unknown = new HashSet<PluginId>(pluginIds);
            for (PluginNode plugin2 : plugins2) {
                unknown.remove(plugin2.getPluginId());
            }
            HeadlessPluginsInstaller.logInfo("unknown plugins: " + String.valueOf(unknown));
        }
        EmptyProgressIndicator indicator2 = new EmptyProgressIndicator();
        PluginManagementPolicy policy = PluginManagementPolicy.getInstance();
        ArrayList<PluginNode> installed = new ArrayList<PluginNode>();
        for (PluginNode plugin3 : plugins2) {
            if (PluginManagerCore.getPlugin((PluginId)plugin3.getPluginId()) != null) {
                HeadlessPluginsInstaller.logInfo("already installed: " + String.valueOf(plugin3.getPluginId()));
                installed.add(plugin3);
                continue;
            }
            if (!policy.canInstallPlugin(plugin3)) {
                HeadlessPluginsInstaller.logInfo("rejected by policy: " + String.valueOf(plugin3.getPluginId()));
                continue;
            }
            try {
                PluginDownloader downloader = PluginDownloader.createDownloader(plugin3, plugin3.getRepositoryName(), null);
                if (!downloader.prepareToInstall((ProgressIndicator)indicator2)) continue;
                PluginInstaller.unpackPlugin(downloader.getFilePath(), PathManager.getPluginsDir());
                installed.add(plugin3);
                HeadlessPluginsInstaller.logInfo("installed plugin: " + String.valueOf(plugin3));
            }
            catch (Exception e) {
                LOG.error("cannot install: " + String.valueOf(plugin3.getPluginId()), (Throwable)e);
            }
        }
        if (giveConsentToUseThirdPartyPlugins && ContainerUtil.exists(installed, plugin -> !plugin.isBundled() && !PluginManagerCore.isVendorTrusted((PluginDescriptor)plugin))) {
            ThirdPartyPluginsWithoutConsentFile.giveConsentToSpecificThirdPartyPlugins(pluginIds);
        }
        PluginEnabler.HEADLESS.enable(installed);
        return new ArrayList<PluginNode>(installed);
    }

    private static void logInfo(String message) {
        System.out.println(message);
        LOG.info(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/HeadlessPluginsInstaller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/HeadlessPluginsInstaller";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = COMMAND_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = COMMAND_NAME;
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

