/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StartMarkAction
extends BasicUndoableAction {
    public static final Key<StartMarkAction> START_MARK_ACTION_KEY = Key.create((String)"current.inplace.refactorings.mark");
    private @NlsContexts.Command String myCommandName;
    private boolean myGlobal;
    private Document myDocument;

    StartMarkAction(@NotNull DocumentReference docRef, @NlsContexts.Command String commandName, boolean isGlobal) {
        if (docRef == null) {
            StartMarkAction.$$$reportNull$$$0(0);
        }
        super(new DocumentReference[]{docRef});
        this.myCommandName = commandName;
        this.myDocument = docRef.getDocument();
        this.myGlobal = isGlobal;
    }

    private StartMarkAction(@NotNull Editor editor2, @NlsContexts.Command String commandName) {
        if (editor2 == null) {
            StartMarkAction.$$$reportNull$$$0(1);
        }
        this(DocumentReferenceManager.getInstance().create(editor2.getDocument()), commandName, false);
    }

    public void undo() {
    }

    public void redo() {
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    @NlsContexts.Command
    public String getCommandName() {
        return this.myCommandName;
    }

    public void setCommandName(@NlsContexts.Command String commandName) {
        this.myCommandName = commandName;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    @TestOnly
    public static void checkCleared(@Nullable Editor editor2) {
        if (editor2 == null) {
            return;
        }
        try {
            StartMarkAction markAction = (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
            assert (markAction == null) : markAction.myDocument;
        }
        finally {
            editor2.putUserData(START_MARK_ACTION_KEY, null);
        }
    }

    public static StartMarkAction start(Editor editor2, Project project2, @NlsContexts.Command String commandName) throws AlreadyStartedException {
        StartMarkAction existingMark = (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
        if (existingMark != null) {
            throw new AlreadyStartedException(existingMark.myCommandName, existingMark.myDocument, existingMark.getAffectedDocuments());
        }
        StartMarkAction markAction = new StartMarkAction(editor2, commandName);
        UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)markAction);
        editor2.putUserData(START_MARK_ACTION_KEY, (Object)markAction);
        return markAction;
    }

    public static StartMarkAction canStart(Editor editor2) {
        return (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
    }

    @Deprecated
    public static StartMarkAction canStart(@NotNull Project project2) {
        if (project2 == null) {
            StartMarkAction.$$$reportNull$$$0(2);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project2).getAllEditors()) {
            StartMarkAction startMarkAction;
            if (!(fileEditor instanceof TextEditor) || (startMarkAction = (StartMarkAction)((Object)((TextEditor)fileEditor).getEditor().getUserData(START_MARK_ACTION_KEY))) == null) continue;
            return startMarkAction;
        }
        return null;
    }

    static void markFinished(Editor editor2) {
        StartMarkAction existingMark = (StartMarkAction)((Object)editor2.getUserData(START_MARK_ACTION_KEY));
        if (existingMark != null) {
            editor2.putUserData(START_MARK_ACTION_KEY, null);
            existingMark.myDocument = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/StartMarkAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class AlreadyStartedException
    extends Exception {
        private final DocumentReference[] myAffectedDocuments;
        private final Document myDocument;

        public AlreadyStartedException(String commandName, Document document2, DocumentReference[] documentRefs) {
            super("Unable to start inplace refactoring:\n" + IdeBundle.message((String)"dialog.message.command.not.finished.yet", (Object[])new Object[]{commandName}));
            this.myAffectedDocuments = documentRefs;
            this.myDocument = document2;
        }

        public DocumentReference[] getAffectedDocuments() {
            return this.myAffectedDocuments;
        }

        public Document getDocument() {
            return this.myDocument;
        }
    }
}

