/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 #2\u00020\u0001:\u0002#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0010J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/fileEditor/impl/SplitterService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/openapi/fileEditor/impl/SplitterService$ActiveState;", "activeWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getActiveWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "value", "initialEditorWindow", "getInitialEditorWindow", "isActive", "", "()Z", "activateSplitChooser", "", "window", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openedFromEditor", "switchWindow", "currentState", "stopSplitChooser", "interrupted", "nextWindow", "previousWindow", "split", "move", "setSplitSide", "side", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;", "Companion", "ActiveState", "intellij.platform.ide.impl"})
public final class SplitterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private ActiveState state;
    @Nullable
    private EditorWindow initialEditorWindow;

    public SplitterService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Nullable
    public final EditorWindow getActiveWindow() {
        ActiveState activeState = this.state;
        return activeState != null ? activeState.getWindow() : null;
    }

    @Nullable
    public final EditorWindow getInitialEditorWindow() {
        return this.initialEditorWindow;
    }

    public final boolean isActive() {
        return this.getActiveWindow() != null;
    }

    public final void activateSplitChooser(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean openedFromEditor) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ActiveState activeState = this.state;
        if (activeState != null) {
            ActiveState it = activeState;
            boolean bl = false;
            this.stopSplitChooser(true, it);
        }
        this.state = new ActiveState(window, file2, window.showSplitChooser$intellij_platform_ide_impl(this.project, true));
        if (openedFromEditor) {
            this.initialEditorWindow = this.getActiveWindow();
        }
    }

    private final void switchWindow(EditorWindow window, ActiveState currentState) {
        currentState.getSplitChooser().dispose();
        this.state = new ActiveState(window, currentState.getFile(), window.showSplitChooser$intellij_platform_ide_impl(this.project, false));
    }

    public final void stopSplitChooser(boolean interrupted) {
        ActiveState activeState = this.state;
        if (activeState == null) {
            return;
        }
        this.stopSplitChooser(interrupted, activeState);
    }

    private final void stopSplitChooser(boolean interrupted, ActiveState currentState) {
        currentState.getSplitChooser().dispose();
        this.state = null;
        this.initialEditorWindow = null;
        if (!interrupted) {
            currentState.getWindow().requestFocus(true);
        }
    }

    public final void nextWindow() {
        ActiveState activeState = this.state;
        if (activeState == null) {
            return;
        }
        ActiveState currentState = activeState;
        List<EditorWindow> orderedWindows = currentState.getWindow().getOwner().getOrderedWindows$intellij_platform_ide_impl();
        int index = (orderedWindows.indexOf(currentState.getWindow()) + 1) % orderedWindows.size();
        this.switchWindow(orderedWindows.get(index), currentState);
    }

    public final void previousWindow() {
        ActiveState activeState = this.state;
        if (activeState == null) {
            return;
        }
        ActiveState currentState = activeState;
        List<EditorWindow> orderedWindows = currentState.getWindow().getOwner().getOrderedWindows$intellij_platform_ide_impl();
        int index = orderedWindows.indexOf(currentState.getWindow()) - 1;
        index = index < 0 ? orderedWindows.size() - 1 : index;
        this.switchWindow(orderedWindows.get(index), currentState);
    }

    public final void split(boolean move2) {
        ActiveState activeState = this.state;
        Intrinsics.checkNotNull((Object)activeState);
        ActiveState state2 = activeState;
        EditorWindow activeWindow = state2.getWindow();
        EditorWindow initialWindow = this.initialEditorWindow;
        EditorWindow.RelativePosition position2 = state2.getSplitChooser().getPosition();
        this.stopSplitChooser(false);
        if (position2 == EditorWindow.RelativePosition.CENTER && Intrinsics.areEqual((Object)initialWindow, (Object)activeWindow)) {
            return;
        }
        VirtualFile file2 = state2.getFile();
        EditorWindow editorWindow = position2 == EditorWindow.RelativePosition.CENTER ? activeWindow.getManager().openFile(file2, activeWindow, new FileEditorOpenOptions(false, false, false, true, false, 0, false, null, false, false, false, null, 4087, null)) : EditorWindow.split$default(activeWindow, position2 == EditorWindow.RelativePosition.UP || position2 == EditorWindow.RelativePosition.DOWN ? 0 : 1, true, file2, true, position2 != EditorWindow.RelativePosition.LEFT && position2 != EditorWindow.RelativePosition.UP, false, 32, null);
        if (initialWindow != null && move2) {
            EditorWindow.closeFile$default(initialWindow, file2, false, 2, null);
        }
    }

    public final void setSplitSide(@NotNull EditorWindow.RelativePosition side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        ActiveState activeState = this.state;
        Intrinsics.checkNotNull((Object)activeState);
        ActiveState state2 = activeState;
        if (side != state2.getSplitChooser().getPosition()) {
            state2.getSplitChooser().positionChanged(side);
        } else {
            EditorWindow editorWindow = state2.getWindow().getAdjacentEditors$intellij_platform_ide_impl().get((Object)side);
            if (editorWindow == null) {
                return;
            }
            this.switchWindow(editorWindow, state2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/fileEditor/impl/SplitterService$ActiveState;", "", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "splitChooser", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow$SplitChooser;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/impl/EditorWindow$SplitChooser;)V", "getWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getSplitChooser", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow$SplitChooser;", "intellij.platform.ide.impl"})
    private static final class ActiveState {
        @NotNull
        private final EditorWindow window;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final EditorWindow.SplitChooser splitChooser;

        public ActiveState(@NotNull EditorWindow window, @NotNull VirtualFile file2, @NotNull EditorWindow.SplitChooser splitChooser) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)splitChooser, (String)"splitChooser");
            this.window = window;
            this.file = file2;
            this.splitChooser = splitChooser;
        }

        @NotNull
        public final EditorWindow getWindow() {
            return this.window;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final EditorWindow.SplitChooser getSplitChooser() {
            return this.splitChooser;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/SplitterService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/fileEditor/impl/SplitterService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nSplitterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitterService.kt\ncom/intellij/openapi/fileEditor/impl/SplitterService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,126:1\n30#2,2:127\n*S KotlinDebug\n*F\n+ 1 SplitterService.kt\ncom/intellij/openapi/fileEditor/impl/SplitterService$Companion\n*L\n16#1:127,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SplitterService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<SplitterService> serviceClass$iv = SplitterService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SplitterService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

