/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.tabInEditor;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.tabInEditor.ToolWindowTabFile;
import com.intellij.openapi.wm.impl.tabInEditor.ToolWindowTabInEditorDefaultHelperKt;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/wm/impl/tabInEditor/Placeholder;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "file", "Lcom/intellij/openapi/wm/impl/tabInEditor/ToolWindowTabFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/content/Content;Lcom/intellij/openapi/wm/impl/tabInEditor/ToolWindowTabFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getContent", "()Lcom/intellij/ui/content/Content;", "getFile", "()Lcom/intellij/openapi/wm/impl/tabInEditor/ToolWindowTabFile;", "dispose", "", "intellij.platform.ide.impl"})
public final class Placeholder
extends JBPanelWithEmptyText
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Content content;
    @NotNull
    private final ToolWindowTabFile file;

    public Placeholder(@NotNull Project project2, @NotNull Content content2, @NotNull ToolWindowTabFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project2;
        this.content = content2;
        this.file = file2;
        this.getEmptyText().appendLine(IdeBundle.message((String)"status.text.tab.open.in.editor", (Object[])new Object[0]));
        this.getEmptyText().appendLine("");
        this.getEmptyText().appendLine(IdeBundle.message((String)"status.text.tab.open.in.editor.jump", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> Placeholder._init_$lambda$0(this, arg_0));
        this.getEmptyText().appendLine(IdeBundle.message((String)"status.text.tab.open.in.editor.restore", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> Placeholder._init_$lambda$1(this, arg_0));
        this.setFocusable(true);
        JComponent jComponent = (JComponent)((Object)this);
        KeyStroke[] keyStrokeArray = new KeyStroke[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeyStroke.getKeyStroke(10, 0), (String)"getKeyStroke(...)");
        UiUtils.addKeyboardAction((JComponent)jComponent, (KeyStroke[])keyStrokeArray, arg_0 -> Placeholder._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Content getContent() {
        return this.content;
    }

    @NotNull
    public final ToolWindowTabFile getFile() {
        return this.file;
    }

    public void dispose() {
        ToolWindowTabInEditorDefaultHelperKt.moveContentBackToTab(this.project, this.content, this.file);
        if (this.file.getComponent() instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.file.getComponent()));
        }
    }

    private static final void _init_$lambda$0(Placeholder this$0, ActionEvent it) {
        FileEditorManager.getInstance((Project)this$0.project).openFile((VirtualFile)this$0.file, true);
    }

    private static final void _init_$lambda$1(Placeholder this$0, ActionEvent it) {
        ToolWindowTabInEditorDefaultHelperKt.moveContentBackToTab(this$0.project, this$0.content, this$0.file);
    }

    private static final Unit _init_$lambda$2(Placeholder this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FileEditorManager.getInstance((Project)this$0.project).openFile((VirtualFile)this$0.file, true);
        return Unit.INSTANCE;
    }
}

