/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.projectActions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.openapi.wm.impl.welcomeScreen.projectActions.RecentProjectsWelcomeScreenActionBase;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.CloneableProjectItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.ProjectsGroupItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.ProviderRecentProjectItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectTreeItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RootItem;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/projectActions/RemoveSelectedProjectsAction;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/projectActions/RecentProjectsWelcomeScreenActionBase;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.platform.ide.impl"})
public final class RemoveSelectedProjectsAction
extends RecentProjectsWelcomeScreenActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RemoveSelectedProjectsAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<RecentProjectTreeItem> list2 = RecentProjectsWelcomeScreenActionBase.Companion.getSelectedItems$intellij_platform_ide_impl(event);
        if (list2 == null) {
            return;
        }
        List<RecentProjectTreeItem> items2 = list2;
        Companion.removeItems(items2);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RecentProjectTreeItem selectedItem = RecentProjectsWelcomeScreenActionBase.Companion.getSelectedItem$intellij_platform_ide_impl(event);
        event.getPresentation().setEnabled(selectedItem != null && RemoveSelectedProjectsAction.Companion.canRemoveItem(selectedItem));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/projectActions/RemoveSelectedProjectsAction$Companion;", "", "<init>", "()V", "canRemoveItem", "", "item", "Lcom/intellij/openapi/wm/impl/welcomeScreen/recentProjects/RecentProjectTreeItem;", "removeItems", "", "items", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nRemoveSelectedProjectsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveSelectedProjectsAction.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/projectActions/RemoveSelectedProjectsAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1915#2,2:73\n*S KotlinDebug\n*F\n+ 1 RemoveSelectedProjectsAction.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/projectActions/RemoveSelectedProjectsAction$Companion\n*L\n60#1:73,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean canRemoveItem(RecentProjectTreeItem item) {
            return item instanceof ProjectsGroupItem || item instanceof RecentProjectItem || item instanceof ProviderRecentProjectItem || item instanceof CloneableProjectItem;
        }

        public final void removeItems(@NotNull List<? extends RecentProjectTreeItem> items2) {
            String string;
            Intrinsics.checkNotNullParameter(items2, (String)"items");
            if (items2.isEmpty()) {
                return;
            }
            RecentProjectsManager recentProjectsManager = RecentProjectsManager.Companion.getInstance();
            CloneableProjectsService cloneableProjectsService = CloneableProjectsService.Companion.getInstance();
            String string2 = items2.size() == 1 ? IdeBundle.message((String)"dialog.title.remove.recent.project", (Object[])new Object[0]) : IdeBundle.message((String)"dialog.title.remove.recent.project.plural", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            String title2 = string2;
            if (items2.size() == 1) {
                Object[] objectArray = new Object[]{((RecentProjectTreeItem)CollectionsKt.first(items2)).displayName()};
                string = IdeBundle.message((String)"dialog.message.remove.0.from.recent.projects.list", (Object[])objectArray);
            } else {
                string = IdeBundle.message((String)"dialog.message.remove.projects.from.recent.projects.list", (Object[])new Object[0]);
            }
            String string3 = string;
            Intrinsics.checkNotNull((Object)string3);
            String message = string3;
            int exitCode2 = Messages.showYesNoDialog((String)message, (String)title2, (String)IdeBundle.message((String)"button.remove", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (exitCode2 == 0) {
                Iterable $this$forEach$iv = items2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RecentProjectTreeItem item = (RecentProjectTreeItem)element$iv;
                    boolean bl = false;
                    RecentProjectTreeItem recentProjectTreeItem = item;
                    if (recentProjectTreeItem instanceof ProjectsGroupItem) {
                        recentProjectsManager.removeGroup(((ProjectsGroupItem)item).getGroup());
                        continue;
                    }
                    if (recentProjectTreeItem instanceof RecentProjectItem) {
                        recentProjectsManager.removePath(((RecentProjectItem)item).projectPath);
                        continue;
                    }
                    if (recentProjectTreeItem instanceof CloneableProjectItem) {
                        cloneableProjectsService.removeCloneableProject(((CloneableProjectItem)item).getCloneableProject());
                        continue;
                    }
                    if (recentProjectTreeItem instanceof ProviderRecentProjectItem) {
                        ((ProviderRecentProjectItem)item).removeFromRecent();
                        continue;
                    }
                    if (recentProjectTreeItem instanceof RootItem) continue;
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

