/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/toolWindow/Surface;", "Ljavax/swing/JComponent;", "myTopImage", "Ljava/awt/Image;", "myBottomImage", "bottomImageOffset", "Ljava/awt/geom/Point2D;", "direction", "", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "desiredTimeToComplete", "<init>", "(Ljava/awt/Image;Ljava/awt/Image;Ljava/awt/geom/Point2D;ILcom/intellij/openapi/wm/ToolWindowAnchor;I)V", "offset", "runMovement", "", "paint", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
final class Surface
extends JComponent {
    @NotNull
    private final Image myTopImage;
    @NotNull
    private final Image myBottomImage;
    private final int direction;
    @NotNull
    private final ToolWindowAnchor anchor;
    private final int desiredTimeToComplete;
    @NotNull
    private final Point2D bottomImageOffset;
    private int offset;

    public Surface(@NotNull Image myTopImage, @NotNull Image myBottomImage, @NotNull Point2D bottomImageOffset, int direction, @NotNull ToolWindowAnchor anchor, int desiredTimeToComplete) {
        Intrinsics.checkNotNullParameter((Object)myTopImage, (String)"myTopImage");
        Intrinsics.checkNotNullParameter((Object)myBottomImage, (String)"myBottomImage");
        Intrinsics.checkNotNullParameter((Object)bottomImageOffset, (String)"bottomImageOffset");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.myTopImage = myTopImage;
        this.myBottomImage = myBottomImage;
        this.direction = direction;
        this.anchor = anchor;
        this.desiredTimeToComplete = desiredTimeToComplete;
        Object object = bottomImageOffset.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.geom.Point2D");
        this.bottomImageOffset = (Point2D)object;
        this.setOpaque(true);
    }

    public final void runMovement() {
        if (!this.isShowing()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        int distance = Intrinsics.areEqual((Object)this.anchor, (Object)ToolWindowAnchor.LEFT) || Intrinsics.areEqual((Object)this.anchor, (Object)ToolWindowAnchor.RIGHT) ? bounds.width : bounds.height;
        int count = 0;
        this.offset = 0;
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        long startTime = System.currentTimeMillis();
        while (true) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            long timeSpent = System.currentTimeMillis() - startTime;
            ++count;
            if (timeSpent >= (long)this.desiredTimeToComplete) break;
            double onePaintTime = (double)timeSpent / (double)count;
            int iterations = (int)((double)((long)this.desiredTimeToComplete - timeSpent) / onePaintTime);
            iterations = RangesKt.coerceAtLeast((int)1, (int)iterations);
            this.offset += (distance - this.offset) / iterations;
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle bounds = this.getBounds();
        ((Graphics2D)g).translate(this.bottomImageOffset.getX(), this.bottomImageOffset.getY());
        ToolWindowAnchor toolWindowAnchor = this.anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            if (this.direction == 1) {
                g.setClip(null);
                g.clipRect(this.offset, 0, bounds.width - this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(0, 0, this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)(this.offset - bounds.width), (int)0, null);
            } else {
                g.setClip(null);
                g.clipRect(bounds.width - this.offset, 0, this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds.width - this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)(-this.offset), (int)0, null);
            }
            this.myTopImage.flush();
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            if (this.direction == 1) {
                g.setClip(null);
                g.clipRect(0, 0, bounds.width - this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(bounds.width - this.offset, 0, this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)(bounds.width - this.offset), (int)0, null);
            } else {
                g.setClip(null);
                g.clipRect(0, 0, this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(this.offset, 0, bounds.width - this.offset, bounds.height);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)this.offset, (int)0, null);
            }
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP)) {
            if (this.direction == 1) {
                g.setClip(null);
                g.clipRect(0, this.offset, bounds.width, bounds.height - this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)0, (int)(-bounds.height + this.offset), null);
            } else {
                g.setClip(null);
                g.clipRect(0, bounds.height - this.offset, bounds.width, this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, bounds.height - this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)0, (int)(-this.offset), null);
            }
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) {
            if (this.direction == 1) {
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, bounds.height - this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(0, bounds.height - this.offset, bounds.width, this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)0, (int)(bounds.height - this.offset), null);
            } else {
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myBottomImage, (int)0, (int)0, null);
                g.setClip(null);
                g.clipRect(0, this.offset, bounds.width, bounds.height - this.offset);
                UIUtil.drawImage((Graphics)g, (Image)this.myTopImage, (int)0, (int)this.offset, null);
            }
        }
    }
}

