/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Conditions;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TreeSpeedSearch
extends SpeedSearchBase<JTree> {
    protected boolean myCanExpand;
    private static final Function<TreePath, String> TO_STRING = path -> path.getLastPathComponent().toString();
    @NotNull
    private final Function<? super TreePath, String> myPresentableStringFunction;
    @Deprecated
    public static final Convertor<TreePath, String> NODE_DESCRIPTOR_TOSTRING = path -> {
        NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)path);
        if (descriptor2 != null) {
            return descriptor2.toString();
        }
        return TO_STRING.apply((TreePath)path);
    };
    public static final Function<TreePath, String> NODE_PRESENTATION_FUNCTION = path -> {
        NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)path);
        return descriptor2 != null ? descriptor2.toString() : TO_STRING.apply((TreePath)path);
    };

    protected TreeSpeedSearch(@NotNull JTree tree2, Void sig) {
        if (tree2 == null) {
            TreeSpeedSearch.$$$reportNull$$$0(0);
        }
        this(tree2, false, sig, TO_STRING);
    }

    protected TreeSpeedSearch(@NotNull JTree tree2, boolean canExpand, Void sig, @NotNull Function<? super TreePath, String> presentableStringFunction) {
        if (tree2 == null) {
            TreeSpeedSearch.$$$reportNull$$$0(1);
        }
        if (presentableStringFunction == null) {
            TreeSpeedSearch.$$$reportNull$$$0(2);
        }
        super(tree2, sig);
        this.setComparator(new SpeedSearchComparator(false, true));
        this.myPresentableStringFunction = presentableStringFunction;
        this.myCanExpand = canExpand;
    }

    @NotNull
    public static TreeSpeedSearch installOn(@NotNull JTree tree2, boolean canExpand, @NotNull Function<? super TreePath, String> presentableStringFunction) {
        if (tree2 == null) {
            TreeSpeedSearch.$$$reportNull$$$0(3);
        }
        if (presentableStringFunction == null) {
            TreeSpeedSearch.$$$reportNull$$$0(4);
        }
        TreeSpeedSearch search = new TreeSpeedSearch(tree2, canExpand, null, presentableStringFunction);
        search.setupListeners();
        TreeSpeedSearch treeSpeedSearch = search;
        if (treeSpeedSearch == null) {
            TreeSpeedSearch.$$$reportNull$$$0(5);
        }
        return treeSpeedSearch;
    }

    @NotNull
    public static TreeSpeedSearch installOn(@NotNull JTree tree2) {
        if (tree2 == null) {
            TreeSpeedSearch.$$$reportNull$$$0(6);
        }
        return TreeSpeedSearch.installOn(tree2, false, TO_STRING);
    }

    @Override
    public void setupListeners() {
        super.setupListeners();
        new MySelectAllAction((JTree)this.myComponent, this).registerCustomShortcutSet(this.myComponent, null);
    }

    @Deprecated
    public TreeSpeedSearch(JTree tree2) {
        this(tree2, false, TO_STRING);
    }

    @Deprecated
    public TreeSpeedSearch(@NotNull JTree tree2, boolean canExpand, @NotNull Function<? super TreePath, String> presentableStringFunction) {
        if (tree2 == null) {
            TreeSpeedSearch.$$$reportNull$$$0(7);
        }
        if (presentableStringFunction == null) {
            TreeSpeedSearch.$$$reportNull$$$0(8);
        }
        super(tree2);
        this.setComparator(new SpeedSearchComparator(false, true));
        this.myPresentableStringFunction = presentableStringFunction;
        this.myCanExpand = canExpand;
        new MySelectAllAction(tree2, this).registerCustomShortcutSet(tree2, null);
    }

    @Deprecated
    public TreeSpeedSearch(JTree tree2, Convertor<? super TreePath, String> toString) {
        this(tree2, false, (Function<? super TreePath, String>)toString);
    }

    @Deprecated
    public TreeSpeedSearch(Tree tree2, Convertor<? super TreePath, String> toString) {
        this((JTree)tree2, false, (Function<? super TreePath, String>)toString);
    }

    @Deprecated
    public TreeSpeedSearch(Tree tree2, Convertor<? super TreePath, String> toString, boolean canExpand) {
        this((JTree)tree2, canExpand, (Function<? super TreePath, String>)toString);
    }

    @Deprecated
    public TreeSpeedSearch(JTree tree2, Convertor<? super TreePath, String> toString, boolean canExpand) {
        this(tree2, canExpand, (Function<? super TreePath, String>)toString);
    }

    public void setCanExpand(boolean canExpand) {
        this.myCanExpand = canExpand;
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        TreeUtil.selectPath((JTree)((JTree)this.myComponent), (TreePath)((TreePath)element));
    }

    @Override
    protected int getSelectedIndex() {
        if (this.myCanExpand) {
            return this.allPaths().indexOf(Conditions.equalTo((Object)((JTree)this.myComponent).getSelectionPath()));
        }
        int[] selectionRows = ((JTree)this.myComponent).getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    @NotNull
    protected final ListIterator<Object> getElementIterator(int startingViewIndex) {
        ListIterator<Object> listIterator = ((ArrayList)this.allPaths().addAllTo(new ArrayList())).listIterator(startingViewIndex);
        if (listIterator == null) {
            TreeSpeedSearch.$$$reportNull$$$0(9);
        }
        return listIterator;
    }

    @Override
    protected final int getElementCount() {
        return this.allPaths().size();
    }

    @NotNull
    protected JBIterable<TreePath> allPaths() {
        return TreeSpeedSearch.allPaths((JTree)this.getComponent(), this.myCanExpand);
    }

    @NotNull
    static JBIterable<TreePath> allPaths(JTree tree2, boolean expand) {
        JBIterable paths;
        if (expand) {
            paths = TreeUtil.treePathTraverser((JTree)tree2).traverse();
        } else {
            Object[] arr = new TreePath[tree2.getRowCount()];
            for (int i2 = 0; i2 < arr.length; ++i2) {
                arr[i2] = tree2.getPathForRow(i2);
            }
            paths = JBIterable.of((Object[])arr);
        }
        JBIterable jBIterable = paths.filter(o -> !(o.getLastPathComponent() instanceof LoadingNode));
        if (jBIterable == null) {
            TreeSpeedSearch.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @Override
    protected String getElementText(Object element) {
        TreePath path = (TreePath)element;
        String string = this.myPresentableStringFunction.apply(path);
        if (string == null) {
            return TO_STRING.apply(path);
        }
        return string;
    }

    @NotNull
    private List<TreePath> findAllFilteredElements(String s) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            paths.add((TreePath)element);
        }
        ArrayList<TreePath> arrayList = paths;
        if (arrayList == null) {
            TreeSpeedSearch.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableStringFunction";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TreeSpeedSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TreeSpeedSearch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "installOn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIterator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "allPaths";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installOn";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static final class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTree myTree;
        @NotNull
        private final TreeSpeedSearch mySearch;

        MySelectAllAction(@NotNull JTree tree2, @NotNull TreeSpeedSearch search) {
            if (tree2 == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myTree = tree2;
            this.mySearch = search;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTree.getSelectionModel().getSelectionMode() == 4);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MySelectAllAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean alreadySelected;
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(4);
            }
            TreeSelectionModel sm = this.myTree.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            List<TreePath> filtered = this.mySearch.findAllFilteredElements(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean bl = alreadySelected = sm.getSelectionCount() == filtered.size() && ContainerUtil.and(filtered, path -> sm.isPathSelected((TreePath)path));
            if (alreadySelected) {
                TreePath anchor = this.myTree.getAnchorSelectionPath();
                sm.setSelectionPath(anchor);
                this.myTree.setAnchorSelectionPath(anchor);
                this.mySearch.findAndSelectElement(query);
            } else {
                TreePath currentElement = (TreePath)this.mySearch.findElement(query);
                TreePath anchor = (TreePath)ObjectUtils.chooseNotNull((Object)currentElement, (Object)filtered.get(0));
                sm.setSelectionPaths(TreePathUtil.toTreePathArray(filtered));
                this.myTree.setAnchorSelectionPath(anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/TreeSpeedSearch$MySelectAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/TreeSpeedSearch$MySelectAllAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

