/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;

final class JBCefLoadHtmlResourceHandler
extends CefResourceHandlerAdapter {
    private static final Logger LOG = Logger.getInstance((String)JBCefLoadHtmlResourceHandler.class.getName());
    @NotNull
    private final InputStream myInputStream;

    JBCefLoadHtmlResourceHandler(@NotNull String html) {
        if (html == null) {
            JBCefLoadHtmlResourceHandler.$$$reportNull$$$0(0);
        }
        this.myInputStream = new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8));
    }

    public boolean processRequest(@NotNull CefRequest request, @NotNull CefCallback callback) {
        if (request == null) {
            JBCefLoadHtmlResourceHandler.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            JBCefLoadHtmlResourceHandler.$$$reportNull$$$0(2);
        }
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(@NotNull CefResponse response, IntRef response_length, StringRef redirectUrl) {
        if (response == null) {
            JBCefLoadHtmlResourceHandler.$$$reportNull$$$0(3);
        }
        response.setMimeType("text/html");
        response.setStatus(200);
    }

    public boolean readResponse(byte @NotNull [] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        if (data_out == null) {
            JBCefLoadHtmlResourceHandler.$$$reportNull$$$0(4);
        }
        try {
            int availableSize = this.myInputStream.available();
            if (availableSize > 0) {
                int bytesToRead = Math.min(bytes_to_read, availableSize);
                bytesToRead = this.myInputStream.read(data_out, 0, bytesToRead);
                bytes_read.set(bytesToRead);
                return true;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        bytes_read.set(0);
        try {
            this.myInputStream.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data_out";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/JBCefLoadHtmlResourceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getResponseHeaders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readResponse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

