/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ui.jcef.JBCefOsrHandler;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.jetbrains.JBR;
import com.jetbrains.cef.SharedMemory;
import com.jetbrains.cef.SharedMemoryCache;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefNativeRenderHandler;
import org.cef.misc.CefLog;
import org.jetbrains.annotations.NotNull;

class JBCefNativeOsrHandler
extends JBCefOsrHandler
implements CefNativeRenderHandler {
    private static final boolean FORCE_USE_SOFTWARE_RENDERING = !Boolean.getBoolean("jcef.remote.enable_hardware_rendering");
    private final SharedMemoryCache mySharedMemCache;
    private SharedMemory.WithRaster myCurrentFrame;

    JBCefNativeOsrHandler(@NotNull JComponent component2, @NotNull Function<? super JComponent, ? extends Rectangle> screenBoundsProvider) {
        if (component2 == null) {
            JBCefNativeOsrHandler.$$$reportNull$$$0(0);
        }
        if (screenBoundsProvider == null) {
            JBCefNativeOsrHandler.$$$reportNull$$$0(1);
        }
        super(component2, screenBoundsProvider);
        this.mySharedMemCache = new SharedMemoryCache();
    }

    public synchronized void disposeNativeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPaintWithSharedMem(CefBrowser browser, boolean popup2, int dirtyRectsCount, String sharedMemName, long sharedMemHandle, int width, int height) {
        CefLog.Debug((String)"JBCefNativeOsrHandler#onPaintWithSharedMem(browser=%s, sharedMemName=%s, width=%s, height=%s)", (Object[])new Object[]{browser.toString(), sharedMemName, width, height});
        SharedMemory.WithRaster mem = this.mySharedMemCache.get(sharedMemName, sharedMemHandle);
        mem.setWidth(width);
        mem.setHeight(height);
        mem.setDirtyRectsCount(dirtyRectsCount);
        if (popup2) {
            JBHiDPIScaledImage image2 = this.myPopupImage;
            if (image2 == null || image2.getDelegate() == null || image2.getDelegate().getWidth(null) != width || image2.getDelegate().getHeight(null) != height) {
                image2 = (JBHiDPIScaledImage)RetinaImage.createFrom((Image)new BufferedImage(mem.getWidth(), mem.getHeight(), 3), (double)this.getPixelDensity(), null);
            }
            Object object = this.myPopupMutex;
            synchronized (object) {
                JBCefNativeOsrHandler.loadBuffered((BufferedImage)Objects.requireNonNull(image2.getDelegate()), mem);
                this.myPopupImage = image2;
            }
        } else {
            this.myCurrentFrame = mem;
        }
        this.myContentOutdated = true;
        SwingUtilities.invokeLater(() -> {
            if (!browser.getUIComponent().isShowing()) {
                return;
            }
            JRootPane root = SwingUtilities.getRootPane(browser.getUIComponent());
            RepaintManager rm = RepaintManager.currentManager(root);
            Rectangle dirtySrc = new Rectangle(0, 0, browser.getUIComponent().getWidth(), browser.getUIComponent().getHeight());
            Rectangle dirtyDst = SwingUtilities.convertRectangle(browser.getUIComponent(), dirtySrc, root);
            int dx = 1;
            rm.addDirtyRegion(root, dirtyDst.x - dx, dirtyDst.y - dx, dirtyDst.width + dx * 2, dirtyDst.height + dx * 2);
        });
    }

    @Override
    protected Dimension getCurrentFrameSize() {
        SharedMemory.WithRaster frame = this.myCurrentFrame;
        if (frame == null) {
            return null;
        }
        return new Dimension((int)Math.ceil((double)frame.getWidth() / this.getPixelDensity()), (int)Math.ceil((double)frame.getHeight() / this.getPixelDensity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawVolatileImage(VolatileImage vi) {
        SharedMemory.WithRaster frame = this.myCurrentFrame;
        if (frame == null) {
            return;
        }
        SharedMemory.WithRaster withRaster = frame;
        synchronized (withRaster) {
            try {
                frame.lock();
                if (JBCefNativeOsrHandler.useNativeRasterLoader().booleanValue()) {
                    JBR.getNativeRasterLoader().loadNativeRaster(vi, frame.getPtr(), frame.getWidth(), frame.getHeight(), frame.getPtr() + (long)frame.getRectsOffset(), frame.getDirtyRectsCount());
                    return;
                }
                JBHiDPIScaledImage image2 = this.myImage;
                if (image2 == null || image2.getDelegate() == null || image2.getDelegate().getWidth(null) != frame.getWidth() || image2.getDelegate().getHeight(null) != frame.getHeight()) {
                    image2 = (JBHiDPIScaledImage)RetinaImage.createFrom((Image)new BufferedImage(frame.getWidth(), frame.getHeight(), 3), (double)this.getPixelDensity(), null);
                }
                JBCefNativeOsrHandler.loadBuffered((BufferedImage)Objects.requireNonNull(image2.getDelegate()), frame);
                this.myImage = image2;
            }
            finally {
                frame.unlock();
            }
        }
        super.drawVolatileImage(vi);
    }

    private static void loadBuffered(BufferedImage bufImage, SharedMemory.WithRaster mem) {
        int srcW = mem.getWidth();
        int srcH = mem.getHeight();
        ByteBuffer srcBuffer = mem.wrapRaster();
        IntBuffer src = srcBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int dstW = bufImage.getRaster().getWidth();
        int dstH = bufImage.getRaster().getHeight();
        int[] dst = ((DataBufferInt)bufImage.getRaster().getDataBuffer()).getData();
        int rectsCount = mem.getDirtyRectsCount();
        Rectangle[] dirtyRects = new Rectangle[]{new Rectangle(0, 0, srcW, srcH)};
        if (rectsCount > 0) {
            dirtyRects = new Rectangle[rectsCount];
            ByteBuffer rectsMem = mem.wrapRects();
            IntBuffer rects = rectsMem.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            for (int c = 0; c < rectsCount; ++c) {
                int pos = c * 4;
                Rectangle r = new Rectangle();
                r.x = rects.get(pos++);
                r.y = rects.get(pos++);
                r.width = rects.get(pos++);
                r.height = rects.get(pos);
                dirtyRects[c] = r;
            }
        }
        for (Rectangle rect : dirtyRects) {
            if (rect.width < srcW || dstW != srcW) {
                for (int line = rect.y; line < rect.y + rect.height; ++line) {
                    JBCefNativeOsrHandler.copyLine(src, srcW, srcH, dst, dstW, dstH, rect.x, line, rect.x + rect.width);
                }
                continue;
            }
            int offset = rect.y * srcW;
            if (rect.y + rect.height <= dstH) {
                src.position(offset).get(dst, offset, srcW * rect.height);
                continue;
            }
            src.position(offset).get(dst, offset, srcW * (dstH - rect.y));
        }
    }

    private static void copyLine(IntBuffer src, int sw, int sh, int[] dst, int dw, int dh, int x0, int y0, int x1) {
        if (x0 < 0 || x0 >= sw || x0 >= dw || x1 <= x0) {
            return;
        }
        if (y0 < 0 || y0 >= sh || y0 >= dh) {
            return;
        }
        int offsetSrc = y0 * sw + x0;
        int offsetDst = y0 * dw + x0;
        if (x1 > dw) {
            src.position(offsetSrc).get(dst, offsetDst, dw - x0);
        } else {
            src.position(offsetSrc).get(dst, offsetDst, x1 - x0);
        }
    }

    private static Boolean useNativeRasterLoader() {
        return !FORCE_USE_SOFTWARE_RENDERING && JBR.isNativeRasterLoaderSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Color getColorAt(int x, int y) {
        if (!JBCefNativeOsrHandler.useNativeRasterLoader().booleanValue()) {
            return super.getColorAt(x, y);
        }
        if (this.myCurrentFrame == null) {
            return null;
        }
        try {
            Color color;
            this.myCurrentFrame.lock();
            ByteBuffer byteBuffer = this.myCurrentFrame.wrapRaster();
            if (x < 0 || x >= this.myCurrentFrame.getWidth() || y < 0 || y >= this.myCurrentFrame.getHeight()) {
                Color color2 = null;
                return color2;
            }
            Color color3 = color = new Color(byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(y * this.myCurrentFrame.getWidth() + x), true);
            return color3;
        }
        finally {
            this.myCurrentFrame.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "screenBoundsProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/jcef/JBCefNativeOsrHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

