/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUrlChangeAdapter;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.platform.debugger.impl.shared.proxy.XLightLineBreakpointProxy;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.progress.CancellationUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.BreakpointManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.BackendBreakpointRequestCounter;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsUsageCollector;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointManagerKt;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointProxyKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class XBreakpointManagerImpl
implements XBreakpointManager {
    private static final Logger LOG = Logger.getInstance(XBreakpointManagerImpl.class);
    private final ReentrantLock myLock;
    private final MultiMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints;
    private final Map<XBreakpointType, Set<XBreakpointBase<?, ?, ?>>> myDefaultBreakpoints;
    private final Map<XBreakpointType, BreakpointState> myBreakpointsDefaults;
    private final Set<XBreakpointBase<?, ?, ?>> myAllBreakpoints;
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers;
    private volatile XBreakpointsDialogState myBreakpointsDialogSettings;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    @NotNull
    private final CoroutineScope myCoroutineScope;
    private final BackendBreakpointRequestCounter myRequestCounter;
    private long myTime;
    @Nullable
    private volatile String myDefaultGroup;
    private RemovedBreakpointData myLastRemovedBreakpoint;
    private volatile boolean myFirstLoadDone;
    private final ExecutorService myHttpBreakpointUpdater;

    public XBreakpointManagerImpl(final @NotNull Project project, @NotNull XDebuggerManagerImpl debuggerManager, SimpleMessageBusConnection messageBusConnection, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(0);
        }
        if (debuggerManager == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(1);
        }
        if (coroutineScope == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(2);
        }
        this.myLock = new ReentrantLock();
        this.myBreakpoints = MultiMap.createLinkedSet();
        this.myDefaultBreakpoints = new LinkedHashMap();
        this.myBreakpointsDefaults = new LinkedHashMap<XBreakpointType, BreakpointState>();
        this.myAllBreakpoints = new LinkedHashSet();
        this.myDispatchers = new ConcurrentHashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
        this.myRequestCounter = new BackendBreakpointRequestCounter();
        this.myLastRemovedBreakpoint = null;
        this.myFirstLoadDone = false;
        this.myHttpBreakpointUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"HttpFileSystem breakpoints updater");
        this.myProject = project;
        this.myDebuggerManager = debuggerManager;
        this.myCoroutineScope = coroutineScope;
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this, messageBusConnection);
        this.myLineBreakpointManager = new XLineBreakpointManager(project, coroutineScope, !SplitDebuggerMode.isSplitDebugger(), MonolithBreakpointManagerKt.asProxy(this));
        XBreakpointType.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<XBreakpointType>(){

            public void extensionAdded(@NotNull XBreakpointType type, @NotNull PluginDescriptor pluginDescriptor) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (project.isDisposed()) {
                    return;
                }
                XBreakpointBase breakpoint2 = XBreakpointManagerImpl.this.createDefaultBreakpoint(type);
                if (breakpoint2 != null) {
                    XBreakpointManagerImpl.this.addBreakpoint(breakpoint2, true, false);
                }
            }

            public void extensionRemoved(@NotNull XBreakpointType type, @NotNull PluginDescriptor pluginDescriptor) {
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                CancellationUtil.withLockMaybeCancellable((Lock)XBreakpointManagerImpl.this.myLock, () -> {
                    for (Object b : XBreakpointManagerImpl.this.getBreakpoints(type)) {
                        XBreakpoint breakpoint2 = (XBreakpoint)b;
                        XBreakpointManagerImpl.this.doRemoveBreakpointImpl(breakpoint2, XBreakpointManagerImpl.this.isDefaultBreakpoint(breakpoint2));
                    }
                    XBreakpointManagerImpl.this.myBreakpointsDefaults.remove(type);
                    XBreakpointManagerImpl.this.myDefaultBreakpoints.remove(type);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)debuggerManager);
        messageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new VirtualFileUrlChangeAdapter(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                XBreakpointManagerImpl.this.myLineBreakpointManager.onFileDeleted(event.getFile().getUrl());
            }

            protected void fileUrlChanged(String oldUrl, String newUrl) {
                XBreakpointManagerImpl.this.myLineBreakpointManager.onFileUrlChanged(oldUrl, newUrl);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$2", "fileDeleted"));
            }
        }));
    }

    public void init() {
        Project project = this.myProject;
        if (!project.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            HttpFileSystem.getInstance().addFileListener(this::updateBreakpointInHttpFile, (Disposable)project);
        }
    }

    private void updateBreakpointInHttpFile(VirtualFile file2) {
        ReadAction.nonBlocking(() -> this.changedBreakpoints(file2)).coalesceBy(new Object[]{Pair.create((Object)this, (Object)file2)}).expireWith((Disposable)this.myProject).finishOnUiThread(ModalityState.defaultModalityState(), this::fireBreakpointsChanged).submit((Executor)this.myHttpBreakpointUpdater);
    }

    @NotNull
    private Collection<? extends XBreakpointBase<?, ?, ?>> changedBreakpoints(VirtualFile file2) {
        ArrayList result2 = new ArrayList();
        for (XBreakpointBase<?, ?, ?> breakpoint2 : this.getAllBreakpoints()) {
            ProgressManager.checkCanceled();
            XSourcePosition position = breakpoint2.getSourcePosition();
            if (position == null || !Comparing.equal((Object)position.getFile(), (Object)file2)) continue;
            result2.add(breakpoint2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @ApiStatus.Internal
    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myCoroutineScope;
        if (coroutineScope == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(4);
        }
        return coroutineScope;
    }

    @ApiStatus.Internal
    public BackendBreakpointRequestCounter getRequestCounter() {
        return this.myRequestCounter;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        return this.doAddBreakpoint(type, properties, false);
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addDefaultBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        return this.doAddBreakpoint(type, properties, true);
    }

    @NotNull
    private <T extends XBreakpointProperties> XBreakpoint<T> doAddBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties, boolean defaultBreakpoint) {
        XBreakpoint xBreakpoint = (XBreakpoint)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            XBreakpointBase<?, XBreakpointProperties, ?> breakpoint2 = this.createBreakpoint(type, properties, true, defaultBreakpoint);
            this.addBreakpoint(breakpoint2, defaultBreakpoint, true);
            return breakpoint2;
        });
        if (xBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(5);
        }
        return xBreakpoint;
    }

    private <T extends XBreakpointProperties> XBreakpointBase<?, T, ?> createBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, T properties, boolean enabled, boolean defaultBreakpoint) {
        return (XBreakpointBase)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            BreakpointState state = new BreakpointState(enabled, type.getId(), defaultBreakpoint ? 0L : (this.myTime = this.myTime + 1L), type.getDefaultSuspendPolicy());
            this.getBreakpointDefaults(type).applyDefaults(state);
            state.setGroup(this.myDefaultGroup);
            return new XBreakpointBase(type, this, properties, state);
        });
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint2, boolean defaultBreakpoint, boolean initUI) {
        XBreakpointType type = breakpoint2.getType();
        CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            if (defaultBreakpoint) {
                this.myDefaultBreakpoints.computeIfAbsent(type, k -> new LinkedHashSet()).add(breakpoint2);
            } else {
                this.myBreakpoints.putValue((Object)type, (Object)breakpoint2);
                if (initUI) {
                    BreakpointsUsageCollector.reportNewBreakpoint(breakpoint2, type, this.getDebuggerManager().getCurrentSession() != null);
                }
            }
            this.myAllBreakpoints.add(breakpoint2);
            if (breakpoint2 instanceof XLineBreakpointImpl) {
                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)breakpoint2;
                this.myLineBreakpointManager.registerBreakpoint(MonolithBreakpointProxyKt.asProxy(lineBreakpoint), initUI);
            }
        });
        this.sendBreakpointEvent(type, listener -> listener.breakpointAdded((XBreakpoint)breakpoint2));
    }

    @NotNull
    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        XBreakpointListener xBreakpointListener = (XBreakpointListener)this.myProject.getMessageBus().syncPublisher(XBreakpointListener.TOPIC);
        if (xBreakpointListener == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(6);
        }
        return xBreakpointListener;
    }

    private void fireBreakpointsChanged(Collection<? extends XBreakpointBase<?, ?, ?>> breakpoints) {
        for (XBreakpointBase<?, ?, ?> breakpoint2 : breakpoints) {
            this.fireBreakpointChanged(breakpoint2);
        }
    }

    private boolean isRegistered(XBreakpoint<?> breakpoint2) {
        return (Boolean)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> this.myAllBreakpoints.contains(breakpoint2));
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint2) {
        if (this.isRegistered(breakpoint2)) {
            if (breakpoint2 instanceof XLineBreakpointImpl) {
                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)breakpoint2;
                this.myLineBreakpointManager.breakpointChanged((XLightLineBreakpointProxy)MonolithBreakpointProxyKt.asProxy(lineBreakpoint));
            }
            this.sendBreakpointEvent(breakpoint2.getType(), listener -> listener.breakpointChanged((XBreakpoint)breakpoint2));
        }
    }

    public void fireBreakpointPresentationUpdated(XBreakpoint<?> breakpoint2, @Nullable XDebugSession session) {
        if (this.isRegistered(breakpoint2)) {
            this.sendBreakpointEvent(breakpoint2.getType(), listener -> listener.breakpointPresentationUpdated(breakpoint2, session));
        }
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint2) {
        if (breakpoint2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(7);
        }
        this.removeBreakpoints(List.of(breakpoint2));
    }

    void removeBreakpoints(@NotNull Collection<? extends XBreakpoint> toRemove) {
        if (toRemove == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(8);
        }
        CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> toRemove.forEach(this::doRemoveBreakpoint));
    }

    public void removeAllBreakpoints() {
        CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> List.copyOf(this.myAllBreakpoints).forEach(this::doRemoveBreakpoint));
    }

    public void removeDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint2) {
        if (breakpoint2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(9);
        }
        CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            if (!this.isDefaultBreakpoint(breakpoint2)) {
                throw new IllegalStateException("Trying to remove not default breakpoint " + String.valueOf(breakpoint2));
            }
            this.doRemoveBreakpointImpl(breakpoint2, true);
        });
    }

    private void doRemoveBreakpoint(XBreakpoint<?> breakpoint2) {
        if (this.isDefaultBreakpoint(breakpoint2)) {
            breakpoint2.setEnabled(false);
        } else {
            this.doRemoveBreakpointImpl(breakpoint2, false);
        }
    }

    private void doRemoveBreakpointImpl(XBreakpoint<?> breakpoint2, boolean isDefaultBreakpoint) {
        XBreakpointType type = breakpoint2.getType();
        XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint2;
        CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            if (isDefaultBreakpoint) {
                Set<XBreakpointBase<?, ?, ?>> typeDefaultBreakpoints = this.myDefaultBreakpoints.get(breakpoint2.getType());
                if (typeDefaultBreakpoints != null) {
                    typeDefaultBreakpoints.remove(breakpoint2);
                }
            } else {
                this.myBreakpoints.remove((Object)type, (Object)breakpointBase);
            }
            this.myAllBreakpoints.remove(breakpointBase);
            if (breakpointBase instanceof XLineBreakpointImpl) {
                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)breakpointBase;
                this.myLineBreakpointManager.unregisterBreakpoint(MonolithBreakpointProxyKt.asProxy(lineBreakpoint));
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> breakpointBase.dispose());
        this.sendBreakpointEvent(type, listener -> listener.breakpointRemoved(breakpoint2));
    }

    private void sendBreakpointEvent(XBreakpointType type, Consumer<? super XBreakpointListener<XBreakpoint<?>>> event) {
        if (this.myFirstLoadDone) {
            EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type);
            if (dispatcher != null) {
                XBreakpointListener multicaster = (XBreakpointListener)dispatcher.getMulticaster();
                event.accept(multicaster);
            }
            event.accept(this.getBreakpointDispatcherMulticaster());
        }
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(10);
        }
        XLineBreakpoint<T> xLineBreakpoint = this.addLineBreakpoint(type, fileUrl, line, properties, false);
        if (xLineBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(11);
        }
        return xLineBreakpoint;
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties, boolean temporary) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(12);
        }
        XLineBreakpoint<T> xLineBreakpoint = this.addLineBreakpoint(type, fileUrl, line, properties, temporary, true);
        if (xLineBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(13);
        }
        return xLineBreakpoint;
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties, boolean temporary, boolean initUI) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(14);
        }
        XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            LineBreakpointState state = new LineBreakpointState(true, type.getId(), fileUrl, line, temporary, ++this.myTime, type.getDefaultSuspendPolicy());
            this.getBreakpointDefaults((XBreakpointType)type).applyDefaults(state);
            state.setGroup(this.myDefaultGroup);
            XLineBreakpointImpl<XBreakpointProperties> breakpoint2 = new XLineBreakpointImpl<XBreakpointProperties>(type, this, properties, state);
            this.addBreakpoint(breakpoint2, false, initUI);
            return breakpoint2;
        });
        if (xLineBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(15);
        }
        return xLineBreakpoint;
    }

    public XBreakpointBase<?, ?, ?> @NotNull [] getAllBreakpoints() {
        XBreakpointBase[] xBreakpointBaseArray = (XBreakpointBase[])CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> this.myAllBreakpoints.toArray(new XBreakpointBase[0]));
        if (xBreakpointBaseArray == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(16);
        }
        return xBreakpointBaseArray;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(17);
        }
        Collection collection = (Collection)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            ArrayList result2 = new ArrayList(this.getDefaultBreakpoints(type));
            result2.addAll(this.myBreakpoints.get((Object)type));
            return Collections.unmodifiableList(result2);
        });
        if (collection == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        XBreakpointType type;
        if (typeClass == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(19);
        }
        LOG.assertTrue((type = XDebuggerUtil.getInstance().findBreakpointType(typeClass)) != null, (Object)("Unregistered breakpoint type " + String.valueOf(typeClass) + ", registered: " + Arrays.toString(XBreakpointType.EXTENSION_POINT_NAME.getExtensions())));
        Collection<B> collection = this.getBreakpoints(type);
        if (collection == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Set<B> getDefaultBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(21);
        }
        Set set = (Set)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            Set<XBreakpointBase<?, ?, ?>> breakpointsSet = this.myDefaultBreakpoints.get(type);
            if (breakpointsSet == null) {
                return Collections.emptySet();
            }
            return Set.copyOf(breakpointsSet);
        });
        if (set == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    public <B extends XLineBreakpoint<P>, P extends XBreakpointProperties> Collection<B> findBreakpointsAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(24);
        }
        Collection collection = (Collection)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> ((StreamEx)StreamEx.of((Collection)this.myBreakpoints.get((Object)type)).select(XLineBreakpoint.class).filter(b -> b.getFileUrl().equals(file2.getUrl()) && b.getLine() == line)).toList());
        if (collection == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(27);
        }
        return (XLineBreakpoint)ContainerUtil.getFirstItem(this.findBreakpointsAtLine(type, file2, line));
    }

    public boolean isDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint2) {
        if (breakpoint2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(28);
        }
        return (Boolean)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> ContainerUtil.exists(this.myDefaultBreakpoints.values(), s -> s.contains(breakpoint2)));
    }

    private <T extends XBreakpointProperties<?>> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type) {
        return this.myDispatchers.computeIfAbsent(type, k -> EventDispatcher.create(XBreakpointListener.class));
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(29);
        }
        if (listener == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(30);
        }
        this.getOrCreateDispatcher(type).addListener(listener);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(31);
        }
        if (listener == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(32);
        }
        this.getOrCreateDispatcher(type).removeListener(listener);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener, Disposable parentDisposable) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(33);
        }
        if (listener == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(34);
        }
        this.getOrCreateDispatcher(type).addListener(listener, parentDisposable);
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint2, @Nullable Icon icon, @Nullable String errorMessage) {
        XLineBreakpointImpl lineBreakpoint;
        CustomizedBreakpointPresentation presentation;
        if (breakpoint2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(35);
        }
        if ((presentation = (lineBreakpoint = (XLineBreakpointImpl)breakpoint2).getCustomizedPresentation()) == null) {
            if (icon == null && errorMessage == null) {
                return;
            }
            presentation = new CustomizedBreakpointPresentation();
        } else if (Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
            return;
        }
        presentation.setErrorMessage(errorMessage);
        presentation.setIcon(icon);
        lineBreakpoint.setCustomizedPresentation(presentation);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint2, () -> ((XBreakpointBase)breakpoint2).fireBreakpointPresentationUpdated(null));
    }

    @ApiStatus.Internal
    @NotNull
    public BreakpointManagerState saveState(@NotNull BreakpointManagerState state) {
        if (state == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(36);
        }
        Map defaultBreakpointsMap = StreamEx.of(this.createDefaultBreakpoints()).toMap(XBreakpointBase::getType, Function.identity());
        BreakpointManagerState breakpointManagerState = (BreakpointManagerState)((Object)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            this.myDependentBreakpointManager.saveState();
            SmartList defaultBreakpoints = new SmartList();
            for (Set<XBreakpointBase<?, ?, ?>> typeDefaultBreakpoints : this.myDefaultBreakpoints.values()) {
                if (!ContainerUtil.exists(typeDefaultBreakpoints, breakpoint2 -> XBreakpointManagerImpl.differsFromDefault(defaultBreakpointsMap, breakpoint2.getType(), breakpoint2.getState()))) continue;
                for (XBreakpointBase xBreakpointBase : typeDefaultBreakpoints) {
                    Object breakpointState = xBreakpointBase.getState();
                    defaultBreakpoints.add(breakpointState);
                }
            }
            SmartList breakpoints = new SmartList();
            for (XBreakpointBase breakpoint4 : this.myBreakpoints.values()) {
                breakpoints.add(breakpoint4.getState());
            }
            SmartList breakpointsDefaults = new SmartList();
            for (Map.Entry entry : this.myBreakpointsDefaults.entrySet()) {
                if (!XBreakpointManagerImpl.statesAreDifferent((BreakpointState)entry.getValue(), XBreakpointManagerImpl.createBreakpointDefaults((XBreakpointType)entry.getKey()), false)) continue;
                breakpointsDefaults.add((BreakpointState)entry.getValue());
            }
            state.getDefaultBreakpoints().clear();
            state.getDefaultBreakpoints().addAll((Collection<BreakpointState>)defaultBreakpoints);
            state.getBreakpoints().clear();
            state.getBreakpoints().addAll((Collection<BreakpointState>)breakpoints);
            state.getBreakpointsDefaults().clear();
            state.getBreakpointsDefaults().addAll((Collection<BreakpointState>)breakpointsDefaults);
            state.setBreakpointsDialogProperties(this.myBreakpointsDialogSettings);
            state.setDefaultGroup(this.myDefaultGroup);
            return state;
        }));
        if (breakpointManagerState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(37);
        }
        return breakpointManagerState;
    }

    private static <P extends XBreakpointProperties> boolean differsFromDefault(Map<XBreakpointType, XBreakpointBase> defaultBreakpoints, XBreakpointType<?, P> type, BreakpointState state) {
        XBreakpointBase defaultBreakpoint = defaultBreakpoints.get(type);
        if (defaultBreakpoint == null) {
            return false;
        }
        return XBreakpointManagerImpl.statesAreDifferent(state, defaultBreakpoint.getState(), false);
    }

    public static boolean statesAreDifferent(BreakpointState state1, BreakpointState state2, boolean ignoreTimestamp) {
        Element elem2;
        Element elem1;
        boolean res;
        long timeStamp1 = state1.getTimeStamp();
        long timeStamp2 = state2.getTimeStamp();
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp2);
        }
        boolean bl = res = !JDOMUtil.areElementsEqual((Element)(elem1 = XmlSerializer.serialize((Object)state1)), (Element)(elem2 = XmlSerializer.serialize((Object)state2)));
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp1);
        }
        return res;
    }

    @ApiStatus.Internal
    public void loadState(@NotNull BreakpointManagerState state) {
        if (state == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(38);
        }
        List<? extends XBreakpointBase> defaultBreakpoints = this.createDefaultBreakpoints();
        ApplicationManager.getApplication().runReadAction(() -> CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            this.myBreakpointsDialogSettings = state.getBreakpointsDialogProperties();
            this.myAllBreakpoints.clear();
            this.myDefaultBreakpoints.clear();
            this.myBreakpointsDefaults.clear();
            state.getDefaultBreakpoints().forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, true));
            ((StreamEx)StreamEx.of((Collection)defaultBreakpoints).remove(b -> this.myDefaultBreakpoints.containsKey(b.getType()))).forEach(b -> this.addBreakpoint((XBreakpointBase)b, true, false));
            List.copyOf(this.myBreakpoints.values()).forEach(this::doRemoveBreakpoint);
            ContainerUtil.notNullize(state.getBreakpoints()).forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, false));
            for (BreakpointState defaults : state.getBreakpointsDefaults()) {
                XBreakpointType<?, ?> type = XBreakpointUtil.findType(defaults.getTypeId());
                if (type != null) {
                    this.myBreakpointsDefaults.put(type, defaults);
                    continue;
                }
                LOG.warn("Unknown breakpoint type " + defaults.getTypeId());
            }
            this.myDependentBreakpointManager.loadState();
            this.myLineBreakpointManager.updateBreakpointsUI();
            this.myDefaultGroup = state.getDefaultGroup();
            this.myFirstLoadDone = true;
        }));
    }

    public void noStateLoaded() {
        List<? extends XBreakpointBase> defaultBreakpoints = this.createDefaultBreakpoints();
        CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            this.myDefaultBreakpoints.clear();
            defaultBreakpoints.forEach(b -> this.addBreakpoint((XBreakpointBase)b, true, false));
            this.myFirstLoadDone = true;
        });
    }

    private List<? extends XBreakpointBase> createDefaultBreakpoints() {
        return XBreakpointUtil.breakpointTypes().map(this::createDefaultBreakpoint).nonNull().toList();
    }

    @Nullable
    private <P extends XBreakpointProperties> XBreakpointBase<?, P, ?> createDefaultBreakpoint(XBreakpointType<? extends XBreakpoint<P>, P> type) {
        assert (!this.myLock.isHeldByCurrentThread());
        return (XBreakpointBase)type.createDefaultBreakpoint(properties -> this.createBreakpoint(type, properties, false, true));
    }

    private void loadBreakpoint(BreakpointState breakpointState, boolean defaultBreakpoint) {
        XBreakpointBase<?, ?, ?> breakpoint2 = this.createBreakpoint(breakpointState);
        if (breakpoint2 != null) {
            this.addBreakpoint(breakpoint2, defaultBreakpoint, false);
        }
        this.myTime = Math.max(this.myTime, breakpointState.getTimeStamp());
    }

    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this.myBreakpointsDialogSettings;
    }

    public void setBreakpointsDialogSettings(XBreakpointsDialogState breakpointsDialogSettings) {
        this.myBreakpointsDialogSettings = breakpointsDialogSettings;
    }

    @Nullable
    public String getDefaultGroup() {
        return this.myDefaultGroup;
    }

    public void setDefaultGroup(@Nullable String defaultGroup) {
        this.myDefaultGroup = defaultGroup;
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(BreakpointState breakpointState) {
        XBreakpointType<?, ?> type = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type == null) {
            LOG.warn("Unknown breakpoint type " + breakpointState.getTypeId());
            return null;
        }
        return XBreakpointUtil.createBreakpoint(type, breakpointState, this);
    }

    @NotNull
    public BreakpointState getBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(39);
        }
        BreakpointState breakpointState = (BreakpointState)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> this.myBreakpointsDefaults.computeIfAbsent(type, k -> XBreakpointManagerImpl.createBreakpointDefaults(type)));
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(40);
        }
        return breakpointState;
    }

    @Nullable
    public <T extends XBreakpointProperties> XLineBreakpoint<T> copyLineBreakpoint(@NotNull XLineBreakpoint<T> source, @NotNull String fileUrl, int line) {
        if (source == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(41);
        }
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(42);
        }
        return (XLineBreakpoint)CancellationUtil.withLockMaybeCancellable((Lock)this.myLock, () -> {
            if (!(source instanceof XLineBreakpointImpl)) {
                return null;
            }
            this.myDependentBreakpointManager.saveState();
            LineBreakpointState sourceState = (LineBreakpointState)((XLineBreakpointImpl)source).getState();
            Element element = XmlSerializer.serialize((Object)sourceState);
            LineBreakpointState newState = element == null ? new LineBreakpointState() : (LineBreakpointState)XmlSerializer.deserialize((Element)element, LineBreakpointState.class);
            newState.setLine(line);
            newState.setFileUrl(fileUrl);
            XLineBreakpointImpl breakpoint2 = (XLineBreakpointImpl)this.createBreakpoint(newState);
            if (breakpoint2 != null) {
                this.addBreakpoint(breakpoint2, false, true);
                XBreakpoint<?> masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint((XBreakpoint<?>)source);
                if (masterBreakpoint != null) {
                    this.myDependentBreakpointManager.setMasterBreakpoint(breakpoint2, masterBreakpoint, sourceState.getDependencyState().isLeaveEnabled());
                }
            }
            return breakpoint2;
        });
    }

    @NotNull
    private static BreakpointState createBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(43);
        }
        BreakpointState state = new BreakpointState();
        state.setTypeId(type.getId());
        state.setSuspendPolicy(type.getDefaultSuspendPolicy());
        BreakpointState breakpointState = state;
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(44);
        }
        return breakpointState;
    }

    public void rememberRemovedBreakpoint(@NotNull XBreakpointBase breakpoint2) {
        if (breakpoint2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(45);
        }
        this.myLastRemovedBreakpoint = new RemovedBreakpointData(breakpoint2);
    }

    @Nullable
    public XBreakpointBase getLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null ? this.myLastRemovedBreakpoint.myBreakpoint : null;
    }

    @Nullable
    public XBreakpoint restoreLastRemovedBreakpoint() {
        if (this.myLastRemovedBreakpoint != null) {
            XBreakpoint breakpoint2 = this.myLastRemovedBreakpoint.restore();
            this.myLastRemovedBreakpoint = null;
            return breakpoint2;
        }
        return null;
    }

    public boolean canRestoreLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null && this.myLastRemovedBreakpoint.isRestorable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 11, 13, 15, 16, 18, 20, 22, 25, 37, 40, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 37: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 7: 
            case 9: 
            case 28: 
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClass";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "changedBreakpoints";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doAddBreakpoint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointDispatcherMulticaster";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineBreakpoint";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBreakpoints";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpoints";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBreakpoints";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findBreakpointsAtLine";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointDefaults";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 37: 
            case 40: 
            case 44: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoints";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDefaultBreakpoint";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addLineBreakpoint";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpoints";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBreakpoints";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointsAtLine";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointAtLine";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultBreakpoint";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointListener";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpointListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateBreakpointPresentation";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointDefaults";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyLineBreakpoint";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointDefaults";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "rememberRemovedBreakpoint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 11, 13, 15, 16, 18, 20, 22, 25, 37, 40, 44 -> new IllegalStateException(string);
        };
    }

    private final class RemovedBreakpointData {
        private final XBreakpointBase myBreakpoint;
        private final XDependentBreakpointManager.DependenciesData myDependenciesData;

        private RemovedBreakpointData(XBreakpointBase breakpoint2) {
            if (breakpoint2 == null) {
                RemovedBreakpointData.$$$reportNull$$$0(0);
            }
            this.myBreakpoint = breakpoint2;
            XDependentBreakpointManager xDependentBreakpointManager = XBreakpointManagerImpl.this.myDependentBreakpointManager;
            Objects.requireNonNull(xDependentBreakpointManager);
            this.myDependenciesData = new XDependentBreakpointManager.DependenciesData(xDependentBreakpointManager, breakpoint2);
        }

        boolean isRestorable() {
            return !(this.myBreakpoint instanceof XLineBreakpointImpl) || ((XLineBreakpointImpl)this.myBreakpoint).getFile() != null;
        }

        @Nullable
        XBreakpoint restore() {
            XBreakpointBase<?, ?, ?> breakpoint2;
            if (this.myBreakpoint instanceof XLineBreakpointImpl) {
                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)this.myBreakpoint;
                VirtualFile file2 = lineBreakpoint.getFile();
                if (file2 == null) {
                    return null;
                }
                XLineBreakpoint existingBreakpoint = XBreakpointManagerImpl.this.findBreakpointAtLine(lineBreakpoint.getType(), file2, lineBreakpoint.getLine());
                if (existingBreakpoint != null) {
                    XBreakpointManagerImpl.this.removeBreakpoint((XBreakpoint<?>)existingBreakpoint);
                }
            }
            if ((breakpoint2 = XBreakpointManagerImpl.this.createBreakpoint((BreakpointState)this.myBreakpoint.getState())) != null) {
                XBreakpointManagerImpl.this.addBreakpoint(breakpoint2, false, true);
                this.myDependenciesData.restore(breakpoint2);
                return breakpoint2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$RemovedBreakpointData", "<init>"));
        }
    }
}

