/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RefEntityImpl
extends UserDataHolderBase
implements RefEntity,
WritableRefEntity {
    private WritableRefEntity myOwner;
    private List<RefEntity> myChildren;
    private final String myName;
    protected long myFlags;
    protected final RefManagerImpl myManager;

    protected RefEntityImpl(@NotNull String name, @NotNull RefManager manager) {
        if (name == null) {
            RefEntityImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RefEntityImpl.$$$reportNull$$$0(1);
        }
        this.myManager = (RefManagerImpl)manager;
        this.myName = this.myManager.internName(name);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RefEntityImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myName;
        if (string == null) {
            RefEntityImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public synchronized List<RefEntity> getChildren() {
        List<RefEntity> list = this.myChildren == null ? ContainerUtil.emptyList() : this.myChildren;
        if (list == null) {
            RefEntityImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public synchronized WritableRefEntity getOwner() {
        return this.myOwner;
    }

    @Override
    public synchronized void setOwner(@NotNull WritableRefEntity owner) {
        if (owner == null) {
            RefEntityImpl.$$$reportNull$$$0(5);
        }
        this.myOwner = owner;
    }

    @Override
    public synchronized void add(@NotNull RefEntity child) {
        if (child == null) {
            RefEntityImpl.$$$reportNull$$$0(6);
        }
        this.addChild(child);
        ((RefEntityImpl)child).setOwner(this);
    }

    protected synchronized void addChild(@NotNull RefEntity child) {
        List<RefEntity> children;
        if (child == null) {
            RefEntityImpl.$$$reportNull$$$0(7);
        }
        if ((children = this.myChildren) == null) {
            this.myChildren = children = new ArrayList<RefEntity>(1);
        }
        children.add(child);
    }

    @Override
    public synchronized void removeChild(@NotNull RefEntity child) {
        if (child == null) {
            RefEntityImpl.$$$reportNull$$$0(8);
        }
        if (this.myChildren != null) {
            this.myChildren.remove(child);
        }
    }

    public String toString() {
        return this.getName();
    }

    public void accept(@NotNull RefVisitor refVisitor) {
        if (refVisitor == null) {
            RefEntityImpl.$$$reportNull$$$0(9);
        }
        ReadAction.run(() -> refVisitor.visitElement((RefEntity)this));
    }

    public synchronized boolean checkFlag(long mask) {
        return BitUtil.isSet((long)this.myFlags, (long)mask);
    }

    public synchronized boolean checkAndSetFlag(long mask) {
        boolean result = BitUtil.isSet((long)this.myFlags, (long)mask);
        if (!result) {
            this.myFlags = BitUtil.set((long)this.myFlags, (long)mask, (boolean)true);
        }
        return result;
    }

    public synchronized void setFlag(boolean value, long mask) {
        this.myFlags = BitUtil.set((long)this.myFlags, (long)mask, (boolean)value);
    }

    public String getExternalName() {
        return this.myName;
    }

    @NotNull
    public RefManagerImpl getRefManager() {
        RefManagerImpl refManagerImpl = this.myManager;
        if (refManagerImpl == null) {
            RefEntityImpl.$$$reportNull$$$0(10);
        }
        return refManagerImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefEntityImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefEntityImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOwner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 10 -> new IllegalStateException(string);
        };
    }
}

