/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.appendonlylog.dev;

import com.intellij.openapi.util.IntRef;
import com.intellij.platform.util.io.storages.AlignmentUtils;
import com.intellij.platform.util.io.storages.appendonlylog.dev.ChunkedAppendOnlyLog;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import com.intellij.util.io.blobstorage.ByteBufferWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class ChunkedAppendOnlyLogOverMMappedFile
implements ChunkedAppendOnlyLog,
Unmappable {
    private static final boolean MORE_DIAGNOSTIC_INFORMATION = SystemProperties.getBooleanProperty((String)"ChunkedAppendOnlyLogOverMMappedFile.MORE_DIAGNOSTIC_INFORMATION", (boolean)true);
    private static final boolean ADD_LOG_CONTENT = SystemProperties.getBooleanProperty((String)"ChunkedAppendOnlyLogOverMMappedFile.ADD_LOG_CONTENT", (boolean)true);
    private static final int DEBUG_DUMP_REGION_WIDTH = 128;
    private static final VarHandle INT32_OVER_BYTE_BUFFER = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private static final VarHandle INT64_OVER_BYTE_BUFFER = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private static final int UNSET_VALUE = 0;
    public static final int MAGIC_WORD = IOUtil.asciiToMagicWord((String)"AOL2");
    public static final int CURRENT_IMPLEMENTATION_VERSION = 1;
    public static final int MAX_PAYLOAD_SIZE_WITH_NEXT_CHUNK = LogChunkImpl.CHUNK_LENGTH_MAX - 4 - 8;
    public static final int MAX_PAYLOAD_SIZE_WITHOUT_NEXT_CHUNK = LogChunkImpl.CHUNK_LENGTH_MAX - 4 - 8;
    private final Object allocationLock;
    @NotNull
    private final MMappedFileStorage storage;
    private transient FileHeader header;
    private final long startOfSuspiciousRegion;
    private final long endOfSuspiciousRegion;

    public ChunkedAppendOnlyLogOverMMappedFile(@NotNull MMappedFileStorage storage) throws IOException {
        long nextRecordToBeCommittedOffset;
        if (storage == null) {
            ChunkedAppendOnlyLogOverMMappedFile.$$$reportNull$$$0(0);
        }
        this.allocationLock = new Object();
        this.storage = storage;
        boolean fileIsEmpty = storage.actualFileSize() == 0L;
        int pageSize = storage.pageSize();
        if (!AlignmentUtils.is64bAligned(pageSize)) {
            throw new IllegalArgumentException("storage.pageSize(=" + pageSize + ") must be 64b-aligned");
        }
        this.header = new FileHeader(storage.pageByOffset(0L));
        if (fileIsEmpty) {
            this.header.putMagicWord(MAGIC_WORD);
            this.header.putImplementationVersion(1);
            this.header.putPageSize(pageSize);
        } else {
            ChunkedAppendOnlyLogOverMMappedFile.checkFileParamsCompatible(storage.storagePath(), this.header, pageSize);
        }
        long nextRecordToBeAllocatedOffset = this.header.getLongHeaderField(16);
        if (nextRecordToBeAllocatedOffset == 0L) {
            nextRecordToBeAllocatedOffset = 64L;
            this.header.setLongHeaderField(16, nextRecordToBeAllocatedOffset);
        }
        if ((nextRecordToBeCommittedOffset = this.header.getLongHeaderField(24)) == 0L) {
            nextRecordToBeCommittedOffset = 64L;
            this.header.setLongHeaderField(24, nextRecordToBeCommittedOffset);
        }
        if (nextRecordToBeCommittedOffset < nextRecordToBeAllocatedOffset) {
            this.startOfSuspiciousRegion = nextRecordToBeCommittedOffset;
            this.endOfSuspiciousRegion = nextRecordToBeAllocatedOffset;
            long successfullyRecoveredUntil = this.recoverRegion(nextRecordToBeCommittedOffset, nextRecordToBeAllocatedOffset);
            long fileSize = storage.actualFileSize();
            if (fileSize < successfullyRecoveredUntil) {
                throw new AssertionError((Object)("file(=" + String.valueOf(storage.storagePath()) + ").size(=" + fileSize + ") < recoveredUntil(=" + successfullyRecoveredUntil + ")"));
            }
            storage.zeroizeTillEOF(successfullyRecoveredUntil);
            nextRecordToBeCommittedOffset = successfullyRecoveredUntil;
            nextRecordToBeAllocatedOffset = successfullyRecoveredUntil;
            IntRef recordsCount = new IntRef(0);
            this.forEachRecord(chunk -> {
                recordsCount.inc();
                return true;
            }, successfullyRecoveredUntil);
            this.header.setIntHeaderField(32, recordsCount.get());
        } else {
            this.startOfSuspiciousRegion = -1L;
            this.endOfSuspiciousRegion = -1L;
        }
        this.header.setLongHeaderField(16, nextRecordToBeAllocatedOffset);
        this.header.setLongHeaderField(24, nextRecordToBeCommittedOffset);
    }

    public int getImplementationVersion() {
        return this.header.readImplementationVersion();
    }

    public int getDataVersion() {
        return this.header.getIntHeaderField(8);
    }

    public void setDataVersion(int version) {
        this.header.setIntHeaderField(8, version);
    }

    @Override
    public int chunksCount() {
        return this.header.getIntHeaderField(32);
    }

    public int getUserDefinedHeaderField(int fieldNo) {
        int headerOffset = 36 + fieldNo * 4;
        return this.header.getIntHeaderField(headerOffset);
    }

    public void setUserDefinedHeaderField(int fieldNo, int headerFieldValue) {
        int headerOffset = 36 + fieldNo * 4;
        this.header.setIntHeaderField(headerOffset, headerFieldValue);
    }

    public boolean wasRecoveryNeeded() {
        return this.startOfSuspiciousRegion >= 0L && this.endOfSuspiciousRegion > this.startOfSuspiciousRegion;
    }

    public Path storagePath() {
        return this.storage.storagePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedAppendOnlyLog.LogChunk append(int chunkPayloadCapacity, boolean reserveNextChunkIdField) throws IOException {
        ChunkedAppendOnlyLogOverMMappedFile.checkPayloadCapacity(chunkPayloadCapacity, reserveNextChunkIdField);
        int pageSize = this.storage.pageSize();
        int totalChunkLength = LogChunkImpl.chunkLengthForPayload(chunkPayloadCapacity, reserveNextChunkIdField);
        if (totalChunkLength > pageSize) {
            throw new IllegalArgumentException("Requested chunkPayloadCapacity(=" + chunkPayloadCapacity + ") is too big: chunk with header (=" + totalChunkLength + ") must fit pageSize(=" + pageSize + ")");
        }
        Object object = this.allocationLock;
        synchronized (object) {
            long chunkOffsetInFile = this.allocateSpaceForChunk(totalChunkLength);
            AlignmentUtils.assert64bAligned(chunkOffsetInFile, "chunkOffsetInFile");
            MMappedFileStorage.Page page = this.storage.pageByOffset(chunkOffsetInFile);
            int offsetInPage = this.storage.toOffsetInPage(chunkOffsetInFile);
            LogChunkImpl chunk = LogChunkImpl.putRegularChunk(page.rawPageBuffer(), totalChunkLength, offsetInPage, chunkOffsetInFile, reserveNextChunkIdField);
            this.header.addToDataRecordsCount(1);
            this.header.updateFirstUnCommittedOffset(chunkOffsetInFile + (long)totalChunkLength);
            return chunk;
        }
    }

    @Override
    public ChunkedAppendOnlyLog.LogChunk read(long chunkId) throws IOException {
        long chunksCommittedUpTo;
        long chunkOffsetInFile = ChunkedAppendOnlyLogOverMMappedFile.chunkIdToOffset(chunkId);
        if (chunkOffsetInFile >= (chunksCommittedUpTo = this.header.firstUnCommittedOffset())) {
            throw new IllegalArgumentException("Can't read chunk(id: " + chunkId + ", offset: " + chunkOffsetInFile + "): outside of committed region [<" + chunksCommittedUpTo + "] " + this.moreDiagnosticInfo(chunkOffsetInFile));
        }
        MMappedFileStorage.Page page = this.storage.pageByOffset(chunkOffsetInFile);
        int chunkOffsetInPage = this.storage.toOffsetInPage(chunkOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        LogChunkImpl chunk = this.readChunkAt(pageBuffer, chunkOffsetInPage, chunkOffsetInFile);
        if (!chunk.isFitIntoPage()) {
            throw new CorruptedException(String.valueOf(chunk) + ".chunkLength(=" + chunk.chunkLength() + ") is incorrect: page[0.." + pageBuffer.limit() + "], committedUpTo: " + this.header.firstUnCommittedOffset() + ", allocatedUpTo: " + this.header.firstUnAllocatedOffset() + ". " + this.moreDiagnosticInfo(chunkOffsetInFile) + (String)(ADD_LOG_CONTENT ? "\n" + this.dumpContentAroundId(chunk.id(), 128) : ""));
        }
        if (chunk.isPadding()) {
            throw new IOException(String.valueOf(chunk) + " is a PaddingChunk -- i.e. has no data. " + this.moreDiagnosticInfo(chunkOffsetInFile));
        }
        return chunk;
    }

    public boolean isValidId(long chunkId) {
        if (chunkId <= 0L) {
            return false;
        }
        long chunkOffset = ChunkedAppendOnlyLogOverMMappedFile.chunkIdToOffsetUnchecked(chunkId);
        if (!AlignmentUtils.is64bAligned(chunkOffset)) {
            return false;
        }
        return chunkOffset < this.header.firstUnAllocatedOffset();
    }

    @Override
    public boolean forEachChunk(@NotNull ChunkedAppendOnlyLog.ChunkReader reader) throws IOException {
        if (reader == null) {
            ChunkedAppendOnlyLogOverMMappedFile.$$$reportNull$$$0(1);
        }
        long firstUnallocatedOffset = this.header.firstUnAllocatedOffset();
        return this.forEachRecord(reader, firstUnallocatedOffset);
    }

    public void clear() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public void flush() throws IOException {
        this.flush(MMappedFileStorage.FSYNC_ON_FLUSH_BY_DEFAULT);
    }

    public void flush(boolean fsync) throws IOException {
        if (fsync) {
            this.storage.fsync();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.header.firstUnAllocatedOffset() == 64L && this.header.firstUnCommittedOffset() == 64L;
    }

    @Override
    public void close() throws IOException {
        if (this.storage.isOpen()) {
            this.flush();
            this.storage.close();
            this.header = null;
        }
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        this.close();
        this.storage.closeAndUnsafelyUnmap();
    }

    public void closeAndClean() throws IOException {
        this.close();
        this.storage.closeAndClean();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.storage.storagePath()) + "]";
    }

    public String dumpDebugInfo() {
        return this.getClass().getSimpleName() + "[" + this.header.firstUnCommittedOffset() + ".." + this.header.firstUnAllocatedOffset() + "]{" + this.chunksCount() + " data chunks}";
    }

    private String dumpContentAroundId(long aroundChunkId, int chunksAround) throws IOException {
        StringBuilder sb = new StringBuilder("Log content around id: " + aroundChunkId + " +/- " + chunksAround + " (first uncommitted offset: " + this.header.firstUnCommittedOffset() + ", first unallocated: " + this.header.firstUnAllocatedOffset() + ")\n");
        this.forEachChunk(chunk -> {
            boolean insideNeighbourRegion;
            long chunkId = chunk.id();
            ByteBuffer buffer = chunk.read();
            long nextRecordId = ChunkedAppendOnlyLogOverMMappedFile.chunkIdToOffset(this.nextChunkOffset(ChunkedAppendOnlyLogOverMMappedFile.chunkIdToOffset(chunkId), buffer.remaining()));
            boolean insideQuestionableRecord = chunkId <= aroundChunkId && aroundChunkId <= nextRecordId;
            boolean bl = insideNeighbourRegion = aroundChunkId - (long)chunksAround <= chunkId && chunkId <= aroundChunkId + (long)chunksAround;
            if (insideQuestionableRecord || insideNeighbourRegion) {
                String bufferAsHex = IOUtil.toHexString((ByteBuffer)buffer.slice());
                sb.append(insideQuestionableRecord ? "*" : "").append("[id: ").append(chunkId).append("][offset: ").append(ChunkedAppendOnlyLogOverMMappedFile.chunkIdToOffset(chunkId)).append("][hex: ").append(bufferAsHex).append("]\n");
            }
            return chunkId <= aroundChunkId + (long)chunksAround;
        });
        return sb.toString();
    }

    private String moreDiagnosticInfo(long chunkOffsetInFile) {
        if (!MORE_DIAGNOSTIC_INFORMATION) {
            return "";
        }
        if (this.startOfSuspiciousRegion < 0L && this.endOfSuspiciousRegion < 0L) {
            return "(There was no recovery, it can't be related to it)";
        }
        if (chunkOffsetInFile >= this.startOfSuspiciousRegion && chunkOffsetInFile < this.endOfSuspiciousRegion) {
            return "(Chunk is in the recovered region [" + this.startOfSuspiciousRegion + ".." + this.endOfSuspiciousRegion + ") so it may be due to some un-recovered records)";
        }
        return "(There was a recovery so it may be due to some un-recovered records, but the Chunk is outside the region [" + this.startOfSuspiciousRegion + ".." + this.endOfSuspiciousRegion + ") recovered)";
    }

    public static void checkFileParamsCompatible(@NotNull Path storagePath, @NotNull FileHeader header, int pageSize) throws IOException {
        int magicWord;
        if (storagePath == null) {
            ChunkedAppendOnlyLogOverMMappedFile.$$$reportNull$$$0(2);
        }
        if (header == null) {
            ChunkedAppendOnlyLogOverMMappedFile.$$$reportNull$$$0(3);
        }
        if ((magicWord = header.readMagicWord()) != MAGIC_WORD) {
            throw new IOException("[" + String.valueOf(storagePath) + "] is of incorrect type: .magicWord(=" + magicWord + ", '" + IOUtil.magicWordToASCII((int)magicWord) + "') != " + MAGIC_WORD + " expected");
        }
        int implementationVersion = header.readImplementationVersion();
        if (implementationVersion != 1) {
            throw new IOException("[" + String.valueOf(storagePath) + "].implementationVersion(=" + implementationVersion + ") is not supported: 1 is the currently supported version.");
        }
        int filePageSize = header.readPageSize();
        if (pageSize != filePageSize) {
            throw new IOException("[" + String.valueOf(storagePath) + "]: file created with pageSize=" + filePageSize + " but current storage.pageSize=" + pageSize);
        }
    }

    private LogChunkImpl readChunkAt(@NotNull ByteBuffer pageBuffer, int chunkOffsetInBuffer, long chunkOffsetInFile) throws IOException {
        int header;
        if (pageBuffer == null) {
            ChunkedAppendOnlyLogOverMMappedFile.$$$reportNull$$$0(4);
        }
        if (!LogChunkImpl.isHeaderSet(header = LogChunkImpl.readHeader(pageBuffer, chunkOffsetInBuffer))) {
            long chunkId = ChunkedAppendOnlyLogOverMMappedFile.chunkOffsetToId(chunkOffsetInFile);
            throw new IOException("chunk[" + chunkId + "][@" + chunkOffsetInFile + "].header is not written: (header=" + Integer.toHexString(header) + ") either unfinished or corrupted. " + this.moreDiagnosticInfo(chunkOffsetInFile) + (String)(ADD_LOG_CONTENT ? "\n" + this.dumpContentAroundId(chunkId, 128) : ""));
        }
        int chunkLength = LogChunkImpl.unpackChunkLength(header);
        boolean isPadding = LogChunkImpl.isPaddingChunk(header);
        boolean hasNextChunkIdField = LogChunkImpl.hasNextChunkIdField(header);
        return new LogChunkImpl(chunkOffsetInFile, pageBuffer, chunkOffsetInBuffer, chunkLength, isPadding, hasNextChunkIdField);
    }

    private long allocateSpaceForChunk(int totalChunkLength) throws IOException {
        long firstUnCommittedOffset;
        int pageSize = this.storage.pageSize();
        if (totalChunkLength > pageSize) {
            throw new AssertionError((Object)("totalRecordLength(=" + totalChunkLength + ") must fit the page(=" + pageSize + ")"));
        }
        long chunkOffsetInFile = this.header.firstUnAllocatedOffset();
        if (chunkOffsetInFile != (firstUnCommittedOffset = this.header.firstUnCommittedOffset())) {
            throw new AssertionError((Object)("Invariant violation: firstUnAllocatedCursor(=" + chunkOffsetInFile + ") must be == firstUnCommitted(=" + firstUnCommittedOffset + ")"));
        }
        int chunkOffsetInPage = this.storage.toOffsetInPage(chunkOffsetInFile);
        int remainingOnPage = pageSize - chunkOffsetInPage;
        if (totalChunkLength <= remainingOnPage) {
            this.header.updateFirstUnAllocatedOffset(chunkOffsetInFile + (long)totalChunkLength);
            return chunkOffsetInFile;
        }
        if (remainingOnPage >= 4) {
            this.header.updateFirstUnAllocatedOffset(chunkOffsetInFile + (long)remainingOnPage);
            MMappedFileStorage.Page page = this.storage.pageByOffset(chunkOffsetInFile);
            LogChunkImpl.putPaddingChunk(remainingOnPage, page.rawPageBuffer(), chunkOffsetInPage, chunkOffsetInFile);
            this.header.updateFirstUnCommittedOffset(chunkOffsetInFile + (long)remainingOnPage);
            return this.allocateSpaceForChunk(totalChunkLength);
        }
        throw new AssertionError((Object)("Bug: remainingOnPage(=" + remainingOnPage + ") < RECORD_HEADER(=4),but chunks must be 64b-aligned, so it must never happen. chunkOffsetInFile(=" + chunkOffsetInFile + "), recordOffsetInPage(=" + chunkOffsetInPage + "), totalRecordLength(=" + totalChunkLength + ")"));
    }

    private long nextChunkOffset(long chunkOffsetInFile, int totalChunkLength) {
        AlignmentUtils.assert64bAligned(chunkOffsetInFile, "chunkOffsetInFile");
        long nextRecordOffset = AlignmentUtils.roundUpToInt64(chunkOffsetInFile + (long)totalChunkLength);
        int pageSize = this.storage.pageSize();
        int offsetInPage = this.storage.toOffsetInPage(nextRecordOffset);
        int remainingOnPage = pageSize - offsetInPage;
        if (remainingOnPage < 4) {
            throw new IllegalStateException("remainingOnPage(=" + remainingOnPage + ") <= chunkHeader(=4)");
        }
        return nextRecordOffset;
    }

    private boolean forEachRecord(@NotNull ChunkedAppendOnlyLog.ChunkReader reader, long untilOffset) throws IOException {
        if (reader == null) {
            ChunkedAppendOnlyLogOverMMappedFile.$$$reportNull$$$0(5);
        }
        int pageSize = this.storage.pageSize();
        long chunkOffsetInFile = 64L;
        while (chunkOffsetInFile < untilOffset) {
            MMappedFileStorage.Page page = this.storage.pageByOffset(chunkOffsetInFile);
            int chunkOffsetInPage = this.storage.toOffsetInPage(chunkOffsetInFile);
            ByteBuffer pageBuffer = page.rawPageBuffer();
            if (pageSize - chunkOffsetInPage < 4) {
                throw new CorruptedException(this.getClass().getSimpleName() + " corrupted: chunkOffsetInPage(=" + chunkOffsetInPage + ") less than RECORD_HEADER(=4b) left until pageEnd(" + pageSize + ") -- all chunks must be 64b-aligned");
            }
            int chunkHeader = LogChunkImpl.readHeader(pageBuffer, chunkOffsetInPage);
            if (!LogChunkImpl.isHeaderSet(chunkHeader)) {
                return true;
            }
            int chunkLength = LogChunkImpl.unpackChunkLength(chunkHeader);
            if (LogChunkImpl.isDataChunk(chunkHeader)) {
                long chunkId = ChunkedAppendOnlyLogOverMMappedFile.chunkOffsetToId(chunkOffsetInFile);
                if (!LogChunkImpl.isFitIntoPage(pageBuffer, chunkOffsetInPage, chunkLength)) {
                    throw new CorruptedException("chunk[" + chunkId + "][@" + chunkOffsetInFile + "].chunkLength(=" + chunkLength + "):  is incorrect: page[0.." + pageBuffer.limit() + "]" + this.moreDiagnosticInfo(chunkOffsetInFile));
                }
                LogChunkImpl chunk = this.readChunkAt(pageBuffer, chunkOffsetInPage, chunkOffsetInFile);
                boolean shouldContinue = reader.read(chunk);
                if (!shouldContinue) {
                    return false;
                }
            } else if (!LogChunkImpl.isPaddingChunk(chunkHeader)) {
                throw new IOException("header(=" + chunkHeader + "](@offset=" + chunkOffsetInFile + "): not a padding, nor a data chunk");
            }
            chunkOffsetInFile = this.nextChunkOffset(chunkOffsetInFile, chunkLength);
        }
        return true;
    }

    private long recoverRegion(long nextRecordToBeCommittedOffset, long nextRecordToBeAllocatedOffset) throws IOException {
        int pageSize = this.storage.pageSize();
        long chunkOffsetInFile = nextRecordToBeCommittedOffset;
        while (chunkOffsetInFile < nextRecordToBeAllocatedOffset) {
            MMappedFileStorage.Page page = this.storage.pageByOffset(chunkOffsetInFile);
            int chunkOffsetInPage = this.storage.toOffsetInPage(chunkOffsetInFile);
            ByteBuffer pageBuffer = page.rawPageBuffer();
            if (pageSize - chunkOffsetInPage <= 4) {
                throw new CorruptedException(this.getClass().getSimpleName() + " corrupted: chunkOffsetInPage(=" + chunkOffsetInPage + ") less than RECORD_HEADER(=4b) left until pageEnd(" + pageSize + ") -- all chunks must be 64b-aligned");
            }
            int chunkHeader = LogChunkImpl.readHeader(pageBuffer, chunkOffsetInPage);
            if (!LogChunkImpl.isHeaderSet(chunkHeader)) {
                return chunkOffsetInFile;
            }
            if (!LogChunkImpl.isDataChunk(chunkHeader) && !LogChunkImpl.isPaddingChunk(chunkHeader)) {
                throw new CorruptedException("header(=" + chunkHeader + "](@offset=" + chunkOffsetInFile + "): not a padding, nor a data record");
            }
            int chunkLength = LogChunkImpl.unpackChunkLength(chunkHeader);
            chunkOffsetInFile = this.nextChunkOffset(chunkOffsetInFile, chunkLength);
        }
        return nextRecordToBeAllocatedOffset;
    }

    @VisibleForTesting
    static long chunkOffsetToId(long chunkOffsetInFile) {
        AlignmentUtils.assert64bAligned(chunkOffsetInFile, "chunkOffsetInFile");
        return (chunkOffsetInFile - 64L >> 3) + 1L;
    }

    private static long chunkIdToOffsetUnchecked(long chunkId) {
        return (chunkId - 1L << 3) + 64L;
    }

    @VisibleForTesting
    static long chunkIdToOffset(long chunkId) {
        long offset = ChunkedAppendOnlyLogOverMMappedFile.chunkIdToOffsetUnchecked(chunkId);
        if (!AlignmentUtils.is64bAligned(offset)) {
            throw new IllegalArgumentException("chunkId(=" + chunkId + ") is invalid: chunkOffsetInFile(=" + offset + ") is not 64b-aligned");
        }
        return offset;
    }

    private static void checkPayloadCapacity(int chunkPayloadCapacity, boolean reserveNextChunkIdField) {
        int maxPayloadSize;
        if (chunkPayloadCapacity <= 0) {
            throw new IllegalArgumentException("Can't append chunk with payloadCapacity(=" + chunkPayloadCapacity + ") <= 0");
        }
        int n = maxPayloadSize = reserveNextChunkIdField ? MAX_PAYLOAD_SIZE_WITH_NEXT_CHUNK : MAX_PAYLOAD_SIZE_WITHOUT_NEXT_CHUNK;
        if (chunkPayloadCapacity > maxPayloadSize) {
            throw new IllegalArgumentException("payloadCapacity(=" + chunkPayloadCapacity + ") > MAX(" + maxPayloadSize + ")");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageBuffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/appendonlylog/dev/ChunkedAppendOnlyLogOverMMappedFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachChunk";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFileParamsCompatible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readChunkAt";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachRecord";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class FileHeader {
        public static final int MAGIC_WORD_OFFSET = 0;
        public static final int IMPLEMENTATION_VERSION_OFFSET = 4;
        public static final int EXTERNAL_VERSION_OFFSET = 8;
        public static final int PAGE_SIZE_OFFSET = 12;
        public static final int NEXT_CHUNK_TO_BE_ALLOCATED_OFFSET = 16;
        public static final int NEXT_CHUNK_TO_BE_COMMITTED_OFFSET = 24;
        public static final int CHUNKS_COUNT_OFFSET = 32;
        public static final int FIRST_UNUSED_OFFSET = 36;
        public static final int HEADER_SIZE = 64;
        private final ByteBuffer headerPageBuffer;

        public FileHeader(@NotNull MMappedFileStorage.Page headerPage) {
            if (headerPage == null) {
                FileHeader.$$$reportNull$$$0(0);
            }
            this.headerPageBuffer = headerPage.rawPageBuffer();
        }

        public int readMagicWord() {
            return this.headerPageBuffer.getInt(0);
        }

        public int readImplementationVersion() {
            return this.headerPageBuffer.getInt(4);
        }

        public int readPageSize() {
            return this.headerPageBuffer.getInt(12);
        }

        public void putMagicWord(int magicWord) {
            this.headerPageBuffer.putInt(0, magicWord);
        }

        public void putImplementationVersion(int implVersion) {
            this.headerPageBuffer.putInt(4, implVersion);
        }

        public void putPageSize(int pageSize) {
            this.headerPageBuffer.putInt(12, pageSize);
        }

        private int getIntHeaderField(int headerRelativeOffsetBytes) {
            Objects.checkIndex(headerRelativeOffsetBytes, 61);
            return INT32_OVER_BYTE_BUFFER.getVolatile(this.headerPageBuffer, headerRelativeOffsetBytes);
        }

        private long getLongHeaderField(int headerRelativeOffsetBytes) {
            Objects.checkIndex(headerRelativeOffsetBytes, 57);
            return INT64_OVER_BYTE_BUFFER.getVolatile(this.headerPageBuffer, headerRelativeOffsetBytes);
        }

        private void setIntHeaderField(int headerRelativeOffsetBytes, int headerFieldValue) {
            Objects.checkIndex(headerRelativeOffsetBytes, 61);
            INT32_OVER_BYTE_BUFFER.setVolatile(this.headerPageBuffer, headerRelativeOffsetBytes, headerFieldValue);
        }

        private void setLongHeaderField(int headerRelativeOffsetBytes, long headerFieldValue) {
            Objects.checkIndex(headerRelativeOffsetBytes, 57);
            INT64_OVER_BYTE_BUFFER.setVolatile(this.headerPageBuffer, headerRelativeOffsetBytes, headerFieldValue);
        }

        private long firstUnAllocatedOffset() {
            return this.getLongHeaderField(16);
        }

        private void updateFirstUnAllocatedOffset(long newValue) {
            INT64_OVER_BYTE_BUFFER.setVolatile(this.headerPageBuffer, 16, newValue);
        }

        private long firstUnCommittedOffset() {
            return this.getLongHeaderField(24);
        }

        private void updateFirstUnCommittedOffset(long newValue) {
            INT64_OVER_BYTE_BUFFER.setVolatile(this.headerPageBuffer, 24, newValue);
        }

        private int addToDataRecordsCount(int recordsCommitted) {
            return INT32_OVER_BYTE_BUFFER.getAndAdd(this.headerPageBuffer, 32, recordsCommitted);
        }

        static {
            if (!AlignmentUtils.is64bAligned(64)) {
                throw new ExceptionInInitializerError("HEADER_SIZE(64) must be 64b-aligned");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerPage", "com/intellij/platform/util/io/storages/appendonlylog/dev/ChunkedAppendOnlyLogOverMMappedFile$FileHeader", "<init>"));
        }
    }

    private static class LogChunkImpl
    implements ChunkedAppendOnlyLog.LogChunk {
        protected static final int RECORD_TYPE_MASK = Integer.MIN_VALUE;
        protected static final int RECORD_TYPE_DATA = 0;
        protected static final int RECORD_TYPE_PADDING = Integer.MIN_VALUE;
        protected static final int NEXT_CHUNK_ID_MASK = 0x40000000;
        protected static final int NEXT_CHUNK_ID_PRESENT = 0x40000000;
        protected static final int NEXT_CHUNK_ID_ABSENT = 0;
        protected static final int CHUNK_LENGTH_MAX = AlignmentUtils.roundDownToInt64(2047);
        protected static final int CHUNK_LENGTH_MASK = 1069547520;
        protected static final int CHUNK_LENGTH_MASK_SHR = 22;
        protected static final int OFFSET_HEADER = 0;
        protected static final int HEADER_SIZE = 4;
        protected static final int NEXT_CHUNK_ID_SIZE = 8;
        protected static final int OFFSET_PAYLOAD = 4;
        protected final ByteBuffer pageBuffer;
        protected final int offsetInBuffer;
        protected final long offsetInFile;
        protected final int chunkLength;
        protected final boolean padding;
        protected final boolean hasNextChunkId;

        /*
         * WARNING - void declaration
         */
        protected LogChunkImpl(long chunkOffsetInFile, @NotNull ByteBuffer pageBuffer, int chunkOffsetInBuffer, int totalChunkLength, boolean padding, boolean bl) {
            void hasNextChunkId;
            if (pageBuffer == null) {
                LogChunkImpl.$$$reportNull$$$0(0);
            }
            AlignmentUtils.assert64bAligned(totalChunkLength, "totalChunkLength");
            if (totalChunkLength <= 0 || totalChunkLength > CHUNK_LENGTH_MAX) {
                throw new IllegalArgumentException("totalChunkLength(=" + totalChunkLength + ") must be in (0, " + CHUNK_LENGTH_MAX + "]");
            }
            this.offsetInFile = chunkOffsetInFile;
            this.pageBuffer = pageBuffer;
            this.offsetInBuffer = chunkOffsetInBuffer;
            this.chunkLength = totalChunkLength;
            this.padding = padding;
            this.hasNextChunkId = hasNextChunkId;
        }

        @Override
        public long id() {
            return ChunkedAppendOnlyLogOverMMappedFile.chunkOffsetToId(this.offsetInFile);
        }

        @Override
        public int capacity() {
            return this.chunkLength() - 4;
        }

        public int chunkLength() {
            return this.chunkLength;
        }

        public boolean isPadding() {
            return this.padding;
        }

        public boolean isDataChunk() {
            return !this.isPadding();
        }

        @Override
        public boolean hasNextChunkIdField() {
            return this.hasNextChunkId;
        }

        @Override
        public long nextChunkId() {
            if (!this.hasNextChunkIdField()) {
                throw new IllegalStateException("Chunk doesn't have .nextChunkId field reserved at creation");
            }
            int nextChunkFieldOffset = this.offsetInBuffer + this.chunkLength - 8;
            return INT64_OVER_BYTE_BUFFER.getVolatile(this.pageBuffer, nextChunkFieldOffset);
        }

        @Override
        public boolean nextChunkId(long nextChunkId) {
            if (!this.hasNextChunkIdField()) {
                throw new IllegalStateException("Chunk doesn't have .nextChunkId field reserved at creation");
            }
            int offset = this.offsetInBuffer + this.chunkLength - 8;
            return INT64_OVER_BYTE_BUFFER.compareAndSet(this.pageBuffer, offset, 0L, nextChunkId);
        }

        public boolean isFitIntoPage() {
            return LogChunkImpl.isFitIntoPage(this.pageBuffer, this.offsetInBuffer, this.chunkLength());
        }

        @Override
        public boolean isFull() {
            int header = this.readHeader();
            int allocatedCursor = LogChunkImpl.unpackAllocatedCursor(header);
            return allocatedCursor == this.capacity();
        }

        @Override
        public int remaining() {
            int header = this.readHeader();
            int allocatedCursor = LogChunkImpl.unpackAllocatedCursor(header);
            return this.capacity() - allocatedCursor;
        }

        @Override
        public boolean isAppendable() {
            return true;
        }

        @Override
        public ByteBuffer read() {
            int header = this.readHeader();
            int committedCursor = LogChunkImpl.unpackCommittedCursor(header);
            return this.pageBuffer.slice(this.offsetInBuffer + 4, committedCursor).asReadOnlyBuffer().order(this.pageBuffer.order());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean append(@NotNull ByteBufferWriter writer, int recordSize) throws IOException {
            int committedCursor;
            int newAllocatedCursor;
            int header;
            if (writer == null) {
                LogChunkImpl.$$$reportNull$$$0(1);
            }
            do {
                header = this.readHeader();
                int allocatedCursor = LogChunkImpl.unpackAllocatedCursor(header);
                committedCursor = LogChunkImpl.unpackCommittedCursor(header);
                newAllocatedCursor = allocatedCursor + recordSize;
                if (newAllocatedCursor <= this.capacity()) continue;
                return false;
            } while (!this.casHeader(header, this.packChunkHeader(newAllocatedCursor, committedCursor)));
            int recordStartingOffset = newAllocatedCursor - recordSize;
            ByteBuffer bufferForWrite = this.pageBuffer.slice(this.offsetInBuffer + 4 + recordStartingOffset, recordSize).order(this.pageBuffer.order());
            try {
                writer.write(bufferForWrite);
            }
            finally {
                int _allocatedCursor;
                int _header;
                int _committedCursor;
                do {
                    _header = this.readHeader();
                    _allocatedCursor = LogChunkImpl.unpackAllocatedCursor(_header);
                } while ((_committedCursor = LogChunkImpl.unpackCommittedCursor(_header)) != recordStartingOffset || !this.casHeader(_header, this.packChunkHeader(_allocatedCursor, _committedCursor + recordSize)));
            }
            return true;
        }

        public String toString() {
            int header = LogChunkImpl.readHeader(this.pageBuffer, this.offsetInBuffer);
            return "Chunk[#" + this.id() + ", " + (this.isDataChunk() ? "data" : "padding") + "][" + (String)(this.isDataChunk() ? "content: " + LogChunkImpl.unpackCommittedCursor(header) + ".." + LogChunkImpl.unpackAllocatedCursor(header) + " of " + this.capacity() : "-") + "]{header: " + Integer.toHexString(header) + ", chunkLength: " + this.chunkLength + "}{inFile: @" + this.offsetInFile + ", inPage: @" + this.offsetInBuffer + "}";
        }

        /*
         * WARNING - void declaration
         */
        private static LogChunkImpl putRegularChunk(@NotNull ByteBuffer pageBuffer, int totalChunkSize, int chunkOffsetInBuffer, long chunkOffsetInFile, boolean bl) {
            void reserveNextChunkIdField;
            if (pageBuffer == null) {
                LogChunkImpl.$$$reportNull$$$0(2);
            }
            LogChunkImpl chunk = new LogChunkImpl(chunkOffsetInFile, pageBuffer, chunkOffsetInBuffer, totalChunkSize, false, (boolean)reserveNextChunkIdField);
            chunk.writeHeaderInitial();
            return chunk;
        }

        private static void putPaddingChunk(int remainsToPad, @NotNull ByteBuffer pageBuffer, int chunkOffsetInBuffer, long chunkOffsetInFile) {
            if (pageBuffer == null) {
                LogChunkImpl.$$$reportNull$$$0(3);
            }
            LogChunkImpl chunk = new LogChunkImpl(chunkOffsetInFile, pageBuffer, chunkOffsetInBuffer, remainsToPad, true, false);
            chunk.writeHeaderInitial();
        }

        protected static boolean isPaddingChunk(int header) {
            return (header & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }

        protected static boolean isDataChunk(int header) {
            return (header & Integer.MIN_VALUE) == 0;
        }

        protected static boolean hasNextChunkIdField(int header) {
            return (header & 0x40000000) == 0x40000000;
        }

        protected static boolean isHeaderSet(int header) {
            return header != 0;
        }

        protected static int readHeader(ByteBuffer buffer, int offsetInBuffer) {
            return INT32_OVER_BYTE_BUFFER.getVolatile(buffer, offsetInBuffer + 0);
        }

        private int readHeader() {
            return LogChunkImpl.readHeader(this.pageBuffer, this.offsetInBuffer);
        }

        protected void writeHeaderInitial() {
            int chunkHeader = LogChunkImpl.packChunkHeader(this.chunkLength(), this.hasNextChunkId, this.isPadding(), 0, 0);
            INT32_OVER_BYTE_BUFFER.setVolatile(this.pageBuffer, this.offsetInBuffer + 0, chunkHeader);
        }

        private static int packChunkHeader(int chunkLength, boolean reserveNextChunkIdField, boolean isPadding, int allocatedCursor, int committedCursor) {
            AlignmentUtils.assert64bAligned(chunkLength, "chunkLength");
            if (chunkLength <= 0 || chunkLength > CHUNK_LENGTH_MAX) {
                throw new IllegalArgumentException("totalChunkLength(=" + chunkLength + ") must be in (0," + CHUNK_LENGTH_MAX + "]");
            }
            if (allocatedCursor < 0 || allocatedCursor > CHUNK_LENGTH_MAX) {
                throw new IllegalArgumentException("allocatedCursor(=" + allocatedCursor + ") must be in [0," + CHUNK_LENGTH_MAX + "]");
            }
            if (committedCursor < 0 || committedCursor > CHUNK_LENGTH_MAX) {
                throw new IllegalArgumentException("committedCursor(=" + committedCursor + ") must be in [0," + CHUNK_LENGTH_MAX + "]");
            }
            int typeComponent = isPadding ? Integer.MIN_VALUE : 0;
            int nextChunkIdComponent = reserveNextChunkIdField ? 0x40000000 : 0;
            int lengthComponent = chunkLength >> 3 << 22;
            int committedCursorComponent = (committedCursor & 0x7FF) << 11;
            int allocatedCursorComponent = allocatedCursor & 0x7FF;
            if (lengthComponent == 0) {
                throw new AssertionError((Object)("chunkLength=" + chunkLength + " => lengthComponent is 0"));
            }
            return typeComponent | nextChunkIdComponent | lengthComponent | committedCursorComponent | allocatedCursorComponent;
        }

        private int packChunkHeader(int allocatedCursor, int committedCursor) {
            return LogChunkImpl.packChunkHeader(this.chunkLength, this.hasNextChunkId, this.padding, allocatedCursor, committedCursor);
        }

        protected static int unpackChunkLength(int header) {
            int chunkLengthField = (header & 0x3FC00000) >> 22;
            return chunkLengthField << 3;
        }

        private static int unpackAllocatedCursor(int header) {
            return header & 0x7FF;
        }

        private static int unpackCommittedCursor(int header) {
            return header >> 11 & 0x7FF;
        }

        private boolean casHeader(int expectedHeader, int newHeader) {
            return INT32_OVER_BYTE_BUFFER.compareAndSet(this.pageBuffer, this.offsetInBuffer + 0, expectedHeader, newHeader);
        }

        protected static int chunkLengthForPayload(int payloadSize, boolean reserveNextChunkIdField) {
            if (reserveNextChunkIdField) {
                return AlignmentUtils.roundUpToInt64(payloadSize + 4 + 8);
            }
            return AlignmentUtils.roundUpToInt64(payloadSize + 4);
        }

        protected static boolean isFitIntoPage(ByteBuffer pageBuffer, int chunkOffsetInPage, int chunkLength) {
            return chunkOffsetInPage + chunkLength <= pageBuffer.limit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pageBuffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/appendonlylog/dev/ChunkedAppendOnlyLogOverMMappedFile$LogChunkImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "append";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putRegularChunk";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putPaddingChunk";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

