/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.ui;

import com.intellij.accessibility.TextFieldWithListAccessibleContext;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.platform.ide.productMode.IdeProductMode;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.searchComponents.ExtendableSearchTextField;
import com.intellij.util.ui.JBUI;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ$\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/ui/SeTextField;", "Lcom/intellij/ui/searchComponents/ExtendableSearchTextField;", "initialText", "", "resultListAccessibleContext", "Lkotlin/Function0;", "Ljavax/accessibility/AccessibleContext;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "value", "", "isInitialSearchPattern", "()Z", "onTextChanged", "Lkotlin/Function1;", "", "configure", "lastSearchText", "getAccessibleContext", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
public class SeTextField
extends ExtendableSearchTextField {
    @Nullable
    private final String initialText;
    @NotNull
    private final Function0<AccessibleContext> resultListAccessibleContext;
    private boolean isInitialSearchPattern;
    @NotNull
    private Function1<? super String, Unit> onTextChanged;

    public SeTextField(@Nullable String initialText, @NotNull Function0<? extends AccessibleContext> resultListAccessibleContext) {
        Intrinsics.checkNotNullParameter(resultListAccessibleContext, (String)"resultListAccessibleContext");
        this.initialText = initialText;
        this.resultListAccessibleContext = resultListAccessibleContext;
        this.isInitialSearchPattern = true;
        this.onTextChanged = SeTextField::onTextChanged$lambda$0;
        this.setOpaque(true);
        this.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        String string = this.initialText;
        if (string == null) {
            string = "";
        }
        this.setText(string);
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Function1 function1 = onTextChanged;
                String string = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                function1.invoke((Object)string);
                isInitialSearchPattern = false;
            }
        });
        if (IdeProductMode.Companion.isFrontend()) {
            AnAction actionQuickImplementations = ActionManager.getInstance().getAction("QuickImplementations");
            AnAction emptyAction2 = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            };
            emptyAction2.registerCustomShortcutSet(actionQuickImplementations.getShortcutSet(), (JComponent)((Object)this));
        }
    }

    public final boolean isInitialSearchPattern() {
        return this.isInitialSearchPattern;
    }

    public final void configure(@Nullable String lastSearchText, @NotNull Function1<? super String, Unit> onTextChanged) {
        Intrinsics.checkNotNullParameter(onTextChanged, (String)"onTextChanged");
        if (this.isInitialSearchPattern) {
            CharSequence charSequence;
            if (lastSearchText != null && ((charSequence = (CharSequence)this.initialText) == null || charSequence.length() == 0)) {
                this.setText(lastSearchText);
            }
            this.selectAll();
        } else {
            String string = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            onTextChanged.invoke((Object)string);
        }
        this.onTextChanged = onTextChanged;
    }

    @Nullable
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = (AccessibleContext)new TextFieldWithListAccessibleContext((JTextComponent)((Object)this), (AccessibleContext)this.resultListAccessibleContext.invoke());
        }
        return this.accessibleContext;
    }

    private static final Unit onTextChanged$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

