/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0007\u001a2\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b \r*\u0017\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b0\f\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectNotificationAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectNotificationAware;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectsWithNotification", "", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "notificationNotify", "", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "notificationExpire", "projectId", "dispose", "fireNotificationUpdated", "isNotificationVisible", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemIds", "getProjectsWithNotification", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAutoImportProjectNotificationAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoImportProjectNotificationAware.kt\ncom/intellij/openapi/externalSystem/autoimport/AutoImportProjectNotificationAware\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1807#2,3:73\n1586#2:76\n1661#2,3:77\n*S KotlinDebug\n*F\n+ 1 AutoImportProjectNotificationAware.kt\ncom/intellij/openapi/externalSystem/autoimport/AutoImportProjectNotificationAware\n*L\n51#1:73,3\n55#1:76\n55#1:77,3\n*E\n"})
public final class AutoImportProjectNotificationAware
implements ExternalSystemProjectNotificationAware,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<ExternalSystemProjectId> projectsWithNotification;
    @NotNull
    private static final Logger LOG;

    public AutoImportProjectNotificationAware(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.projectsWithNotification = set;
    }

    public void notificationNotify(@NotNull ExternalSystemProjectAware projectAware) {
        Intrinsics.checkNotNullParameter((Object)projectAware, (String)"projectAware");
        ExternalSystemProjectId projectId = projectAware.getProjectId();
        LOG.debug(projectId + ": Notify notification");
        this.projectsWithNotification.add(projectId);
        this.fireNotificationUpdated();
    }

    public void notificationExpire(@NotNull ExternalSystemProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        LOG.debug(projectId + ": Expire notification");
        this.projectsWithNotification.remove(projectId);
        this.fireNotificationUpdated();
    }

    public void notificationExpire() {
        LOG.debug("Expire notification");
        this.projectsWithNotification.clear();
        this.fireNotificationUpdated();
    }

    public void dispose() {
        this.notificationExpire();
    }

    private final void fireNotificationUpdated() {
        ((ExternalSystemProjectNotificationAware.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ExternalSystemProjectNotificationAware.TOPIC)).onNotificationChanged(this.project);
    }

    public boolean isNotificationVisible() {
        return !((Collection)this.projectsWithNotification).isEmpty();
    }

    public boolean isNotificationVisible(@NotNull ProjectSystemId systemId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
            Iterable $this$any$iv = this.projectsWithNotification;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ExternalSystemProjectId it = (ExternalSystemProjectId)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getSystemId(), (Object)systemId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProjectSystemId> getSystemIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.projectsWithNotification;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalSystemProjectId externalSystemProjectId = (ExternalSystemProjectId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSystemId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @TestOnly
    @NotNull
    public final Set<ExternalSystemProjectId> getProjectsWithNotification() {
        return CollectionsKt.toSet((Iterable)this.projectsWithNotification);
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final AutoImportProjectNotificationAware getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectNotificationAware$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectNotificationAware;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final AutoImportProjectNotificationAware getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExternalSystemProjectNotificationAware externalSystemProjectNotificationAware = ExternalSystemProjectNotificationAware.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)externalSystemProjectNotificationAware, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.autoimport.AutoImportProjectNotificationAware");
            return (AutoImportProjectNotificationAware)externalSystemProjectNotificationAware;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

