/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationHandlerKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\tH\u0002J-\u0010\u0010\u001a\u00020\u0005*\u00020\u000b2\u001f\u0010\u0011\u001a\u001b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u00050\u0012\u00a2\u0006\u0002\b\u0014H\u0002J.\u0010\u0015\u001a\u00020\u0005*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00050\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/PackagePrefixConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "<init>", "()V", "apply", "", "module", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "getSourceFolders", "", "Lcom/intellij/openapi/roots/SourceFolder;", "getAllSourceFolders", "onPackagePrefixes", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "forEachPackagePrefix", "Lkotlin/Function2;", "", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPackagePrefixConfigurationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackagePrefixConfigurationHandler.kt\ncom/intellij/openapi/externalSystem/service/project/settings/PackagePrefixConfigurationHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n11705#2:62\n12052#2,3:63\n11705#2:66\n12052#2,3:67\n1586#3:70\n1661#3,3:71\n*S KotlinDebug\n*F\n+ 1 PackagePrefixConfigurationHandler.kt\ncom/intellij/openapi/externalSystem/service/project/settings/PackagePrefixConfigurationHandler\n*L\n34#1:62\n34#1:63,3\n38#1:66\n38#1:67,3\n18#1:70\n18#1:71,3\n*E\n"})
public final class PackagePrefixConfigurationHandler
implements ConfigurationHandler {
    public void apply(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.onPackagePrefixes(configuration, arg_0 -> PackagePrefixConfigurationHandler.apply$lambda$0(this, modelsProvider, module, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SourceFolder> getSourceFolders(Module module, IdeModifiableModelsProvider modelsProvider) {
        void $this$mapTo$iv$iv;
        ContentEntry[] contentEntries;
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableRootModel(...)");
        ModifiableRootModel modifiableRootModel2 = modifiableRootModel;
        ContentEntry[] contentEntryArray = modifiableRootModel2.getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        ContentEntry[] $this$map$iv = contentEntries = contentEntryArray;
        boolean $i$f$map = false;
        ContentEntry[] contentEntryArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var13_13 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SourceFolder[] sourceFolderArray = it.getSourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFolderArray, (String)"getSourceFolders(...)");
            collection.add(ArraysKt.toList((Object[])sourceFolderArray));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SourceFolder> getAllSourceFolders(IdeModifiableModelsProvider modelsProvider) {
        void $this$mapTo$iv$iv;
        Module[] moduleArray = modelsProvider.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getModules(...)");
        Object[] $this$map$iv = moduleArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.getSourceFolders((Module)it, modelsProvider));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    private final void onPackagePrefixes(ConfigurationData $this$onPackagePrefixes, Function1<? super Map<?, ?>, Unit> action2) {
        Object data = $this$onPackagePrefixes.find("packagePrefix");
        if (!(data instanceof Map)) {
            return;
        }
        action2.invoke(data);
    }

    private final void forEachPackagePrefix(Map<?, ?> $this$forEachPackagePrefix, Function2<? super String, ? super String, Unit> action2) {
        for (Map.Entry<?, ?> entry : $this$forEachPackagePrefix.entrySet()) {
            Object sourcePath = entry.getKey();
            Object packagePrefix = entry.getValue();
            if (!(sourcePath instanceof String)) {
                Object object;
                RunConfigurationHandlerKt.getLOG().warn("unexpected value type: " + ((object = sourcePath) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + ", skipping");
                continue;
            }
            if (!(packagePrefix instanceof String)) {
                Object object;
                RunConfigurationHandlerKt.getLOG().warn("unexpected value type: " + ((object = packagePrefix) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + ", skipping");
                continue;
            }
            action2.invoke(sourcePath, packagePrefix);
        }
    }

    private static final Unit apply$lambda$0$1(SourceFolderManager $sourceFolderManager, List $sourceFolders, String path, String packagePrefix) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
        String string = VfsUtilCore.pathToUrl((String)FileUtil.toCanonicalPath((String)path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
        String url = string;
        $sourceFolderManager.setSourceFolderPackagePrefix(url, packagePrefix);
        for (Pair pair : $sourceFolders) {
            SourceFolder sourceFolder = (SourceFolder)pair.component1();
            Object object = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
            String sourcePath = (String)object;
            if (!FileUtil.pathsEqual((String)path, (String)sourcePath)) continue;
            sourceFolder.setPackagePrefix(packagePrefix);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit apply$lambda$0(PackagePrefixConfigurationHandler this$0, IdeModifiableModelsProvider $modelsProvider, Module $module, Map $this$onPackagePrefixes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$onPackagePrefixes, (String)"$this$onPackagePrefixes");
        Iterable iterable = this$0.getAllSourceFolders($modelsProvider);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SourceFolder sourceFolder = (SourceFolder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)VfsUtilCore.urlToPath((String)it.getUrl())));
        }
        List sourceFolders = (List)destination$iv$iv;
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance((Project)$module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)sourceFolderManager, (String)"getInstance(...)");
        SourceFolderManager sourceFolderManager2 = sourceFolderManager;
        this$0.forEachPackagePrefix($this$onPackagePrefixes, (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> PackagePrefixConfigurationHandler.apply$lambda$0$1(sourceFolderManager2, sourceFolders, arg_0, arg_1)));
        return Unit.INSTANCE;
    }
}

