/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.toolWindow.ToolWindowHeadlessManagerImpl;
import com.intellij.ui.AppUIUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExternalToolWindowManager
implements ExternalSystemSettingsListenerEx {
    ExternalToolWindowManager() {
    }

    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settingList) {
        if (project == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(1);
        }
        if (settingList == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(2);
        }
    }

    public void onProjectsLinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> __) {
        if (project == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(4);
        }
        if (__ == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(5);
        }
        if (project.isDefault()) {
            return;
        }
        StartupManager startupManager = StartupManager.getInstance((Project)project);
        boolean showToolWindow = startupManager.postStartupActivityPassed();
        startupManager.runAfterOpened(() -> {
            ToolWindow toolWindow = ExternalToolWindowManager.getToolWindow(project, manager.getSystemId());
            AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
            if (toolWindow != null) {
                ExternalToolWindowManager.activate(toolWindow, settings, showToolWindow);
            } else {
                ((AppUIExecutor)AppUIExecutor.onUiThread((ModalityState)ModalityState.nonModal()).expireWith((Disposable)settings)).later().execute(() -> WriteIntentReadAction.run(() -> ToolWindowManager.getInstance((Project)settings.getProject()).invokeLater(() -> {
                    ToolWindow toolWindow1 = ExternalToolWindowManager.getToolWindow(settings.getProject(), manager.getSystemId());
                    if (toolWindow1 != null) {
                        ExternalToolWindowManager.activate(toolWindow1, settings, showToolWindow);
                    }
                })));
            }
        });
    }

    public void onProjectsUnlinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Set<String> linkedProjectPaths) {
        AbstractExternalSystemSettings settings;
        if (project == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(7);
        }
        if (linkedProjectPaths == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(8);
        }
        if (!(settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings().isEmpty()) {
            return;
        }
        ToolWindow toolWindow = ExternalToolWindowManager.getToolWindow(project, manager.getSystemId());
        if (toolWindow != null) {
            ((AppUIExecutor)((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)settings)).expireWith(toolWindow.getDisposable())).execute(() -> toolWindow.setAvailable(false));
        }
    }

    private static void activate(@NotNull ToolWindow toolWindow, @NotNull AbstractExternalSystemSettings<?, ?, ?> settings, boolean showToolWindow) {
        if (toolWindow == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(10);
        }
        if (toolWindow.isAvailable() && !showToolWindow) {
            return;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)toolWindow.getProject(), () -> {
            boolean shouldShow;
            boolean bl = shouldShow = showToolWindow && settings.getLinkedProjectsSettings().size() == 1 && settings.getProject().getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == null;
            toolWindow.setAvailable(true, shouldShow ? () -> ((ToolWindow)toolWindow).show() : null);
        });
    }

    @Nullable
    public static ToolWindow getToolWindow(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        ToolWindow result;
        if (project == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(11);
        }
        if (externalSystemId == null) {
            ExternalToolWindowManager.$$$reportNull$$$0(12);
        }
        if ((result = ToolWindowManager.getInstance((Project)project).getToolWindow(externalSystemId.getReadableName())) == null && ApplicationManager.getApplication().isUnitTestMode()) {
            result = new ToolWindowHeadlessManagerImpl.MockToolWindow(project);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectsLoaded";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectsLinked";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectsUnlinked";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "activate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

