/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.properties;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.execution.util.ListTableWithButtonsUtilKt;
import com.intellij.openapi.externalSystem.service.ui.properties.PropertiesInfo;
import com.intellij.openapi.externalSystem.service.ui.properties.PropertiesTable;
import com.intellij.openapi.externalSystem.service.ui.util.ObservableDialogWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0015H\u0014J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013*\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/properties/PropertiesDialog;", "Lcom/intellij/openapi/externalSystem/service/ui/util/ObservableDialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "info", "Lcom/intellij/openapi/externalSystem/service/ui/properties/PropertiesInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/ui/properties/PropertiesInfo;)V", "table", "Lcom/intellij/openapi/externalSystem/service/ui/properties/PropertiesTable;", "<set-?>", "", "Lcom/intellij/openapi/externalSystem/service/ui/properties/PropertiesTable$Property;", "properties", "getProperties$delegate", "(Lcom/intellij/openapi/externalSystem/service/ui/properties/PropertiesDialog;)Ljava/lang/Object;", "getProperties", "()Ljava/util/List;", "setProperties", "(Ljava/util/List;)V", "configureCenterPanel", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "doOKAction", "validateProperties", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPropertiesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertiesDialog.kt\ncom/intellij/openapi/externalSystem/service/ui/properties/PropertiesDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1807#2,3:66\n1807#2,3:69\n1807#2,3:72\n*S KotlinDebug\n*F\n+ 1 PropertiesDialog.kt\ncom/intellij/openapi/externalSystem/service/ui/properties/PropertiesDialog\n*L\n48#1:66,3\n51#1:69,3\n54#1:72,3\n*E\n"})
public final class PropertiesDialog
extends ObservableDialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final PropertiesInfo info;
    @NotNull
    private final PropertiesTable table;

    public PropertiesDialog(@NotNull Project project, @NotNull PropertiesInfo info) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super(project);
        this.project = project;
        this.info = info;
        this.table = new PropertiesTable();
        this.setTitle(this.info.getDialogTitle());
        this.setOKButtonText(this.info.getDialogOkButton());
        this.init();
    }

    @NotNull
    public final List<PropertiesTable.Property> getProperties() {
        return this.table.getProperties();
    }

    public final void setProperties(@NotNull List<PropertiesTable.Property> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.table.setProperties(list);
    }

    private static Object getProperties$delegate(PropertiesDialog propertiesDialog) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)propertiesDialog.table, PropertiesTable.class, "properties", "getProperties()Ljava/util/List;", 0)));
    }

    @Override
    protected void configureCenterPanel(@NotNull Panel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Panel $this$configureCenterPanel_u24lambda_u240 = panel;
        boolean bl = false;
        Panel.row$default((Panel)$this$configureCenterPanel_u24lambda_u240, null, arg_0 -> PropertiesDialog.configureCenterPanel$lambda$0$0(this, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$configureCenterPanel_u24lambda_u240, null, arg_0 -> PropertiesDialog.configureCenterPanel$lambda$0$1(this, arg_0), (int)1, null);
    }

    protected void doOKAction() {
        ValidationInfo validationInfo = this.validateProperties();
        if (validationInfo != null) {
            String title = ExternalSystemBundle.message((String)"external.system.properties.error.title", (Object[])new Object[0]);
            Messages.showErrorDialog((Project)this.project, (String)validationInfo.message, (String)title);
            return;
        }
        super.doOKAction();
    }

    private final ValidationInfo validateProperties() {
        boolean bl;
        block14: {
            boolean bl2;
            PropertiesTable.Property it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block13: {
                boolean bl3;
                block12: {
                    $this$any$iv = this.table.getProperties();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (PropertiesTable.Property)element$iv;
                            boolean bl4 = false;
                            boolean bl5 = ((CharSequence)it.getName()).length() == 0;
                            if (!bl5) continue;
                            bl3 = true;
                            break block12;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return new ValidationInfo(ExternalSystemBundle.message((String)"external.system.properties.error.empty.message", (Object[])new Object[0]));
                }
                $this$any$iv = this.table.getProperties();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PropertiesTable.Property)element$iv;
                        boolean bl6 = false;
                        if (!StringsKt.contains$default((CharSequence)it.getName(), (char)' ', (boolean)false, (int)2, null)) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return new ValidationInfo(ExternalSystemBundle.message((String)"external.system.properties.error.space.message", (Object[])new Object[0]));
            }
            $this$any$iv = this.table.getProperties();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PropertiesTable.Property)element$iv;
                    boolean bl7 = false;
                    if (!StringsKt.contains$default((CharSequence)it.getName(), (char)'=', (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return new ValidationInfo(ExternalSystemBundle.message((String)"external.system.properties.error.assign.message", (Object[])new Object[0]));
        }
        return null;
    }

    private static final Unit configureCenterPanel$lambda$0$0(PropertiesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.info.getDialogLabel());
        return Unit.INSTANCE;
    }

    private static final Unit configureCenterPanel$lambda$0$1(PropertiesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ListTableWithButtonsUtilKt.setEmptyState((ListTableWithButtons)this$0.table, (String)this$0.info.getDialogEmptyState());
        JComponent jComponent = this$0.table.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }
}

