/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.parser.psi.DockerFileAddOrCopyCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFileOrUrl;
import com.intellij.docker.dockerFile.parser.psi.DockerFileHeredocStart;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileCopyHeredocInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "HeredocCopyInspector", "intellij.clouds.docker.file.backend"})
public final class DockerFileCopyHeredocInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.getFile() instanceof DockerPsiFile) {
            psiElementVisitor = (PsiElementVisitor)new HeredocCopyInspector(holder, isOnTheFly);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileCopyHeredocInspection$HeredocCopyInspector;", "Lcom/intellij/docker/dockerFile/inspections/DockerFileInspectorBase;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "visitAddOrCopyCommand", "", "o", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileAddOrCopyCommand;", "intellij.clouds.docker.file.backend"})
    private static final class HeredocCopyInspector
    extends DockerFileInspectorBase {
        public HeredocCopyInspector(@NotNull ProblemsHolder holder, boolean onTheFly) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super(holder, onTheFly);
        }

        public void visitAddOrCopyCommand(@NotNull DockerFileAddOrCopyCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)o))) {
                return;
            }
            if (o.getParametersInJsonForm() != null) {
                return;
            }
            List list = o.getHeredocStartList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHeredocStartList(...)");
            DockerFileHeredocStart dockerFileHeredocStart = (DockerFileHeredocStart)CollectionsKt.lastOrNull((List)list);
            if (dockerFileHeredocStart == null) {
                return;
            }
            DockerFileHeredocStart lastHeredoc = dockerFileHeredocStart;
            List list2 = o.getFileOrUrlList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFileOrUrlList(...)");
            DockerFileFileOrUrl lastFile = (DockerFileFileOrUrl)CollectionsKt.lastOrNull((List)list2);
            if (lastFile != null && lastHeredoc.getTextRange().getStartOffset() < lastFile.getTextRange().getStartOffset()) {
                return;
            }
            if (lastFile == null && o.getHeredocStartList().size() < 2) {
                return;
            }
            Object object = o.getCopyKeyword();
            if (object == null || (object = object.getText()) == null) {
                PsiElement psiElement = o.getAddKeyword();
                object = psiElement != null ? psiElement.getText() : null;
                if (object == null) {
                    return;
                }
            }
            Object cmd = object;
            Object[] objectArray = new Object[]{cmd};
            this.registerProblem(CollectionsKt.listOf((Object)lastHeredoc), DockerBundle.message((String)"DockerFileCopyHeredocInspection.problem", (Object[])objectArray), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
        }
    }
}

