/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.designer.model.QuickFix;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorInfo {
    private static final String KEY = "Inspection.Errors";
    @Nls
    private final String myName;
    private final String myPropertyName;
    private final HighlightDisplayLevel myLevel;
    private final List<QuickFix> myQuickFixes;

    public ErrorInfo(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nullable String propertyName, @NotNull HighlightDisplayLevel level) {
        if (name == null) {
            ErrorInfo.$$$reportNull$$$0(0);
        }
        if (level == null) {
            ErrorInfo.$$$reportNull$$$0(1);
        }
        this.myQuickFixes = new ArrayList<QuickFix>();
        this.myName = name;
        this.myPropertyName = propertyName;
        this.myLevel = level;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getName() {
        return this.myName;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    @Nullable
    public String getPropertyName() {
        return this.myPropertyName;
    }

    public List<QuickFix> getQuickFixes() {
        return this.myQuickFixes;
    }

    public static boolean haveFixes(List<ErrorInfo> errorInfos) {
        for (ErrorInfo errorInfo : errorInfos) {
            if (errorInfo.getQuickFixes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "level";
                break;
            }
        }
        objectArray[1] = "com/intellij/designer/model/ErrorInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

