/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.lang.reflect.Field;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class FontSubpixelResolution {
    private static final Logger LOG;
    public static final Dimension RESOLUTION;
    public static final boolean ENABLED;

    static {
        Dimension resolution;
        LOG = Logger.getInstance(FontSubpixelResolution.class);
        try {
            Field field;
            Class<?> clazz = Class.forName("sun.font.FontUtilities");
            try {
                field = clazz.getDeclaredField("subpixelResolution");
            }
            catch (NoSuchFieldException ignore) {
                field = clazz.getDeclaredField("supplementarySubpixelGlyphResolution");
            }
            field.setAccessible(true);
            resolution = (Dimension)field.get(null);
        }
        catch (ReflectiveOperationException ignore) {
            resolution = null;
        }
        catch (Throwable e) {
            resolution = null;
            LOG.error("Couldn't get font subpixel resolution settings", e);
        }
        RESOLUTION = resolution;
        ENABLED = RESOLUTION != null && (FontSubpixelResolution.RESOLUTION.width > 1 || FontSubpixelResolution.RESOLUTION.height > 1);
    }
}

