/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UsageViewTreeModelBuilder
extends DefaultTreeModel {
    private final GroupNode.Root myRootNode;
    @Nullable
    private final TargetsRootNode myTargetsNode;
    private final UsageTarget[] myTargets;
    private UsageTargetNode[] myTargetNodes;

    UsageViewTreeModelBuilder(@NotNull UsageViewPresentation presentation, UsageTarget @NotNull [] targets) {
        if (presentation == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(1);
        }
        super(GroupNode.createRoot());
        this.myRootNode = (GroupNode.Root)this.root;
        String targetsNodeText = presentation.getTargetsNodeText();
        this.myTargetsNode = targetsNodeText == null ? null : new TargetsRootNode(targetsNodeText);
        this.myTargets = targets;
        UIUtil.invokeLaterIfNeeded(() -> {
            this.addTargetNodes();
            this.setRoot(this.myRootNode);
        });
    }

    private void addTargetNodes() {
        if (this.myTargetsNode == null || this.myTargets.length == 0) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myTargetNodes = new UsageTargetNode[this.myTargets.length];
        this.myTargetsNode.removeAllChildren();
        for (int i = 0; i < this.myTargets.length; ++i) {
            UsageTarget target = this.myTargets[i];
            UsageTargetNode targetNode = new UsageTargetNode(target);
            this.myTargetsNode.add(targetNode);
            this.myTargetNodes[i] = targetNode;
        }
        this.myRootNode.addTargetsNode(this.myTargetsNode, this);
        this.reload(this.myTargetsNode);
    }

    UsageNode getFirstUsageNode() {
        return UsageViewTreeModelBuilder.getFirstUsageNode(this.myRootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UsageNode getFirstUsageNode(@NotNull GroupNode parent) {
        UsageNode usageNode;
        Node found;
        if (parent == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(2);
        }
        GroupNode groupNode = parent;
        synchronized (groupNode) {
            found = (Node)ContainerUtil.find(parent.getChildren(), c -> c instanceof UsageNode || c instanceof GroupNode);
        }
        if (found instanceof GroupNode) {
            GroupNode groupNode2 = (GroupNode)found;
            usageNode = UsageViewTreeModelBuilder.getFirstUsageNode(groupNode2);
        } else {
            usageNode = (UsageNode)found;
        }
        return usageNode;
    }

    boolean areTargetsValid() {
        if (this.myTargetNodes == null) {
            return true;
        }
        for (UsageTargetNode targetNode : this.myTargetNodes) {
            if (targetNode.isValid()) continue;
            return false;
        }
        return true;
    }

    void reset() {
        this.myRootNode.removeAllChildren();
        this.addTargetNodes();
        this.reload(this.myRootNode);
    }

    @Override
    @NotNull
    public Object getRoot() {
        GroupNode.Root root = this.myRootNode;
        if (root == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(3);
        }
        return root;
    }

    @Override
    public void nodeChanged(TreeNode node) {
        ThreadingAssertions.assertEventDispatchThread();
        super.nodeChanged(node);
    }

    @Override
    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        ThreadingAssertions.assertEventDispatchThread();
        super.nodesWereInserted(node, childIndices);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        ThreadingAssertions.assertEventDispatchThread();
        super.nodesWereRemoved(node, childIndices, removedChildren);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        ThreadingAssertions.assertEventDispatchThread();
        super.nodesChanged(node, childIndices);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        ThreadingAssertions.assertEventDispatchThread();
        super.nodeStructureChanged(node);
    }

    @Override
    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        ThreadingAssertions.assertEventDispatchThread();
        super.fireTreeNodesChanged(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        ThreadingAssertions.assertEventDispatchThread();
        super.fireTreeNodesInserted(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        ThreadingAssertions.assertEventDispatchThread();
        super.fireTreeNodesRemoved(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        ThreadingAssertions.assertEventDispatchThread();
        super.fireTreeStructureChanged(source, path, childIndices, children);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewTreeModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewTreeModelBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFirstUsageNode";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    static final class TargetsRootNode
    extends Node {
        private TargetsRootNode(@NotNull String name) {
            if (name == null) {
                TargetsRootNode.$$$reportNull$$$0(0);
            }
            this.setUserObject(name);
        }

        @Override
        protected boolean isDataValid() {
            return true;
        }

        @Override
        protected boolean isDataReadOnly() {
            return true;
        }

        @Override
        protected boolean isDataExcluded() {
            return false;
        }

        @Override
        protected boolean canDataNavigate() {
            return false;
        }

        @Override
        @NotNull
        protected String getNodeText() {
            String string = this.getUserObject().toString();
            if (string == null) {
                TargetsRootNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/UsageViewTreeModelBuilder$TargetsRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/UsageViewTreeModelBuilder$TargetsRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

