/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class UserFileType<T extends UserFileType<T>>
implements FileType,
Cloneable {
    @NotNull
    private String myName = "";
    private @NlsContexts.Label String myDescription = "";
    private Icon myIcon;
    private String myIconPath;

    protected UserFileType() {
    }

    public abstract SettingsEditor<T> getEditor();

    public UserFileType<T> clone() {
        try {
            return (UserFileType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            UserFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            UserFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            UserFileType.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    public void setDescription(@NlsContexts.Label String description) {
        this.myDescription = description;
    }

    @NotNull
    public String getDefaultExtension() {
        ExtensionFileNameMatcher ext = (ExtensionFileNameMatcher)ContainerUtil.findInstance(FileTypeManager.getInstance().getAssociations(this), ExtensionFileNameMatcher.class);
        String string = ext == null ? "" : ext.getExtension();
        if (string == null) {
            UserFileType.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            if (this.myIconPath != null) {
                this.myIcon = icon = IconLoader.getIcon((String)this.myIconPath, (ClassLoader)UserFileType.class.getClassLoader());
            }
            if (icon == null) {
                icon = PlatformIcons.CUSTOM_FILE_ICON;
            }
        }
        return icon;
    }

    public void copyFrom(@NotNull UserFileType<T> newType) {
        if (newType == null) {
            UserFileType.$$$reportNull$$$0(4);
        }
        this.myName = newType.getName();
        this.myDescription = newType.getDescription();
    }

    public void setIcon(@NotNull Icon icon) {
        if (icon == null) {
            UserFileType.$$$reportNull$$$0(5);
        }
        this.myIcon = icon;
    }

    public void setIconPath(@NotNull String value) {
        if (value == null) {
            UserFileType.$$$reportNull$$$0(6);
        }
        this.myIconPath = value;
    }

    public String toString() {
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/UserFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/UserFileType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setIconPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

