/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dvcs/branch/DvcsBranchSyncPolicyUpdateNotifier;", "Repo", "Lcom/intellij/dvcs/repo/Repository;", "", "project", "Lcom/intellij/openapi/project/Project;", "dvcsSyncSettings", "Lcom/intellij/dvcs/branch/DvcsSyncSettings;", "repositoryManager", "Lcom/intellij/dvcs/repo/AbstractRepositoryManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/dvcs/branch/DvcsSyncSettings;Lcom/intellij/dvcs/repo/AbstractRepositoryManager;)V", "initBranchSyncPolicyIfNotInitialized", "", "notifyAboutSyncedBranches", "intellij.platform.vcs.dvcs.impl"})
@ApiStatus.Internal
public final class DvcsBranchSyncPolicyUpdateNotifier<Repo extends Repository> {
    @NotNull
    private final Project project;
    @NotNull
    private final DvcsSyncSettings dvcsSyncSettings;
    @NotNull
    private final AbstractRepositoryManager<Repo> repositoryManager;

    public DvcsBranchSyncPolicyUpdateNotifier(@NotNull Project project, @NotNull DvcsSyncSettings dvcsSyncSettings, @NotNull AbstractRepositoryManager<Repo> repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dvcsSyncSettings, (String)"dvcsSyncSettings");
        Intrinsics.checkNotNullParameter(repositoryManager, (String)"repositoryManager");
        this.project = project;
        this.dvcsSyncSettings = dvcsSyncSettings;
        this.repositoryManager = repositoryManager;
    }

    public final void initBranchSyncPolicyIfNotInitialized() {
        if (this.repositoryManager.moreThanOneRoot() && this.dvcsSyncSettings.getSyncSetting() == DvcsSyncSettings.Value.NOT_DECIDED) {
            if (this.repositoryManager.shouldProposeSyncControl()) {
                this.notifyAboutSyncedBranches();
                this.dvcsSyncSettings.setSyncSetting(DvcsSyncSettings.Value.SYNC);
            } else {
                this.dvcsSyncSettings.setSyncSetting(DvcsSyncSettings.Value.DONT_SYNC);
            }
        }
    }

    private final void notifyAboutSyncedBranches() {
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.project);
        NotificationGroup notificationGroup = VcsNotifier.standardNotification();
        String string = DvcsBundle.message((String)"notification.message.branch.operations.are.executed.on.all.roots", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        vcsNotifier.notify(notificationGroup.createNotification(string, NotificationType.INFORMATION).setDisplayId("vcs.branch.operations.are.executed.on.all.roots").addAction((AnAction)NotificationAction.create((String)DvcsBundle.message((String)"action.NotificationAction.DvcsBranchPopup.text.disable", (Object[])new Object[0]), (arg_0, arg_1) -> DvcsBranchSyncPolicyUpdateNotifier.notifyAboutSyncedBranches$lambda$1((arg_0, arg_1) -> DvcsBranchSyncPolicyUpdateNotifier.notifyAboutSyncedBranches$lambda$0(this, arg_0, arg_1), arg_0, arg_1))));
    }

    private static final Unit notifyAboutSyncedBranches$lambda$0(DvcsBranchSyncPolicyUpdateNotifier this$0, AnActionEvent anActionEvent, Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, this$0.repositoryManager.getVcs().getDisplayName());
        if (this$0.dvcsSyncSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
            notification.expire();
        }
        return Unit.INSTANCE;
    }

    private static final void notifyAboutSyncedBranches$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

