/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.CachedIconPresentation;
import com.intellij.ide.util.treeView.CachedPresentationData;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.icons.CachedImageIcon;
import java.util.Iterator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\rH\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0002\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0013\u0010\u0012\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"getIconData", "Lcom/intellij/ide/util/treeView/CachedIconPresentation;", "icon", "Ljavax/swing/Icon;", "findCachedImageIcon", "Lcom/intellij/ui/icons/CachedImageIcon;", "iconCoords", "Lkotlin/Pair;", "", "Ljava/lang/ClassLoader;", "getBiggestLayer", "Lcom/intellij/ui/LayeredIcon;", "getBiggestRow", "Lcom/intellij/ui/RowIcon;", "size", "", "getSize", "(Ljavax/swing/Icon;)I", "DEFAULT_ICON", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/ide/util/treeView/CachedPresentationData;", "getIcon", "(Lcom/intellij/ide/util/treeView/CachedPresentationData;)Ljavax/swing/Icon;", "getLoadingIcon", "iconData", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTreeIconCaching.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeIconCaching.kt\ncom/intellij/ide/util/treeView/TreeIconCachingKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1484#2,14:82\n2045#3,14:96\n*S KotlinDebug\n*F\n+ 1 TreeIconCaching.kt\ncom/intellij/ide/util/treeView/TreeIconCachingKt\n*L\n49#1:82,14\n52#1:96,14\n*E\n"})
public final class TreeIconCachingKt {
    @NotNull
    private static final Icon DEFAULT_ICON;

    @Nullable
    public static final CachedIconPresentation getIconData(@Nullable Icon icon) {
        CachedIconPresentation cachedIconPresentation;
        CachedImageIcon cachedImageIcon = TreeIconCachingKt.findCachedImageIcon(icon);
        if (cachedImageIcon == null) {
            return null;
        }
        CachedImageIcon cachedIcon = cachedImageIcon;
        if ((cachedIcon.getImageFlags() & 0x10) != 0) {
            return null;
        }
        Pair pair = cachedIcon.getCoords();
        if (pair != null) {
            Pair it = pair;
            boolean bl = false;
            cachedIconPresentation = TreeIconCachingKt.getIconData((Pair<String, ? extends ClassLoader>)it);
        } else {
            cachedIconPresentation = null;
        }
        return cachedIconPresentation;
    }

    @ApiStatus.Internal
    @Nullable
    public static final CachedImageIcon findCachedImageIcon(@Nullable Icon icon) {
        Icon icon2 = icon;
        return icon2 == null ? null : (icon2 instanceof LayeredIcon ? TreeIconCachingKt.findCachedImageIcon(TreeIconCachingKt.getBiggestLayer((LayeredIcon)icon)) : (icon2 instanceof RowIcon ? TreeIconCachingKt.findCachedImageIcon(TreeIconCachingKt.getBiggestRow((RowIcon)icon)) : (icon2 instanceof RetrievableIcon ? TreeIconCachingKt.findCachedImageIcon(((RetrievableIcon)icon).retrieveIcon()) : (icon2 instanceof CachedImageIcon ? (CachedImageIcon)icon : null))));
    }

    private static final CachedIconPresentation getIconData(Pair<String, ? extends ClassLoader> iconCoords) {
        String path = (String)iconCoords.getFirst();
        ClassLoader classLoader = (ClassLoader)iconCoords.getSecond();
        IconManager iconManager = IconManager.Companion.getInstance();
        Pair classLoaderCoords = iconManager.getPluginAndModuleId(classLoader);
        return new CachedIconPresentation(path, (String)classLoaderCoords.getFirst(), (String)classLoaderCoords.getSecond());
    }

    private static final Icon getBiggestLayer(LayeredIcon icon) {
        Object v0;
        Sequence $this$maxByOrNull$iv = SequencesKt.filterNotNull((Sequence)ArraysKt.asSequence((Object[])icon.getAllLayers()));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Icon it = (Icon)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = TreeIconCachingKt.getSize(it);
                do {
                    Object e$iv = iterator$iv.next();
                    Icon it2 = (Icon)e$iv;
                    $i$a$-maxByOrNull-TreeIconCachingKt$getBiggestLayer$1 = false;
                    int v$iv = TreeIconCachingKt.getSize(it2);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private static final Icon getBiggestRow(RowIcon icon) {
        Object v0;
        Iterable $this$maxByOrNull$iv = icon.getAllIcons();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Icon it = (Icon)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = TreeIconCachingKt.getSize(it);
                do {
                    Object e$iv = iterator$iv.next();
                    Icon it2 = (Icon)e$iv;
                    $i$a$-maxByOrNull-TreeIconCachingKt$getBiggestRow$1 = false;
                    int v$iv = TreeIconCachingKt.getSize(it2);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private static final int getSize(Icon $this$size) {
        return Math.min($this$size.getIconWidth(), $this$size.getIconHeight());
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon getIcon(@NotNull CachedPresentationData $this$icon) {
        Intrinsics.checkNotNullParameter((Object)$this$icon, (String)"<this>");
        return TreeIconCachingKt.getLoadingIcon($this$icon.getIconData());
    }

    private static final Icon getLoadingIcon(CachedIconPresentation iconData) {
        if (iconData == null) {
            return DEFAULT_ICON;
        }
        IconManager iconManager = IconManager.Companion.getInstance();
        return iconManager.createDeferredIcon(DEFAULT_ICON, (Object)iconData, arg_0 -> TreeIconCachingKt.getLoadingIcon$lambda$0(iconManager, iconData, arg_0));
    }

    private static final Icon getLoadingIcon$lambda$0(IconManager $iconManager, CachedIconPresentation $iconData, CachedIconPresentation it) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClassLoader classLoader = $iconManager.getClassLoader($iconData.getPlugin(), $iconData.getModule());
        if (classLoader == null) {
            icon = DEFAULT_ICON;
        } else {
            Icon icon2;
            try {
                icon2 = $iconManager.getIcon($iconData.getPath(), classLoader);
            }
            catch (Exception e) {
                icon2 = DEFAULT_ICON;
            }
            icon = icon2;
        }
        return icon;
    }

    static {
        Icon icon = AllIcons.FileTypes.Unknown;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Unknown");
        DEFAULT_ICON = icon;
    }
}

