/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.rd.GraphicsExKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.JBEditorTabPainter;
import com.intellij.ui.tabs.impl.JBEditorTabsBorder;
import com.intellij.ui.tabs.impl.themes.DefaultTabTheme;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016JB\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016JB\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J0\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J(\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J \u0010#\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/intellij/ui/tabs/impl/JBDefaultTabPainter;", "Lcom/intellij/ui/tabs/JBTabPainter;", "theme", "Lcom/intellij/ui/tabs/impl/themes/TabTheme;", "<init>", "(Lcom/intellij/ui/tabs/impl/themes/TabTheme;)V", "getTheme", "()Lcom/intellij/ui/tabs/impl/themes/TabTheme;", "getTabTheme", "getBackgroundColor", "Ljava/awt/Color;", "getCustomBackground", "tabColor", "selected", "", "active", "hovered", "fillBackground", "", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "paintTab", "position", "Lcom/intellij/ui/tabs/JBTabsPosition;", "borderThickness", "", "paintSelectedTab", "paintUnderline", "paintBorderLine", "thickness", "from", "Ljava/awt/Point;", "to", "underlineRectangle", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nJBDefaultTabPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBDefaultTabPainter.kt\ncom/intellij/ui/tabs/impl/JBDefaultTabPainter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public class JBDefaultTabPainter
implements JBTabPainter {
    @NotNull
    private final TabTheme theme;

    public JBDefaultTabPainter(@NotNull TabTheme theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.theme = theme;
    }

    public /* synthetic */ JBDefaultTabPainter(TabTheme tabTheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tabTheme = new DefaultTabTheme();
        }
        this(tabTheme);
    }

    @NotNull
    public final TabTheme getTheme() {
        return this.theme;
    }

    @Override
    @NotNull
    public TabTheme getTabTheme() {
        return this.theme;
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        Color color = this.theme.getBackground();
        if (color == null) {
            color = this.theme.getBorderColor();
        }
        return color;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Color getCustomBackground(@Nullable Color tabColor, boolean selected2, boolean active, boolean hovered) {
        Ref.ObjectRef bg;
        block13: {
            Color color;
            block17: {
                Color hover;
                block16: {
                    void it;
                    block10: {
                        Color color2;
                        block15: {
                            Color hover2;
                            block14: {
                                void it2;
                                block11: {
                                    Object object;
                                    Ref.ObjectRef objectRef;
                                    block12: {
                                        void inactive;
                                        bg = new Ref.ObjectRef();
                                        if (selected2) break block10;
                                        if (tabColor == null) break block11;
                                        objectRef = bg;
                                        object = this.theme.getInactiveColoredTabBackground();
                                        if (object == null) break block12;
                                        Color color3 = object;
                                        Ref.ObjectRef objectRef2 = objectRef;
                                        boolean bl2 = false;
                                        Color color4 = ColorUtil.alphaBlending((Color)inactive, (Color)tabColor);
                                        objectRef = objectRef2;
                                        object = color4;
                                        if (color4 != null) break block11;
                                    }
                                    object = objectRef.element = tabColor;
                                }
                                if (!hovered) break block13;
                                Color color5 = active ? this.theme.getHoverBackground() : this.theme.getHoverInactiveBackground();
                                if (color5 == null) break block13;
                                hover2 = color5;
                                boolean bl4 = false;
                                Ref.ObjectRef objectRef = bg;
                                color2 = (Color)bg.element;
                                if (color2 == null) break block14;
                                Color bl2 = color2;
                                Ref.ObjectRef objectRef3 = objectRef;
                                boolean bl3 = false;
                                Color color6 = ColorUtil.alphaBlending((Color)hover2, (Color)it2);
                                objectRef = objectRef3;
                                color2 = color6;
                                if (color6 != null) break block15;
                            }
                            color2 = hover2;
                        }
                        objectRef.element = color2;
                        break block13;
                    }
                    Object object = tabColor;
                    if (object == null && (object = active ? this.theme.getUnderlinedTabBackground() : this.theme.getUnderlinedTabInactiveBackground()) == null) {
                        object = bg.element = this.theme.getBackground();
                    }
                    if (!hovered) break block13;
                    hover = active ? this.theme.getHoverSelectedBackground() : this.theme.getHoverSelectedInactiveBackground();
                    boolean bl = false;
                    Ref.ObjectRef objectRef = bg;
                    color = (Color)bg.element;
                    if (color == null) break block16;
                    Color bl4 = color;
                    Ref.ObjectRef objectRef4 = objectRef;
                    boolean bl5 = false;
                    Color color7 = ColorUtil.alphaBlending((Color)hover, (Color)it);
                    objectRef = objectRef4;
                    color = color7;
                    if (color7 != null) break block17;
                }
                color = hover;
            }
            objectRef.element = color;
        }
        return (Color)bg.element;
    }

    @Override
    public void fillBackground(@NotNull Graphics2D g, @NotNull Rectangle rect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Color color = this.theme.getBackground();
            if (color == null) break block0;
            Color it = color;
            boolean bl = false;
            GraphicsExKt.fill2DRect(g, rect, it);
        }
    }

    @Override
    public void paintTab(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness, @Nullable Color tabColor, boolean active, boolean hovered) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Color color = this.getCustomBackground(tabColor, false, active, hovered);
            if (color == null) break block0;
            Color it = color;
            boolean bl = false;
            GraphicsExKt.fill2DRect(g, rect, it);
        }
    }

    @Override
    public void paintSelectedTab(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness, @Nullable Color tabColor, boolean active, boolean hovered) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Color color = this.getCustomBackground(tabColor, true, active, hovered);
        if (color != null) {
            Color it = color;
            boolean bl = false;
            GraphicsExKt.fill2DRect(g, rect, it);
        }
        if (!JBEditorTabsBorder.Companion.hasAnimation$intellij_platform_ide() || !(this instanceof JBEditorTabPainter)) {
            this.paintUnderline(position, rect, borderThickness, g, active);
        }
    }

    @Override
    public void paintUnderline(@NotNull JBTabsPosition position, @NotNull Rectangle rect, int borderThickness, @NotNull Graphics2D g, boolean active) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle underline = this.underlineRectangle(position, rect, this.theme.getUnderlineHeight());
        int arc = this.theme.getUnderlineArc();
        Color color2 = color = active ? this.theme.getUnderlineColor() : this.theme.getInactiveUnderlineColor();
        if (arc > 0) {
            GraphicsExKt.fill2DRoundRect(g, underline, arc, color);
        } else {
            GraphicsExKt.fill2DRect(g, underline, color);
        }
    }

    @Override
    public void paintBorderLine(@NotNull Graphics2D g, int thickness, @NotNull Point from, @NotNull Point to) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        GraphicsExKt.paint2DLine(g, from, to, LinePainter2D.StrokeType.INSIDE, thickness, this.theme.getBorderColor());
    }

    @NotNull
    protected Rectangle underlineRectangle(@NotNull JBTabsPosition position, @NotNull Rectangle rect, int thickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return new Rectangle(rect.x, rect.y + rect.height - thickness, rect.width, thickness);
    }

    public JBDefaultTabPainter() {
        this(null, 1, null);
    }
}

