/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ui.RangeBlinkerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u001c\u001a\u00020\u00192\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0012J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\u0019H\u0002J\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u000ej\b\u0012\u0004\u0012\u00020\u0014`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/util/ui/RangeBlinker;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "timeToLive", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/markup/TextAttributes;ILcom/intellij/openapi/Disposable;)V", "lifetime", "markers", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/util/Segment;", "Lkotlin/collections/ArrayList;", "show", "", "addedHighlighters", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "triggerFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "blinkingJob", "Lkotlinx/coroutines/Job;", "resetMarkers", "", "resetTime", "removeHighlights", "doBlinkTick", "startBlinking", "stopBlinking", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRangeBlinker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeBlinker.kt\ncom/intellij/util/ui/RangeBlinker\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,122:1\n42#2,3:123\n*S KotlinDebug\n*F\n+ 1 RangeBlinker.kt\ncom/intellij/util/ui/RangeBlinker\n*L\n37#1:123,3\n*E\n"})
public final class RangeBlinker {
    @NotNull
    private final Editor editor;
    @NotNull
    private final TextAttributes attributes;
    private int timeToLive;
    private final int lifetime;
    @NotNull
    private final ArrayList<Segment> markers;
    private boolean show;
    @NotNull
    private final ArrayList<RangeHighlighter> addedHighlighters;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableSharedFlow<Unit> triggerFlow;
    @Nullable
    private Job blinkingJob;

    public RangeBlinker(@NotNull Editor editor, @NotNull TextAttributes attributes, int timeToLive, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.editor = editor;
        this.attributes = attributes;
        this.lifetime = this.timeToLive = timeToLive;
        this.markers = new ArrayList();
        this.show = true;
        this.addedHighlighters = new ArrayList();
        boolean $i$f$service = false;
        Class<RangeBlinkerService> serviceClass$iv = RangeBlinkerService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)((RangeBlinkerService)object).getCoroutineScope(), (String)"RangeBlinker", null, (boolean)false, (int)6, null);
        this.triggerFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)1, null, (int)4, null);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> RangeBlinker._init_$lambda$0(this));
        }
    }

    public final void resetMarkers(@NotNull List<? extends Segment> markers, boolean resetTime) {
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        this.removeHighlights();
        this.markers.clear();
        this.stopBlinking();
        this.markers.addAll((Collection<Segment>)markers);
        this.show = true;
        if (resetTime) {
            this.timeToLive = this.lifetime;
        }
    }

    public static /* synthetic */ void resetMarkers$default(RangeBlinker rangeBlinker, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rangeBlinker.resetMarkers(list, bl);
    }

    private final void removeHighlights() {
        MarkupModel markupModel = this.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        Object[] objectArray = markupModel2.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllHighlighters(...)");
        Object[] allHighlighters = objectArray;
        Iterator<RangeHighlighter> iterator = this.addedHighlighters.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RangeHighlighter> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RangeHighlighter highlighter;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (ArraysKt.indexOf((Object[])allHighlighters, (Object)highlighter) == -1) continue;
            highlighter.dispose();
        }
        this.addedHighlighters.clear();
    }

    private final void doBlinkTick() {
        Project project = this.editor.getProject();
        if (ApplicationManager.getApplication().isDisposed() || this.editor.isDisposed() || project != null && project.isDisposed()) {
            return;
        }
        MarkupModel markupModel = this.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        if (this.show) {
            Iterator<Segment> iterator = this.markers.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Segment> iterator2 = iterator;
            while (iterator2.hasNext()) {
                RangeHighlighter highlighter;
                Segment segment;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (segment.getEndOffset() > this.editor.getDocument().getTextLength()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)markupModel2.addRangeHighlighter(segment.getStartOffset(), segment.getEndOffset(), 3000, this.attributes, HighlighterTargetArea.EXACT_RANGE), (String)"addRangeHighlighter(...)");
                this.addedHighlighters.add(highlighter);
            }
        } else {
            this.removeHighlights();
        }
        if (this.timeToLive > 0 || this.show) {
            int n = this.timeToLive;
            this.timeToLive = n + -1;
            this.show = !this.show;
            this.triggerFlow.tryEmit((Object)Unit.INSTANCE);
        } else {
            this.stopBlinking();
        }
    }

    public final void startBlinking() {
        if (this.blinkingJob == null) {
            this.blinkingJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ RangeBlinker this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            RangeBlinker.access$doBlinkTick(this.this$0);
                            this.label = 1;
                            Object object2 = FlowKt.sample((Flow)FlowKt.debounce((Flow)((Flow)RangeBlinker.access$getTriggerFlow$p(this.this$0)), (long)400L), (long)400L).collect(new FlowCollector(this.this$0){
                                final /* synthetic */ RangeBlinker this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                    RangeBlinker.access$doBlinkTick(this.this$0);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.triggerFlow.tryEmit((Object)Unit.INSTANCE);
        }
    }

    public final void stopBlinking() {
        Job job = this.blinkingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.blinkingJob = null;
    }

    private static final void _init_$lambda$0(RangeBlinker this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.scope, null, (int)1, null);
    }

    public static final /* synthetic */ void access$doBlinkTick(RangeBlinker $this) {
        $this.doBlinkTick();
    }

    public static final /* synthetic */ MutableSharedFlow access$getTriggerFlow$p(RangeBlinker $this) {
        return $this.triggerFlow;
    }
}

