/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offline;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineProblemDescriptor {
    private String myType;
    private String myFQName;
    private @InspectionMessage String myDescription;
    private List<String> myHints;
    private int myProblemIndex;
    private int myLine;
    private int myOffset;
    private String myModuleName;

    public String getType() {
        return this.myType;
    }

    public void setType(String type) {
        this.myType = type;
    }

    public String getFQName() {
        return this.myFQName;
    }

    public void setFQName(String FQName) {
        this.myFQName = FQName;
    }

    @InspectionMessage
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@InspectionMessage String description) {
        this.myDescription = description;
    }

    public List<String> getHints() {
        return this.myHints;
    }

    public void setHints(@NotNull @NotNull List<@NotNull String> hints) {
        if (hints == null) {
            OfflineProblemDescriptor.$$$reportNull$$$0(0);
        }
        this.myHints = hints;
    }

    public int getProblemIndex() {
        return this.myProblemIndex;
    }

    public void setProblemIndex(int problemIndex) {
        this.myProblemIndex = problemIndex;
    }

    public int getLine() {
        return this.myLine;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    public void setOffset(int offset) {
        this.myOffset = offset;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @Nullable
    public RefEntity getRefElement(@NotNull RefManager refManager) {
        if (refManager == null) {
            OfflineProblemDescriptor.$$$reportNull$$$0(1);
        }
        return (RefEntity)ReadAction.compute(() -> refManager.getProject().isDisposed() ? null : refManager.getReference(this.myType, this.myFQName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineProblemDescriptor that = (OfflineProblemDescriptor)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myProblemIndex != that.myProblemIndex) {
            return false;
        }
        if (!Objects.equals(this.myDescription, that.myDescription)) {
            return false;
        }
        if (!Objects.equals(this.myFQName, that.myFQName)) {
            return false;
        }
        if (!Objects.equals(this.myHints, that.myHints)) {
            return false;
        }
        if (!Objects.equals(this.myModuleName, that.myModuleName)) {
            return false;
        }
        return Objects.equals(this.myType, that.myType);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.myType);
        result = 31 * result + (this.myFQName != null ? this.myFQName.hashCode() : 0);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myHints != null ? this.myHints.hashCode() : 0);
        result = 31 * result + this.myProblemIndex;
        result = 31 * result + this.myLine;
        result = 31 * result + (this.myModuleName != null ? this.myModuleName.hashCode() : 0);
        return result;
    }

    public void setModule(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public String toString() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myFQName;
        }
        return this.myDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/offline/OfflineProblemDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setHints";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

