/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateElementActionBase
extends CreateInDirectoryActionBase
implements WriteActionAware {
    protected CreateElementActionBase() {
    }

    protected CreateElementActionBase(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon) {
        super(text, description, icon);
    }

    protected CreateElementActionBase(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon) {
        if (dynamicText == null) {
            CreateElementActionBase.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateElementActionBase.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon);
    }

    protected CreateElementActionBase(@NotNull Supplier<String> dynamicText, @Nullable Supplier<String> dynamicDescription, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon) {
        if (dynamicText == null) {
            CreateElementActionBase.$$$reportNull$$$0(2);
        }
        super(dynamicText, dynamicDescription, icon);
    }

    @Deprecated
    protected PsiElement @NotNull [] invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        if (project == null) {
            CreateElementActionBase.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            CreateElementActionBase.$$$reportNull$$$0(4);
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            CreateElementActionBase.$$$reportNull$$$0(5);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected void invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull Consumer<? super PsiElement[]> elementsConsumer) {
        if (project == null) {
            CreateElementActionBase.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            CreateElementActionBase.$$$reportNull$$$0(7);
        }
        if (elementsConsumer == null) {
            CreateElementActionBase.$$$reportNull$$$0(8);
        }
        elementsConsumer.accept((PsiElement[])this.invokeDialog(project, directory));
    }

    @NotNull
    protected abstract @NotNull PsiElement @NotNull [] create(@NotNull String var1, @NotNull PsiDirectory var2) throws Exception;

    @NlsContexts.DialogTitle
    protected abstract String getErrorTitle();

    @Deprecated
    protected String getCommandName() {
        return "";
    }

    @NlsContexts.Command
    @NotNull
    protected abstract String getActionName(@NotNull PsiDirectory var1, @NotNull String var2);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        if (e == null) {
            CreateElementActionBase.$$$reportNull$$$0(9);
        }
        if ((view = this.getIdeView(e)) == null) {
            return;
        }
        Project project = e.getProject();
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project == null) {
            return;
        }
        this.invokeDialog(project, dir, createdElements -> {
            for (PsiElement createdElement : createdElements) {
                view.selectElement(createdElement);
            }
        });
    }

    @Nullable
    protected IdeView getIdeView(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateElementActionBase.$$$reportNull$$$0(10);
        }
        return (IdeView)e.getData(LangDataKeys.IDE_VIEW);
    }

    public static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        @NonNls String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart((String)message, (String)"java.io.IOException:");
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateElementActionBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateElementActionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIdeView";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    protected class MyInputValidator
    extends ElementCreator
    implements InputValidator {
        @NotNull
        private final PsiDirectory myDirectory;
        @NotNull
        private @NotNull PsiElement @NotNull [] myCreatedElements;

        public MyInputValidator(@NotNull Project project, PsiDirectory directory) {
            if (directory == null) {
                MyInputValidator.$$$reportNull$$$0(0);
            }
            super(project, CreateElementActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        @NotNull
        public PsiDirectory getDirectory() {
            PsiDirectory psiDirectory = this.myDirectory;
            if (psiDirectory == null) {
                MyInputValidator.$$$reportNull$$$0(1);
            }
            return psiDirectory;
        }

        public boolean checkInput(String inputString) {
            return true;
        }

        @Override
        public PsiElement @NotNull [] create(@NotNull String newName) throws Exception {
            if (newName == null) {
                MyInputValidator.$$$reportNull$$$0(2);
            }
            PsiElement[] psiElementArray = CreateElementActionBase.this.create(newName, this.myDirectory);
            if (psiElementArray == null) {
                MyInputValidator.$$$reportNull$$$0(3);
            }
            return psiElementArray;
        }

        public boolean startInWriteAction() {
            return CreateElementActionBase.this.startInWriteAction();
        }

        @Override
        @NotNull
        public String getActionName(@NotNull String newName) {
            if (newName == null) {
                MyInputValidator.$$$reportNull$$$0(4);
            }
            String string = CreateElementActionBase.this.getActionName(this.myDirectory, newName);
            if (string == null) {
                MyInputValidator.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/CreateElementActionBase$MyInputValidator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/CreateElementActionBase$MyInputValidator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

