/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.TodoAttributes;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoPattern
implements Cloneable {
    private static final String CASE_SENS_ATT = "case-sensitive";
    private static final String PATTERN_ATT = "pattern";
    private final IndexPattern myIndexPattern;
    private TodoAttributes myAttributes;

    @ApiStatus.Internal
    public TodoPattern(@NotNull TodoAttributes attributes) {
        if (attributes == null) {
            TodoPattern.$$$reportNull$$$0(0);
        }
        this("", attributes, false);
    }

    @ApiStatus.Internal
    public TodoPattern(@NotNull Element state, @NotNull TextAttributes defaultTodoAttributes) {
        if (state == null) {
            TodoPattern.$$$reportNull$$$0(1);
        }
        if (defaultTodoAttributes == null) {
            TodoPattern.$$$reportNull$$$0(2);
        }
        this.myAttributes = new TodoAttributes(state, defaultTodoAttributes);
        this.myIndexPattern = new IndexPattern(state.getAttributeValue(PATTERN_ATT, "").trim(), Boolean.parseBoolean(state.getAttributeValue(CASE_SENS_ATT)));
    }

    public TodoPattern(@NotNull String patternString, @NotNull TodoAttributes attributes, boolean caseSensitive) {
        if (patternString == null) {
            TodoPattern.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            TodoPattern.$$$reportNull$$$0(4);
        }
        this.myIndexPattern = new IndexPattern(patternString, caseSensitive);
        this.myAttributes = attributes;
    }

    public TodoPattern clone() {
        return new TodoPattern(this.myIndexPattern.getPatternString(), this.myAttributes.clone(), this.myIndexPattern.isCaseSensitive());
    }

    @NotNull
    @NlsSafe
    public String getPatternString() {
        String string = this.myIndexPattern.getPatternString();
        if (string == null) {
            TodoPattern.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setPatternString(@NotNull String patternString) {
        if (patternString == null) {
            TodoPattern.$$$reportNull$$$0(6);
        }
        this.myIndexPattern.setPatternString(patternString);
    }

    @NotNull
    public TodoAttributes getAttributes() {
        TodoAttributes todoAttributes = this.myAttributes;
        if (todoAttributes == null) {
            TodoPattern.$$$reportNull$$$0(7);
        }
        return todoAttributes;
    }

    public void setAttributes(@NotNull TodoAttributes attributes) {
        if (attributes == null) {
            TodoPattern.$$$reportNull$$$0(8);
        }
        this.myAttributes = attributes;
    }

    public boolean isCaseSensitive() {
        return this.myIndexPattern.isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myIndexPattern.setCaseSensitive(caseSensitive);
    }

    @Nullable
    public Pattern getPattern() {
        return this.myIndexPattern.getPattern();
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            TodoPattern.$$$reportNull$$$0(9);
        }
        this.myAttributes.writeExternal(element);
        if (this.myIndexPattern.isCaseSensitive()) {
            element.setAttribute(CASE_SENS_ATT, "true");
        }
        element.setAttribute(PATTERN_ATT, this.myIndexPattern.getPatternString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TodoPattern)) return false;
        TodoPattern that = (TodoPattern)o;
        if (!this.myIndexPattern.equals(that.myIndexPattern)) return false;
        if (!this.myAttributes.equals(that.myAttributes)) return false;
        return true;
    }

    public int hashCode() {
        return this.myIndexPattern.hashCode() * 31 + this.myAttributes.hashCode();
    }

    public IndexPattern getIndexPattern() {
        return this.myIndexPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTodoAttributes";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternString";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/TodoPattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/TodoPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPatternString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

