/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent;

import com.intellij.docker.DockerCloudConfiguration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/docker/ijent/DockerEndpointEncoder;", "", "<init>", "()V", "UNIX_PREFIX", "", "NPIPE_PREFIX", "TCP_PREFIX", "SSH_PREFIX", "WSL_PREFIX", "SSHCFG_PREFIX", "UNIX_ENCODED", "NPIPE_ENCODED", "TCP_ENCODED", "SSH_ENCODED", "WSL_ENCODED", "SSHCFG_ENCODED", "ESCAPE_CHAR", "", "ESCAPED_TILDE", "encode", "endpoint", "decode", "encoded", "getDefaultEndpoint", "getDefaultEndpointAlias", "isDefaultEndpoint", "", "encodeOrAlias", "decodeOrDefault", "escapePath", "path", "unescapePath", "escaped", "schemaPrefix", "intellij.clouds.docker"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nDockerEelPathFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEndpointEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,482:1\n1#2:483\n*E\n"})
public final class DockerEndpointEncoder {
    @NotNull
    public static final DockerEndpointEncoder INSTANCE = new DockerEndpointEncoder();
    @NotNull
    private static final String UNIX_PREFIX = "unix://";
    @NotNull
    private static final String NPIPE_PREFIX = "npipe://";
    @NotNull
    private static final String TCP_PREFIX = "tcp://";
    @NotNull
    private static final String SSH_PREFIX = "ssh://";
    @NotNull
    private static final String WSL_PREFIX = "wsl://";
    @NotNull
    private static final String SSHCFG_PREFIX = "sshcfg://";
    @NotNull
    private static final String UNIX_ENCODED = "u~";
    @NotNull
    private static final String NPIPE_ENCODED = "np~";
    @NotNull
    private static final String TCP_ENCODED = "tcp~";
    @NotNull
    private static final String SSH_ENCODED = "ssh~";
    @NotNull
    private static final String WSL_ENCODED = "wsl~";
    @NotNull
    private static final String SSHCFG_ENCODED = "sshcfg~";
    private static final char ESCAPE_CHAR = '~';
    @NotNull
    private static final String ESCAPED_TILDE = "~~";

    private DockerEndpointEncoder() {
    }

    @VisibleForTesting
    @NotNull
    public final String encode(@NotNull String endpoint) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!(((CharSequence)endpoint).length() > 0)) {
            boolean $i$a$-require-DockerEndpointEncoder$encode$22 = false;
            String $i$a$-require-DockerEndpointEncoder$encode$22 = "Endpoint cannot be empty";
            throw new IllegalArgumentException($i$a$-require-DockerEndpointEncoder$encode$22.toString());
        }
        if (StringsKt.startsWith$default((String)endpoint, (String)UNIX_PREFIX, (boolean)false, (int)2, null)) {
            pair = TuplesKt.to((Object)UNIX_ENCODED, (Object)StringsKt.removePrefix((String)StringsKt.removePrefix((String)endpoint, (CharSequence)UNIX_PREFIX), (CharSequence)"/"));
        } else if (StringsKt.startsWith$default((String)endpoint, (String)NPIPE_PREFIX, (boolean)false, (int)2, null)) {
            pair = TuplesKt.to((Object)NPIPE_ENCODED, (Object)StringsKt.removePrefix((String)StringsKt.removePrefix((String)endpoint, (CharSequence)NPIPE_PREFIX), (CharSequence)"//"));
        } else if (StringsKt.startsWith$default((String)endpoint, (String)TCP_PREFIX, (boolean)false, (int)2, null)) {
            pair = TuplesKt.to((Object)TCP_ENCODED, (Object)StringsKt.removePrefix((String)endpoint, (CharSequence)TCP_PREFIX));
        } else if (StringsKt.startsWith$default((String)endpoint, (String)SSH_PREFIX, (boolean)false, (int)2, null)) {
            pair = TuplesKt.to((Object)SSH_ENCODED, (Object)StringsKt.removePrefix((String)endpoint, (CharSequence)SSH_PREFIX));
        } else if (StringsKt.startsWith$default((String)endpoint, (String)WSL_PREFIX, (boolean)false, (int)2, null)) {
            pair = TuplesKt.to((Object)WSL_ENCODED, (Object)StringsKt.removePrefix((String)endpoint, (CharSequence)WSL_PREFIX));
        } else if (StringsKt.startsWith$default((String)endpoint, (String)SSHCFG_PREFIX, (boolean)false, (int)2, null)) {
            pair = TuplesKt.to((Object)SSHCFG_ENCODED, (Object)StringsKt.removePrefix((String)endpoint, (CharSequence)SSHCFG_PREFIX));
        } else {
            throw new IllegalArgumentException("Unknown Docker endpoint schema: " + endpoint + ". Supported schemas: unix://, npipe://, tcp://, ssh://, wsl://, sshcfg://");
        }
        Pair pair2 = pair;
        String schemaPrefix = (String)pair2.component1();
        String remainder = (String)pair2.component2();
        return schemaPrefix + this.escapePath(remainder);
    }

    @VisibleForTesting
    @NotNull
    public final String decode(@NotNull String encoded) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        if (!(((CharSequence)encoded).length() > 0)) {
            boolean $i$a$-require-DockerEndpointEncoder$decode$22 = false;
            String $i$a$-require-DockerEndpointEncoder$decode$22 = "Encoded endpoint cannot be empty";
            throw new IllegalArgumentException($i$a$-require-DockerEndpointEncoder$decode$22.toString());
        }
        if (StringsKt.startsWith$default((String)encoded, (String)UNIX_ENCODED, (boolean)false, (int)2, null)) {
            triple = new Triple((Object)UNIX_PREFIX, (Object)StringsKt.removePrefix((String)encoded, (CharSequence)UNIX_ENCODED), (Object)"/");
        } else if (StringsKt.startsWith$default((String)encoded, (String)NPIPE_ENCODED, (boolean)false, (int)2, null)) {
            triple = new Triple((Object)NPIPE_PREFIX, (Object)StringsKt.removePrefix((String)encoded, (CharSequence)NPIPE_ENCODED), (Object)"//");
        } else if (StringsKt.startsWith$default((String)encoded, (String)TCP_ENCODED, (boolean)false, (int)2, null)) {
            triple = new Triple((Object)TCP_PREFIX, (Object)StringsKt.removePrefix((String)encoded, (CharSequence)TCP_ENCODED), (Object)"");
        } else if (StringsKt.startsWith$default((String)encoded, (String)SSH_ENCODED, (boolean)false, (int)2, null)) {
            triple = new Triple((Object)SSH_PREFIX, (Object)StringsKt.removePrefix((String)encoded, (CharSequence)SSH_ENCODED), (Object)"");
        } else if (StringsKt.startsWith$default((String)encoded, (String)WSL_ENCODED, (boolean)false, (int)2, null)) {
            triple = new Triple((Object)WSL_PREFIX, (Object)StringsKt.removePrefix((String)encoded, (CharSequence)WSL_ENCODED), (Object)"");
        } else if (StringsKt.startsWith$default((String)encoded, (String)SSHCFG_ENCODED, (boolean)false, (int)2, null)) {
            triple = new Triple((Object)SSHCFG_PREFIX, (Object)StringsKt.removePrefix((String)encoded, (CharSequence)SSHCFG_ENCODED), (Object)"");
        } else {
            throw new IllegalArgumentException("Unknown encoded Docker endpoint: " + encoded + ". Expected prefixes: u~, np~, tcp~, ssh~, wsl~, sshcfg~");
        }
        Triple triple2 = triple;
        String schemaPrefix = (String)triple2.component1();
        String remainder = (String)triple2.component2();
        String pathPrefix = (String)triple2.component3();
        return schemaPrefix + pathPrefix + this.unescapePath(remainder, schemaPrefix);
    }

    @NotNull
    public final String getDefaultEndpoint() {
        return DockerCloudConfiguration.Companion.createDefault().getApiUrl();
    }

    @NotNull
    public final String getDefaultEndpointAlias() {
        return "";
    }

    public final boolean isDefaultEndpoint(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return Intrinsics.areEqual((Object)endpoint, (Object)this.getDefaultEndpoint());
    }

    @NotNull
    public final String encodeOrAlias(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return this.isDefaultEndpoint(endpoint) ? this.getDefaultEndpointAlias() : this.encode(endpoint);
    }

    @NotNull
    public final String decodeOrDefault(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        return ((CharSequence)encoded).length() == 0 ? this.getDefaultEndpoint() : this.decode(encoded);
    }

    private final String escapePath(String path2) {
        StringBuilder stringBuilder;
        StringBuilder $this$escapePath_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = path2.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = path2.charAt(i);
            switch (c) {
                case '/': 
                case ':': {
                    StringBuilder stringBuilder2 = $this$escapePath_u24lambda_u240.append('~');
                    continue block4;
                }
                case '~': {
                    StringBuilder stringBuilder2 = $this$escapePath_u24lambda_u240.append(ESCAPED_TILDE);
                    continue block4;
                }
                default: {
                    StringBuilder stringBuilder2 = $this$escapePath_u24lambda_u240.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private final String unescapePath(String escaped, String schemaPrefix) {
        StringBuilder stringBuilder;
        StringBuilder $this$unescapePath_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean firstColonRestored = false;
        boolean secondColonRestored = false;
        int atIndex = Intrinsics.areEqual((Object)schemaPrefix, (Object)SSH_PREFIX) ? StringsKt.indexOf$default((CharSequence)escaped, (char)'@', (int)0, (boolean)false, (int)6, null) : -1;
        int i = 0;
        while (i < escaped.length()) {
            if (escaped.charAt(i) == '~' && i + 1 < escaped.length() && escaped.charAt(i + 1) == '~') {
                $this$unescapePath_u24lambda_u240.append('~');
                i += 2;
                continue;
            }
            if (escaped.charAt(i) == '~') {
                int n;
                String string = schemaPrefix;
                if (Intrinsics.areEqual((Object)string, (Object)SSH_PREFIX)) {
                    if (atIndex >= 0 && i < atIndex && !firstColonRestored) {
                        firstColonRestored = true;
                        n = 58;
                    } else {
                        boolean bl2 = 0 <= atIndex ? atIndex <= i : false;
                        if (bl2 && !secondColonRestored) {
                            secondColonRestored = true;
                            n = 58;
                        } else if (atIndex < 0 && !firstColonRestored) {
                            firstColonRestored = true;
                            n = 58;
                        } else {
                            n = 47;
                        }
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)TCP_PREFIX)) {
                    if (!firstColonRestored) {
                        firstColonRestored = true;
                        n = 58;
                    } else {
                        n = 47;
                    }
                } else {
                    n = 47;
                }
                $this$unescapePath_u24lambda_u240.append((char)n);
                ++i;
                continue;
            }
            $this$unescapePath_u24lambda_u240.append(escaped.charAt(i));
            ++i;
        }
        return stringBuilder.toString();
    }
}

