/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.fileTree;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ui.fileTree.FileSystemNode;
import com.intellij.docker.ui.fileTree.FileSystemTree;
import com.intellij.docker.vfs.RemoteFileService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.eel.path.EelPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/ui/fileTree/RenameFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "fileSystemTree", "Lcom/intellij/docker/ui/fileTree/FileSystemTree;", "<init>", "(Lcom/intellij/docker/ui/fileTree/FileSystemTree;)V", "applicationService", "Lcom/intellij/docker/vfs/RemoteFileService;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "RenameFileDialog", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nFileActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileActions.kt\ncom/intellij/docker/ui/fileTree/RenameFileAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,206:1\n42#2,3:207\n*S KotlinDebug\n*F\n+ 1 FileActions.kt\ncom/intellij/docker/ui/fileTree/RenameFileAction\n*L\n77#1:207,3\n*E\n"})
public final class RenameFileAction
extends DumbAwareAction {
    @NotNull
    private final FileSystemTree fileSystemTree;
    @NotNull
    private final RemoteFileService applicationService;

    public RenameFileAction(@NotNull FileSystemTree fileSystemTree) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileSystemTree), (String)"fileSystemTree");
        super(RenameFileAction::_init_$lambda$0, AllIcons.Actions.Edit);
        this.fileSystemTree = fileSystemTree;
        boolean $i$f$service = false;
        Class<RemoteFileService> serviceClass$iv = RemoteFileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.applicationService = (RemoteFileService)object;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileSystemNode node = this.fileSystemTree.getSelectedNode();
        e.getPresentation().setEnabled(!node.isDirectory());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileSystemNode node = this.fileSystemTree.getSelectedNode();
        String fileName = node.getFileTreePath().getPath().getFileName();
        Project project = node.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RenameFileDialog dialog = new RenameFileDialog(project, fileName);
        if (dialog.showAndGet()) {
            String newFileName = dialog.getNewFileName();
            EelPath eelPath = node.getFileTreePath().getPath().getParent();
            if (eelPath == null || (eelPath = eelPath.resolve(newFileName)) == null) {
                RenameFileAction $this$actionPerformed_u24lambda_u240 = this;
                boolean bl = false;
                new Notification("Docker", DockerBundle.message((String)"ShowFiles.notification.content.could.not.resolve.new.file.name", (Object[])new Object[0]), NotificationType.ERROR).notify(node.getProject());
                return;
            }
            EelPath newPath = eelPath;
            BuildersKt.launch$default((CoroutineScope)this.applicationService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, node, newPath, null){
                int label;
                final /* synthetic */ RenameFileAction this$0;
                final /* synthetic */ FileSystemNode $node;
                final /* synthetic */ EelPath $newPath;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    this.$newPath = $newPath;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = RenameFileAction.access$getApplicationService$p(this.this$0).moveFile(this.$node.getFileTreePath(), this.$newPath, (Continuation<? super Unit>)((Continuation)this));
                            ** if (v0 != var4_2) goto lbl11
lbl10:
                            // 1 sources

                            return var4_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            v1 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                            v2 = ModalityState.any();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                            this.label = 2;
                            v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$node, null){
                                int label;
                                final /* synthetic */ RenameFileAction this$0;
                                final /* synthetic */ FileSystemNode $node;
                                {
                                    this.this$0 = $receiver;
                                    this.$node = $node;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            RenameFileAction.access$getFileSystemTree$p(this.this$0).updateTree((AbstractTreeNode<Object>)this.$node.getParent());
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v3 != var4_2) goto lbl24
lbl23:
                            // 1 sources

                            return var4_2;
lbl24:
                            // 1 sources

                            ** GOTO lbl34
                        }
                        case 2: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
                            }
                            catch (Exception <unused var>) {
                                var3_4 = new Object[]{this.$node.getFileTreePath().getPath()};
                                new Notification("Docker", DockerBundle.message((String)"ShowFiles.notification.content.error.occurred.while.renaming.file", (Object[])var3_4), NotificationType.ERROR).notify(this.$node.getProject());
                            }
lbl34:
                            // 3 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private static final String _init_$lambda$0() {
        return DockerBundle.message((String)"ShowFiles.action.rename.file.text", (Object[])new Object[0]);
    }

    public static final /* synthetic */ RemoteFileService access$getApplicationService$p(RenameFileAction $this) {
        return $this.applicationService;
    }

    public static final /* synthetic */ FileSystemTree access$getFileSystemTree$p(RenameFileAction $this) {
        return $this.fileSystemTree;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ui/fileTree/RenameFileAction$RenameFileDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "<init>", "(Lcom/intellij/docker/ui/fileTree/RenameFileAction;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "newNameField", "Ljavax/swing/JTextField;", "value", "newFileName", "getNewFileName", "()Ljava/lang/String;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "intellij.clouds.docker"})
    public final class RenameFileDialog
    extends DialogWrapper {
        @NotNull
        private final String fileName;
        @NotNull
        private final JTextField newNameField;
        @NotNull
        private String newFileName;

        public RenameFileDialog(@NotNull Project project, String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            super(project);
            this.fileName = fileName;
            this.newNameField = new JTextField();
            this.newFileName = "";
            this.setTitle(DockerBundle.message((String)"ShowFiles.dialog.title.rename.file", (Object[])new Object[0]));
            this.init();
        }

        @NotNull
        public final String getNewFileName() {
            return this.newFileName;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            Object object = new Object[]{this.fileName};
            JLabel pathLabel = new JLabel(DockerBundle.message((String)"ShowFiles.rename.file.to", (Object[])object));
            Object $this$createCenterPanel_u24lambda_u240 = object = new JPanel(new BorderLayout());
            boolean bl = false;
            ((Container)$this$createCenterPanel_u24lambda_u240).add((Component)pathLabel, "North");
            ((Container)$this$createCenterPanel_u24lambda_u240).add((Component)this.newNameField, "Center");
            return (JComponent)object;
        }

        protected void doOKAction() {
            String string = this.newNameField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.newFileName = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)this.newFileName).length() > 0) {
                super.doOKAction();
            } else {
                Messages.showErrorDialog((Component)this.getContentPane(), (String)DockerBundle.message((String)"ShowFiles.dialog.message.file.name.cannot.be.empty", (Object[])new Object[0]), (String)DockerBundle.message((String)"ShowFiles.dialog.title.invalid.file.name", (Object[])new Object[0]));
            }
        }
    }
}

