/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.actions.handlers.XAddToWatchesFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public class XEvaluateInConsoleFromEditorActionHandler
extends XAddToWatchesFromEditorActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSessionProxy session, @NotNull DataContext dataContext) {
        if (session == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(1);
        }
        return super.isEnabled(session, dataContext) && XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session) != null;
    }

    @Nullable
    private static ConsoleExecuteAction getConsoleExecuteAction(@NotNull XDebugSessionProxy session) {
        if (session == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(2);
        }
        return XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session.getConsoleView());
    }

    @Nullable
    public static ConsoleExecuteAction getConsoleExecuteAction(@Nullable ConsoleView consoleView) {
        if (!(consoleView instanceof LanguageConsoleView)) {
            return null;
        }
        LanguageConsoleView languageConsoleView = (LanguageConsoleView)consoleView;
        List actions = ActionUtil.getActions((JComponent)languageConsoleView.getConsoleEditor().getComponent());
        ConsoleExecuteAction action = (ConsoleExecuteAction)ContainerUtil.findInstance((Iterable)actions, ConsoleExecuteAction.class);
        return action == null || !action.isEnabled() ? null : action;
    }

    @Override
    protected void perform(@NotNull XDebugSessionProxy session, @NotNull DataContext dataContext) {
        Promise rangeAndText;
        int selectionEnd;
        Editor editor;
        if (session == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            XEvaluateInConsoleFromEditorActionHandler.$$$reportNull$$$0(4);
        }
        if (!((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) instanceof EditorEx)) {
            return;
        }
        int selectionStart = editor.getSelectionModel().getSelectionStart();
        if (selectionStart != (selectionEnd = editor.getSelectionModel().getSelectionEnd())) {
            TextRange textRange = new TextRange(selectionStart, selectionEnd);
            rangeAndText = Promises.resolvedPromise((Object)Pair.create((Object)textRange, (Object)editor.getDocument().getText(textRange)));
        } else {
            XDebuggerEvaluator evaluator = session.getCurrentEvaluator();
            if (evaluator != null) {
                Promise expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(session.getProject(), editor.getDocument(), selectionStart, true);
                rangeAndText = expressionInfoPromise.then(expressionInfo -> {
                    if (expressionInfo == null) {
                        return null;
                    }
                    return Pair.create((Object)expressionInfo.getTextRange(), (Object)XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument()));
                });
            } else {
                return;
            }
        }
        rangeAndText.onSuccess(textRangeStringPair -> ApplicationManager.getApplication().invokeLater(() -> {
            TextRange range = (TextRange)textRangeStringPair.getFirst();
            String text = (String)textRangeStringPair.getSecond();
            if (text == null) {
                return;
            }
            ConsoleExecuteAction action = XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session);
            if (action != null) {
                action.execute(range, text, (EditorEx)editor);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XEvaluateInConsoleFromEditorActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConsoleExecuteAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

