/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLightLineBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointHighlighterRange;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointProxy;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.actions.ToggleLineBreakpointAction;
import com.intellij.xdebugger.impl.actions.handlers.XToggleLineBreakpointActionHandler;
import com.intellij.xdebugger.impl.breakpoints.InlineBreakpointInlayManager;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManagerKt;
import com.intellij.xdebugger.impl.proxy.MonolithBreakpointProxyKt;
import com.intellij.xdebugger.impl.proxy.MonolithLineBreakpointProxy;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 B2\u00020\u0001:\u0006=>?@ABB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0007J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0007J\u0006\u0010\u001c\u001a\u00020\u0017J\u001c\u0010\u001d\u001a\u00020\u00172\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0007J\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0011J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0#2\u0006\u0010$\u001a\u00020%J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0017J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0003J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010*\u001a\u00020\u00172\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010#H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020.H\u0016J\"\u0010/\u001a\u00020\u00172\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u0001012\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0007J\u001e\u00104\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u00105\u001a\u000203H\u0007J\u0018\u00104\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020.2\u0006\u00105\u001a\u000203H\u0016J\u0010\u00106\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020.H\u0002J\u001c\u0010/\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020.2\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0002J\u0006\u00107\u001a\u00020\u0017J\u0010\u00108\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00109\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\r\u001a#\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u000e\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;", "Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointManagerProxy;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "isEnabled", "", "manager", "Lcom/intellij/platform/debugger/impl/shared/proxy/XBreakpointManagerProxy;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;ZLcom/intellij/platform/debugger/impl/shared/proxy/XBreakpointManagerProxy;)V", "cs", "myBreakpoints", "Lcom/intellij/util/containers/MultiMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointProxy;", "Lorg/jetbrains/annotations/NotNull;", "breakpointUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "myDragDetected", "onFileDeleted", "", "url", "onFileUrlChanged", "oldUrl", "newUrl", "updateBreakpointsUI", "registerBreakpoint", "breakpoint", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl;", "initUI", "unregisterBreakpoint", "getDocumentBreakpointProxies", "", "document", "Lcom/intellij/openapi/editor/Document;", "getDocumentBreakpoints", "getAllBreakpoints", "updateBreakpoints", "cleanUpBreakpoints", "removeBreakpoints", "toRemove", "Lcom/intellij/platform/debugger/impl/shared/proxy/XBreakpointProxy;", "breakpointChanged", "Lcom/intellij/platform/debugger/impl/shared/proxy/XLightLineBreakpointProxy;", "queueBreakpointUpdate", "slave", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "callOnUpdate", "Ljava/lang/Runnable;", "queueBreakpointUpdateCallback", "callback", "updateBreakpointNow", "queueAllBreakpointsUpdate", "scheduleDocumentUpdate", "scheduleBreakpointsCleanUp", "isFromMyProject", "editor", "Lcom/intellij/openapi/editor/Editor;", "MyDocumentListener", "MyEditorMouseMotionListener", "MyEditorMouseListener", "MyDependentBreakpointListener", "MyEditorColorsListener", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nXLineBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XLineBreakpointManager.kt\ncom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,445:1\n1915#2,2:446\n812#2,12:458\n1586#2:470\n1661#2,3:471\n1915#2,2:474\n1512#2:476\n1538#2,3:477\n1541#2,3:487\n777#2:490\n873#2,2:491\n1391#2:493\n1480#2,5:494\n60#3,5:448\n60#3,5:453\n383#4,7:480\n*S KotlinDebug\n*F\n+ 1 XLineBreakpointManager.kt\ncom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager\n*L\n132#1:446,2\n174#1:458,12\n174#1:470\n174#1:471,3\n190#1:474,2\n216#1:476\n216#1:477,3\n216#1:487,3\n237#1:490\n237#1:491,2\n238#1:493\n238#1:494,5\n158#1:448,5\n165#1:453,5\n216#1:480,7\n*E\n"})
public final class XLineBreakpointManager
implements XLineBreakpointManagerProxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final XBreakpointManagerProxy manager;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final MultiMap<String, XLineBreakpointProxy> myBreakpoints;
    @NotNull
    private final MergingUpdateQueue breakpointUpdateQueue;
    private boolean myDragDetected;
    @JvmField
    @NotNull
    public static final DataKey<Integer> BREAKPOINT_LINE_KEY = DataKey.Companion.create("xdebugger.breakpoint.line");

    public XLineBreakpointManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope, boolean isEnabled, @NotNull XBreakpointManagerProxy manager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.project = project;
        this.manager = manager;
        this.cs = com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"XLineBreakpointManager", null, (boolean)false, (int)6, null);
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.myBreakpoints = multiMap;
        this.breakpointUpdateQueue = MergingUpdateQueue.Companion.mergingUpdateQueue("XLine breakpoints", 300, this.cs);
        Disposable disposable = CoroutineScopeKt.asDisposable((CoroutineScope)this.cs);
        MessageBusConnection busConnection = this.project.getMessageBus().connect(disposable);
        if (!this.project.isDefault()) {
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
            EditorEventMulticaster editorEventMulticaster2 = editorEventMulticaster;
            editorEventMulticaster2.addDocumentListener((DocumentListener)new MyDocumentListener(), disposable);
            editorEventMulticaster2.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), disposable);
            editorEventMulticaster2.addEditorMouseMotionListener((EditorMouseMotionListener)new MyEditorMouseMotionListener(), disposable);
            Topic<XDependentBreakpointListener> topic = XDependentBreakpointListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            busConnection.subscribe(topic, (Object)new MyDependentBreakpointListener());
            Registry.Companion.get("debugger.show.breakpoints.inline").addListener(new RegistryValueListener(){

                public void afterValueChanged(RegistryValue value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    for (String fileUrl : myBreakpoints.keySet()) {
                        Document document;
                        VirtualFile file2;
                        if (VirtualFileManager.getInstance().findFileByUrl(fileUrl) == null || XDebuggerUtil.areInlineBreakpointsEnabled((VirtualFile)file2) || FileDocumentManager.getInstance().getDocument(file2) == null) continue;
                        this.updateBreakpoints(document);
                    }
                }
            }, disposable);
        }
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, (Object)new MyEditorColorsListener());
        Topic topic2 = FileDocumentManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        busConnection.subscribe(topic2, (Object)new FileDocumentManagerListener(){

            /*
             * WARNING - void declaration
             */
            public void fileContentLoaded(VirtualFile file2, Document document) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                Collection collection = myBreakpoints.get((Object)file2.getUrl());
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), 2::fileContentLoaded$lambda$0);
                XLineBreakpointManager xLineBreakpointManager = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    XLineBreakpointProxy it = (XLineBreakpointProxy)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    XLineBreakpointManager.queueBreakpointUpdate$default(xLineBreakpointManager, (XLightLineBreakpointProxy)it, null, 2, null);
                }
            }

            private static final boolean fileContentLoaded$lambda$0(XLineBreakpointProxy it) {
                return it.getHighlighter() == null;
            }
        });
        if (!isEnabled) {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
        }
    }

    @ApiStatus.Internal
    public final void onFileDeleted(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.removeBreakpoints(this.myBreakpoints.get((Object)url));
    }

    @ApiStatus.Internal
    public final void onFileUrlChanged(@NotNull String oldUrl, @NotNull String newUrl) {
        Intrinsics.checkNotNullParameter((Object)oldUrl, (String)"oldUrl");
        Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
        Collection collection = this.myBreakpoints.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object url;
            XLineBreakpointProxy breakpoint2 = (XLineBreakpointProxy)element$iv;
            boolean bl = false;
            Object object = breakpoint2.getFile();
            if (object == null || (object = object.getUrl()) == null) {
                object = breakpoint2.getFileUrl();
            }
            if (!FileUtil.startsWith((String)(url = object), (String)oldUrl)) continue;
            String string = ((String)url).substring(oldUrl.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            breakpoint2.setFileUrl(newUrl + string);
        }
    }

    public final void updateBreakpointsUI() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)this.project).runAfterOpened(() -> XLineBreakpointManager.updateBreakpointsUI$lambda$0(this));
    }

    @Deprecated(message="Use {@link #registerBreakpoint(XLineBreakpointProxy, boolean)} instead")
    public final void registerBreakpoint(@NotNull XLineBreakpointImpl<?> breakpoint2, boolean initUI) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        this.registerBreakpoint(MonolithBreakpointProxyKt.asProxy(breakpoint2), initUI);
    }

    public final void registerBreakpoint(@NotNull XLineBreakpointProxy breakpoint2, boolean initUI) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)breakpoint2, (String)"breakpoint");
        if (initUI) {
            this.updateBreakpointNow((XLightLineBreakpointProxy)breakpoint2);
        }
        if ((object = breakpoint2.getFile()) == null || (object = object.getUrl()) == null) {
            object = breakpoint2.getFileUrl();
        }
        Object fileUrl = object;
        Logger $this$debug_u24default$iv = XLineBreakpointManagerKt.access$getLog$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Register line breakpoint " + breakpoint2.getId() + " " + breakpoint2.getClass().getSimpleName() + ": " + (String)fileUrl, t$iv);
        }
        this.myBreakpoints.putValue(fileUrl, (Object)breakpoint2);
    }

    public final void unregisterBreakpoint(@NotNull XLineBreakpointProxy breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)breakpoint2, (String)"breakpoint");
        Object object = breakpoint2.getFile();
        if (object == null || (object = object.getUrl()) == null) {
            object = breakpoint2.getFileUrl();
        }
        Object fileUrl = object;
        boolean removed = this.myBreakpoints.remove(fileUrl, (Object)breakpoint2);
        Logger $this$debug_u24default$iv = XLineBreakpointManagerKt.access$getLog$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Unregister line breakpoint " + breakpoint2.getId() + " [removed=" + removed + "] " + breakpoint2.getClass().getSimpleName() + ": " + (String)fileUrl, t$iv);
        }
    }

    @NotNull
    public Collection<XLineBreakpointProxy> getDocumentBreakpointProxies(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile file2 = virtualFile;
        Collection collection = this.myBreakpoints.get((Object)file2.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<XLineBreakpointImpl<?>> getDocumentBreakpoints(@NotNull Document document) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Iterable $this$filterIsInstance$iv = this.getDocumentBreakpointProxies(document);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MonolithLineBreakpointProxy)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MonolithLineBreakpointProxy monolithLineBreakpointProxy = (MonolithLineBreakpointProxy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBreakpoint());
        }
        return (List)destination$iv$iv;
    }

    @TestOnly
    @NotNull
    public Collection<XLineBreakpointProxy> getAllBreakpoints() {
        Collection collection = this.myBreakpoints.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void updateBreakpoints(Document document) {
        Collection<XLineBreakpointProxy> breakpoints = this.getDocumentBreakpointProxies(document);
        if (breakpoints.isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162343");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            Iterable $this$forEach$iv = breakpoints;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XLineBreakpointProxy it2 = (XLineBreakpointProxy)element$iv;
                boolean bl2 = false;
                it2.updatePosition();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.cleanUpBreakpoints(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanUpBreakpoints(Document document) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        Object highlighter;
        Collection<XLineBreakpointProxy> breakpoints = this.getDocumentBreakpointProxies(document);
        List valid = new ArrayList();
        List invalid = new ArrayList();
        for (XLineBreakpointProxy breakpoint2 : breakpoints) {
            highlighter = breakpoint2.getHighlighter();
            if (highlighter == null) continue;
            boolean bl = highlighter.isValid() ? valid.add(breakpoint2) : invalid.add(breakpoint2);
        }
        this.removeBreakpoints(invalid);
        boolean areInlineBreakpoints = XDebuggerUtil.areInlineBreakpointsEnabled((VirtualFile)FileDocumentManager.getInstance().getFile(document));
        highlighter = valid;
        boolean $i$f$groupBy = false;
        void var9_10 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Serializable serializable;
            XLineBreakpointProxy b = (XLineBreakpointProxy)element$iv$iv;
            boolean bl = false;
            if (areInlineBreakpoints) {
                Triple triple;
                AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162343");
                Throwable throwable = null;
                try {
                    TextRange textRange;
                    AccessToken it2 = (AccessToken)autoCloseable;
                    boolean bl2 = false;
                    XLineBreakpointHighlighterRange range = b.getHighlightRange();
                    if (range instanceof XLineBreakpointHighlighterRange.Available) {
                        textRange = ((XLineBreakpointHighlighterRange.Available)range).getRange();
                    } else {
                        if (range instanceof XLineBreakpointHighlighterRange.Unavailable) {
                            this.scheduleBreakpointsCleanUp(document);
                            return;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    Integer startOffset = textRange != null ? Integer.valueOf(textRange.getStartOffset()) : null;
                    triple = new Triple((Object)b.getType(), (Object)b.getLine(), (Object)startOffset);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                serializable = (Serializable)triple;
            } else {
                serializable = Integer.valueOf(b.getLine());
            }
            Serializable key$iv$iv = serializable;
            Object object2 = destination$iv$iv;
            Serializable key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.drop((Iterable)it, (int)1);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List duplicates = (List)destination$iv$iv;
        this.removeBreakpoints(duplicates);
    }

    private final void removeBreakpoints(Collection<? extends XBreakpointProxy> toRemove) {
        Collection collection = toRemove;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        for (XBreakpointProxy breakpoint2 : collection) {
            this.manager.removeBreakpoint(breakpoint2);
        }
    }

    public void breakpointChanged(@NotNull XLightLineBreakpointProxy breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)breakpoint2, (String)"breakpoint");
        if (EDT.isCurrentThreadEdt()) {
            this.updateBreakpointNow(breakpoint2);
        } else {
            this.queueBreakpointUpdate(breakpoint2, null);
        }
    }

    @JvmOverloads
    public final void queueBreakpointUpdate(@Nullable XBreakpoint<?> slave, @Nullable Runnable callOnUpdate) {
        if (slave instanceof XLineBreakpointImpl) {
            this.queueBreakpointUpdate((XLightLineBreakpointProxy)MonolithBreakpointProxyKt.asProxy((XLineBreakpointImpl)slave), callOnUpdate);
        }
    }

    public static /* synthetic */ void queueBreakpointUpdate$default(XLineBreakpointManager xLineBreakpointManager, XBreakpoint xBreakpoint, Runnable runnable, int n, Object object) {
        if ((n & 2) != 0) {
            runnable = null;
        }
        xLineBreakpointManager.queueBreakpointUpdate(xBreakpoint, runnable);
    }

    @Deprecated(message="Use queueBreakpointUpdateCallback(XLightLineBreakpointProxy, Runnable)")
    public final void queueBreakpointUpdateCallback(@Nullable XLineBreakpointImpl<?> breakpoint2, @NotNull Runnable callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.breakpointUpdateQueue.queue(new Update(breakpoint2, callback2){
            final /* synthetic */ Runnable $callback;
            {
                this.$callback = $callback;
                super($breakpoint, false, 0, 6, null);
            }

            public void run() {
                this.$callback.run();
            }
        });
    }

    public void queueBreakpointUpdateCallback(@NotNull XLightLineBreakpointProxy breakpoint2, @NotNull Runnable callback2) {
        Intrinsics.checkNotNullParameter((Object)breakpoint2, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.breakpointUpdateQueue.queue(new Update(breakpoint2, callback2){
            final /* synthetic */ Runnable $callback;
            {
                this.$callback = $callback;
                super((Object)$breakpoint, false, 0, 6, null);
            }

            public void run() {
                this.$callback.run();
            }
        });
    }

    private final void updateBreakpointNow(XLightLineBreakpointProxy breakpoint2) {
        XLineBreakpointManager.queueBreakpointUpdate$default(this, breakpoint2, null, 2, null);
        this.breakpointUpdateQueue.sendFlush();
    }

    private final void queueBreakpointUpdate(XLightLineBreakpointProxy breakpoint2, Runnable callOnUpdate) {
        this.breakpointUpdateQueue.queue(new Update(breakpoint2, callOnUpdate){
            final /* synthetic */ XLightLineBreakpointProxy $breakpoint;
            final /* synthetic */ Runnable $callOnUpdate;
            {
                this.$breakpoint = $breakpoint;
                this.$callOnUpdate = $callOnUpdate;
                super((Object)$breakpoint, false, 0, 6, null);
            }

            public void run() {
                this.$breakpoint.doUpdateUI(() -> queueBreakpointUpdate.1.run$lambda$0(this.$callOnUpdate));
            }

            private static final Unit run$lambda$0(Runnable $callOnUpdate) {
                block0: {
                    Runnable runnable = $callOnUpdate;
                    if (runnable == null) break block0;
                    runnable.run();
                }
                return Unit.INSTANCE;
            }
        });
    }

    static /* synthetic */ void queueBreakpointUpdate$default(XLineBreakpointManager xLineBreakpointManager, XLightLineBreakpointProxy xLightLineBreakpointProxy, Runnable runnable, int n, Object object) {
        if ((n & 2) != 0) {
            runnable = null;
        }
        xLineBreakpointManager.queueBreakpointUpdate(xLightLineBreakpointProxy, runnable);
    }

    public final void queueAllBreakpointsUpdate() {
        this.breakpointUpdateQueue.queue(new Update(this){
            final /* synthetic */ XLineBreakpointManager this$0;
            {
                this.this$0 = $receiver;
                super((Object)"all breakpoints", false, 0, 6, null);
            }

            public void run() {
                for (XLineBreakpointProxy breakpoint2 : XLineBreakpointManager.access$getMyBreakpoints$p(this.this$0).values()) {
                    Intrinsics.checkNotNull((Object)breakpoint2);
                    XLightLineBreakpointProxy.doUpdateUI$default((XLightLineBreakpointProxy)((XLightLineBreakpointProxy)breakpoint2), null, (int)1, null);
                }
            }
        });
        this.breakpointUpdateQueue.sendFlush();
    }

    private final void scheduleDocumentUpdate(Document document) {
        Pair pair = TuplesKt.to((Object)"update", (Object)document);
        this.breakpointUpdateQueue.queue(new Update(this, document, (Pair<String, ? extends Document>)pair){
            final /* synthetic */ XLineBreakpointManager this$0;
            final /* synthetic */ Document $document;
            {
                this.this$0 = $receiver;
                this.$document = $document;
                super($super_call_param$1, false, 0, 6, null);
            }

            public void run() {
                ApplicationManager.getApplication().invokeLater(() -> scheduleDocumentUpdate.1.run$lambda$0(this.this$0, this.$document));
            }

            private static final void run$lambda$0(XLineBreakpointManager this$0, Document $document) {
                XLineBreakpointManager.access$updateBreakpoints(this$0, $document);
            }
        });
    }

    private final void scheduleBreakpointsCleanUp(Document document) {
        Pair pair = TuplesKt.to((Object)"clean up", (Object)document);
        this.breakpointUpdateQueue.queue(new Update(this, document, (Pair<String, ? extends Document>)pair){
            final /* synthetic */ XLineBreakpointManager this$0;
            final /* synthetic */ Document $document;
            {
                this.this$0 = $receiver;
                this.$document = $document;
                super($super_call_param$1, false, 0, 6, null);
            }

            public void run() {
                ApplicationManager.getApplication().invokeLater(() -> scheduleBreakpointsCleanUp.1.run$lambda$0(this.this$0, this.$document));
            }

            private static final void run$lambda$0(XLineBreakpointManager this$0, Document $document) {
                XLineBreakpointManager.access$cleanUpBreakpoints(this$0, $document);
            }
        });
    }

    private final boolean isFromMyProject(Editor editor) {
        if (this.project == editor.getProject()) {
            return true;
        }
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        for (FileEditor fileEditor : fileEditorArray) {
            if (!(fileEditor instanceof TextEditor) || !Intrinsics.areEqual((Object)((TextEditor)fileEditor).getEditor(), (Object)editor)) continue;
            return true;
        }
        return false;
    }

    @JvmOverloads
    public final void queueBreakpointUpdate(@Nullable XBreakpoint<?> slave) {
        XLineBreakpointManager.queueBreakpointUpdate$default(this, slave, null, 2, null);
    }

    private static final void updateBreakpointsUI$lambda$0(XLineBreakpointManager this$0) {
        this$0.queueAllBreakpointsUpdate();
    }

    public static final /* synthetic */ void access$cleanUpBreakpoints(XLineBreakpointManager $this, Document document) {
        $this.cleanUpBreakpoints(document);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$Companion;", "", "<init>", "()V", "BREAKPOINT_LINE_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$MyDependentBreakpointListener;", "Lcom/intellij/xdebugger/impl/breakpoints/XDependentBreakpointListener;", "<init>", "(Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;)V", "dependencySet", "", "slave", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "master", "dependencyCleared", "breakpoint", "intellij.platform.debugger.impl"})
    private final class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        @Override
        public void dependencySet(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master) {
            Intrinsics.checkNotNullParameter(slave, (String)"slave");
            Intrinsics.checkNotNullParameter(master, (String)"master");
            XLineBreakpointManager.queueBreakpointUpdate$default(XLineBreakpointManager.this, slave, null, 2, null);
        }

        @Override
        public void dependencyCleared(@Nullable XBreakpoint<?> breakpoint2) {
            XLineBreakpointManager.queueBreakpointUpdate$default(XLineBreakpointManager.this, breakpoint2, null, 2, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "(Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;)V", "documentChanged", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nXLineBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XLineBreakpointManager.kt\ncom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$MyDocumentListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,445:1\n1915#2,2:446\n*S KotlinDebug\n*F\n+ 1 XLineBreakpointManager.kt\ncom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$MyDocumentListener\n*L\n315#1:446,2\n*E\n"})
    private final class MyDocumentListener
    implements DocumentListener {
        public void documentChanged(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Document document = e.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            Collection<XLineBreakpointProxy> breakpoints = XLineBreakpointManager.this.getDocumentBreakpointProxies(document2);
            if (!breakpoints.isEmpty()) {
                Iterable $this$forEach$iv = breakpoints;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    XLineBreakpointProxy it = (XLineBreakpointProxy)element$iv;
                    boolean bl = false;
                    it.fastUpdatePosition();
                }
                XLineBreakpointManager.this.scheduleDocumentUpdate(document2);
                InlineBreakpointInlayManager.Companion.getInstance(XLineBreakpointManager.this.project).redrawDocument(e);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$MyEditorColorsListener;", "Lcom/intellij/openapi/editor/colors/EditorColorsListener;", "<init>", "(Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;)V", "globalSchemeChange", "", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "intellij.platform.debugger.impl"})
    private final class MyEditorColorsListener
    implements EditorColorsListener {
        public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
            XLineBreakpointManager.this.updateBreakpointsUI();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$MyEditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "<init>", "(Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;)V", "mousePressed", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseClicked", "isInsideClickableGutterArea", "", "intellij.platform.debugger.impl"})
    private final class MyEditorMouseListener
    implements EditorMouseListener {
        public void mousePressed(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XLineBreakpointManager.this.myDragDetected = false;
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            MouseEvent mouseEvent = e.getMouseEvent();
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
            MouseEvent mouseEvent2 = mouseEvent;
            if (mouseEvent2.isPopupTrigger() || mouseEvent2.isMetaDown() || mouseEvent2.isControlDown() || mouseEvent2.getButton() != 1 || DiffUtil.isDiffEditor((Editor)editor2) || !this.isInsideClickableGutterArea(e) || ConsoleViewUtil.isConsoleViewEditor((Editor)editor2) || !XLineBreakpointManager.this.isFromMyProject(editor2) || editor2.getSelectionModel().hasSelection() && XLineBreakpointManager.this.myDragDetected) {
                return;
            }
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)XLineBreakpointManager.this.project).commitDocument(document2);
            int line = EditorUtil.yToLogicalLineNoCustomRenderers((Editor)editor2, (int)mouseEvent2.getY());
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document2);
            if (DocumentUtil.isValidLine((int)line, (Document)document2) && file2 != null) {
                AnAction action = ActionManager.getInstance().getAction("ToggleLineBreakpoint");
                if (action == null) {
                    throw new AssertionError((Object)"'ToggleLineBreakpoint' action not found");
                }
                DataContext dataContext = SimpleDataContext.getSimpleContext(BREAKPOINT_LINE_KEY, (Object)line, (DataContext)DataManager.getInstance().getDataContext(mouseEvent2.getComponent()));
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getSimpleContext(...)");
                DataContext dataContext2 = dataContext;
                AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)mouseEvent2, (String)"ICON_NAVIGATION", (DataContext)dataContext2);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                AnActionEvent event = anActionEvent;
                if (SplitDebuggerMode.isSplitDebugger()) {
                    XToggleLineBreakpointActionHandler handler = ToggleLineBreakpointAction.ourHandler;
                    if (handler.isEnabled(XLineBreakpointManager.this.project, event)) {
                        handler.perform(XLineBreakpointManager.this.project, event);
                        ActionsCollectorImpl.Companion.onAfterActionInvoked(action, event, AnActionResult.PERFORMED);
                    }
                } else {
                    ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
                }
            }
        }

        private final boolean isInsideClickableGutterArea(EditorMouseEvent e) {
            if (ExperimentalUI.Companion.isNewUI() && Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.LINE_NUMBERS_AREA)) {
                return UISettings.Companion.getInstance().getShowBreakpointsOverLineNumbers();
            }
            if (ExperimentalUI.Companion.isNewUI() && e.getEditor().getSettings().isLineNumbersAfterIcons() && e.getEditor().getSettings().isLineNumbersShown()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.LINE_MARKERS_AREA) && !Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.FOLDING_OUTLINE_AREA)) {
                return false;
            }
            int n = e.getMouseEvent().getX();
            Editor editor = e.getEditor();
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            return n <= ((EditorEx)editor).getGutterComponentEx().getWhitespaceSeparatorOffset();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager$MyEditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "(Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;)V", "mouseDragged", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.platform.debugger.impl"})
    private final class MyEditorMouseMotionListener
    implements EditorMouseMotionListener {
        public void mouseDragged(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            XLineBreakpointManager.this.myDragDetected = true;
        }
    }
}

