/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.klogging.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spaceport.klogging.impl.ApplicationLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggerFactory;
import libraries.klogging.KLoggerStaticFactoryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\n0\fj\u0002`\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spaceport/klogging/impl/KLoggerFactoryIdea;", "Llibraries/klogging/KLoggerFactory;", "<init>", "()V", "logger", "Llibraries/klogging/KLogger;", "owner", "Lkotlin/reflect/KClass;", "", "name", "", "nameSource", "Lkotlin/Function0;", "Llibraries/klogging/LoggerNameSource;", "wrapLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "wrapWithApplicationLogger", "Lcom/intellij/spaceport/klogging/impl/ApplicationLogger;", "intellij.spaceport"})
public final class KLoggerFactoryIdea
implements KLoggerFactory {
    @NotNull
    public static final KLoggerFactoryIdea INSTANCE = new KLoggerFactoryIdea();

    private KLoggerFactoryIdea() {
    }

    @NotNull
    public KLogger logger(@NotNull KClass<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Logger logger = Logger.getInstance((Class)JvmClassMappingKt.getJavaClass(owner));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return this.wrapLogger(logger);
    }

    @NotNull
    public KLogger logger(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.logger(JvmClassMappingKt.getKotlinClass(owner.getClass()));
    }

    @NotNull
    public KLogger logger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Logger logger = Logger.getInstance((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return this.wrapLogger(logger);
    }

    @NotNull
    public KLogger logger(@NotNull Function0<String> nameSource) {
        Intrinsics.checkNotNullParameter(nameSource, (String)"nameSource");
        return this.logger(KLoggerStaticFactoryKt.loggerNameFromSource(nameSource));
    }

    private final KLogger wrapLogger(Logger logger) {
        return new KLogger((BaseLogger)this.wrapWithApplicationLogger(logger));
    }

    private final ApplicationLogger wrapWithApplicationLogger(Logger logger) {
        return new ApplicationLogger(logger);
    }
}

