/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.browser.RemoteBrowser;
import com.jetbrains.cef.remote.browser.RemoteDevToolsMessageObserver;
import com.jetbrains.cef.remote.browser.RemoteFrame;
import com.jetbrains.cef.remote.callback.RemoteAuthCallback;
import com.jetbrains.cef.remote.callback.RemoteCallback;
import com.jetbrains.cef.remote.callback.RemoteCompletionCallback;
import com.jetbrains.cef.remote.callback.RemoteIntCallback;
import com.jetbrains.cef.remote.callback.RemoteMediaAccessCallback;
import com.jetbrains.cef.remote.callback.RemotePdfPrintCallback;
import com.jetbrains.cef.remote.callback.RemoteRunContextMenuCallback;
import com.jetbrains.cef.remote.callback.RemoteRunFileDialogCallback;
import com.jetbrains.cef.remote.callback.RemoteSchemeHandlerFactory;
import com.jetbrains.cef.remote.callback.RemoteStringVisitor;
import com.jetbrains.cef.remote.menu.ContextMenuParams;
import com.jetbrains.cef.remote.menu.RemoteMenuModel;
import com.jetbrains.cef.remote.network.RemoteCookieAccessFilter;
import com.jetbrains.cef.remote.network.RemoteCookieManager;
import com.jetbrains.cef.remote.network.RemoteCookieVisitor;
import com.jetbrains.cef.remote.network.RemoteRequest;
import com.jetbrains.cef.remote.network.RemoteRequestContextHandler;
import com.jetbrains.cef.remote.network.RemoteRequestImpl;
import com.jetbrains.cef.remote.network.RemoteResourceHandler;
import com.jetbrains.cef.remote.network.RemoteResourceRequestHandler;
import com.jetbrains.cef.remote.network.RemoteResponse;
import com.jetbrains.cef.remote.network.RemoteResponseImpl;
import com.jetbrains.cef.remote.network.RemoteSSLInfo;
import com.jetbrains.cef.remote.router.RemoteMessageRouterHandler;
import com.jetbrains.cef.remote.router.RemoteQueryCallback;
import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift_codegen.ClientHandlers;
import com.jetbrains.cef.remote.thrift_codegen.Cookie;
import com.jetbrains.cef.remote.thrift_codegen.KeyEvent;
import com.jetbrains.cef.remote.thrift_codegen.MenuItem;
import com.jetbrains.cef.remote.thrift_codegen.Point;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import com.jetbrains.cef.remote.thrift_codegen.Range;
import com.jetbrains.cef.remote.thrift_codegen.Rect;
import com.jetbrains.cef.remote.thrift_codegen.ResponseData;
import com.jetbrains.cef.remote.thrift_codegen.ResponseHeaders;
import com.jetbrains.cef.remote.thrift_codegen.ScreenInfo;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.cef.CefSettings;
import org.cef.browser.CefDevToolsMessageObserver;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefCookieVisitor;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefCookieAccessFilter;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefNativeRenderHandler;
import org.cef.handler.CefPermissionHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestContextHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefScreenInfo;
import org.cef.misc.BoolRef;
import org.cef.misc.CefLog;
import org.cef.misc.CefRange;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.misc.Utils;
import org.cef.network.CefCookie;
import org.cef.network.CefRequest;
import org.cef.network.CefURLRequest;
import org.cef.security.CefSSLInfo;

public class ClientHandlersImpl
implements ClientHandlers.Iface {
    private static final boolean TRACE_REMOTE_FIND_BID = Utils.getBoolean("TRACE_REMOTE_FIND_BID");
    private Runnable myOnContextInitialized;
    private final RpcContext myRpc;
    private static final Rect INVALID_RECT = new Rect(0, 0, -1, -1);
    private static final Point INVALID_POINT = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final ScreenInfo INVALID_SCREENINFO = new ScreenInfo(-1.0, -1, -1, false, new Rect(), new Rect());
    private static final RObject NULL_ROBJECT = new RObject();

    public ClientHandlersImpl(RpcContext rpcContext) {
        this.myRpc = rpcContext;
    }

    public void setOnContextInitialized(Runnable onContextInitialized) {
        this.myOnContextInitialized = onContextInitialized;
    }

    private RemoteBrowser getRemoteBrowser(int bid) {
        RemoteBrowser browser = this.myRpc.server.bid2Browser.get(bid);
        if (browser == null) {
            if (TRACE_REMOTE_FIND_BID) {
                CefLog.Debug("Can't find remote browser with bid=%d.", bid);
            }
            return null;
        }
        return browser;
    }

    @Override
    public void log(String msg) {
        CefLog.Debug("received message from CefServer: " + msg, new Object[0]);
    }

    @Override
    public String echo(String msg) {
        return msg;
    }

    @Override
    public void AppHandler_OnContextInitialized() {
        CefLog.Debug("AppHandler_OnContextInitialized: ", new Object[0]);
        if (this.myOnContextInitialized != null) {
            this.myOnContextInitialized.run();
        }
    }

    @Override
    public Rect RenderHandler_GetViewRect(int bid) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return INVALID_RECT;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return INVALID_RECT;
        }
        Rectangle rect = rh.getViewRect(browser);
        return new Rect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public ScreenInfo RenderHandler_GetScreenInfo(int bid) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return INVALID_SCREENINFO;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return INVALID_SCREENINFO;
        }
        CefScreenInfo csi = new CefScreenInfo();
        boolean success = rh.getScreenInfo(browser, csi);
        return success ? new ScreenInfo(csi.device_scale_factor, csi.depth, csi.depth_per_component, csi.is_monochrome, new Rect(csi.x, csi.y, csi.width, csi.height), new Rect(csi.available_x, csi.available_y, csi.available_width, csi.available_height)) : INVALID_SCREENINFO;
    }

    @Override
    public Point RenderHandler_GetScreenPoint(int bid, int viewX, int viewY) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return INVALID_POINT;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return INVALID_POINT;
        }
        java.awt.Point res = rh.getScreenPoint(browser, new java.awt.Point(viewX, viewY));
        return new Point(res.x, res.y);
    }

    @Override
    public void RenderHandler_OnPaint(int bid, boolean popup, int dirtyRectsCount, String sharedMemName, long sharedMemHandle, int width, int height) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return;
        }
        ((CefNativeRenderHandler)rh).onPaintWithSharedMem(browser, popup, dirtyRectsCount, sharedMemName, sharedMemHandle, width, height);
    }

    @Override
    public void RenderHandler_OnPopupShow(int bid, boolean show) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return;
        }
        rh.onPopupShow(browser, show);
    }

    @Override
    public void RenderHandler_OnPopupSize(int bid, Rect rect) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return;
        }
        rh.onPopupSize(browser, new Rectangle(rect.x, rect.y, rect.w, rect.h));
    }

    @Override
    public void RenderHandler_OnTextSelectionChanged(int bid, String selectedText, Range selectionRange) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return;
        }
        rh.OnTextSelectionChanged(browser, selectedText, new CefRange((int)selectionRange.from, (int)selectionRange.to));
    }

    @Override
    public void RenderHandler_OnImeCompositionRangeChanged(int bid, Range selectionRange, List<Rect> charactersBounds) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return;
        }
        Rectangle[] rects = (Rectangle[])charactersBounds.stream().map(rect -> new Rectangle(rect.x, rect.y, rect.w, rect.h)).toArray(Rectangle[]::new);
        rh.OnImeCompositionRangeChanged(browser, new CefRange((int)selectionRange.from, (int)selectionRange.to), rects);
    }

    @Override
    public boolean LifeSpanHandler_OnBeforePopup(int bid, RObject frame, String url, String frameName, boolean gesture) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        return browser.getOwner().getLifeSpanHandler().handleBool(lsh -> lsh.onBeforePopup(browser, rframe, url, frameName));
    }

    @Override
    public void LifeSpanHandler_OnAfterCreated(int bid, int nativeBrowserIdentifier) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        browser.getOwner().onAfterCreated(browser, nativeBrowserIdentifier);
    }

    @Override
    public void LifeSpanHandler_OnBeforeClose(int bid) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        browser.getOwner().onBeforeClosed(browser);
    }

    @Override
    public boolean LifeSpanHandler_DoClose(int bid) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser != null) {
            browser.getOwner().getLifeSpanHandler().handle(lsh -> lsh.doClose(browser));
        }
        return false;
    }

    @Override
    public void LoadHandler_OnLoadingStateChange(int bid, boolean isLoading, boolean canGoBack, boolean canGoForward) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        loadHandler.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
    }

    private static CefRequest.TransitionType getTransitionType(int transitionTypeNative) {
        int TT_SOURCE_MASK = 255;
        int TT_QUALIFIER_MASK = -256;
        CefRequest.TransitionType result = null;
        for (CefRequest.TransitionType tt : CefRequest.TransitionType.values()) {
            if ((tt.getValue() & 0xFF) != (transitionTypeNative & 0xFF)) continue;
            result = tt;
            break;
        }
        if (result != null) {
            result.addQualifiers(transitionTypeNative & 0xFFFFFF00);
        }
        return result;
    }

    @Override
    public void LoadHandler_OnLoadStart(int bid, RObject frame, int transition_type) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        loadHandler.onLoadStart(browser, rframe, ClientHandlersImpl.getTransitionType(transition_type));
    }

    @Override
    public void LoadHandler_OnLoadEnd(int bid, RObject frame, int httpStatusCode) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        loadHandler.onLoadEnd(browser, rframe, httpStatusCode);
    }

    @Override
    public void LoadHandler_OnLoadError(int bid, RObject frame, int errorCode, String errorText, String failedUrl) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        loadHandler.onLoadError(browser, rframe, CefLoadHandler.ErrorCode.findByCode(errorCode), errorText, failedUrl);
    }

    @Override
    public void DisplayHandler_OnAddressChange(int bid, RObject frame, String url) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        dh.onAddressChange(browser, rframe, url);
    }

    @Override
    public void DisplayHandler_OnTitleChange(int bid, String title) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return;
        }
        dh.onTitleChange(browser, title);
    }

    @Override
    public boolean DisplayHandler_OnTooltip(int bid, String text) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return false;
        }
        return dh.onTooltip(browser, text);
    }

    @Override
    public void DisplayHandler_OnStatusMessage(int bid, String value) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return;
        }
        dh.onStatusMessage(browser, value);
    }

    @Override
    public boolean DisplayHandler_OnConsoleMessage(int bid, String level, String message, String source, int line) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return false;
        }
        CefSettings.LogSeverity logSeverity = CefSettings.LogSeverity.LOGSEVERITY_DEFAULT;
        if ("verbose".equals(level)) {
            logSeverity = CefSettings.LogSeverity.LOGSEVERITY_VERBOSE;
        } else if ("info".equals(level)) {
            logSeverity = CefSettings.LogSeverity.LOGSEVERITY_INFO;
        } else if ("warning".equals(level)) {
            logSeverity = CefSettings.LogSeverity.LOGSEVERITY_WARNING;
        } else if ("error".equals(level)) {
            logSeverity = CefSettings.LogSeverity.LOGSEVERITY_ERROR;
        } else if ("fatal".equals(level)) {
            logSeverity = CefSettings.LogSeverity.LOGSEVERITY_FATAL;
        } else if ("disable".equals(level)) {
            logSeverity = CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
        }
        return dh.onConsoleMessage(browser, logSeverity, message, source, line);
    }

    @Override
    public boolean KeyboardHandler_OnPreKeyEvent(int bid, KeyEvent event) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefKeyboardHandler kh = browser.getOwner().getKeyboardHandler();
        if (kh == null) {
            return false;
        }
        return kh.onPreKeyEvent(browser, ClientHandlersImpl.thrift2jcef(event), new BoolRef());
    }

    private static CefKeyboardHandler.CefKeyEvent thrift2jcef(KeyEvent event) {
        CefKeyboardHandler.CefKeyEvent.EventType type;
        if (event == null) {
            return null;
        }
        if (event.type == null || event.type.isEmpty()) {
            CefLog.Error("Empty key event type: ", new Object[0]);
            return null;
        }
        try {
            type = CefKeyboardHandler.CefKeyEvent.EventType.valueOf(event.type);
        }
        catch (Throwable e) {
            CefLog.Error("Unknown key event type: event.type=%s, exception: %s", event.type, e.getMessage());
            return null;
        }
        return new CefKeyboardHandler.CefKeyEvent(type, event.modifiers, event.windows_key_code, event.native_key_code, event.is_system_key, (char)event.character, (char)event.unmodified_character, event.focus_on_editable_field);
    }

    @Override
    public boolean KeyboardHandler_OnKeyEvent(int bid, KeyEvent event) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefKeyboardHandler kh = browser.getOwner().getKeyboardHandler();
        if (kh == null) {
            return false;
        }
        return kh.onKeyEvent(browser, ClientHandlersImpl.thrift2jcef(event));
    }

    @Override
    public void FocusHandler_OnTakeFocus(int bid, boolean next) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefFocusHandler fh = browser.getOwner().getFocusHandler();
        if (fh == null) {
            return;
        }
        fh.onTakeFocus(browser, next);
    }

    @Override
    public boolean FocusHandler_OnSetFocus(int bid, String source) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefFocusHandler fh = browser.getOwner().getFocusHandler();
        if (fh == null) {
            return false;
        }
        CefFocusHandler.FocusSource src = CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION;
        if (source != null && !source.isEmpty()) {
            try {
                src = CefFocusHandler.FocusSource.valueOf(source);
            }
            catch (Throwable e) {
                CefLog.Error("FocusHandler_OnSetFocus: source=%s, exception: %s", source, e.getMessage());
            }
        }
        return fh.onSetFocus(browser, src);
    }

    @Override
    public void FocusHandler_OnGotFocus(int bid) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefFocusHandler fh = browser.getOwner().getFocusHandler();
        if (fh == null) {
            return;
        }
        fh.onGotFocus(browser);
    }

    @Override
    public boolean RequestHandler_OnBeforeBrowse(int bid, RObject frame, RObject request, boolean user_gesture, boolean is_redirect) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        return rh.onBeforeBrowse(browser, rframe, new RemoteRequest(rr), user_gesture, is_redirect);
    }

    @Override
    public RObject RequestHandler_GetResourceRequestHandler(int bid, RObject frame, RObject request, boolean isNavigation, boolean isDownload, String requestInitiator) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return NULL_ROBJECT;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return NULL_ROBJECT;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        BoolRef disableDefaultHandling = new BoolRef(false);
        CefResourceRequestHandler handler = rh.getResourceRequestHandler(browser, rframe, new RemoteRequest(rr), isNavigation, isDownload, requestInitiator, disableDefaultHandling);
        if (handler == null) {
            return NULL_ROBJECT;
        }
        RemoteResourceRequestHandler resultHandler = RemoteResourceRequestHandler.create(handler);
        return resultHandler.thriftId(disableDefaultHandling.get() ? 1 : 0);
    }

    @Override
    public RObject ResourceRequestHandler_GetCookieAccessFilter(int rrHandler, int bid, RObject frame, RObject request) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return NULL_ROBJECT;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        CefCookieAccessFilter filter = null;
        try {
            ((CefResourceRequestHandler)rrrh.getDelegate()).getCookieAccessFilter(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr));
        }
        catch (Throwable e) {
            CefLog.Error("getCookieAccessFilter: exception=%s", e.getMessage());
        }
        if (filter == null) {
            return NULL_ROBJECT;
        }
        RemoteCookieAccessFilter resultHandler = RemoteCookieAccessFilter.create(filter);
        return resultHandler.thriftId();
    }

    @Override
    public void ResourceRequestHandler_Dispose(int rrHandler) {
        RemoteResourceRequestHandler.FACTORY.dispose(rrHandler);
    }

    @Override
    public void CookieAccessFilter_Dispose(int filter) {
        RemoteCookieAccessFilter.FACTORY.dispose(filter);
    }

    private static CefCookie cookieFromList(List<String> cookie) {
        try {
            return new CefCookie(cookie.get(0), cookie.get(1), cookie.get(2), cookie.get(3), Boolean.parseBoolean(cookie.get(4)), Boolean.parseBoolean(cookie.get(5)), new Date(Long.parseLong(cookie.get(6))), new Date(Long.parseLong(cookie.get(7))), Boolean.parseBoolean(cookie.get(8)), new Date(Long.parseLong(cookie.get(9))));
        }
        catch (NumberFormatException e) {
            CefLog.Error("Can't parse cookie: err %s, list: '%s'", e.getMessage(), Arrays.toString(cookie.toArray()));
            return null;
        }
    }

    @Override
    public boolean CookieAccessFilter_CanSendCookie(int filter, int bid, RObject frame, RObject request, List<String> cookie) {
        RemoteCookieAccessFilter f = RemoteCookieAccessFilter.FACTORY.get(filter);
        if (f == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        boolean result = true;
        try {
            result = ((CefCookieAccessFilter)f.getDelegate()).canSendCookie(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr), ClientHandlersImpl.cookieFromList(cookie));
        }
        catch (Throwable e) {
            CefLog.Error("canSendCookie: exception=%s", e.getMessage());
        }
        return result;
    }

    @Override
    public boolean CookieAccessFilter_CanSaveCookie(int filter, int bid, RObject frame, RObject request, RObject response, List<String> cookie) {
        RemoteCookieAccessFilter f = RemoteCookieAccessFilter.FACTORY.get(filter);
        if (f == null) {
            return false;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myRpc, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myRpc, response);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        boolean result = true;
        try {
            result = ((CefCookieAccessFilter)f.getDelegate()).canSaveCookie(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp), ClientHandlersImpl.cookieFromList(cookie));
        }
        catch (Throwable e) {
            CefLog.Error("canSaveCookie: exception=%s", e.getMessage());
        }
        return result;
    }

    @Override
    public boolean RequestHandler_OnOpenURLFromTab(int bid, RObject frame, String target_url, boolean user_gesture) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        return rh.onOpenURLFromTab(browser, rframe, target_url, user_gesture);
    }

    @Override
    public boolean RequestHandler_GetAuthCredentials(int bid, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, RObject authCallback) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteAuthCallback callback = new RemoteAuthCallback(this.myRpc, authCallback);
        return rh.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback);
    }

    @Override
    public boolean RequestHandler_OnCertificateError(int bid, String cert_error, String request_url, ByteBuffer sslInfo, RObject callback) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteCallback cb = new RemoteCallback(this.myRpc, callback);
        CefSSLInfo ssl = RemoteSSLInfo.fromBinary(sslInfo);
        CefLoadHandler.ErrorCode err = CefLoadHandler.ErrorCode.ERR_NONE;
        if (cert_error != null && !cert_error.isEmpty()) {
            try {
                err = CefLoadHandler.ErrorCode.valueOf(cert_error);
            }
            catch (Throwable e) {
                CefLog.Error("OnCertificateError: cert_error=%s, exception: %s", cert_error, e.getMessage());
            }
        }
        return rh.onCertificateError(browser, err, request_url, ssl, cb);
    }

    @Override
    public void RequestHandler_OnRenderProcessTerminated(int bid, String status, int errCode, String errText) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return;
        }
        CefRequestHandler.TerminationStatus s = CefRequestHandler.TerminationStatus.TS_ABNORMAL_TERMINATION;
        if (status != null && !status.isEmpty()) {
            try {
                s = CefRequestHandler.TerminationStatus.valueOf(status);
            }
            catch (Throwable e) {
                CefLog.Error("onRenderProcessTerminated: status=%s, exception: %s", status, e.getMessage());
            }
        }
        rh.onRenderProcessTerminated(browser, s, errCode, errText);
    }

    @Override
    public boolean ResourceRequestHandler_OnBeforeResourceLoad(int rrHandler, int bid, RObject frame, RObject request) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        boolean result = false;
        try {
            result = ((CefResourceRequestHandler)rrrh.getDelegate()).onBeforeResourceLoad(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr));
            rr.flush();
        }
        catch (Throwable e) {
            CefLog.Error("onBeforeResourceLoad: exception=%s", e.getMessage());
        }
        return result;
    }

    @Override
    public RObject ResourceRequestHandler_GetResourceHandler(int rrHandler, int bid, RObject frame, RObject request) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return NULL_ROBJECT;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        CefResourceHandler handler = null;
        try {
            handler = ((CefResourceRequestHandler)rrrh.getDelegate()).getResourceHandler(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr));
        }
        catch (Throwable e) {
            CefLog.Error("getResourceHandler: exception=%s", e.getMessage());
        }
        if (handler == null) {
            return NULL_ROBJECT;
        }
        RemoteResourceHandler result = RemoteResourceHandler.create(handler);
        return result.thriftId();
    }

    @Override
    public boolean ResourceHandler_ProcessRequest(int resourceHandler, RObject request, RObject callback) throws TException {
        RemoteResourceHandler rrh = RemoteResourceHandler.FACTORY.find(resourceHandler);
        if (rrh == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        RemoteCallback cb = new RemoteCallback(this.myRpc, callback);
        boolean result = false;
        try {
            result = ((CefResourceHandler)rrh.getDelegate()).processRequest(new RemoteRequest(rr), cb);
        }
        catch (Throwable e) {
            CefLog.Error("processRequest: exception=%s", e.getMessage());
        }
        return result;
    }

    @Override
    public ResponseHeaders ResourceHandler_GetResponseHeaders(int resourceHandler, RObject response) throws TException {
        RemoteResourceHandler rrh = RemoteResourceHandler.FACTORY.find(resourceHandler);
        if (rrh == null) {
            return null;
        }
        RemoteResponseImpl rr = new RemoteResponseImpl(this.myRpc, response);
        IntRef respLen = new IntRef();
        StringRef redirectUrlRef = new StringRef();
        ResponseHeaders result = null;
        try {
            ((CefResourceHandler)rrh.getDelegate()).getResponseHeaders(new RemoteResponse(rr), respLen, redirectUrlRef);
            rr.flush();
            result = new ResponseHeaders();
            result.setLength(respLen.get());
            if (redirectUrlRef.get() != null) {
                result.setRedirectUrl(redirectUrlRef.get());
            }
        }
        catch (Throwable e) {
            CefLog.Error("getResponseHeaders: exception=%s", e.getMessage());
        }
        return result;
    }

    @Override
    public ResponseData ResourceHandler_ReadResponse(int resourceHandler, int bytes_to_read, RObject callback) throws TException {
        RemoteResourceHandler rrh;
        if (bytes_to_read <= 0) {
            return new ResponseData();
        }
        if (bytes_to_read > 262144) {
            CefLog.Error("ResourceHandler_ReadResponse: too much bytes to read %d. Need to implement via shared memory.", bytes_to_read);
        }
        if ((rrh = RemoteResourceHandler.FACTORY.find(resourceHandler)) == null) {
            return null;
        }
        RemoteCallback cb = new RemoteCallback(this.myRpc, callback);
        byte[] buf = new byte[bytes_to_read];
        IntRef bytesRead = new IntRef();
        boolean continueRead = false;
        try {
            continueRead = ((CefResourceHandler)rrh.getDelegate()).readResponse(buf, bytes_to_read, bytesRead, cb);
        }
        catch (Throwable e) {
            CefLog.Error("readResponse: exception=%s", e.getMessage());
        }
        int read = bytesRead.get();
        ResponseData result = new ResponseData();
        result.setContinueRead(continueRead);
        result.setBytes_read(read);
        result.setData(ByteBuffer.wrap(buf, 0, read));
        return result;
    }

    @Override
    public void ResourceHandler_Cancel(int resourceHandler) throws TException {
        RemoteResourceHandler rrh = RemoteResourceHandler.FACTORY.find(resourceHandler);
        if (rrh == null) {
            return;
        }
        try {
            ((CefResourceHandler)rrh.getDelegate()).cancel();
        }
        catch (Throwable e) {
            CefLog.Error("ResourceHandler_Cancel: exception=%s", e.getMessage());
        }
    }

    @Override
    public String ResourceRequestHandler_OnResourceRedirect(int rrHandler, int bid, RObject frame, RObject request, RObject response, String new_url) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return "";
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myRpc, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myRpc, response);
        StringRef sref = new StringRef(new_url);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        try {
            ((CefResourceRequestHandler)rrrh.getDelegate()).onResourceRedirect(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp), sref);
        }
        catch (Throwable e) {
            CefLog.Error("onResourceRedirect: exception=%s", e.getMessage());
        }
        return sref.get();
    }

    @Override
    public boolean ResourceRequestHandler_OnResourceResponse(int rrHandler, int bid, RObject frame, RObject request, RObject response) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return false;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myRpc, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myRpc, response);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        boolean result = false;
        try {
            result = ((CefResourceRequestHandler)rrrh.getDelegate()).onResourceResponse(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp));
            rreq.flush();
        }
        catch (Throwable e) {
            CefLog.Error("onResourceResponse: exception=%s", e.getMessage());
        }
        return result;
    }

    @Override
    public void ResourceRequestHandler_OnResourceLoadComplete(int rrHandler, int bid, RObject frame, RObject request, RObject response, String status, long receivedContentLength) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myRpc, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myRpc, response);
        CefURLRequest.Status s = CefURLRequest.Status.UR_UNKNOWN;
        if (status != null && !status.isEmpty()) {
            try {
                s = CefURLRequest.Status.valueOf(status);
            }
            catch (Throwable e) {
                CefLog.Error("OnResourceLoadComplete: status=%s, exception: %s", status, e.getMessage());
            }
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        try {
            ((CefResourceRequestHandler)rrrh.getDelegate()).onResourceLoadComplete(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp), s, receivedContentLength);
        }
        catch (Throwable e) {
            CefLog.Error("onResourceLoadComplete: exception=%s", e.getMessage());
        }
    }

    @Override
    public boolean ResourceRequestHandler_OnProtocolExecution(int rrHandler, int bid, RObject frame, RObject request, boolean allowOsExecution) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return false;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        BoolRef br = new BoolRef(allowOsExecution);
        try {
            ((CefResourceRequestHandler)rrrh.getDelegate()).onProtocolExecution(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), br);
        }
        catch (Throwable e) {
            CefLog.Error("onProtocolExecution: exception=%s", e.getMessage());
        }
        return br.get();
    }

    @Override
    public List<MenuItem> ContextMenuHandler_OnBeforeContextMenu(int bid, RObject frame, com.jetbrains.cef.remote.thrift_codegen.ContextMenuParams params, List<MenuItem> menu_model) throws TException {
        RemoteBrowser cefBrowser = this.getRemoteBrowser(bid);
        if (cefBrowser == null) {
            CefLog.Error("CefContextMenuHandler::OnBeforeContextMenu: There is no browser with bid=%d", bid);
            return menu_model;
        }
        RemoteFrame cefFrame = new RemoteFrame(this.myRpc, frame);
        RemoteMenuModel cefMenuModel = new RemoteMenuModel(menu_model);
        ContextMenuParams cefParams = new ContextMenuParams(params);
        CefContextMenuHandler handler = cefBrowser.getOwner().getContextMenuHandler();
        if (handler == null) {
            CefLog.Error("CefContextMenuHandler::OnBeforeContextMenu: There is no CefContextMenuHandler for the browser with bid=%d", bid);
            return menu_model;
        }
        handler.onBeforeContextMenu(cefBrowser, cefFrame, cefParams, cefMenuModel);
        return cefMenuModel.getThriftModel();
    }

    @Override
    public boolean ContextMenuHandler_RunContextMenu(int bid, RObject frame, com.jetbrains.cef.remote.thrift_codegen.ContextMenuParams params, List<MenuItem> model, RObject callback) throws TException {
        RemoteBrowser cefBrowser = this.getRemoteBrowser(bid);
        if (cefBrowser == null) {
            CefLog.Error("CefContextMenuHandler::RunContextMenu: There is no browser with bid=%d", bid);
            return false;
        }
        RemoteFrame cefFrame = new RemoteFrame(this.myRpc, frame);
        ContextMenuParams cefParams = new ContextMenuParams(params);
        RemoteMenuModel cefMenuModel = new RemoteMenuModel(model);
        RemoteRunContextMenuCallback cefCallback = new RemoteRunContextMenuCallback(this.myRpc, callback);
        CefContextMenuHandler handler = cefBrowser.getOwner().getContextMenuHandler();
        if (handler == null) {
            CefLog.Error("CefContextMenuHandler::OnBeforeContextMenu: There is no CefContextMenuHandler for the browser with bid=%d", bid);
            return false;
        }
        return handler.runContextMenu(cefBrowser, cefFrame, cefParams, cefMenuModel, cefCallback);
    }

    @Override
    public boolean ContextMenuHandler_OnContextMenuCommand(int bid, RObject frame, com.jetbrains.cef.remote.thrift_codegen.ContextMenuParams params, int command_id, int event_flags) throws TException {
        RemoteBrowser cefBrowser = this.getRemoteBrowser(bid);
        if (cefBrowser == null) {
            CefLog.Error("CefContextMenuHandler::RunContextMenu: There is no browser with bid=%d", bid);
            return false;
        }
        RemoteFrame cefFrame = new RemoteFrame(this.myRpc, frame);
        ContextMenuParams cefParams = new ContextMenuParams(params);
        CefContextMenuHandler handler = cefBrowser.getOwner().getContextMenuHandler();
        if (handler == null) {
            CefLog.Error("CefContextMenuHandler::OnBeforeContextMenu: There is no CefContextMenuHandler for the browser with bid=%d", bid);
            return false;
        }
        return handler.onContextMenuCommand(cefBrowser, cefFrame, cefParams, command_id, event_flags);
    }

    @Override
    public void ContextMenuHandler_OnContextMenuDismissed(int bid, RObject frame) throws TException {
        RemoteBrowser cefBrowser = this.getRemoteBrowser(bid);
        if (cefBrowser == null) {
            CefLog.Error("CefContextMenuHandler::RunContextMenu: There is no browser with bid=%d", bid);
            return;
        }
        RemoteFrame cefFrame = new RemoteFrame(this.myRpc, frame);
        CefContextMenuHandler handler = cefBrowser.getOwner().getContextMenuHandler();
        if (handler == null) {
            CefLog.Error("CefContextMenuHandler::OnBeforeContextMenu: There is no CefContextMenuHandler for the browser with bid=%d", bid);
            return;
        }
        handler.onContextMenuDismissed(cefBrowser, cefFrame);
    }

    @Override
    public void ResourceHandler_Dispose(int resHandler) throws TException {
        RemoteResourceHandler.FACTORY.dispose(resHandler);
    }

    @Override
    public boolean MessageRouterHandler_onQuery(RObject handler, int bid, RObject frame, long queryId, String request, boolean persistent, RObject queryCallback) throws TException {
        RemoteMessageRouterHandler rmrh = RemoteMessageRouterHandler.FACTORY.get(handler.objId);
        if (rmrh == null) {
            return false;
        }
        RemoteQueryCallback rcb = new RemoteQueryCallback(this.myRpc, queryCallback);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        boolean result = false;
        try {
            result = ((CefMessageRouterHandler)rmrh.getDelegate()).onQuery(this.getRemoteBrowser(bid), rframe, queryId, request, persistent, rcb);
        }
        catch (Throwable e) {
            CefLog.Error("onQuery: exception=%s", e.getMessage());
        }
        return result;
    }

    @Override
    public void MessageRouterHandler_onQueryCanceled(RObject handler, int bid, RObject frame, long queryId) throws TException {
        RemoteMessageRouterHandler rmrh = RemoteMessageRouterHandler.FACTORY.get(handler.objId);
        if (rmrh == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        try {
            ((CefMessageRouterHandler)rmrh.getDelegate()).onQueryCanceled(this.getRemoteBrowser(bid), rframe, queryId);
        }
        catch (Throwable e) {
            CefLog.Error("onQueryCanceled: exception=%s", e.getMessage());
        }
    }

    @Override
    public void MessageRouterHandler_Dispose(int handler) throws TException {
        RemoteMessageRouterHandler.FACTORY.dispose(handler);
    }

    @Override
    public RObject SchemeHandlerFactory_CreateHandler(int schemeHandlerFactory, int bid, RObject frame, String scheme_name, RObject request) throws TException {
        RemoteSchemeHandlerFactory sf = RemoteSchemeHandlerFactory.FACTORY.get(schemeHandlerFactory);
        if (sf == null) {
            return NULL_ROBJECT;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        CefResourceHandler handler = null;
        try {
            handler = ((CefSchemeHandlerFactory)sf.getDelegate()).create(this.getRemoteBrowser(bid), rframe, scheme_name, new RemoteRequest(rreq));
        }
        catch (Throwable e) {
            CefLog.Error("SchemeHandlerFactory_CreateHandler: exception=%s", e.getMessage());
        }
        if (handler == null) {
            return NULL_ROBJECT;
        }
        RemoteResourceHandler result = RemoteResourceHandler.create(handler);
        return result.thriftId();
    }

    @Override
    public void SchemeHandlerFactory_Dispose(int schemeHandlerFactory) throws TException {
        RemoteSchemeHandlerFactory.FACTORY.dispose(schemeHandlerFactory);
    }

    @Override
    public void CompletionCallback_OnComplete(int completionCallback) throws TException {
        RemoteCompletionCallback cc = RemoteCompletionCallback.FACTORY.get(completionCallback);
        if (cc == null) {
            return;
        }
        try {
            ((CefCompletionCallback)cc.getDelegate()).onComplete();
        }
        catch (Throwable e) {
            CefLog.Error("CompletionCallback_OnComplete: exception=%s", e.getMessage());
        }
        RemoteCompletionCallback.FACTORY.dispose(completionCallback);
    }

    @Override
    public RObject RequestContextHandler_GetResourceRequestHandler(int handlerId, int bid, RObject frame, RObject request, boolean isNavigation, boolean isDownload, String requestInitiator) throws TException {
        RemoteRequestContextHandler rhandler = RemoteRequestContextHandler.FACTORY.get(handlerId);
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null || rhandler == null) {
            return NULL_ROBJECT;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myRpc, request);
        RemoteFrame rframe = new RemoteFrame(this.myRpc, frame);
        BoolRef disableDefaultHandling = new BoolRef(false);
        CefResourceRequestHandler handler = null;
        try {
            handler = ((CefRequestContextHandler)rhandler.getDelegate()).getResourceRequestHandler(browser, rframe, new RemoteRequest(rr), isNavigation, isDownload, requestInitiator, disableDefaultHandling);
        }
        catch (Throwable e) {
            CefLog.Error("getResourceRequestHandler: exception=%s", e.getMessage());
        }
        if (handler == null) {
            return NULL_ROBJECT;
        }
        RemoteResourceRequestHandler resultHandler = RemoteResourceRequestHandler.create(handler);
        return resultHandler.thriftId(disableDefaultHandling.get() ? 1 : 0);
    }

    @Override
    public boolean CookieVisitor_Visit(int visitor, Cookie cookie, int count, int total) throws TException {
        RemoteCookieVisitor rvisitor = RemoteCookieVisitor.FACTORY.get(visitor);
        if (rvisitor == null) {
            return false;
        }
        BoolRef delete = new BoolRef(false);
        boolean continueTraverse = true;
        try {
            continueTraverse = ((CefCookieVisitor)rvisitor.getDelegate()).visit(RemoteCookieManager.toCefCookie(cookie), count, total, delete);
        }
        catch (Throwable e) {
            CefLog.Error("CookieVisitor_Visit: exception=%s", e.getMessage());
        }
        if (delete.get()) {
            CefLog.Error("Can't delete cookie %s via CefCookieVisitor, please use CefCookieManager.deleteCookie. TODO: implement.", cookie);
        }
        if (count == total || !continueTraverse) {
            CefLog.Debug("Last cookie (%d) visited, dispose RemoteCookieVisitor %d.", total, visitor);
            RemoteCookieVisitor.FACTORY.dispose(visitor);
        }
        return continueTraverse;
    }

    @Override
    public void CookieVisitor_Dispose(int visitor) throws TException {
        CefLog.Debug("Dispose RemoteCookieVisitor %d (by server request).", visitor);
        RemoteCookieVisitor.FACTORY.dispose(visitor);
    }

    @Override
    public void StringVisitor_Visit(int visitor, String str) throws TException {
        RemoteStringVisitor rvisitor = RemoteStringVisitor.FACTORY.get(visitor);
        if (rvisitor == null) {
            return;
        }
        try {
            ((CefStringVisitor)rvisitor.getDelegate()).visit(str);
        }
        catch (Throwable e) {
            CefLog.Error("StringVisitor_Visit: exception=%s", e.getMessage());
        }
    }

    @Override
    public void StringVisitor_Dispose(int visitor) throws TException {
        CefLog.Debug("Dispose RemoteStringVisitor %d (by server request).", visitor);
        RemoteStringVisitor.FACTORY.dispose(visitor);
    }

    @Override
    public void DevToolsMessageObserver_OnDevToolsEvent(int observer, int bid, String method, String parameters) throws TException {
        RemoteDevToolsMessageObserver ro = RemoteDevToolsMessageObserver.FACTORY.get(observer);
        if (ro == null) {
            return;
        }
        try {
            ((CefDevToolsMessageObserver)ro.getDelegate()).onDevToolsEvent(this.getRemoteBrowser(bid), method, parameters);
        }
        catch (Throwable e) {
            CefLog.Error("onDevToolsEvent: exception=%s", e.getMessage());
        }
    }

    @Override
    public boolean PermissionHandler_OnRequestMediaAccessPermission(int bid, RObject frame, String requesting_origin, int requested_permissions, RObject mediaAccessCallback) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefPermissionHandler permissionHandler = browser.getOwner().getPermissionHandler();
        if (permissionHandler == null) {
            return false;
        }
        RemoteFrame remoteFrame = frame.isNull ? null : new RemoteFrame(this.myRpc, frame);
        return permissionHandler.onRequestMediaAccessPermission(browser, remoteFrame, requesting_origin, requested_permissions, new RemoteMediaAccessCallback(this.myRpc, mediaAccessCallback));
    }

    @Override
    public void DevToolsMessageObserver_OnDevToolsMethodResult(int observer, int bid, int messageId, boolean success, String result) throws TException {
        RemoteDevToolsMessageObserver ro = RemoteDevToolsMessageObserver.FACTORY.get(observer);
        if (ro == null) {
            return;
        }
        try {
            ((CefDevToolsMessageObserver)ro.getDelegate()).onDevToolsMethodResult(this.getRemoteBrowser(bid), messageId, success, result);
        }
        catch (Throwable e) {
            CefLog.Error("onDevToolsMethodResult: exception=%s", e.getMessage());
        }
    }

    @Override
    public void DevToolsMessageObserver_Dispose(int observer) throws TException {
        RemoteDevToolsMessageObserver.FACTORY.dispose(observer);
    }

    @Override
    public void IntCallback_OnComplete(int intCallback, int result) throws TException {
        RemoteIntCallback rcb = RemoteIntCallback.FACTORY.get(intCallback);
        if (rcb == null) {
            return;
        }
        rcb.onComplete(result);
        RemoteIntCallback.FACTORY.dispose(intCallback);
    }

    @Override
    public void RunFileDialogCallback_OnFileDialogDismissed(int runFileDialogCallback, List<String> filePaths) throws TException {
        RemoteRunFileDialogCallback rcb = RemoteRunFileDialogCallback.FACTORY.get(runFileDialogCallback);
        if (rcb == null) {
            return;
        }
        try {
            ((CefRunFileDialogCallback)rcb.getDelegate()).onFileDialogDismissed(new Vector<String>(filePaths));
        }
        catch (Throwable e) {
            CefLog.Error("onFileDialogDismissed: exception=%s", e.getMessage());
        }
        RemoteRunFileDialogCallback.FACTORY.dispose(runFileDialogCallback);
    }

    @Override
    public void PdfPrintCallback_OnPdfPrintFinished(int pdfPrintCallback, String path, boolean ok) throws TException {
        RemotePdfPrintCallback rcb = RemotePdfPrintCallback.FACTORY.get(pdfPrintCallback);
        if (rcb == null) {
            return;
        }
        try {
            ((CefPdfPrintCallback)rcb.getDelegate()).onPdfPrintFinished(path, ok);
        }
        catch (Throwable e) {
            CefLog.Error("onPdfPrintFinished: exception=%s", e.getMessage());
        }
        RemotePdfPrintCallback.FACTORY.dispose(pdfPrintCallback);
    }
}

