/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangesViewDiffAction;
import com.intellij.openapi.vcs.changes.ChangesViewNodeAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelDataExKt;
import com.intellij.platform.ide.navigation.NavigationOptions;
import com.intellij.platform.ide.navigation.NavigationService;
import com.intellij.platform.vcs.impl.shared.commit.CommitToolWindowViewModel;
import com.intellij.ui.ClickListener;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewInputHandler;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;)V", "diffRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vcs/changes/ChangesViewDiffAction;", "Lcom/intellij/codeWithMe/ClientId;", "getDiffRequests", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "installListeners", "", "handleEnterOrDoubleClick", "", "requestFocus", "performHoverAction", "SingleClickDiffPreviewHandler", "intellij.platform.vcs.impl.shared"})
@SourceDebugExtension(value={"SMAP\nCommitChangesViewWithToolbarPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitChangesViewWithToolbarPanel.kt\ncom/intellij/openapi/vcs/changes/ChangesViewInputHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,286:1\n30#2,2:287\n*S KotlinDebug\n*F\n+ 1 CommitChangesViewWithToolbarPanel.kt\ncom/intellij/openapi/vcs/changes/ChangesViewInputHandler\n*L\n240#1:287,2\n*E\n"})
final class ChangesViewInputHandler {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ChangesListView changesView;
    @NotNull
    private final MutableSharedFlow<Pair<ChangesViewDiffAction, ClientId>> diffRequests;

    public ChangesViewInputHandler(@NotNull CoroutineScope cs, @NotNull ChangesListView changesView) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)((Object)changesView), (String)"changesView");
        this.cs = cs;
        this.changesView = changesView;
        this.diffRequests = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
    }

    @NotNull
    public final MutableSharedFlow<Pair<ChangesViewDiffAction, ClientId>> getDiffRequests() {
        return this.diffRequests;
    }

    @RequiresEdt
    public final void installListeners() {
        this.changesView.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)arg_0 -> ChangesViewInputHandler.installListeners$lambda$0(this, arg_0)));
        this.changesView.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)arg_0 -> ChangesViewInputHandler.installListeners$lambda$1(this, arg_0)));
        new SingleClickDiffPreviewHandler(this.changesView, (Function0<Unit>)((Function0)() -> ChangesViewInputHandler.installListeners$lambda$2(this))).install();
    }

    private final boolean handleEnterOrDoubleClick(boolean requestFocus) {
        if (!this.performHoverAction()) {
            Project project = this.changesView.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CommitToolWindowViewModel> serviceClass$iv = CommitToolWindowViewModel.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            boolean diffPreviewOnDoubleClickOrEnter = ((CommitToolWindowViewModel)object).getDiffPreviewOnDoubleClickOrEnter();
            if (diffPreviewOnDoubleClickOrEnter && VcsTreeModelDataExKt.getSelectedDiffableNode(this.changesView) != null) {
                v2 = this.diffRequests.tryEmit((Object)TuplesKt.to((Object)((Object)ChangesViewDiffAction.PERFORM_DIFF), (Object)ClientId.Companion.getCurrent()));
            } else {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this.changesView));
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                DataContext dataContext2 = dataContext;
                v2 = BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(requestFocus, this, dataContext2, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ boolean $requestFocus;
                    final /* synthetic */ ChangesViewInputHandler this$0;
                    final /* synthetic */ DataContext $dataContext;
                    {
                        this.$requestFocus = $requestFocus;
                        this.this$0 = $receiver;
                        this.$dataContext = $dataContext;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                NavigationOptions parameters = NavigationOptions.Companion.defaultOptions().requestFocus(this.$requestFocus);
                                Project project = ChangesViewInputHandler.access$getChangesView$p(this.this$0).getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)parameters);
                                this.label = 1;
                                Object object2 = NavigationService.Companion.getInstance(project).navigate(this.$dataContext, parameters, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                NavigationOptions parameters = (NavigationOptions)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        return true;
    }

    private final boolean performHoverAction() {
        ChangesBrowserNode selected = (ChangesBrowserNode)VcsTreeModelData.selected((JTree)((Object)this.changesView)).iterateNodes().single();
        if (selected == null) {
            return false;
        }
        Project project = this.changesView.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        for (ChangesViewNodeAction extension : ChangesViewNodeAction.EP_NAME.getExtensions((AreaInstance)project)) {
            if (!extension.handleDoubleClick(selected)) continue;
            return true;
        }
        return false;
    }

    private static final boolean installListeners$lambda$0(ChangesViewInputHandler this$0, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this$0.changesView)), (MouseEvent)e)) {
            return false;
        }
        return this$0.handleEnterOrDoubleClick(true);
    }

    private static final boolean installListeners$lambda$1(ChangesViewInputHandler this$0, KeyEvent it) {
        return this$0.handleEnterOrDoubleClick(false);
    }

    private static final Unit installListeners$lambda$2(ChangesViewInputHandler this$0) {
        this$0.diffRequests.tryEmit((Object)TuplesKt.to((Object)((Object)ChangesViewDiffAction.SINGLE_CLICK_DIFF_PREVIEW), (Object)ClientId.Companion.getCurrent()));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ChangesListView access$getChangesView$p(ChangesViewInputHandler $this) {
        return $this.changesView;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\t\u001a\u00020\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewInputHandler$SingleClickDiffPreviewHandler;", "Lcom/intellij/ui/ClickListener;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "previewDiff", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;Lkotlin/jvm/functions/Function0;)V", "install", "onClick", "", "event", "Ljava/awt/event/MouseEvent;", "clickCount", "", "intellij.platform.vcs.impl.shared"})
    private static final class SingleClickDiffPreviewHandler
    extends ClickListener {
        @NotNull
        private final ChangesListView changesView;
        @NotNull
        private final Function0<Unit> previewDiff;

        public SingleClickDiffPreviewHandler(@NotNull ChangesListView changesView, @NotNull Function0<Unit> previewDiff) {
            Intrinsics.checkNotNullParameter((Object)((Object)changesView), (String)"changesView");
            Intrinsics.checkNotNullParameter(previewDiff, (String)"previewDiff");
            this.changesView = changesView;
            this.previewDiff = previewDiff;
        }

        public final void install() {
            this.installOn((Component)((Object)this.changesView));
        }

        public boolean onClick(@NotNull MouseEvent event, int clickCount) {
            boolean showDiff;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean bl = showDiff = clickCount == 1 && event.getButton() == 1 && Registry.Companion.get("show.diff.preview.as.editor.tab.with.single.click").asBoolean() && VcsConfiguration.getInstance((Project)this.changesView.getProject()).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN && !EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.changesView)), (MouseEvent)event);
            if (showDiff) {
                this.previewDiff.invoke();
            }
            return showDiff;
        }
    }
}

