/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.SshApiBundle;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshConnectionConfigPatchConverter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import com.jetbrains.gateway.ssh.deploy.e;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Tag(value="sshConfig")
public class SshConfig
implements Cloneable {
    public static final int DEFAULT_PORT = 22;
    @NonNls
    public static final String DEFAULT_KEY_PATH;
    private static final int DEFAULT_INVALID_PORT = -1;
    @NotNull
    private String myId;
    private boolean isProjectLevel;
    @NotNull
    private String myHost;
    @NotNull
    private String myLiteralPort;
    private int myPort;
    @Deprecated
    @NotNull
    private String myLiteralLocalPort;
    @Deprecated
    private int myLocalPort;
    @NotNull
    private String myUsername;
    @NotNull
    private AuthType myAuthType;
    @NotNull
    private String myKeyPath;
    @NotNull
    private NameFormat myNameFormat;
    @Nullable
    @NlsSafe
    private String myCustomName;
    @Nullable
    private SshConnectionConfigPatch myConnectionConfigPatch;
    @Attribute(value="useOpenSSHConfig")
    @NotNull
    private String mySerializedUseOpenSSHConfig;
    private static int[] a;
    private static final long b;
    private static final String[] c;
    private static final String[] d;
    private static final Map e;

    @Attribute(value="id")
    @NotNull
    @NonNls
    public String getId() {
        String string;
        long l = b ^ 0xFCDC14A46EEL;
        try {
            string = this.myId;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setId(@NotNull String id) {
        long l = b ^ 0x7BDC02687324L;
        try {
            if (id == null) {
                SshConfig.$$$reportNull$$$0(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        this.myId = id;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.isProjectLevel;
    }

    public void setProjectLevel(boolean projectLevel) {
        this.isProjectLevel = projectLevel;
    }

    @Attribute(value="host")
    @NotNull
    @NlsSafe
    public String getHost() {
        String string;
        long l = b ^ 0x5957ABD7FDC3L;
        try {
            string = this.myHost;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setHost(@Nullable String host2) {
        this.myHost = StringUtil.notNullize((String)host2);
    }

    @Transient
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = Math.max(port, -1);
        this.myLiteralPort = String.valueOf(this.myPort);
    }

    @Attribute(value="port")
    @NotNull
    @NlsSafe
    public String getLiteralPort() {
        String string;
        long l = b ^ 0xF892369F2B3L;
        try {
            string = this.myLiteralPort;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setLiteralPort(@Nullable String literalPort) {
        this.myLiteralPort = StringUtil.notNullize((String)literalPort);
        this.myPort = SshConfig.parseSshPort(literalPort);
    }

    @Deprecated
    @Attribute(value="localPort")
    @NotNull
    public String getLiteralLocalPort() {
        String string;
        long l = b ^ 0x5986B60AFB8BL;
        try {
            string = this.myLiteralLocalPort;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(4);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @Deprecated
    public void setLiteralLocalPort(@Nullable String literalLocalPort) {
        this.myLiteralLocalPort = StringUtil.notNullize((String)literalLocalPort);
        this.myLocalPort = SshConfig.parseSshPort(literalLocalPort);
    }

    @Deprecated
    @Transient
    public int getLocalPort() {
        return this.myLocalPort;
    }

    @Deprecated
    public void setLocalPort(int localPort) {
        this.myLocalPort = Math.max(localPort, -1);
        this.myLiteralLocalPort = String.valueOf(this.myLocalPort);
    }

    @Attribute(value="username")
    @NlsSafe
    @NotNull
    public String getUsername() {
        String string;
        long l = b ^ 0x3D83D4427CAEL;
        try {
            string = this.myUsername;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(5);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setUsername(@Nullable String username) {
        this.myUsername = StringUtil.notNullize((String)username);
    }

    @Attribute(value="authType")
    @NotNull
    public AuthType getAuthType() {
        AuthType authType;
        long l = b ^ 0x3D406D4C41DAL;
        try {
            authType = this.myAuthType;
            if (authType == null) {
                SshConfig.$$$reportNull$$$0(6);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return authType;
    }

    public void setAuthType(@NotNull AuthType authType) {
        long l = b ^ 0x3C1F7EE1B4E6L;
        try {
            if (authType == null) {
                SshConfig.$$$reportNull$$$0(7);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        this.myAuthType = authType;
    }

    @Attribute(value="keyPath")
    @NotNull
    public String getKeyPath() {
        String string;
        long l = b ^ 0x11297CE99733L;
        try {
            string = this.myKeyPath;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(8);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setKeyPath(@Nullable String keyPath) {
        this.myKeyPath = StringUtil.notNullize((String)keyPath);
    }

    @Transient
    public boolean isOpenSshConfigUsageForced() {
        boolean bl;
        block6: {
            block7: {
                boolean bl2;
                block8: {
                    block9: {
                        long l = b ^ 0x6232A92E7F66L;
                        int[] nArray = SshConfig.t();
                        try {
                            try {
                                try {
                                    bl = StringUtil.isEmpty((String)this.mySerializedUseOpenSSHConfig);
                                    if (nArray != null) break block6;
                                    if (!bl) break block7;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw SshConfig.a(illegalStateException);
                                }
                                bl2 = PlatformUtils.isDataGrip();
                                if (nArray != null) break block8;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            if (bl2) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
                return bl2;
            }
            bl = Boolean.parseBoolean(this.mySerializedUseOpenSSHConfig);
        }
        return bl;
    }

    @Transient
    public void setOpenSshConfigUsageForced(boolean useOpenSSHConfig) {
        this.mySerializedUseOpenSSHConfig = String.valueOf(useOpenSSHConfig);
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    @Nullable
    public SshConnectionConfigPatch getConnectionConfigPatch() {
        return this.myConnectionConfigPatch;
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    public void setConnectionConfigPatch(@Nullable SshConnectionConfigPatch patch) {
        this.myConnectionConfigPatch = patch;
    }

    public void mergeKeyPath(@Nullable String keyPath) {
        boolean bl;
        block3: {
            block4: {
                long l = b ^ 0x110D7C209AE4L;
                int[] nArray = SshConfig.t();
                try {
                    bl = StringUtil.isEmpty((String)this.myKeyPath);
                    if (nArray != null) break block3;
                    if (bl) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                return;
            }
            bl = StringUtil.isEmpty((String)keyPath);
        }
        if (bl) {
            return;
        }
        this.myKeyPath = keyPath;
    }

    @Transient
    @NotNull
    public String getName() {
        String string;
        long l = b ^ 0x510EE75C057BL;
        try {
            string = this.myNameFormat.getName(this);
            if (string == null) {
                SshConfig.$$$reportNull$$$0(9);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @Deprecated
    @Attribute(value="nameFormat")
    @NotNull
    public NameFormat getSerializedNameFormat() {
        NameFormat nameFormat;
        long l = b ^ 0x65C4A542BF85L;
        try {
            nameFormat = this.myNameFormat;
            if (nameFormat == null) {
                SshConfig.$$$reportNull$$$0(10);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return nameFormat;
    }

    @Deprecated
    public void setSerializedNameFormat(@Nullable NameFormat nameFormat) {
        NameFormat nameFormat2;
        block2: {
            block3: {
                long l = b ^ 0x2D4F9A54C64DL;
                int[] nArray = SshConfig.t();
                try {
                    SshConfig sshConfig = this;
                    nameFormat2 = nameFormat;
                    if (nArray != null) break block2;
                    if (nameFormat2 != null) break block3;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                nameFormat2 = NameFormat.INITIAL;
                break block2;
            }
            nameFormat2 = nameFormat;
        }
        sshConfig.myNameFormat = nameFormat2;
    }

    @Deprecated
    @Attribute(value="customName")
    @Nullable
    public String getSerializedCustomName() {
        return this.myCustomName;
    }

    @Deprecated
    public void setSerializedCustomName(@Nullable String customName) {
        this.myCustomName = StringUtil.nullize((String)customName, (boolean)true);
    }

    public void setCustomName(@Nullable String customName) {
        block8: {
            block9: {
                block11: {
                    block10: {
                        long l = b ^ 0xA7CDDAA7D8BL;
                        customName = StringUtil.nullize((String)customName, (boolean)true);
                        int[] nArray = SshConfig.t();
                        try {
                            SshConfig sshConfig;
                            try {
                                try {
                                    try {
                                        if (nArray != null) break block8;
                                        if (customName != null) break block9;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw SshConfig.a(illegalStateException);
                                    }
                                    this.myCustomName = null;
                                    sshConfig = this;
                                    if (nArray != null) break block10;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw SshConfig.a(illegalStateException);
                                }
                                if (sshConfig.myNameFormat != NameFormat.CUSTOM) break block11;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            sshConfig = this;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    sshConfig.myNameFormat = NameFormat.DESCRIPTIVE;
                }
                return;
            }
            this.setNonemptyCustomName(customName);
        }
    }

    public void mergeCustomName(@Nullable String customName) {
        block11: {
            String string;
            block9: {
                int[] nArray;
                block10: {
                    long l = b ^ 0x71ACAA14D300L;
                    nArray = SshConfig.t();
                    try {
                        try {
                            try {
                                string = this.myCustomName;
                                if (nArray != null) break block9;
                                if (string == null) break block10;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            if (this.myNameFormat != NameFormat.CUSTOM) break block10;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        return;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                customName = StringUtil.nullize((String)customName, (boolean)true);
                try {
                    if (nArray != null) break block11;
                    string = customName;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            if (string == null) {
                return;
            }
            this.setNonemptyCustomName(customName);
        }
    }

    private void setNonemptyCustomName(@NotNull String customName) {
        block11: {
            String string;
            int[] nArray;
            block8: {
                block9: {
                    long l = b ^ 0x74E88E745EE3L;
                    nArray = SshConfig.t();
                    try {
                        try {
                            string = customName;
                            if (nArray != null) break block8;
                            if (string != null) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        SshConfig.$$$reportNull$$$0(11);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                string = customName;
            }
            try {
                block10: {
                    try {
                        if (!string.equals(NameFormat.DESCRIPTIVE.getName(this))) break block10;
                        this.myCustomName = null;
                        this.myNameFormat = NameFormat.DESCRIPTIVE;
                        if (nArray == null) break block11;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                this.myCustomName = customName;
                this.myNameFormat = NameFormat.CUSTOM;
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
    }

    @Nullable
    public String getCustomName() {
        String string;
        block6: {
            block5: {
                SshConfig sshConfig;
                block4: {
                    long l = b ^ 0x4C246642CF36L;
                    int[] nArray = SshConfig.t();
                    try {
                        try {
                            sshConfig = this;
                            if (nArray != null) break block4;
                            if (sshConfig.myNameFormat != NameFormat.CUSTOM) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        sshConfig = this;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                string = sshConfig.myCustomName;
                break block6;
            }
            string = null;
        }
        return string;
    }

    @Nls
    @NotNull
    public String getPresentableShortName() {
        String string;
        long l = b ^ 0x7C95F4C546C5L;
        try {
            string = this.myNameFormat.getPresentableShortName(this);
            if (string == null) {
                SshConfig.$$$reportNull$$$0(12);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @Nls
    @Nullable
    public String getPresentableAddition() {
        return this.myNameFormat.getPresentableAddition(this);
    }

    @Nls
    @NotNull
    public String getPresentableFullName() {
        String string;
        long l = b ^ 0x5D7D738140DEL;
        try {
            string = this.getPresentableShortName();
            if (string == null) {
                SshConfig.$$$reportNull$$$0(13);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @NotNull
    public AuthData getAuthDataFromForPasswordSafe() {
        AuthData authData;
        long l = b ^ 0x47951D8CA807L;
        AuthData authData2 = new AuthData();
        int[] nArray = SshConfig.t();
        switch (this.myAuthType) {
            case PASSWORD: {
                Pair<Credentials, Boolean> pair = this.getPasswordCredentialsFromPasswordSafe();
                authData2.setPasswordAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
                if (nArray == null) break;
            }
            case KEY_PAIR: {
                Pair<Credentials, Boolean> pair = this.getPassphraseCredentialsFromPasswordSafe();
                authData2.setKeyAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
                break;
            }
        }
        try {
            authData = authData2;
            if (authData == null) {
                SshConfig.$$$reportNull$$$0(14);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return authData;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Credentials getCredentials() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        boolean bl;
        int[] nArray;
        block68: {
            SshConfig sshConfig;
            block67: {
                SshConfig sshConfig2;
                block66: {
                    block65: {
                        block64: {
                            block63: {
                                boolean bl2;
                                block62: {
                                    block61: {
                                        block60: {
                                            block59: {
                                                block58: {
                                                    Object object;
                                                    block56: {
                                                        block57: {
                                                            Object object2;
                                                            block54: {
                                                                block55: {
                                                                    long l = b ^ 0x643292B6F267L;
                                                                    nArray = SshConfig.t();
                                                                    try {
                                                                        try {
                                                                            object2 = this;
                                                                            if (nArray != null) break block54;
                                                                            if (object2 != o) break block55;
                                                                            return true;
                                                                        }
                                                                        catch (IllegalStateException illegalStateException) {
                                                                            throw SshConfig.a(illegalStateException);
                                                                        }
                                                                    }
                                                                    catch (IllegalStateException illegalStateException) {
                                                                        throw SshConfig.a(illegalStateException);
                                                                    }
                                                                }
                                                                object2 = o;
                                                            }
                                                            try {
                                                                try {
                                                                    try {
                                                                        if (object2 == null) return false;
                                                                        object = this.getClass();
                                                                        if (nArray != null) break block56;
                                                                    }
                                                                    catch (IllegalStateException illegalStateException) {
                                                                        throw SshConfig.a(illegalStateException);
                                                                    }
                                                                    if (object == o.getClass()) break block57;
                                                                    return false;
                                                                }
                                                                catch (IllegalStateException illegalStateException) {
                                                                    throw SshConfig.a(illegalStateException);
                                                                }
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw SshConfig.a(illegalStateException);
                                                            }
                                                        }
                                                        object = o;
                                                    }
                                                    sshConfig = (SshConfig)object;
                                                    try {
                                                        try {
                                                            bl2 = this.isProjectLevel;
                                                            if (nArray != null) break block58;
                                                            if (bl2 != sshConfig.isProjectLevel) return false;
                                                        }
                                                        catch (IllegalStateException illegalStateException) {
                                                            throw SshConfig.a(illegalStateException);
                                                        }
                                                        bl2 = this.myId.equals(sshConfig.myId);
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw SshConfig.a(illegalStateException);
                                                    }
                                                }
                                                try {
                                                    try {
                                                        if (nArray != null) break block59;
                                                        if (!bl2) return false;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw SshConfig.a(illegalStateException);
                                                    }
                                                    bl2 = this.myHost.equals(sshConfig.myHost);
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw SshConfig.a(illegalStateException);
                                                }
                                            }
                                            try {
                                                try {
                                                    if (nArray != null) break block60;
                                                    if (!bl2) return false;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw SshConfig.a(illegalStateException);
                                                }
                                                bl2 = this.myLiteralPort.equals(sshConfig.myLiteralPort);
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw SshConfig.a(illegalStateException);
                                            }
                                        }
                                        try {
                                            try {
                                                if (nArray != null) break block61;
                                                if (!bl2) return false;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw SshConfig.a(illegalStateException);
                                            }
                                            bl2 = this.myLiteralLocalPort.equals(sshConfig.myLiteralLocalPort);
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw SshConfig.a(illegalStateException);
                                        }
                                    }
                                    try {
                                        try {
                                            try {
                                                if (nArray != null) break block62;
                                                if (!bl2) return false;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw SshConfig.a(illegalStateException);
                                            }
                                            sshConfig2 = this;
                                            if (nArray != null) break block63;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw SshConfig.a(illegalStateException);
                                        }
                                        bl2 = sshConfig2.myUsername.equals(sshConfig.myUsername);
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw SshConfig.a(illegalStateException);
                                    }
                                }
                                if (!bl2) return false;
                                sshConfig2 = this;
                            }
                            try {
                                try {
                                    if (nArray != null) break block64;
                                    if (sshConfig2.myAuthType != sshConfig.myAuthType) return false;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw SshConfig.a(illegalStateException);
                                }
                                sshConfig2 = this;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                        }
                        try {
                            try {
                                if (nArray != null) break block65;
                                if (!sshConfig2.myKeyPath.equals(sshConfig.myKeyPath)) return false;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            sshConfig2 = this;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    try {
                        try {
                            if (nArray != null) break block66;
                            if (sshConfig2.myNameFormat != sshConfig.myNameFormat) return false;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        sshConfig2 = this;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                try {
                    try {
                        bl = sshConfig2.mySerializedUseOpenSSHConfig.equals(sshConfig.mySerializedUseOpenSSHConfig);
                        if (nArray != null) break block67;
                        if (!bl) return false;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    bl = Objects.equals(this.myCustomName, sshConfig.myCustomName);
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            try {
                try {
                    if (nArray != null) break block68;
                    if (!bl) return false;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                bl = Objects.equals(this.myConnectionConfigPatch, sshConfig.myConnectionConfigPatch);
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
        try {
            if (nArray != null) return bl;
            if (!bl) return false;
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
    }

    public int hashCode() {
        long l = b ^ 0x51ADB117A5E9L;
        int[] nArray = SshConfig.t();
        int n = Objects.hash(new Object[]{this.getId(), this.isProjectLevel(), this.getHost(), this.getLiteralPort(), this.getLiteralLocalPort(), this.getAuthType(), this.getKeyPath(), this.getUsername(), this.myNameFormat, this.myCustomName, this.isOpenSshConfigUsageForced(), this.getConnectionConfigPatch()});
        if (nArray != null) {
            int n2 = ShellArgument.t();
            ShellArgument.t(++n2);
        }
        return n;
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentials remoteCredentials;
        long l = b ^ 0x61405FD53C55L;
        try {
            remoteCredentials = this.copyToCredentials(this.getAuthDataFromForPasswordSafe());
            if (remoteCredentials == null) {
                SshConfig.$$$reportNull$$$0(15);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return remoteCredentials;
    }

    @NotNull
    public RemoteCredentials copyToCredentials(@NotNull AuthData data) {
        RemoteCredentialsHolder remoteCredentialsHolder;
        block11: {
            int n;
            block10: {
                long l = b ^ 0xA1B23637E15L;
                int[] nArray = SshConfig.t();
                try {
                    if (data == null) {
                        SshConfig.$$$reportNull$$$0(16);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                RemoteCredentialsHolder remoteCredentialsHolder2 = new RemoteCredentialsHolder();
                try {
                    try {
                        remoteCredentialsHolder2.setHost(this.getHost());
                        remoteCredentialsHolder2.setLiteralPort(this.getLiteralPort());
                        remoteCredentialsHolder2.setAuthType(this.getAuthType());
                        remoteCredentialsHolder2.setUserName(this.getUsername());
                        remoteCredentialsHolder2.setPassword(data.getPassword());
                        remoteCredentialsHolder2.setPassphrase(data.getPassphrase());
                        remoteCredentialsHolder2.setStorePassword(data.isSavePassword());
                        remoteCredentialsHolder2.setStorePassphrase(data.isSavePassphrase());
                        remoteCredentialsHolder2.setPrivateKeyFile(this.getKeyPath());
                        remoteCredentialsHolder = remoteCredentialsHolder2;
                        n = this.isOpenSshConfigUsageForced();
                        if (nArray != null) break block10;
                        remoteCredentialsHolder.setOpenSshConfigUsageForced(n != 0);
                        remoteCredentialsHolder2.setConnectionConfigPatch(this.getConnectionConfigPatch());
                        remoteCredentialsHolder = remoteCredentialsHolder2;
                        if (remoteCredentialsHolder != null) break block11;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    n = 17;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            SshConfig.$$$reportNull$$$0(n);
        }
        try {
            if (ShellArgument.Z() != 0) {
                SshConfig.t(new int[5]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return remoteCredentialsHolder;
    }

    @NotNull
    public static SshConfig create(boolean projectLevel, String host2, int port, String username, AuthType authType, @Nullable String keyPath) {
        SshConfig sshConfig;
        block5: {
            int n;
            block4: {
                long l = b ^ 0x73B23D0B8E71L;
                SshConfig sshConfig2 = new SshConfig(true);
                sshConfig2.setProjectLevel(projectLevel);
                int[] nArray = SshConfig.t();
                sshConfig2.setHost(host2);
                int[] nArray2 = nArray;
                try {
                    try {
                        sshConfig = sshConfig2;
                        n = port;
                        if (nArray2 != null) break block4;
                        sshConfig.setPort(n);
                        sshConfig2.setUsername(username);
                        sshConfig2.setAuthType(authType);
                        sshConfig2.setKeyPath(keyPath);
                        sshConfig = sshConfig2;
                        if (sshConfig != null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    n = 18;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            SshConfig.$$$reportNull$$$0(n);
        }
        return sshConfig;
    }

    @Deprecated
    public SshConfig() {
        this(false);
    }

    public SshConfig(boolean latestFormat) {
        long l = b ^ 0x10F4E81ECF23L;
        this.myHost = "";
        this.myLiteralPort = "";
        this.myPort = -1;
        this.myLiteralLocalPort = "";
        this.myLocalPort = -1;
        this.myUsername = "";
        this.myAuthType = AuthType.KEY_PAIR;
        this.myKeyPath = "";
        this.mySerializedUseOpenSSHConfig = "";
        this.myId = UUID.randomUUID().toString();
        this.myNameFormat = latestFormat ? NameFormat.DESCRIPTIVE : NameFormat.INITIAL;
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPasswordCredentialsFromPasswordSafe() {
        return SshConfig.getCredentialsAndMemoryOnlyStatus(this, AuthType.PASSWORD);
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPassphraseCredentialsFromPasswordSafe() {
        return SshConfig.getCredentialsAndMemoryOnlyStatus(this, AuthType.KEY_PAIR);
    }

    public void eraseAuthDataFromPasswordSafe() {
        block6: {
            long l = b ^ 0x179931B38337L;
            AuthType[] authTypeArray = AuthType.values();
            int n = authTypeArray.length;
            int[] nArray = SshConfig.t();
            for (int i = 0; i < n; ++i) {
                AuthType authType = authTypeArray[i];
                try {
                    try {
                        if (nArray != null) break block6;
                        if (authType == AuthType.OPEN_SSH) {
                            continue;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                PasswordSafe.getInstance().set(SshConfig.createAttributes(this, false, authType), null, false);
                if (nArray == null) continue;
            }
            this.eraseConfigPatchAuthDataFromPasswordSafe();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveAuthDataToPasswordSafe(@NotNull AuthData data) {
        var2_2 = SshConfig.b ^ 70443963024029L;
        var4_3 = SshConfig.t();
        try {
            if (data == null) {
                SshConfig.$$$reportNull$$$0(19);
            }
        }
        catch (IllegalStateException v0) {
            throw SshConfig.a(v0);
        }
        var5_4 = null;
        var6_5 = false;
        var7_6 = null;
        var8_7 = false;
        switch (1.$SwitchMap$com$intellij$remote$AuthType[this.getAuthType().ordinal()]) {
            case 1: {
                var9_8 = data.getPassword();
                try {
                    v1 = data.isSavePassword();
                    if (var4_3 != null) ** GOTO lbl27
                    if (!v1) {
                    }
                    ** GOTO lbl26
                }
                catch (IllegalStateException v2) {
                    throw SshConfig.a(v2);
                }
                v1 = true;
                ** GOTO lbl27
lbl26:
                // 1 sources

                v1 = false;
lbl27:
                // 3 sources

                var6_5 = v1;
                try {
                    v3 = var9_8 == null ? null : new Credentials(null, var9_8);
                }
                catch (IllegalStateException v4) {
                    throw SshConfig.a(v4);
                }
                var5_4 = v3;
                break;
            }
            case 2: {
                var9_9 = data.getPassphrase();
                try {
                    v5 = data.isSavePassphrase();
                    if (var4_3 != null) ** GOTO lbl47
                    if (!v5) {
                    }
                    ** GOTO lbl46
                }
                catch (IllegalStateException v6) {
                    throw SshConfig.a(v6);
                }
                v5 = true;
                ** GOTO lbl47
lbl46:
                // 1 sources

                v5 = false;
lbl47:
                // 3 sources

                var8_7 = v5;
                try {
                    v7 = var9_9 == null ? null : new Credentials(null, var9_9);
                }
                catch (IllegalStateException v8) {
                    throw SshConfig.a(v8);
                }
                var7_6 = v7;
                break;
            }
            default: {
                return;
            }
        }
        PasswordSafe.getInstance().set(SshConfig.createAttributes(this, var6_5, AuthType.PASSWORD), var5_4, var6_5);
        PasswordSafe.getInstance().set(SshConfig.createAttributes(this, var8_7, AuthType.KEY_PAIR), var7_6, var8_7);
        this.saveConfigPatchCredentialsToPasswordSafe(this.myConnectionConfigPatch);
    }

    public void setConnectionConfigPatchAuthData() {
        block12: {
            SshConfig sshConfig;
            block13: {
                SshConnectionConfigPatch sshConnectionConfigPatch;
                block11: {
                    long l = b ^ 0x946373643E2L;
                    int[] nArray = SshConfig.t();
                    try {
                        try {
                            try {
                                sshConnectionConfigPatch = this.myConnectionConfigPatch;
                                if (nArray != null) break block11;
                                if (sshConnectionConfigPatch == null) break block12;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            sshConfig = this;
                            if (nArray != null) break block13;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        sshConnectionConfigPatch = sshConfig.myConnectionConfigPatch;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                try {
                    if (sshConnectionConfigPatch.getProxyParams() == null) break block12;
                    sshConfig = this;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            Credentials credentials = sshConfig.getConfigPatchAuthDataCredentialsFromPasswordSafe(this.myConnectionConfigPatch.getProxyParams());
            try {
                if (credentials != null) {
                    this.setConfigPatchAuthData(this.myConnectionConfigPatch.getProxyParams(), credentials);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
    }

    private CredentialAttributes createConnectionConfigPatchAttributes(SshConnectionConfigPatch.ProxyParams proxyParams) {
        long l = b ^ 0x527D469B585DL;
        String string = CredentialAttributesKt.generateServiceName((String)((Object)SshConfig.a("p", (int)28540, (long)(0x12FA7CB4CD4DDF42L ^ l))), (String)(SshConfig.makeNotEmpty(proxyParams.getProxyHost(), (String)((Object)SshConfig.a("p", (int)8775, (long)(0x5BCFB6BFCDFB9278L ^ l)))) + ":" + SshConfig.makeNotEmpty(String.valueOf(proxyParams.getProxyPort()), (String)((Object)SshConfig.a("p", (int)14219, (long)(0x4C6E898153CA07B7L ^ l)))) + " " + this.getId()));
        return new CredentialAttributes(string, null, false);
    }

    private void saveConfigPatchAuthDataToPasswordSafe(SshConnectionConfigPatch.ProxyParams proxyParams) {
        long l = b ^ 0x413E2B8C01CBL;
        SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = proxyParams.getAuthData();
        try {
            if (proxyAuthData != null) {
                PasswordSafe.getInstance().set(this.createConnectionConfigPatchAttributes(proxyParams), new Credentials(proxyAuthData.getUsername(), proxyAuthData.getPassword()));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
    }

    private void eraseConfigPatchAuthDataFromPasswordSafe() {
        block8: {
            SshConnectionConfigPatch sshConnectionConfigPatch;
            block7: {
                long l = b ^ 0x1E08DD641B91L;
                int[] nArray = SshConfig.t();
                try {
                    try {
                        sshConnectionConfigPatch = this.myConnectionConfigPatch;
                        if (nArray != null) break block7;
                        if (sshConnectionConfigPatch == null) break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    sshConnectionConfigPatch = this.myConnectionConfigPatch;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            try {
                if (sshConnectionConfigPatch.getProxyParams() != null) {
                    PasswordSafe.getInstance().set(this.createConnectionConfigPatchAttributes(this.myConnectionConfigPatch.getProxyParams()), null);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
    }

    private Credentials getConfigPatchAuthDataCredentialsFromPasswordSafe(SshConnectionConfigPatch.ProxyParams proxyParams) {
        return PasswordSafe.getInstance().get(this.createConnectionConfigPatchAttributes(proxyParams));
    }

    /*
     * Unable to fully structure code
     */
    private void setConfigPatchAuthData(SshConnectionConfigPatch.ProxyParams proxyParams, Credentials proxyCredentials) {
        block9: {
            block7: {
                var3_3 = SshConfig.b ^ 53557514591742L;
                var6_4 = proxyParams.getAuthData();
                var5_5 = SshConfig.t();
                if (var6_4 == null) break block9;
                var7_6 = proxyCredentials.getUserName();
                var8_7 = proxyCredentials.getPasswordAsString();
                try {
                    v0 = var7_6;
                    if (var5_5 != null) break block7;
                    if (v0 != null) {
                    }
                    ** GOTO lbl26
                }
                catch (IllegalStateException v1) {
                    throw SshConfig.a(v1);
                }
                v0 = var8_7;
            }
            try {
                block8: {
                    try {
                        if (v0.isEmpty()) break block8;
                        var6_4.setUsername(var7_6);
                        var6_4.setPassword(var8_7);
                        if (var5_5 == null) break block9;
                    }
                    catch (IllegalStateException v2) {
                        throw SshConfig.a(v2);
                    }
                }
                proxyParams.setAuthData(null);
            }
            catch (IllegalStateException v3) {
                throw SshConfig.a(v3);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveConfigPatchCredentialsToPasswordSafe(SshConnectionConfigPatch patch) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        var2_2 = SshConfig.b ^ 74312069647789L;
                        var4_3 = SshConfig.t();
                        try {
                            v0 = patch;
                            if (var4_3 != null) break block14;
                            if (v0 == null) break block15;
                        }
                        catch (IllegalStateException v1) {
                            throw SshConfig.a(v1);
                        }
                        v0 = patch;
                    }
                    try {
                        try {
                            v2 = v0.getProxyParams();
                            if (var4_3 != null) break block16;
                            if (v2 == null) break block15;
                        }
                        catch (IllegalStateException v3) {
                            throw SshConfig.a(v3);
                        }
                        v2 = patch.getProxyParams();
                    }
                    catch (IllegalStateException v4) {
                        throw SshConfig.a(v4);
                    }
                }
                var5_4 = v2.getAuthData();
                try {
                    try {
                        if (var4_3 != null) break block17;
                        if (var5_4 != null) {
                        }
                        ** GOTO lbl41
                    }
                    catch (IllegalStateException v5) {
                        throw SshConfig.a(v5);
                    }
                    this.saveConfigPatchAuthDataToPasswordSafe(patch.getProxyParams());
                }
                catch (IllegalStateException v6) {
                    throw SshConfig.a(v6);
                }
            }
            try {
                if (var4_3 == null) break block15;
lbl41:
                // 2 sources

                this.eraseConfigPatchAuthDataFromPasswordSafe();
            }
            catch (IllegalStateException v7) {
                throw SshConfig.a(v7);
            }
        }
    }

    @NotNull
    public PresentableId createPresentableId() {
        PresentableId presentableId;
        long l = b ^ 0x14A9BCCDB939L;
        try {
            presentableId = Objects.requireNonNull(PresentableId.createId((String)this.getId(), (String)this.getName()));
            if (presentableId == null) {
                SshConfig.$$$reportNull$$$0(20);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return presentableId;
    }

    public SshConfigVisibility getVisibility() {
        SshConfigVisibility sshConfigVisibility;
        long l = b ^ 0x332CBA121D78L;
        try {
            sshConfigVisibility = this.isProjectLevel ? SshConfigVisibility.Project : SshConfigVisibility.App;
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return sshConfigVisibility;
    }

    public SshConfig clone() {
        SshConfig sshConfig;
        try {
            sshConfig = (SshConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
        return sshConfig;
    }

    public String toString() {
        long l = b ^ 0x37BD804E195AL;
        String string = String.valueOf(this.myConnectionConfigPatch);
        String string2 = this.mySerializedUseOpenSSHConfig;
        String string3 = String.valueOf((Object)this.myNameFormat);
        String string4 = this.myKeyPath;
        String string5 = String.valueOf(this.myAuthType);
        String string6 = this.myUsername;
        int n = this.myLocalPort;
        String string7 = this.myLiteralLocalPort;
        int n2 = this.myPort;
        String string8 = this.myLiteralPort;
        String string9 = this.myHost;
        boolean bl = this.isProjectLevel;
        String string10 = this.myId;
        return (String)((Object)SshConfig.a("p", (int)19469, (long)(0x582AD9E973F6BD37L ^ l))) + string10 + (String)((Object)SshConfig.a("p", (int)10427, (long)(0x3077418AE3DD5986L ^ l))) + bl + (String)((Object)SshConfig.a("p", (int)7170, (long)(0x3F88501300DA6D3EL ^ l))) + string9 + (String)((Object)SshConfig.a("p", (int)22928, (long)(0x3660AB92FE9928AFL ^ l))) + string8 + (String)((Object)SshConfig.a("p", (int)6489, (long)(0x30A5A89B8A566867L ^ l))) + n2 + (String)((Object)SshConfig.a("p", (int)31976, (long)(0x28E9834C50F60DD9L ^ l))) + string7 + (String)((Object)SshConfig.a("p", (int)25762, (long)(0x2635C3825F811592L ^ l))) + n + (String)((Object)SshConfig.a("p", (int)3499, (long)(0x2FFA09F1D6B27C98L ^ l))) + string6 + (String)((Object)SshConfig.a("p", (int)14389, (long)(0x4EF09706B6C6C907L ^ l))) + string5 + (String)((Object)SshConfig.a("p", (int)19455, (long)(0x3429AE507FBEBACAL ^ l))) + string4 + (String)((Object)SshConfig.a("p", (int)12871, (long)(0x74A023451A784373L ^ l))) + string3 + (String)((Object)SshConfig.a("p", (int)13651, (long)(0x1FF5C7CA9BD4464L ^ l))) + string2 + (String)((Object)SshConfig.a("p", (int)15285, (long)(0x1B0898475D3ECA83L ^ l))) + string + "}";
    }

    @NotNull
    private static Pair<Credentials, Boolean> getCredentialsAndMemoryOnlyStatus(SshConfig server, @NotNull AuthType authType) {
        boolean bl;
        Credentials credentials;
        block14: {
            CredentialAttributes credentialAttributes;
            block13: {
                AuthType authType2;
                int[] nArray;
                long l;
                block11: {
                    block12: {
                        l = b ^ 0x5AB1DE2F2083L;
                        nArray = SshConfig.t();
                        try {
                            try {
                                authType2 = authType;
                                if (nArray != null) break block11;
                                if (authType2 != null) break block12;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            SshConfig.$$$reportNull$$$0(21);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    authType2 = authType;
                }
                try {
                    if (authType2 == AuthType.OPEN_SSH) {
                        throw new IllegalStateException((String)((Object)SshConfig.a("p", (int)7179, (long)(0x75EC2BF1EAB854FBL ^ l))) + String.valueOf(authType));
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                credentialAttributes = SshConfig.createAttributes(server, false, authType);
                credentials = PasswordSafe.getInstance().get(credentialAttributes);
                if (credentials != null) break block13;
                bl = true;
                if (nArray == null) break block14;
            }
            bl = PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(credentialAttributes, credentials);
        }
        return new Pair((Object)credentials, (Object)bl);
    }

    /*
     * Exception decompiling
     */
    private static CredentialAttributes createAttributes(SshConfig config, Boolean isPasswordMemoryOnly, @NotNull AuthType authType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static String makeNotEmpty(@Nullable String value, @NotNull String defaultValue) {
        String string;
        String string2;
        block13: {
            block14: {
                int[] nArray;
                block11: {
                    block12: {
                        long l = b ^ 0x2E3144379EFCL;
                        nArray = SshConfig.t();
                        try {
                            try {
                                string2 = defaultValue;
                                if (nArray != null) break block11;
                                if (string2 != null) break block12;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            SshConfig.$$$reportNull$$$0(23);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    string2 = value;
                }
                try {
                    try {
                        if (nArray != null) break block13;
                        if (!StringUtil.isEmpty((String)string2)) break block14;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    string2 = defaultValue;
                    break block13;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            string2 = value;
        }
        try {
            string = string2;
            if (string2 == null) {
                SshConfig.$$$reportNull$$$0(24);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void parseContent(@NotNull String name, @NotNull SshConfig config) {
        block64: {
            block68: {
                block66: {
                    block65: {
                        block62: {
                            block61: {
                                block60: {
                                    block58: {
                                        block56: {
                                            block57: {
                                                block54: {
                                                    block55: {
                                                        block52: {
                                                            block53: {
                                                                block50: {
                                                                    block51: {
                                                                        var2_2 = SshConfig.b ^ 5773898554208L;
                                                                        var4_3 = SshConfig.t();
                                                                        try {
                                                                            if (name == null) {
                                                                                SshConfig.$$$reportNull$$$0(25);
                                                                            }
                                                                        }
                                                                        catch (IllegalStateException v0) {
                                                                            throw SshConfig.a(v0);
                                                                        }
                                                                        try {
                                                                            if (config == null) {
                                                                                SshConfig.$$$reportNull$$$0(26);
                                                                            }
                                                                        }
                                                                        catch (IllegalStateException v1) {
                                                                            throw SshConfig.a(v1);
                                                                        }
                                                                        var5_4 = SshConfig.cutPiece(name, '@', (String)SshConfig.a("p", (int)12819, (long)(2299675652953981191L ^ var2_2)));
                                                                        try {
                                                                            v2 /* !! */  = var5_4;
                                                                            if (var4_3 != null) break block50;
                                                                            if (v2 /* !! */  != null) break block51;
                                                                        }
                                                                        catch (IllegalStateException v3) {
                                                                            throw SshConfig.a(v3);
                                                                        }
                                                                        return;
                                                                    }
                                                                    name = (String)var5_4.getFirst();
                                                                    config.setUsername((String)var5_4.getSecond());
                                                                    v2 /* !! */  = var5_4 = SshConfig.cutPiece(name, ':', (String)SshConfig.a("p", (int)22803, (long)(1066860391790881285L ^ var2_2)));
                                                                }
                                                                try {
                                                                    if (var4_3 != null) break block52;
                                                                    if (v2 /* !! */  != null) break block53;
                                                                }
                                                                catch (IllegalStateException v4) {
                                                                    throw SshConfig.a(v4);
                                                                }
                                                                return;
                                                            }
                                                            v2 /* !! */  = var5_4.getFirst();
                                                        }
                                                        name = (String)v2 /* !! */ ;
                                                        config.setHost((String)var5_4.getSecond());
                                                        var5_5 = false;
                                                        var6_6 = SshConfig.cutPiece(name, ':', (String)SshConfig.a("p", (int)18261, (long)(2602062025727030336L ^ var2_2)));
                                                        try {
                                                            v5 /* !! */  = var6_6;
                                                            if (var4_3 != null) break block54;
                                                            if (v5 /* !! */  == null) break block55;
                                                        }
                                                        catch (IllegalStateException v6) {
                                                            throw SshConfig.a(v6);
                                                        }
                                                        var5_5 = true;
                                                        name = (String)var6_6.getFirst();
                                                        config.setLiteralPort((String)var6_6.getSecond());
                                                    }
                                                    v5 /* !! */  = var6_6 = SshConfig.cutPiece(name, ' ', (String)SshConfig.a("p", (int)18261, (long)(2602062025727030336L ^ var2_2)));
                                                }
                                                try {
                                                    if (var4_3 != null) break block56;
                                                    if (v5 /* !! */  != null) break block57;
                                                }
                                                catch (IllegalStateException v7) {
                                                    throw SshConfig.a(v7);
                                                }
                                                return;
                                            }
                                            v5 /* !! */  = var6_6.getFirst();
                                        }
                                        name = (String)v5 /* !! */ ;
                                        try {
                                            block59: {
                                                try {
                                                    try {
                                                        if (var4_3 != null) break block58;
                                                        if (!var5_5) break block59;
                                                    }
                                                    catch (IllegalStateException v8) {
                                                        throw SshConfig.a(v8);
                                                    }
                                                    config.setLiteralLocalPort((String)var6_6.getSecond());
                                                    if (var4_3 == null) break block60;
                                                }
                                                catch (IllegalStateException v9) {
                                                    throw SshConfig.a(v9);
                                                }
                                            }
                                            config.setLiteralPort((String)var6_6.getSecond());
                                        }
                                        catch (IllegalStateException v10) {
                                            throw SshConfig.a(v10);
                                        }
                                    }
                                    config.setLiteralLocalPort("");
                                }
                                try {
                                    try {
                                        v11 = SshConfig.a("p", (int)8661, (long)(3753509050493555406L ^ var2_2)).equals(name);
                                        if (var4_3 != null) break block61;
                                        if (!v11) {
                                        }
                                        ** GOTO lbl110
                                    }
                                    catch (IllegalStateException v12) {
                                        throw SshConfig.a(v12);
                                    }
                                    v11 = SshConfig.a("p", (int)21839, (long)(8775976018113930837L ^ var2_2)).equals(name);
                                }
                                catch (IllegalStateException v13) {
                                    throw SshConfig.a(v13);
                                }
                            }
                            try {
                                block63: {
                                    try {
                                        try {
                                            if (var4_3 != null) break block62;
                                            if (!v11) break block63;
                                        }
                                        catch (IllegalStateException v14) {
                                            throw SshConfig.a(v14);
                                        }
lbl110:
                                        // 2 sources

                                        config.setAuthType(AuthType.PASSWORD);
                                        if (var4_3 == null) break block64;
                                    }
                                    catch (IllegalStateException v15) {
                                        throw SshConfig.a(v15);
                                    }
                                }
                                v11 = SshConfig.a("p", (int)16595, (long)(4515618396483269578L ^ var2_2)).equals(name);
                            }
                            catch (IllegalStateException v16) {
                                throw SshConfig.a(v16);
                            }
                        }
                        try {
                            try {
                                if (var4_3 != null) break block65;
                                if (!v11) {
                                }
                                ** GOTO lbl142
                            }
                            catch (IllegalStateException v17) {
                                throw SshConfig.a(v17);
                            }
                            v11 = SshConfig.a("p", (int)16552, (long)(6306954772959736752L ^ var2_2)).equals(name);
                        }
                        catch (IllegalStateException v18) {
                            throw SshConfig.a(v18);
                        }
                    }
                    try {
                        block67: {
                            try {
                                try {
                                    if (var4_3 != null) break block66;
                                    if (!v11) break block67;
                                }
                                catch (IllegalStateException v19) {
                                    throw SshConfig.a(v19);
                                }
lbl142:
                                // 2 sources

                                config.setAuthType(AuthType.KEY_PAIR);
                                if (var4_3 == null) break block64;
                            }
                            catch (IllegalStateException v20) {
                                throw SshConfig.a(v20);
                            }
                        }
                        v11 = SshConfig.a("p", (int)23486, (long)(5802612984177305761L ^ var2_2)).equals(name);
                    }
                    catch (IllegalStateException v21) {
                        throw SshConfig.a(v21);
                    }
                }
                try {
                    try {
                        if (var4_3 != null) break block68;
                        if (!v11) {
                        }
                        ** GOTO lbl168
                    }
                    catch (IllegalStateException v22) {
                        throw SshConfig.a(v22);
                    }
                    v11 = SshConfig.a("p", (int)19851, (long)(1004730762706173589L ^ var2_2)).equals(name);
                }
                catch (IllegalStateException v23) {
                    throw SshConfig.a(v23);
                }
            }
            try {
                if (!v11) break block64;
lbl168:
                // 2 sources

                config.setAuthType(AuthType.OPEN_SSH);
            }
            catch (IllegalStateException v24) {
                throw SshConfig.a(v24);
            }
        }
    }

    @Nullable
    private static @Nullable Pair<@NotNull String, @Nullable String> cutPiece(@NotNull String text, char separator, @Nullable String defaultValue) {
        String string;
        int n;
        block13: {
            String string2;
            block12: {
                String string3;
                int[] nArray;
                block10: {
                    block11: {
                        long l = b ^ 0x2435DDD9ED38L;
                        nArray = SshConfig.t();
                        try {
                            try {
                                string3 = text;
                                if (nArray != null) break block10;
                                if (string3 != null) break block11;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            SshConfig.$$$reportNull$$$0(27);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    string3 = text;
                }
                n = string3.indexOf(separator);
                try {
                    if (n < 0) {
                        return null;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                string = text.substring(0, n);
                try {
                    string2 = defaultValue;
                    if (nArray != null) break block12;
                    if (string2 == null) break block13;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                string2 = defaultValue;
            }
            if (string2.equals(string)) {
                string = null;
            }
        }
        return new Pair((Object)text.substring(n + 1), (Object)string);
    }

    public static int parseSshPort(@Nullable String port) {
        return Math.max(StringUtil.parseInt((String)port, (int)-1), -1);
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void $$$reportNull$$$0(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 42[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void t(int[] nArray) {
        a = nArray;
    }

    public static int[] t() {
        return a;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block11: {
            block10: {
                SshConfig.b = com.jetbrains.gateway.ssh.deploy.e.a(-1211702267301767966L, 3377878315082068057L, MethodHandles.lookup().lookupClass()).a(191488586668484L);
                SshConfig.e = new HashMap<K, V>(13);
                var0 = SshConfig.b ^ 57262809278660L;
                SshConfig.t(null);
                var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                v0 = SecretKeyFactory.getInstance("DES");
                v1 = new byte[8];
                v2 = v1;
                v1[0] = (byte)(var0 >>> 56);
                for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                    v2 = v2;
                    v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                }
                var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                var9_3 = new String[69];
                var7_4 = 0;
                var6_5 = "\u0017[\u00dfsO\u0006H\"R\u00c2\u00ab\u00fce14%\u0002\bX\u0093\u0096]\u00c7#\u00e9|\u00e6<o\u00cbRx\u0010\u00af\u00c3\u008b\u00cej!\u00ecp\u0006\u00ce\u00bd\u00a9\u00cf\u0019\u00ec9\u0010\u00ba-ZI\u001f\u0087\u00c3sX\u00f5\u00c7=:\u00b7\u00b0\u0002(\u00bba\t\u00c0\u0081\u00cf\u0093\u00deG|\u009b*1A[\u000e\u00fb\u001e_\u00f9\u00a6X'\u0016\u0010o\u0089u\u00d4\u0088\\8\u00c9#\u0007\u0082\u00bbD\u0093a(Ahc\"R\u0080\u001f\"\u0011*\u00d2D\"N\u000b+#\u00f2\u009a\u00ef\u00f7K\u0016\u00c80u\u00d4\u00dcz\u00cf\u0007\u00aa+.\u0010\u00c1L\u00b8\u00b6\r \u00c3N0\u00a0?\u00d0\u009e\t:\u001cx\u00a7\u00a3\u0082\u00ed\u00e5\u00fd\u001e\u00b4\u0004\u00b4\u00a0\u00d3\u00b3!U8\u00a2!\u00fbUk(\u000ew\u00f4W\u007f\"\u00ae\u00a4\t3\u0019\u00ae\u0095\u00a6n\u00a3\u0017I\u0018z%C\u00ad+\u00931Dw2X\u008a*j\"\u00faK\n\u00d98\u00a9 \u009d\u0081+\u00f4\u0083|>6vWHM\u00f0\u00aa\u0005\u0087Y.IP\u00c9\u00d0G\u001e\u001e2\u00b6T\u00beD\u00d4L0\u007f\u00a7\u0095O\u0084w\u00a9\u0095\nX\u00fa{+\u00d6\u0092\u00f5[\u00d3\u00eb@\u001e\u00de4&\u00e5b\u00fe\u00a6]\u001cP&\u0082\u0000\u00c9\u00b3\u00b4\u0084\u00f7\u00f6\u00e5\u00f7e\u0086h\u0017\u00ee\u00e1 \u00ec\u00c4\u00ee\u00e2_\u00f0w\fR\u00ab\u009ahd/\u00d6\u00e4a\u0011\u00ec\u001dm2\u0098{\u00a4\u00b4\u00ae,4\u00cf\u00b1\u00d6 U>\u00bajL\u00ec)ia\u00de\u0084\t\u009bQ\u00e7\u00ac0\u008c\u0082\u0092\f\u00bb\u00dcD\u00d9\u00f9\u0016\u008a\u0096\u00f3\u00e4W\u0018t\u008b\u001bB\u009b\u0087$-V\u00bf\u00e4k\u001a\u0017&\u0090pu\\`Gm;\u00fb\u0018\u00cf:lK\u0010\u000e\u001dJ\u00e0\u0095\u00f1\u0000\u00dd\u00e5\u0096\u0000\u0006\u00bc\u0092\u00a6\u00b2\u00e8\u00ae\u00d5(\u0093\u00cc\u00f0\u00d6ss\u0091\u00ab\u009b\u0083\u00c4\u00d55\u00f2\u00c5k\u00a9e\u00b8\u00104D\u00d6\u00ae\u00a9m\u00b6\u00bf\r.S\u00bc\u00a5&\u00a4\u0019\u00e0W\u0082\u00f80-\u00a6\u00ae\u00d9i\u0007\u00ca\u00bd\u0007\u0005F)\u0083\u00b7\u001a?\u0092\f\u0000\u00ac$\u00ba\u00e0\u0004\u0090\u0086;\u00cb\u00f0\u0083\u0081\u00ab\u00ed\u00da\u008e\u00fc\u0086\u0002\u0005Z\u0095\u0087\u008c?y\u00f3\u0081\u00a68\u00fe\u00f1\u0089a\u0000\u000f\u001ei\u0006\u0085Dd\u00f7\u00a4[\u00eb<^\u00d0\u00e5A\u00de\u00c1p\n?\u00fe\u009c_D\u00d3r\u00a4\u00cd\u00f8\u0083\r\u00f7s\u00b5\u0016TV\u00be\u0000\u00c2\nXM\u00fb\u00cc\u0017\u00d5L\u0082A(ub\u00fe\u00de\u00d5\u00a3M~\u00b4r\u0081\u00a6\u0084|\u00e0\u00da\u0005L\u009cU\u00be\u00c7D\u00b0\u00f40\u00da\u00ce\u0016\u00eb\u00fa\f\u00f3\u008d'-\u00cb\u0004\u008b\u00f1 (u\u00a8~6'H\u00beX\u00f3'\u00f7\u00d5k\u00a0\u00cf\u007f\u00bdd5iL\u00b6\u0092\u0096\u00beR\u00c72\u00d0V\u00a5 \u000et\u00acd4g\u00d2(\u00e2\u00f7\u00de?H\u00cb\u009aS!uv\u00b3\u001d\u00c8\u0017\u00f4\u0004\u00f8\u00bf\nC4\u00d3\u00ae(\u001f\u00e3\u00bfBA|\u00f8D'*\u00f8\u008cv\u0003W\u009f\u0090\u00e2^\u00f0\u00be\u00e0W\u0007\u00bc\u009fi\u00a2\u00a6v\f9\u0002k\u00ec\u0018p\u00de\u0003\u001a b\u00a3\u00f4\fP\u00e8\u00da\u00fa\u00adhL\u00d8\u0006j0\u0098\t\f\u0094\u0098U\u00e7\u00fc\u007f\u00a4\u0092\u00ef\u0093R\u00f7\u00cbA\u0010\u00ab\u008d\u0088\u00d6\u0088m\u00aa}\u001eAu6mV\u00a9@\u0010\u00a7'\u00c3\u00ce\u00cf\u00d7\u00ee\u0017I<\u00ae\u00b4\u00ce\u009e\u00b1\u000e H\u000e\u0007\u00e8\u0098q\u00b2\u00cc\u00a9\u00b83\u0084S\u00f2\u00aa\u001bIf\u001f\u009d\u009d\u00c0\u00dbw0\u00b1\u00b1\u001a\u001c\f\u00ce\u00c7\u0010\u0083\u00ef\u00feDR|\u00f1\u0013.q\u00c1YJ\u009a\u0085\u00e2 \u000f\u0086\u0090_\u009aI\u00f3{[0\u009f\u00dd\u00dbej\u008b\u0017c\u00a5\u001e\u00b7\u0011pz\u00df[\u0011\u0004\u00f7\u00d0\u00fa\u00c6\u0010\u00ba\u007f\u00f2\u00190\u0003\u0083\u00ff{\u008f\u00f0\u00e7\u001e\u0005\u00ad\u00b1\u0010\u001cZ\u00ccW\u00d8\u00a6'\u00b6\u00d9`~}\u0011t\u00ac\u00c7\u0010\u0002Z\u0092\u00db\u0004\u008a\u00f2\u00c8\u00ce|\u00a9\u009a<\u0010\u0095\u00f3\u0010\u007f\u000f\u0006\u00f4\u000fX\u00e2\u00a6%\u001c\u00f7\u00f2\u00b0$'\u008aH\u008au\u00bb\u00b7\u0089\u00b3DT\u00e0`c\u0091\u0000\u0083\u0017\u0098\u00dc$l\u008c\u00e3\u00e0\"\u0082;\u00a3\u00fe\u00db\u00d7\u00e1\u001fK/\u00b7\u00b3fx?\u0091G\u0006(\u0006\n\u0007zgg\u00ae\u00d3\u00e8H\u00a8\u00e1|;\\\u00d1\u0002\u00e0\u00f1r?0\u000b\r\u00ba\u00a3)rL\u00fcp\u008b\u00a8\u0083bhh\u00c9\u0080\u00f9Oh\u00e07+\u00fb\u009a\u0097#\u00e3\u00b6\u00b1\u009dL\u00b0t\u0012#\u0017\u00dcK\u00d9\u00e7\u00b06\\|X\u001d\u00ac\u00bbu)\u00cc\u0003\u0000\u00ac7\u00e4\u009d\u00f5U`\u00f0\u00c2\u0005\u008c\u00f7\u00e2\u00f6\u008c\u00a7,\u000f\u00a8\u0091\u00f1\u0018\u00bfc\u0090\u0095\u00c5\u00c4\u00b2}\u00a5\u001b\u0082WN\u00f0;I\u00d7\u008f\u0086Ao\u009f\u00e6\u00a0R\u00ca/W1\b\u001b\u0082\u00b3\\0\u0094\u0004&M\u001f\u00db\u00e6\u00e4[\tH\u00f0\u00c0\u009c\u00a8\u00e21\u0010-\u0098\u00b2\u0080GV\u009fDnd~\u00ddX\u001eJ\u00d6\u00fd*m\t\u00cf\u00c8\u009b\u0003i\u00fd\u008d\u0084\u00de\u00d4\u0083O\u00d9\u0002\u007f\u0006c\u00d9\u00ebaR\u000e\u00e1ur\u00be\u00ee\u00c4\u001a\u009c\u00e9\u00f6\u00aaM\u00aad\u00dd\u00ef\u00ca\u00dd\u00a1\u0000~}u\u0010\u00c6\u00dc\u00c8W\u00d4\u00e5\u009c\u0003b%M\u00c6\u00f6-\u00be\u0090 \u00e3\u0096\u00ce\u00e4.\u00a3\u00e0\u0088\u0096[\u00f2\u0089\u009d\u00baGY\u00d4\u008d\u0098#\u008f:.:\u00b3:\u00d0\u00d2\u0096\u00a3\u00a8\u00fe\u0018\u00e6\u009f\u00c7\u0019\u00a2\\\u0098\u008cu\n\u0007d\u000e\u00f8\u001e{\u00c3P\u0014\\a5Pt\u0010\u00ba\u00bf\u00ca1S\u00f6\u008dI3\u0015\u00d3\u00e2\u0081\u00e5i\u008a }[\u00fbZ\u0083m*t7g\u001a7\u00f0\u00d5^\u0091=\u00f3!\u00fe\u00c4u\u00a7-\u00c5(\u00f2\u00c8\u00fa#\u008e\u00fc\u0010n\u00c6q\u00fd\u00a3n\u00e3\u0013\u0011w\u00cd\u00ed\bN<W\u0010\u001d\u00eb\u00a2\u00e7vA\u00ef#\u00d9W\u00d9\u0099A\u0019\u00f4/\u0010\u00cc\u00ab\u00aa\u00e7)\u0007\u009dwk8B-\u00ce\u000b\u00880\u0010\u009fL\u009e\u0014+\u00df\u0012{Q\u00db}\u0005\u00be+\u008dTH\u00b6\u001b\u0006\u0080\u001dlP\u00c1\u0014\u00dc\u0015<\u00fb\u00d7\u00ee\u001a\u00f2/\u00b6p\u00daQ\u00a6\u00dc\u00b5\u0004\u00b7\u0085\u00c4\u00f9\u0094\u0087\u00f2\u00d2\u00d6\u0005\u00faA\u00b8\u00a5\u00f6\u001e\u00e2\u0093F@-'\u00de\r*\u00f3\u00df\u0015\u00e4\u0005\u00ef\u00f3G\u00ad\u009b\u0006~\u00a0:#^Ct\u00ef\u00e7%\u00102e\u00eb-\u00db\u0004\u00bd\u009d$\u00c6R\u008fu\u00fdT\u00f6 1s\u00dfMZ\u0018dg\u0012\u0007!\u00ed\u00e7\u00ae0\u0093\u00f5C7\u0019\u00a30\u0098Q\u00f8{\u00f9 NCk\u00bd(Ar\u00a9\u00d1%N\u00bdt8O\u00ca\u00d0\u0097\u008c\u00d3 d\\agt\u0098\u00c3\u00b2\u00d5\u008c\u00dc-\u001d\u0003\u0086\u00a3\u00c9\u00cd\u00ce\u00bf\u00b5\u00d2\u00ecJ\u0018(\u001d+\u0006\u00f1\u00ca\u009f9k3^e\u00aa\u0000v\u0004\u00b5\u0093\u0013N\u0001\u00cen*\u0018\u00fe\u0006a\u00f6\u0006\u00c8U\b\u00c4\u00d7\u0092\u00a8K\u00cez``k\u0016\u00c1S\u007fzb \u00f5X\u00920\u008e\u0092\u008a~\u0010\u00f3z\u00d2\u00fbO\u00e4\u000e\u0099\u0093\b{\u009a\u00f5\u00ab\u0014m2\u00fc\u00f4\u00f0\u001ea\u00c4\u0010\u0086Vsh\u00c8\u00ee\u0092\u0002\u0084A\u00e7\u00e00jM}(\u0089\u0012\u001d\u00d0\u001bqwI\u001a\u0018\u0096]\u0003[HO%NbU\u0086\u00b0:\u00d5+\u00af\u00b4\u00b6\u000eP\u0000\u00b8d\r\u00c9\u0098\u00e3\u00dfR\u00ce(\r\u00f2\u0007\u00da1VN\u0000\u0014\u00ef\u00beA\u00bf\u00b9\u00d6~\u0017\"6i\u0013/\u00ae\u0001\u00ca)>\u00001\u00bf\u00da\u009f\u00e4\u0011YP\u00c3\t\u00dd\u00050R\u00c4\u001e(\u00a4\u00ec<\f?\u00b4;\u0016d\u00f0\u009fk\u0081E\u00d3\u00c8\n\u0011hJ3\u00aec\u00cc\u00a4\u00fa\u00fc%zQ z\u00b0\u00d7\u0090\u00ae\u00d8\u0006 R6r\u00fb90 W\u00f1\u0006\u008f9\u00e4\u00fa\u00a4p\u0087\u00fc\u0013&\u00a2\u00b3\u0085\u00cd\u00e6\u00c2v\u009f+^\u0019\u00a1\u00b5\u00f3\u00fb\u0014\u00ef\u001eF\u000b\u0097\u008d\u00d8\u00f0\u00a5\u0086\u00ad\u0089\u0081.\u00f4\u00a1\u009a\u0001(\u0003}P\u00e5\u001e\u001e\u00d3[\u0016\u009c\u00f9\u00e2@\u00ed\u009d=Q\u0097b\u00e0\u00b8z\u000et\u00a6c\u00b2\u001b\u00a7$\u0091>w.\u00ff\u00a1\u0082\u0015K}\u0010\u00e9WT-{\u00f6'%X\u00e7\u0085\u00f1Gl\u00a0\u00f5(Tfh=k\u0011\u00ba]b\u0013,\u00b3\u00a68\u00d80\u001e\u0012\u00f9\u0098\u001ca\u009c\u00aa&\u0013\u00d52\u0096wX\u00e68\u00c2\u00a3\u00ecka\u00b6\u00b8 q\u000f\u008f\u001c\u0098\u00f6\u00a8-='\u00cf?\u00a4\u0016\u00ce6\u0086\u00eb\u00cf\u0019\f\u00a1\u00c5k\u00bff\u0001\u00c7\u00ebr\u00889\u0010z\u00c3@\u0096@\u0098#qf\u00de*\u00d1j\u009a\u00cc\u00a6 0\u0002\u00f7\u00f4\u001d\u00deI&\u00b7\u008b?\u00b8\u00ed\u00cch\u0099\u001d\u00e2\u001c\u00e5\u00c3\u00b8\u007fO\u000b\u00a7\u009a\u00d2\u0018\u00ced\u001f(\u00d7\u00ec\u0085U\"!\u00e1\u008dbP\u00a9O\u00f7T\u0017\u00e3*\u00f2:P\u0095\u0017\u00e0\u00fd\u00e1\u00fa\u00c9\u000b0!\u0003\u0095\u008a\u00faw-\u008b\u00f9)\u00ac(\u00a1\u00bcg>\u00b6\u0002s\u0089\u00f2}\u0012x\u00bd\\\u0004\u0080S\u00c3`[&\u0015\u0004z0:\u00a1\u00b83\u00c6\u00d1 _y\u000f\u00ab\u008c\u0099\u0082\u00e90h\u008f\u00c2\u00f6\u00b1\u0002w\u00e6RhGS_\u0087qy\u0091\u0012\u00ef\u009a\u00ff\u00ea\u0094\u0095\u00aeQ\u00a9\u00ae\u0096cjg\u00f3\u008a/m\u00012\u001b\u00a5L\u0099Sl-\u00fb\"\u00f7@\u008a!\u0007H\u00b7\u0088%\u00f2\u0088\u0091\u009e\u00ba6\u0096\u00b6W\u00b3\u00b1\u00c1\u00f1\u00dc\u0018n\u00ef\t\u00db\u0090\u001eb+j\u0090U\\\u0003r\u00e5F\u00a7\u00e7\u00b7c\u00f2\u001c\u0090\u00f4\u00f7\u00a2>\u00d514\u00b1\u0085\u0099\u00b6\u0015z\u00fa_\u000f^`%(\u00a2FQ\u0011\u00aau\u0095\u00be\u0002N%|\u0081E\u0004\u00b0\u00ed\u0091BwDKo\u00db\u0097\u0095~\u0083\u00b8\u008c)\u00ab\u0088\u00020e\u00b6\u009cE\u001c \u0014\u00b9\u008a\u00ff9\u00de\u00aa\u00adU\u0086\u0013\u00f9*\u001eZY\u00bb1\u0091\u00b0$\u00a3|\u00f5\u00e5^\u0088_\u00ce_c2 \u00a9\u00e0\u00c9\u009cu\u00b2\u008e\u00c6\u0012\u0004\u00d9\u00bc\u00ad\u0011\u009f\u007f\b|;\u0018\u00b7\u0088\u0096d|j\u0019\u00bfT8\u00b3\u00e8";
                var8_6 = "\u0017[\u00dfsO\u0006H\"R\u00c2\u00ab\u00fce14%\u0002\bX\u0093\u0096]\u00c7#\u00e9|\u00e6<o\u00cbRx\u0010\u00af\u00c3\u008b\u00cej!\u00ecp\u0006\u00ce\u00bd\u00a9\u00cf\u0019\u00ec9\u0010\u00ba-ZI\u001f\u0087\u00c3sX\u00f5\u00c7=:\u00b7\u00b0\u0002(\u00bba\t\u00c0\u0081\u00cf\u0093\u00deG|\u009b*1A[\u000e\u00fb\u001e_\u00f9\u00a6X'\u0016\u0010o\u0089u\u00d4\u0088\\8\u00c9#\u0007\u0082\u00bbD\u0093a(Ahc\"R\u0080\u001f\"\u0011*\u00d2D\"N\u000b+#\u00f2\u009a\u00ef\u00f7K\u0016\u00c80u\u00d4\u00dcz\u00cf\u0007\u00aa+.\u0010\u00c1L\u00b8\u00b6\r \u00c3N0\u00a0?\u00d0\u009e\t:\u001cx\u00a7\u00a3\u0082\u00ed\u00e5\u00fd\u001e\u00b4\u0004\u00b4\u00a0\u00d3\u00b3!U8\u00a2!\u00fbUk(\u000ew\u00f4W\u007f\"\u00ae\u00a4\t3\u0019\u00ae\u0095\u00a6n\u00a3\u0017I\u0018z%C\u00ad+\u00931Dw2X\u008a*j\"\u00faK\n\u00d98\u00a9 \u009d\u0081+\u00f4\u0083|>6vWHM\u00f0\u00aa\u0005\u0087Y.IP\u00c9\u00d0G\u001e\u001e2\u00b6T\u00beD\u00d4L0\u007f\u00a7\u0095O\u0084w\u00a9\u0095\nX\u00fa{+\u00d6\u0092\u00f5[\u00d3\u00eb@\u001e\u00de4&\u00e5b\u00fe\u00a6]\u001cP&\u0082\u0000\u00c9\u00b3\u00b4\u0084\u00f7\u00f6\u00e5\u00f7e\u0086h\u0017\u00ee\u00e1 \u00ec\u00c4\u00ee\u00e2_\u00f0w\fR\u00ab\u009ahd/\u00d6\u00e4a\u0011\u00ec\u001dm2\u0098{\u00a4\u00b4\u00ae,4\u00cf\u00b1\u00d6 U>\u00bajL\u00ec)ia\u00de\u0084\t\u009bQ\u00e7\u00ac0\u008c\u0082\u0092\f\u00bb\u00dcD\u00d9\u00f9\u0016\u008a\u0096\u00f3\u00e4W\u0018t\u008b\u001bB\u009b\u0087$-V\u00bf\u00e4k\u001a\u0017&\u0090pu\\`Gm;\u00fb\u0018\u00cf:lK\u0010\u000e\u001dJ\u00e0\u0095\u00f1\u0000\u00dd\u00e5\u0096\u0000\u0006\u00bc\u0092\u00a6\u00b2\u00e8\u00ae\u00d5(\u0093\u00cc\u00f0\u00d6ss\u0091\u00ab\u009b\u0083\u00c4\u00d55\u00f2\u00c5k\u00a9e\u00b8\u00104D\u00d6\u00ae\u00a9m\u00b6\u00bf\r.S\u00bc\u00a5&\u00a4\u0019\u00e0W\u0082\u00f80-\u00a6\u00ae\u00d9i\u0007\u00ca\u00bd\u0007\u0005F)\u0083\u00b7\u001a?\u0092\f\u0000\u00ac$\u00ba\u00e0\u0004\u0090\u0086;\u00cb\u00f0\u0083\u0081\u00ab\u00ed\u00da\u008e\u00fc\u0086\u0002\u0005Z\u0095\u0087\u008c?y\u00f3\u0081\u00a68\u00fe\u00f1\u0089a\u0000\u000f\u001ei\u0006\u0085Dd\u00f7\u00a4[\u00eb<^\u00d0\u00e5A\u00de\u00c1p\n?\u00fe\u009c_D\u00d3r\u00a4\u00cd\u00f8\u0083\r\u00f7s\u00b5\u0016TV\u00be\u0000\u00c2\nXM\u00fb\u00cc\u0017\u00d5L\u0082A(ub\u00fe\u00de\u00d5\u00a3M~\u00b4r\u0081\u00a6\u0084|\u00e0\u00da\u0005L\u009cU\u00be\u00c7D\u00b0\u00f40\u00da\u00ce\u0016\u00eb\u00fa\f\u00f3\u008d'-\u00cb\u0004\u008b\u00f1 (u\u00a8~6'H\u00beX\u00f3'\u00f7\u00d5k\u00a0\u00cf\u007f\u00bdd5iL\u00b6\u0092\u0096\u00beR\u00c72\u00d0V\u00a5 \u000et\u00acd4g\u00d2(\u00e2\u00f7\u00de?H\u00cb\u009aS!uv\u00b3\u001d\u00c8\u0017\u00f4\u0004\u00f8\u00bf\nC4\u00d3\u00ae(\u001f\u00e3\u00bfBA|\u00f8D'*\u00f8\u008cv\u0003W\u009f\u0090\u00e2^\u00f0\u00be\u00e0W\u0007\u00bc\u009fi\u00a2\u00a6v\f9\u0002k\u00ec\u0018p\u00de\u0003\u001a b\u00a3\u00f4\fP\u00e8\u00da\u00fa\u00adhL\u00d8\u0006j0\u0098\t\f\u0094\u0098U\u00e7\u00fc\u007f\u00a4\u0092\u00ef\u0093R\u00f7\u00cbA\u0010\u00ab\u008d\u0088\u00d6\u0088m\u00aa}\u001eAu6mV\u00a9@\u0010\u00a7'\u00c3\u00ce\u00cf\u00d7\u00ee\u0017I<\u00ae\u00b4\u00ce\u009e\u00b1\u000e H\u000e\u0007\u00e8\u0098q\u00b2\u00cc\u00a9\u00b83\u0084S\u00f2\u00aa\u001bIf\u001f\u009d\u009d\u00c0\u00dbw0\u00b1\u00b1\u001a\u001c\f\u00ce\u00c7\u0010\u0083\u00ef\u00feDR|\u00f1\u0013.q\u00c1YJ\u009a\u0085\u00e2 \u000f\u0086\u0090_\u009aI\u00f3{[0\u009f\u00dd\u00dbej\u008b\u0017c\u00a5\u001e\u00b7\u0011pz\u00df[\u0011\u0004\u00f7\u00d0\u00fa\u00c6\u0010\u00ba\u007f\u00f2\u00190\u0003\u0083\u00ff{\u008f\u00f0\u00e7\u001e\u0005\u00ad\u00b1\u0010\u001cZ\u00ccW\u00d8\u00a6'\u00b6\u00d9`~}\u0011t\u00ac\u00c7\u0010\u0002Z\u0092\u00db\u0004\u008a\u00f2\u00c8\u00ce|\u00a9\u009a<\u0010\u0095\u00f3\u0010\u007f\u000f\u0006\u00f4\u000fX\u00e2\u00a6%\u001c\u00f7\u00f2\u00b0$'\u008aH\u008au\u00bb\u00b7\u0089\u00b3DT\u00e0`c\u0091\u0000\u0083\u0017\u0098\u00dc$l\u008c\u00e3\u00e0\"\u0082;\u00a3\u00fe\u00db\u00d7\u00e1\u001fK/\u00b7\u00b3fx?\u0091G\u0006(\u0006\n\u0007zgg\u00ae\u00d3\u00e8H\u00a8\u00e1|;\\\u00d1\u0002\u00e0\u00f1r?0\u000b\r\u00ba\u00a3)rL\u00fcp\u008b\u00a8\u0083bhh\u00c9\u0080\u00f9Oh\u00e07+\u00fb\u009a\u0097#\u00e3\u00b6\u00b1\u009dL\u00b0t\u0012#\u0017\u00dcK\u00d9\u00e7\u00b06\\|X\u001d\u00ac\u00bbu)\u00cc\u0003\u0000\u00ac7\u00e4\u009d\u00f5U`\u00f0\u00c2\u0005\u008c\u00f7\u00e2\u00f6\u008c\u00a7,\u000f\u00a8\u0091\u00f1\u0018\u00bfc\u0090\u0095\u00c5\u00c4\u00b2}\u00a5\u001b\u0082WN\u00f0;I\u00d7\u008f\u0086Ao\u009f\u00e6\u00a0R\u00ca/W1\b\u001b\u0082\u00b3\\0\u0094\u0004&M\u001f\u00db\u00e6\u00e4[\tH\u00f0\u00c0\u009c\u00a8\u00e21\u0010-\u0098\u00b2\u0080GV\u009fDnd~\u00ddX\u001eJ\u00d6\u00fd*m\t\u00cf\u00c8\u009b\u0003i\u00fd\u008d\u0084\u00de\u00d4\u0083O\u00d9\u0002\u007f\u0006c\u00d9\u00ebaR\u000e\u00e1ur\u00be\u00ee\u00c4\u001a\u009c\u00e9\u00f6\u00aaM\u00aad\u00dd\u00ef\u00ca\u00dd\u00a1\u0000~}u\u0010\u00c6\u00dc\u00c8W\u00d4\u00e5\u009c\u0003b%M\u00c6\u00f6-\u00be\u0090 \u00e3\u0096\u00ce\u00e4.\u00a3\u00e0\u0088\u0096[\u00f2\u0089\u009d\u00baGY\u00d4\u008d\u0098#\u008f:.:\u00b3:\u00d0\u00d2\u0096\u00a3\u00a8\u00fe\u0018\u00e6\u009f\u00c7\u0019\u00a2\\\u0098\u008cu\n\u0007d\u000e\u00f8\u001e{\u00c3P\u0014\\a5Pt\u0010\u00ba\u00bf\u00ca1S\u00f6\u008dI3\u0015\u00d3\u00e2\u0081\u00e5i\u008a }[\u00fbZ\u0083m*t7g\u001a7\u00f0\u00d5^\u0091=\u00f3!\u00fe\u00c4u\u00a7-\u00c5(\u00f2\u00c8\u00fa#\u008e\u00fc\u0010n\u00c6q\u00fd\u00a3n\u00e3\u0013\u0011w\u00cd\u00ed\bN<W\u0010\u001d\u00eb\u00a2\u00e7vA\u00ef#\u00d9W\u00d9\u0099A\u0019\u00f4/\u0010\u00cc\u00ab\u00aa\u00e7)\u0007\u009dwk8B-\u00ce\u000b\u00880\u0010\u009fL\u009e\u0014+\u00df\u0012{Q\u00db}\u0005\u00be+\u008dTH\u00b6\u001b\u0006\u0080\u001dlP\u00c1\u0014\u00dc\u0015<\u00fb\u00d7\u00ee\u001a\u00f2/\u00b6p\u00daQ\u00a6\u00dc\u00b5\u0004\u00b7\u0085\u00c4\u00f9\u0094\u0087\u00f2\u00d2\u00d6\u0005\u00faA\u00b8\u00a5\u00f6\u001e\u00e2\u0093F@-'\u00de\r*\u00f3\u00df\u0015\u00e4\u0005\u00ef\u00f3G\u00ad\u009b\u0006~\u00a0:#^Ct\u00ef\u00e7%\u00102e\u00eb-\u00db\u0004\u00bd\u009d$\u00c6R\u008fu\u00fdT\u00f6 1s\u00dfMZ\u0018dg\u0012\u0007!\u00ed\u00e7\u00ae0\u0093\u00f5C7\u0019\u00a30\u0098Q\u00f8{\u00f9 NCk\u00bd(Ar\u00a9\u00d1%N\u00bdt8O\u00ca\u00d0\u0097\u008c\u00d3 d\\agt\u0098\u00c3\u00b2\u00d5\u008c\u00dc-\u001d\u0003\u0086\u00a3\u00c9\u00cd\u00ce\u00bf\u00b5\u00d2\u00ecJ\u0018(\u001d+\u0006\u00f1\u00ca\u009f9k3^e\u00aa\u0000v\u0004\u00b5\u0093\u0013N\u0001\u00cen*\u0018\u00fe\u0006a\u00f6\u0006\u00c8U\b\u00c4\u00d7\u0092\u00a8K\u00cez``k\u0016\u00c1S\u007fzb \u00f5X\u00920\u008e\u0092\u008a~\u0010\u00f3z\u00d2\u00fbO\u00e4\u000e\u0099\u0093\b{\u009a\u00f5\u00ab\u0014m2\u00fc\u00f4\u00f0\u001ea\u00c4\u0010\u0086Vsh\u00c8\u00ee\u0092\u0002\u0084A\u00e7\u00e00jM}(\u0089\u0012\u001d\u00d0\u001bqwI\u001a\u0018\u0096]\u0003[HO%NbU\u0086\u00b0:\u00d5+\u00af\u00b4\u00b6\u000eP\u0000\u00b8d\r\u00c9\u0098\u00e3\u00dfR\u00ce(\r\u00f2\u0007\u00da1VN\u0000\u0014\u00ef\u00beA\u00bf\u00b9\u00d6~\u0017\"6i\u0013/\u00ae\u0001\u00ca)>\u00001\u00bf\u00da\u009f\u00e4\u0011YP\u00c3\t\u00dd\u00050R\u00c4\u001e(\u00a4\u00ec<\f?\u00b4;\u0016d\u00f0\u009fk\u0081E\u00d3\u00c8\n\u0011hJ3\u00aec\u00cc\u00a4\u00fa\u00fc%zQ z\u00b0\u00d7\u0090\u00ae\u00d8\u0006 R6r\u00fb90 W\u00f1\u0006\u008f9\u00e4\u00fa\u00a4p\u0087\u00fc\u0013&\u00a2\u00b3\u0085\u00cd\u00e6\u00c2v\u009f+^\u0019\u00a1\u00b5\u00f3\u00fb\u0014\u00ef\u001eF\u000b\u0097\u008d\u00d8\u00f0\u00a5\u0086\u00ad\u0089\u0081.\u00f4\u00a1\u009a\u0001(\u0003}P\u00e5\u001e\u001e\u00d3[\u0016\u009c\u00f9\u00e2@\u00ed\u009d=Q\u0097b\u00e0\u00b8z\u000et\u00a6c\u00b2\u001b\u00a7$\u0091>w.\u00ff\u00a1\u0082\u0015K}\u0010\u00e9WT-{\u00f6'%X\u00e7\u0085\u00f1Gl\u00a0\u00f5(Tfh=k\u0011\u00ba]b\u0013,\u00b3\u00a68\u00d80\u001e\u0012\u00f9\u0098\u001ca\u009c\u00aa&\u0013\u00d52\u0096wX\u00e68\u00c2\u00a3\u00ecka\u00b6\u00b8 q\u000f\u008f\u001c\u0098\u00f6\u00a8-='\u00cf?\u00a4\u0016\u00ce6\u0086\u00eb\u00cf\u0019\f\u00a1\u00c5k\u00bff\u0001\u00c7\u00ebr\u00889\u0010z\u00c3@\u0096@\u0098#qf\u00de*\u00d1j\u009a\u00cc\u00a6 0\u0002\u00f7\u00f4\u001d\u00deI&\u00b7\u008b?\u00b8\u00ed\u00cch\u0099\u001d\u00e2\u001c\u00e5\u00c3\u00b8\u007fO\u000b\u00a7\u009a\u00d2\u0018\u00ced\u001f(\u00d7\u00ec\u0085U\"!\u00e1\u008dbP\u00a9O\u00f7T\u0017\u00e3*\u00f2:P\u0095\u0017\u00e0\u00fd\u00e1\u00fa\u00c9\u000b0!\u0003\u0095\u008a\u00faw-\u008b\u00f9)\u00ac(\u00a1\u00bcg>\u00b6\u0002s\u0089\u00f2}\u0012x\u00bd\\\u0004\u0080S\u00c3`[&\u0015\u0004z0:\u00a1\u00b83\u00c6\u00d1 _y\u000f\u00ab\u008c\u0099\u0082\u00e90h\u008f\u00c2\u00f6\u00b1\u0002w\u00e6RhGS_\u0087qy\u0091\u0012\u00ef\u009a\u00ff\u00ea\u0094\u0095\u00aeQ\u00a9\u00ae\u0096cjg\u00f3\u008a/m\u00012\u001b\u00a5L\u0099Sl-\u00fb\"\u00f7@\u008a!\u0007H\u00b7\u0088%\u00f2\u0088\u0091\u009e\u00ba6\u0096\u00b6W\u00b3\u00b1\u00c1\u00f1\u00dc\u0018n\u00ef\t\u00db\u0090\u001eb+j\u0090U\\\u0003r\u00e5F\u00a7\u00e7\u00b7c\u00f2\u001c\u0090\u00f4\u00f7\u00a2>\u00d514\u00b1\u0085\u0099\u00b6\u0015z\u00fa_\u000f^`%(\u00a2FQ\u0011\u00aau\u0095\u00be\u0002N%|\u0081E\u0004\u00b0\u00ed\u0091BwDKo\u00db\u0097\u0095~\u0083\u00b8\u008c)\u00ab\u0088\u00020e\u00b6\u009cE\u001c \u0014\u00b9\u008a\u00ff9\u00de\u00aa\u00adU\u0086\u0013\u00f9*\u001eZY\u00bb1\u0091\u00b0$\u00a3|\u00f5\u00e5^\u0088_\u00ce_c2 \u00a9\u00e0\u00c9\u009cu\u00b2\u008e\u00c6\u0012\u0004\u00d9\u00bc\u00ad\u0011\u009f\u007f\b|;\u0018\u00b7\u0088\u0096d|j\u0019\u00bfT8\u00b3\u00e8".length();
                var5_7 = 32;
                var4_8 = -1;
lbl21:
                // 2 sources

                while (true) {
                    v3 = ++var4_8;
                    v4 = var6_5.substring(v3, v3 + var5_7);
                    v5 = -1;
                    break block10;
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var9_3[var7_4++] = SshConfig.a(var10_9).intern();
                    if ((var4_8 += var5_7) < var8_6) {
                        var5_7 = var6_5.charAt(var4_8);
                        ** continue;
                    }
                    var6_5 = "\u00dbf\r\u008f\u00db\u00e7bO\u0000\u0097\u00ba\u00c0\\r<\u00acP2-\u0017\u00b5E\u00aa\r\u001f\u00c7&?\u00864\u00b9\u0085 2\u0081@\u0013x\u00a5]\u0018!\u0093\u00e6\u00d8 pd\u00fe=@\u00bb\u00c1\u0097\"\u00eb_>\u00b1F\u00ccdq\u008d_";
                    var8_6 = "\u00dbf\r\u008f\u00db\u00e7bO\u0000\u0097\u00ba\u00c0\\r<\u00acP2-\u0017\u00b5E\u00aa\r\u001f\u00c7&?\u00864\u00b9\u0085 2\u0081@\u0013x\u00a5]\u0018!\u0093\u00e6\u00d8 pd\u00fe=@\u00bb\u00c1\u0097\"\u00eb_>\u00b1F\u00ccdq\u008d_".length();
                    var5_7 = 32;
                    var4_8 = -1;
lbl35:
                    // 2 sources

                    while (true) {
                        v6 = ++var4_8;
                        v4 = var6_5.substring(v6, v6 + var5_7);
                        v5 = 0;
                        break block10;
                        break;
                    }
                    break;
                }
lbl40:
                // 1 sources

                while (true) {
                    var9_3[var7_4++] = SshConfig.a(var10_9).intern();
                    if ((var4_8 += var5_7) < var8_6) {
                        var5_7 = var6_5.charAt(var4_8);
                        ** continue;
                    }
                    break block11;
                    break;
                }
            }
            var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
            switch (v5) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl52:
                // 1 sources

                ** continue;
            }
        }
        SshConfig.c = var9_3;
        SshConfig.d = new String[69];
        SshConfig.DEFAULT_KEY_PATH = SshConfig.a("p", (int)30062, (long)(4245424520386213261L ^ var0));
    }

    private static IllegalStateException a(IllegalStateException illegalStateException) {
        return illegalStateException;
    }

    private static String a(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            char c2;
            int n3 = 0xFF & byArray[i];
            if (n3 < 192) {
                cArray[n++] = (char)n3;
                continue;
            }
            if (n3 < 224) {
                c2 = (char)((char)(n3 & 0x1F) << 6);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F));
                cArray[n++] = c2;
                continue;
            }
            if (i >= n2 - 2) continue;
            c2 = (char)((char)(n3 & 0xF) << 12);
            n3 = byArray[++i];
            c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
            n3 = byArray[++i];
            c2 = (char)(c2 | (char)(n3 & 0x3F));
            cArray[n++] = c2;
        }
        return new String(cArray, 0, n);
    }

    private static String a(int n, long l) {
        int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x3D07;
        if (d[n2] == null) {
            Object[] objectArray;
            try {
                Long l2 = Thread.currentThread().getId();
                objectArray = (Object[])e.get(l2);
                if (objectArray == null) {
                    objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                    e.put(l2, objectArray);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig", exception);
            }
            byte[] byArray = new byte[8];
            byArray[0] = (byte)(l >>> 56);
            for (int i = 1; i < 8; ++i) {
                byArray[i] = (byte)(l << i * 8 >>> 56);
            }
            DESKeySpec dESKeySpec = new DESKeySpec(byArray);
            SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
            ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
            byte[] byArray2 = c[n2].getBytes("ISO-8859-1");
            SshConfig.d[n2] = SshConfig.a(((Cipher)objectArray[0]).doFinal(byArray2));
        }
        return d[n2];
    }

    private static Object a(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
        int n = (Integer)objectArray[0];
        long l = (Long)objectArray[1];
        String string2 = SshConfig.a(n, l);
        MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
        mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
        return string2;
    }

    private static CallSite a(MethodHandles.Lookup lookup, String string, MethodType methodType) {
        MutableCallSite mutableCallSite = new MutableCallSite(methodType);
        try {
            mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
        }
        catch (Exception exception) {
            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig" + " : " + string + " : " + methodType.toString(), exception);
        }
        return mutableCallSite;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(SshConfig.class, "a", MethodType.fromMethodDescriptorString("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/invoke/MutableCallSite;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    public static abstract sealed class NameFormat
    extends Enum<NameFormat> {
        public static final /* enum */ NameFormat INITIAL;
        public static final /* enum */ NameFormat DESCRIPTIVE;
        public static final /* enum */ NameFormat CUSTOM;
        private static final /* synthetic */ NameFormat[] $VALUES;
        private static final long a;
        private static final String[] c;
        private static final String[] d;
        private static final Map e;

        public static NameFormat[] values() {
            return (NameFormat[])$VALUES.clone();
        }

        public static NameFormat valueOf(String name) {
            return Enum.valueOf(NameFormat.class, name);
        }

        @NonNls
        @NotNull
        public abstract String getName(@NotNull SshConfig var1);

        @Nls
        @NotNull
        public abstract String getPresentableShortName(@NotNull SshConfig var1);

        @Nls
        @Nullable
        public abstract String getPresentableAddition(@NotNull SshConfig var1);

        @NotNull
        private static String getBasicDescription(@NotNull SshConfig config) {
            String string;
            Object object;
            String string2;
            String string3;
            String string4;
            block15: {
                int n;
                block13: {
                    block14: {
                        SshConfig sshConfig;
                        int[] nArray;
                        long l;
                        block11: {
                            block12: {
                                l = a ^ 0x6ED8831D41F0L;
                                nArray = SshConfig.t();
                                try {
                                    try {
                                        sshConfig = config;
                                        if (nArray != null) break block11;
                                        if (sshConfig != null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw NameFormat.a(illegalArgumentException);
                                    }
                                    NameFormat.$$$reportNull$$$0(0);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw NameFormat.a(illegalArgumentException);
                                }
                            }
                            sshConfig = config;
                        }
                        try {
                            try {
                                string4 = SshConfig.makeNotEmpty(sshConfig.getUsername(), (String)((Object)NameFormat.a("k", (int)32716, (long)(0xA7B658BAE9BA754L ^ l))));
                                string3 = SshConfig.makeNotEmpty(config.getHost(), (String)((Object)NameFormat.a("k", (int)12174, (long)(0x60F82993F827F717L ^ l))));
                                string2 = SshConfig.makeNotEmpty(config.getLiteralPort(), (String)((Object)NameFormat.a("k", (int)32513, (long)(0x19AD39B21A20279BL ^ l))));
                                n = config.getLocalPort();
                                if (nArray != null) break block13;
                                if (n != -1) break block14;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw NameFormat.a(illegalArgumentException);
                            }
                            object = "";
                            break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw NameFormat.a(illegalArgumentException);
                        }
                    }
                    n = config.getLocalPort();
                }
                object = ":" + n;
            }
            try {
                string = string4 + "@" + string3 + ":" + string2 + (String)object;
                if (string == null) {
                    NameFormat.$$$reportNull$$$0(1);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw NameFormat.a(illegalArgumentException);
            }
            return string;
        }

        private static /* synthetic */ NameFormat[] $values() {
            return new NameFormat[]{INITIAL, DESCRIPTIVE, CUSTOM};
        }

        /*
         * Unable to fully structure code
         */
        static {
            block11: {
                block10: {
                    NameFormat.a = com.jetbrains.gateway.ssh.deploy.e.a(7495825914946744660L, -3238891123087871961L, MethodHandles.lookup().lookupClass()).a(275159902029132L);
                    var9 = NameFormat.a ^ 136997924729092L;
                    NameFormat.e = new HashMap<K, V>(13);
                    var0_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                    v0 = SecretKeyFactory.getInstance("DES");
                    v1 = new byte[8];
                    v2 = v1;
                    v1[0] = (byte)(var9 >>> 56);
                    for (var1_2 = 1; var1_2 < 8; ++var1_2) {
                        v2 = v2;
                        v2[var1_2] = (byte)(var9 << var1_2 * 8 >>> 56);
                    }
                    var0_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                    var7_3 = new String[13];
                    var5_4 = 0;
                    var4_5 = "t\u00acSe%\u00af\u00b7B\"\u009b\u00bd\u00e5/\"`[q\u00b3%\u0019\u00b6\u00ec:5\u00e0Ej\u00f5G?\u00e8\u00fa\u0010\u0001\u00eb\u00aeU\\\u00faO[\u00f6\u0014\u0007\u00e2{f\u00a2\u00f8\u0010\u00af\u00cd\u009f\u00cf\u0082CpQX_\u009c\u0007\u00b5\u0006W\u0088\u00105u)\u00fd\u00b0\u00fdR\u00a4\u00c3t\u00a2'\u00be=]\u00d6 \u0007\u0094t\u00c1\u00fb\u00dc\u0089\u000fC4\u00a8\u007f3\u00a9\u0095n\u00ce\u00a9\u0094\u00f1Vd\"\u00c1>\u00c9\u00c6\u00b8a\u0018ou\u0010\u0094)r\u0081z\u00db\u00ce\u00fa\u00a1\u00af\u00fc6\u008c\u00de\u001c<`\u00af\u00d5\u00cd\u00f8z\u00f4\u00eb\u0007\u009b\n\u009bZ\u007f\u001e\u00e1=\u00b735P\u0087G\u00a0/\u0007\b\u00a1\u00b3{\u0081\u00ac\u008d\u009c\u00bf]\u00cavO\u00b2\u0080\u00b2j\u00db\u00fet^\u00afu\u0000\u0017\u009b\u0017k\u00cf\u0088\u00fek\u009a\\\u00e9r\u00ba\u00e2ijO\u00b2\u008cb?\u0015K\u00eda\u00d7a\u001a4\u00e2r\\\u00bf\u001b\u00ff\u00a2\u00f5\u00fc={\u008e\u0016q\u00f6~\u00aaKPzq\u00bc\u00ec\u00c2\u0016A\u00b2\u00f0\u008dw\u00c1\u00da@\u00d7D\u00a9\"\u0096\u0016eu\\\u00acrO\u00beX\u00e0lr\u0098\u00e6\u00dc\u00c3u\u00a4rI\"\u00f0\u00e0\u00e4wA')\u00d4\u0086 \u00df\u00c9i\u00e1yT\u0010K\u00c5rg?\u00baoa\u00b9|g\u00e9\u00e7o\u00f7\u00ab\u0088\u00dc\u00e1\u0091\u00a0O\u00b3\u0010!d_N\u0014\u008fP\u00dfz\u009f\u00b4\u00d3\u00e8\u007f'bX\u0093G\u00c6?\u0001\u00d2\u0097i\f'\u009f\u0092\u00feW39\u0004\u00a9\u00de\u00bb\u00dc\u0000HI-g\u00e2p\u00c6\u0087S\u00cf:uS\u00963M\u00cc)\u00cd\u00b1!\u00a0z\u0090a\u00d3\u00efZ\u00fc\u00a1\u0093\u00b1\u0019\u00f4N\u00bdp\u0016\u009bA\u00149h;~\fj\u0013\u00f6\u00dcJ`p\u00ce\u001d\u008b5\u00fe\u00b8\u00f9,1\u008e\u00b8\u00fb\u001d`\u008aH\u0004l%\u0017\u00ef\u00af\u00e6@W\u009a\u00a9\u00afXX\u0081\u00f7\u00a4d\u00ccp5\u0017\u00ed\u00a7\u00c5\u00b3\u0005\u00e9\u00fd\u00e4\u0017{\u00b5\u0016\u00b5K\u00a9\u00b8:\u00c0?!\u00e99\u0096\u0013|\u00cf\u008b\u00dd\u00b748\u0091V\u00c9\u0084\u00dc_\u0012\u0093\u00d4\u00a7u\u000e\u00f9\u00a1\"\u00de=&\u00a2w,g\u0005\u00b1\u0016\u00c0S& \u0084\u00eb\u0080P\u0010\u00bb\u0015\u00e0\u00db'\u0082\u0018";
                    var6_6 = "t\u00acSe%\u00af\u00b7B\"\u009b\u00bd\u00e5/\"`[q\u00b3%\u0019\u00b6\u00ec:5\u00e0Ej\u00f5G?\u00e8\u00fa\u0010\u0001\u00eb\u00aeU\\\u00faO[\u00f6\u0014\u0007\u00e2{f\u00a2\u00f8\u0010\u00af\u00cd\u009f\u00cf\u0082CpQX_\u009c\u0007\u00b5\u0006W\u0088\u00105u)\u00fd\u00b0\u00fdR\u00a4\u00c3t\u00a2'\u00be=]\u00d6 \u0007\u0094t\u00c1\u00fb\u00dc\u0089\u000fC4\u00a8\u007f3\u00a9\u0095n\u00ce\u00a9\u0094\u00f1Vd\"\u00c1>\u00c9\u00c6\u00b8a\u0018ou\u0010\u0094)r\u0081z\u00db\u00ce\u00fa\u00a1\u00af\u00fc6\u008c\u00de\u001c<`\u00af\u00d5\u00cd\u00f8z\u00f4\u00eb\u0007\u009b\n\u009bZ\u007f\u001e\u00e1=\u00b735P\u0087G\u00a0/\u0007\b\u00a1\u00b3{\u0081\u00ac\u008d\u009c\u00bf]\u00cavO\u00b2\u0080\u00b2j\u00db\u00fet^\u00afu\u0000\u0017\u009b\u0017k\u00cf\u0088\u00fek\u009a\\\u00e9r\u00ba\u00e2ijO\u00b2\u008cb?\u0015K\u00eda\u00d7a\u001a4\u00e2r\\\u00bf\u001b\u00ff\u00a2\u00f5\u00fc={\u008e\u0016q\u00f6~\u00aaKPzq\u00bc\u00ec\u00c2\u0016A\u00b2\u00f0\u008dw\u00c1\u00da@\u00d7D\u00a9\"\u0096\u0016eu\\\u00acrO\u00beX\u00e0lr\u0098\u00e6\u00dc\u00c3u\u00a4rI\"\u00f0\u00e0\u00e4wA')\u00d4\u0086 \u00df\u00c9i\u00e1yT\u0010K\u00c5rg?\u00baoa\u00b9|g\u00e9\u00e7o\u00f7\u00ab\u0088\u00dc\u00e1\u0091\u00a0O\u00b3\u0010!d_N\u0014\u008fP\u00dfz\u009f\u00b4\u00d3\u00e8\u007f'bX\u0093G\u00c6?\u0001\u00d2\u0097i\f'\u009f\u0092\u00feW39\u0004\u00a9\u00de\u00bb\u00dc\u0000HI-g\u00e2p\u00c6\u0087S\u00cf:uS\u00963M\u00cc)\u00cd\u00b1!\u00a0z\u0090a\u00d3\u00efZ\u00fc\u00a1\u0093\u00b1\u0019\u00f4N\u00bdp\u0016\u009bA\u00149h;~\fj\u0013\u00f6\u00dcJ`p\u00ce\u001d\u008b5\u00fe\u00b8\u00f9,1\u008e\u00b8\u00fb\u001d`\u008aH\u0004l%\u0017\u00ef\u00af\u00e6@W\u009a\u00a9\u00afXX\u0081\u00f7\u00a4d\u00ccp5\u0017\u00ed\u00a7\u00c5\u00b3\u0005\u00e9\u00fd\u00e4\u0017{\u00b5\u0016\u00b5K\u00a9\u00b8:\u00c0?!\u00e99\u0096\u0013|\u00cf\u008b\u00dd\u00b748\u0091V\u00c9\u0084\u00dc_\u0012\u0093\u00d4\u00a7u\u000e\u00f9\u00a1\"\u00de=&\u00a2w,g\u0005\u00b1\u0016\u00c0S& \u0084\u00eb\u0080P\u0010\u00bb\u0015\u00e0\u00db'\u0082\u0018".length();
                    var3_7 = 32;
                    var2_8 = -1;
lbl20:
                    // 2 sources

                    while (true) {
                        v3 = ++var2_8;
                        v4 = var4_5.substring(v3, v3 + var3_7);
                        v5 = -1;
                        break block10;
                        break;
                    }
lbl25:
                    // 1 sources

                    while (true) {
                        var7_3[var5_4++] = NameFormat.a(var8_9).intern();
                        if ((var2_8 += var3_7) < var6_6) {
                            var3_7 = var4_5.charAt(var2_8);
                            ** continue;
                        }
                        var4_5 = "Tz\u0013\u001c\u0011W+\u00ee\u008aG\u00fa\u0097WSc\u00e9\u00bfFW\u0085-/\"\u00e3\u0018\u00cb\u00f6\u009a:\u0003X\u00c8\u0006#\u0004\u008a\u001c<\u001d\u0098(S\u0005Ga`\u0095$\u00b5\u0097\u00be\u00ba7\u0017\u00dd\u0004\u0002\u000f\u00f7]\u00a37\u00de\u00af'\u0095\u00c2\u00a8nW\u00b4\u00ed:\u00a3p\u0018\u00f3\u00ce\u00c4\u00e8\u00cd";
                        var6_6 = "Tz\u0013\u001c\u0011W+\u00ee\u008aG\u00fa\u0097WSc\u00e9\u00bfFW\u0085-/\"\u00e3\u0018\u00cb\u00f6\u009a:\u0003X\u00c8\u0006#\u0004\u008a\u001c<\u001d\u0098(S\u0005Ga`\u0095$\u00b5\u0097\u00be\u00ba7\u0017\u00dd\u0004\u0002\u000f\u00f7]\u00a37\u00de\u00af'\u0095\u00c2\u00a8nW\u00b4\u00ed:\u00a3p\u0018\u00f3\u00ce\u00c4\u00e8\u00cd".length();
                        var3_7 = 40;
                        var2_8 = -1;
lbl34:
                        // 2 sources

                        while (true) {
                            v6 = ++var2_8;
                            v4 = var4_5.substring(v6, v6 + var3_7);
                            v5 = 0;
                            break block10;
                            break;
                        }
                        break;
                    }
lbl39:
                    // 1 sources

                    while (true) {
                        var7_3[var5_4++] = NameFormat.a(var8_9).intern();
                        if ((var2_8 += var3_7) < var6_6) {
                            var3_7 = var4_5.charAt(var2_8);
                            ** continue;
                        }
                        break block11;
                        break;
                    }
                }
                var8_9 = var0_1.doFinal(v4.getBytes("ISO-8859-1"));
                switch (v5) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl51:
                    // 1 sources

                    ** continue;
                }
            }
            NameFormat.c = var7_3;
            NameFormat.d = new String[13];
            NameFormat.INITIAL = new NameFormat(){
                private static final long b;
                private static final String[] f;
                private static final String[] g;
                private static final Map h;

                /*
                 * Exception decompiling
                 */
                @Override
                @NonNls
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    String string;
                    long l = b ^ 0x7DC2C276A40CL;
                    try {
                        if (config == null) {
                            1.$$$reportNull$$$0(2);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    try {
                        string = DESCRIPTIVE.getPresentableShortName(config);
                        if (string == null) {
                            1.$$$reportNull$$$0(3);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    return string;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableAddition(@NotNull SshConfig config) {
                    String string;
                    long l = b ^ 0x566AB8FD201FL;
                    try {
                        if (config == null) {
                            1.$$$reportNull$$$0(4);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    try {
                        string = DESCRIPTIVE.getPresentableAddition(config);
                        if (string == null) {
                            1.$$$reportNull$$$0(5);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    return string;
                }

                /*
                 * Exception decompiling
                 */
                private static /* synthetic */ void $$$reportNull$$$0(int var0) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block11: {
                        block10: {
                            1.b = com.jetbrains.gateway.ssh.deploy.e.a(-4963131239834581352L, -8537468336642561448L, MethodHandles.lookup().lookupClass()).a(188367126677906L);
                            1.h = new HashMap<K, V>(13);
                            var0 = 1.b ^ 20818401336340L;
                            var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                            v0 = SecretKeyFactory.getInstance("DES");
                            v1 = new byte[8];
                            v2 = v1;
                            v1[0] = (byte)(var0 >>> 56);
                            for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                                v2 = v2;
                                v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                            }
                            var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                            var9_3 = new String[12];
                            var7_4 = 0;
                            var6_5 = "u\u00b4\u0005\u00ad\u00b0\u001a\u00e0\u00b9\u00da\u00b5\u0086\u0091\u00ae~v\u00b2h\u001dJe#\u00d4\u00bb\u0017x%o\u0093\u00e8\u0016I\u0001%W\u0086L\u00b0g\u00ca\u00dd\u0088\u00ab\u0093@\u00d8\u00b4)T/z\u0011\nd2\u00c94\rh\u00e8V\u0003i\u0001\u00a04\u00aeu\u00c16L>\n\n\u0080\u0014\u00b8\u00d87'\u008aFC\u00ddn\u000b\u00ae\u0092\u0085\u0099f\u007f\u00c0\u0004\u00d5t\u008a\u00f8L\u00d23\u0099\u00a30\u00fce\u00cf$\u0014\u0002\u001e\u00b4\\\u00a5Gws\u0001\\\u00a1\u001erP\u001aY>\u008a4\u00c4\u00e6)\u0083;\u009c\u00c5F\u00acm\u000f\u0010\u0097D\u00a82\u0094\t\u00939\u0096`m\u00f7\u00f5o\u00ff\"\u00c4\fn\u0095=*\u00e9\u00da\u000bG3t%\u00da\u0003{\u00c1O\u00df\u00ff\u00e2s\u0017\n\u001e\u00af\u009bzLj\u0088\u00d4\u00cd\u00a0\u001b\u009b\u00e5\u007f\u00e7\u00b8\u00b79\u00c5nw\u00a4\u00f8\u00105n\u001f^/!\u00a4\u00d3\u0014g\u00cb\u0014F\u0016\u00ed<X:\u00ea`\u009eb\u0014`\u00fc\u00b3\u0084\u00a8%\u0095\u0091K\u00fe\u00d7Z\u001dNX\u00b9\u00c5\u0095\u00f3/yD\u00f7\u009bU\u0017\u00ba\u00fd\u00de\u000f\u00d0v1/\u00f5\u0084\u00cf\u00ae\u0001a)\u008f6\u0085q]\u00f8\u00b4\u0099\u00e4x\u00fe\u00a4\u008b\u0083\b\f|\u00ec\u00da\u00c0\u0018\u0000\u0006\u00de\u00a4\u00ca\u0000\u0000F\u00fa\u0083V\u00cd\u00dd\u0090\u007f\u0007B\u0003\u009d\u008eX\u0087R\u0082\u00e5\u00dc\u00eaPo\u00eb\u00d1pu\u009d\u0097m\u00a1\u00c6\u00a1\u009ep\u00e0\u00f3\r\u0081O;I\u00b8\u00b8\u001d\u00ad \u00ed\u0005\u0001W\u0095~F\u00d3\u00aa\u001c\u0083)\u008fv'\u009e\u00danP\u0095@s\u008e\u00a0\u00f1}\u0094\"<\u0005]f\u0091`\u0002\u00acw@\u0085)a\u00d2\u00cb\u00fbj\u0087G\u00c2\u0001\u00e1\u00c5j\u0011g\u00c1\u000b\u00109\u00c8\u00f2K]gx\u00b1\u00db`U\u00f4\u0089!\u00ae\u00cb(\u0015\u00e0\u0011\u00cd5\u0099\u00ed\u0019X\u00af\u0002X\u00ca\u00d7\u00b2P\u00c6\u00d3M\u00f1\u00a5\u00e1\u00f2JS\u0084\u00e9O\u00a8\u00c5~?\u0095\u0001et\u007f\u00f0\u0013\u00c0(\u008f\u00aa\u00f3h\u00d2\u00e7\u008cl\u00fb\u00b5[\u00dd[$\u00c8n\u0010\u00cd\u001d\u00faA}\u00f6\u00ea\r{\u00c0\u00f7\u00a2%w1\u0099s]\u00c8\u00cfP\u00b5\u00cc\u0010\u00ea\u00cak;p\u0000\u00ff\u00dbdE\u0094\u00e3\u000fYw{";
                            var8_6 = "u\u00b4\u0005\u00ad\u00b0\u001a\u00e0\u00b9\u00da\u00b5\u0086\u0091\u00ae~v\u00b2h\u001dJe#\u00d4\u00bb\u0017x%o\u0093\u00e8\u0016I\u0001%W\u0086L\u00b0g\u00ca\u00dd\u0088\u00ab\u0093@\u00d8\u00b4)T/z\u0011\nd2\u00c94\rh\u00e8V\u0003i\u0001\u00a04\u00aeu\u00c16L>\n\n\u0080\u0014\u00b8\u00d87'\u008aFC\u00ddn\u000b\u00ae\u0092\u0085\u0099f\u007f\u00c0\u0004\u00d5t\u008a\u00f8L\u00d23\u0099\u00a30\u00fce\u00cf$\u0014\u0002\u001e\u00b4\\\u00a5Gws\u0001\\\u00a1\u001erP\u001aY>\u008a4\u00c4\u00e6)\u0083;\u009c\u00c5F\u00acm\u000f\u0010\u0097D\u00a82\u0094\t\u00939\u0096`m\u00f7\u00f5o\u00ff\"\u00c4\fn\u0095=*\u00e9\u00da\u000bG3t%\u00da\u0003{\u00c1O\u00df\u00ff\u00e2s\u0017\n\u001e\u00af\u009bzLj\u0088\u00d4\u00cd\u00a0\u001b\u009b\u00e5\u007f\u00e7\u00b8\u00b79\u00c5nw\u00a4\u00f8\u00105n\u001f^/!\u00a4\u00d3\u0014g\u00cb\u0014F\u0016\u00ed<X:\u00ea`\u009eb\u0014`\u00fc\u00b3\u0084\u00a8%\u0095\u0091K\u00fe\u00d7Z\u001dNX\u00b9\u00c5\u0095\u00f3/yD\u00f7\u009bU\u0017\u00ba\u00fd\u00de\u000f\u00d0v1/\u00f5\u0084\u00cf\u00ae\u0001a)\u008f6\u0085q]\u00f8\u00b4\u0099\u00e4x\u00fe\u00a4\u008b\u0083\b\f|\u00ec\u00da\u00c0\u0018\u0000\u0006\u00de\u00a4\u00ca\u0000\u0000F\u00fa\u0083V\u00cd\u00dd\u0090\u007f\u0007B\u0003\u009d\u008eX\u0087R\u0082\u00e5\u00dc\u00eaPo\u00eb\u00d1pu\u009d\u0097m\u00a1\u00c6\u00a1\u009ep\u00e0\u00f3\r\u0081O;I\u00b8\u00b8\u001d\u00ad \u00ed\u0005\u0001W\u0095~F\u00d3\u00aa\u001c\u0083)\u008fv'\u009e\u00danP\u0095@s\u008e\u00a0\u00f1}\u0094\"<\u0005]f\u0091`\u0002\u00acw@\u0085)a\u00d2\u00cb\u00fbj\u0087G\u00c2\u0001\u00e1\u00c5j\u0011g\u00c1\u000b\u00109\u00c8\u00f2K]gx\u00b1\u00db`U\u00f4\u0089!\u00ae\u00cb(\u0015\u00e0\u0011\u00cd5\u0099\u00ed\u0019X\u00af\u0002X\u00ca\u00d7\u00b2P\u00c6\u00d3M\u00f1\u00a5\u00e1\u00f2JS\u0084\u00e9O\u00a8\u00c5~?\u0095\u0001et\u007f\u00f0\u0013\u00c0(\u008f\u00aa\u00f3h\u00d2\u00e7\u008cl\u00fb\u00b5[\u00dd[$\u00c8n\u0010\u00cd\u001d\u00faA}\u00f6\u00ea\r{\u00c0\u00f7\u00a2%w1\u0099s]\u00c8\u00cfP\u00b5\u00cc\u0010\u00ea\u00cak;p\u0000\u00ff\u00dbdE\u0094\u00e3\u000fYw{".length();
                            var5_7 = 16;
                            var4_8 = -1;
lbl20:
                            // 2 sources

                            while (true) {
                                v3 = ++var4_8;
                                v4 = var6_5.substring(v3, v3 + var5_7);
                                v5 = -1;
                                break block10;
                                break;
                            }
lbl25:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 1.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                var6_5 = "1\u0018n\"\u0001\u00ff\u0015\u00eb\u00f5\u00b2\u0018\u00b4\u00fbKI\u00c3S.\u0019\u00fd@\u00e8\u00d9\u0019tH\u00cel7\u0081z\u00912D\u00d0\u00d7\u00eat\u0091\u00cf(\u00c6\u00fa\u00d9\u00b6q\u00d8\u0092\u00a4\u00cc1f\u00db\u00b9\u0011\u00cd\u0083\u00cfN3tV\u007f#\u001a\u0005Ga\u009b\u00cb~1b\u00ed\u0093\u00ae\u00b5\u00fd\u00ec\u008ft";
                                var8_6 = "1\u0018n\"\u0001\u00ff\u0015\u00eb\u00f5\u00b2\u0018\u00b4\u00fbKI\u00c3S.\u0019\u00fd@\u00e8\u00d9\u0019tH\u00cel7\u0081z\u00912D\u00d0\u00d7\u00eat\u0091\u00cf(\u00c6\u00fa\u00d9\u00b6q\u00d8\u0092\u00a4\u00cc1f\u00db\u00b9\u0011\u00cd\u0083\u00cfN3tV\u007f#\u001a\u0005Ga\u009b\u00cb~1b\u00ed\u0093\u00ae\u00b5\u00fd\u00ec\u008ft".length();
                                var5_7 = 40;
                                var4_8 = -1;
lbl34:
                                // 2 sources

                                while (true) {
                                    v6 = ++var4_8;
                                    v4 = var6_5.substring(v6, v6 + var5_7);
                                    v5 = 0;
                                    break block10;
                                    break;
                                }
                                break;
                            }
lbl39:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 1.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                break block11;
                                break;
                            }
                        }
                        var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                        switch (v5) {
                            default: {
                                ** continue;
                            }
                            ** case 0:
lbl51:
                            // 1 sources

                            ** continue;
                        }
                    }
                    1.f = var9_3;
                    1.g = new String[12];
                }

                private static MatchException a(MatchException matchException) {
                    return matchException;
                }

                private static String b(byte[] byArray) {
                    int n = 0;
                    int n2 = byArray.length;
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        char c2;
                        int n3 = 0xFF & byArray[i];
                        if (n3 < 192) {
                            cArray[n++] = (char)n3;
                            continue;
                        }
                        if (n3 < 224) {
                            c2 = (char)((char)(n3 & 0x1F) << 6);
                            n3 = byArray[++i];
                            c2 = (char)(c2 | (char)(n3 & 0x3F));
                            cArray[n++] = c2;
                            continue;
                        }
                        if (i >= n2 - 2) continue;
                        c2 = (char)((char)(n3 & 0xF) << 12);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F));
                        cArray[n++] = c2;
                    }
                    return new String(cArray, 0, n);
                }

                private static String b(int n, long l) {
                    int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x1566;
                    if (g[n2] == null) {
                        Object[] objectArray;
                        try {
                            Long l2 = Thread.currentThread().getId();
                            objectArray = (Object[])h.get(l2);
                            if (objectArray == null) {
                                objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                                h.put(l2, objectArray);
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$1", exception);
                        }
                        byte[] byArray = new byte[8];
                        byArray[0] = (byte)(l >>> 56);
                        for (int i = 1; i < 8; ++i) {
                            byArray[i] = (byte)(l << i * 8 >>> 56);
                        }
                        DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                        SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                        ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                        byte[] byArray2 = f[n2].getBytes("ISO-8859-1");
                        1.g[n2] = 1.b(((Cipher)objectArray[0]).doFinal(byArray2));
                    }
                    return g[n2];
                }

                private static Object b(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
                    int n = (Integer)objectArray[0];
                    long l = (Long)objectArray[1];
                    String string2 = 1.b(n, l);
                    MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
                    mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
                    return string2;
                }

                private static CallSite b(MethodHandles.Lookup lookup, String string, MethodType methodType) {
                    MutableCallSite mutableCallSite = new MutableCallSite(methodType);
                    try {
                        mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$1" + " : " + string + " : " + methodType.toString(), exception);
                    }
                    return mutableCallSite;
                }
            };
            NameFormat.DESCRIPTIVE = new NameFormat(){
                private static final long b;
                private static final String[] f;
                private static final String[] g;
                private static final Map h;

                /*
                 * Exception decompiling
                 */
                @Override
                @NonNls
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    String string;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    block33: {
                        int n;
                        block31: {
                            block32: {
                                int[] nArray;
                                block29: {
                                    String string2;
                                    block30: {
                                        long l;
                                        block27: {
                                            String string3;
                                            block28: {
                                                block25: {
                                                    String string4;
                                                    block26: {
                                                        SshConfig sshConfig;
                                                        block23: {
                                                            block24: {
                                                                l = b ^ 0x718805FCD8CFL;
                                                                nArray = SshConfig.t();
                                                                try {
                                                                    try {
                                                                        sshConfig = config;
                                                                        if (nArray != null) break block23;
                                                                        if (sshConfig != null) break block24;
                                                                    }
                                                                    catch (MatchException matchException) {
                                                                        throw 2.a(matchException);
                                                                    }
                                                                    2.$$$reportNull$$$0(2);
                                                                }
                                                                catch (MatchException matchException) {
                                                                    throw 2.a(matchException);
                                                                }
                                                            }
                                                            sshConfig = config;
                                                        }
                                                        string4 = sshConfig.getUsername();
                                                        string3 = config.getHost();
                                                        string2 = config.getLiteralPort();
                                                        try {
                                                            try {
                                                                object4 = string4;
                                                                if (nArray != null) break block25;
                                                                if (!StringUtil.isEmpty((String)object4)) break block26;
                                                            }
                                                            catch (MatchException matchException) {
                                                                throw 2.a(matchException);
                                                            }
                                                            object4 = "<" + SshApiBundle.message((String)((Object)2.b("u", (int)29836, (long)(0x4937D50FB9389F78L ^ l))), new Object[0]) + ">";
                                                            break block25;
                                                        }
                                                        catch (MatchException matchException) {
                                                            throw 2.a(matchException);
                                                        }
                                                    }
                                                    object4 = string4;
                                                }
                                                try {
                                                    try {
                                                        object3 = string3;
                                                        if (nArray != null) break block27;
                                                        if (!StringUtil.isEmpty((String)object3)) break block28;
                                                    }
                                                    catch (MatchException matchException) {
                                                        throw 2.a(matchException);
                                                    }
                                                    object3 = "<" + SshApiBundle.message((String)((Object)2.b("u", (int)17972, (long)(0x1F3740B4EAAB2DC7L ^ l))), new Object[0]) + ">";
                                                    break block27;
                                                }
                                                catch (MatchException matchException) {
                                                    throw 2.a(matchException);
                                                }
                                            }
                                            object3 = string3;
                                        }
                                        try {
                                            try {
                                                object2 = string2;
                                                if (nArray != null) break block29;
                                                if (!StringUtil.isEmpty((String)object2)) break block30;
                                            }
                                            catch (MatchException matchException) {
                                                throw 2.a(matchException);
                                            }
                                            object2 = "<" + SshApiBundle.message((String)((Object)2.b("u", (int)18024, (long)(0xAE2143368C3AD9AL ^ l))), new Object[0]) + ">";
                                            break block29;
                                        }
                                        catch (MatchException matchException) {
                                            throw 2.a(matchException);
                                        }
                                    }
                                    object2 = string2;
                                }
                                try {
                                    try {
                                        n = config.getLocalPort();
                                        if (nArray != null) break block31;
                                        if (n != -1) break block32;
                                    }
                                    catch (MatchException matchException) {
                                        throw 2.a(matchException);
                                    }
                                    object = "";
                                    break block33;
                                }
                                catch (MatchException matchException) {
                                    throw 2.a(matchException);
                                }
                            }
                            n = config.getLocalPort();
                        }
                        object = ":" + n;
                    }
                    try {
                        string = (String)object4 + "@" + (String)object3 + ":" + (String)object2 + (String)object;
                        if (string == null) {
                            2.$$$reportNull$$$0(3);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 2.a(matchException);
                    }
                    return string;
                }

                /*
                 * Exception decompiling
                 */
                @Override
                @Nls
                @NotNull
                public String getPresentableAddition(@NotNull SshConfig config) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Exception decompiling
                 */
                private static /* synthetic */ void $$$reportNull$$$0(int var0) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block11: {
                        block10: {
                            2.b = com.jetbrains.gateway.ssh.deploy.e.a(-2280791316533868791L, 439677387086575009L, MethodHandles.lookup().lookupClass()).a(263819892997932L);
                            2.h = new HashMap<K, V>(13);
                            var0 = 2.b ^ 29589559017784L;
                            var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                            v0 = SecretKeyFactory.getInstance("DES");
                            v1 = new byte[8];
                            v2 = v1;
                            v1[0] = (byte)(var0 >>> 56);
                            for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                                v2 = v2;
                                v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                            }
                            var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                            var9_3 = new String[20];
                            var7_4 = 0;
                            var6_5 = "\t\u00cb`/E\u00bblf\u00ff\u0094?d]\u00b9g\u00fa}C\u0088\u0002\u008e\u00a8c\u00843\u008a\u00e5\u0084\u0086\u00d1\u00a2%\u0010pm\u00e6w\u00c3F\u00ba\u001e\u00a8\u00bfP\u00b6\u001f\u00d7\u00b8\u00d6\u0010\u00c9E\u008a\u008fp\bZ~9j\u0012k5\u00e4\u000e\u00c8P\u00cd\u00b0\u008a\u00b7\u000e\u00d8\u00e7\u00e4\u001d\u00d0\u00ef4H,\u00f6\u00bb\u00e5\u00c6\u0086\u0010]q)r\u009d\u000e\u00f3F\u00b0,@\u00da\u0000\u00d7\u00c4v\u00ab6\u0006+\u00b3\u00d5\u0018m\u0084\u008f\u00f9\u00c6\u009e\u00c9\u0087\u00b8*\u00e1\u00d6u`\u00fe\u00d6\u00c3\u00b5\\}\u00d2\u00c0\u00cb\u0000\u00fa\u00e5\u00a9c\u0012\u0086\u00c1\u00af\u00b4tgS\u00ebP\u00a0\u00e6U3\u0013O\u00e9\u00cc\u00bf/\u00fe92\b\u00f10'\u0097\u0098\u00d7\u0019\u00b3K,\u00ff\u00dd\u0094\u00ef\\R\u0096(Au\u00db\u00b7\u0086\u00bd`\u0004\u00f3sA\u00fedC\u009er\u000e\u00a5~s\u00d1+!\u001b\u00b0\u008cG&\u00a6T6\u00e5\u00fd\u00c1^\u009dd\u00ea\u00c21Q\u007f\u0014\u00c76M\u00e35P\u000br\u00b6\u000e\u008c\u00e5\u00df\u00c2r\r\u00b6F\n\u00f3Cyo:|\t\u00c3\u0017\u00ca\u008e\u0001\u009d\u000ea=h\u008f\u00d3\u00e11\u00b3\u00dc\u00df*\u0085\u00fb\u00abS\u00b6\u001f\u0097mE4\u00ec\u00ce\u0084\u00b2\u00de|r\u00e8DV\u00c6\u0082v~\u009f\tN\u00b9\u00c8X\u00a6%\u000b\u00b5g4\u008e\u00ff\u0084\\z PQ\u00d4b\u0081[l\u00d1\u00b1Ip\u00b6\u00af\u0004\u0018\u00b1\u00ca\u00e0\u00f8\u009c\u00b7Ba\u00e2V\u0094\u0011No\u00cc\u0086\u0015m\u00ab\u00b8]\u00f3\u0093\u00bbU5\u00e9\u00fa\u00a5\u00eb\u0002\u00a1\"\u0012\u008b\u0090\u00b6\u0017\u00e5+ \u00bdo\u00d7\u0010\u00c9v\u0003A\u00b5\u0010y(\u00d1o\u0084z\t\u000f[P\u00b0\u00ef\u00a1\u00b0|@\u00f37\u00a1\u00da\u0094\u00018c/\u00be\u00c1\u00d9\"0\u00dbs\b-TK6 0C\u00b5\u00b0\u00c4\\\u00e5\u00f0G\u009a\u00a5\u00d5g:\u001d\u00a3\u00a1\u00e8\u0086\u0087D\u00b9\u00e4/\u00bd\u009ay\u00b2\u0006\u00c8\u00a4W2\u00a3\u0013a\u00c63\u00f7ZK\u00f6Pf\u00c2w\fg\u00a8\u0090\\\u00cf\u00894{\u00bd\t(\u007f\u00bfo\u00da\u0018\"\u00b1\u00cb\u00c5\u008dT\u0085x\u0085\u00d3A\u001a\u00cb/.\u00dfR\u0097\u0086\u0016yGr[\u0093\u00e0\u00ccC\u00b5\u0013^\u00aeC\u00a4\u0003{3\r_c\u00f6[\u00ceW\u00ae\u001b\u0095\u001c\n\u00c0\u008d\u00c4\u00c2\u00a5\u009a\u00d1\u00a4\u0018.\u00f5`\u00e7T\u00e3l\u00f6\u00c6\t\u00190\u00ea\u00deAU\u0006\u001b|\u00d8_vP\u0006}\u00c2\u00b9W\u0007\u0098j4\u00a8\u00a0\u0096\u00a9?XA\u00f2\u00ff\u001d\u00d7\u00ce\u00ae\u00bc\u00e3\u00ca\u00f30\u009a\u0094\\e\u00fe\u0011i\u00e0\u00dd\u00a9\u0097z\u00fe\u0097\u00b5\u00e9\u00c9\u00c8\u00a6\u00a4&a\u00ec\u0094X\u001c\u00e3E\u00ec^\b\u00a7Q\u00c0\u00d301>c\u0083\u001a8\u00d6(.^ac\u00ccPm\u00c6K\u00e1\u00beO\u00f2+HCO\u000b\u008fJq\u0097\u00de\u00ec\u00e2X\f&\u00de\u0013\u0088\u000b:\u0007\b;3\u00b1Dz\u0089\u000b~9e\u0007\u00ae\u0091CbV\u00f4\u00acMxgR\u00cd\u000b\u0090H\u009a\u0087\rO\u00a7:\u00bf+C\u00b2k\u00d7VbWF\t\u00b1\u000f/\u00b1\u00e2\u0090\u00aa\u001f\u0010\u00a3\u00b6\u0087\r\u00bfoQ\u00b9)\u0097N O\u00d0\u00ceQX\u0096\u0094\u00cd792\u0007\u0090\u00e7\u00e1\u00e2J\u00d2.\u00e3\u00f9\u00eb\u00af\u00c3w\u0019 \u00e4\u00ed\u0083\u00deR\u0019S\u00b1N\u00ec\u0012F\u00d7]!\fY\u009f\u0011\u0013\u0095\u00b3\u00f6\u00d2\u00d5l(\u00fc\u00c3w\u0092\u0095\u00a1\u00cf-')4\u009a\u00ff\u00e6\u00f5`\u00a1|\u008f]\u00a7\u0001\u0080\f}J\u001e\u001b\u00ee\u0084\u00ddOV\u0096\u00eb\u00c8\u00de\u00eb\u00ebXN\u0096\u00f0e\u0006\u00d2\u000bU\u0086_\\\u00d8\u009e\\@\u00e5\u00c4\u008d\u000e\u0014\u00dc\u0097It\u0087\u00d8\u00d7\u00bf\u001d\u009c\u00a0\u00e0\u00c2\u00c9f\u00e7J\u00e5h,\u00c33\u001e\u00f8\u00b0\n\u0007\u00f0\u00ce\u008f\u0087\u00dd\u009e?=\u0019QQf\u008f/\u009d\u0081\u00fb\u001e\u001e\u00b6\u00f5\u000b2\u00bb\u00dbX_\u0081\u008a\u00e6\u00ce&\u0081\u001e,\u0018ib\u0084sA\u0010\u00f8D\u0097g\u00d4A\u009f\r\u001b\u00fc\u000eqb\u00e6;h0\u00d1\u00a1\u0082\u0096&\u00f5\u00d6\u0085zf\u00f3\u0017\u009f\r`\u00eb\u0019$y\u0005\u008d\u00d3'\u00fa\u00e1\u0091\u0086\n\u00e5\u00e5!\u00ebl$'\u00d0\u00f4\u00d8\u00b2\u00af\u00ea\u00b7/\u00b1\u00ba\u0093\u0096*0\u00d8\u0011\u00ed\u00d1e\u0086*\u0016r\u00ce\u00f3!\u00aeU\u00b3\u00b2'y\u00db/\u0012*$\u009bFs\u00ca^L\u001e\u00f7\u00a9&ocy9\u00b9f\u00c8\u00aeq\u0084\u00e17\u00f4\u0017\u00c3\u0010\u00bbK\u00e9\u00998\u00d9{\u008e1\u00e2Xa\u00b4\u00dd_\u001a";
                            var8_6 = "\t\u00cb`/E\u00bblf\u00ff\u0094?d]\u00b9g\u00fa}C\u0088\u0002\u008e\u00a8c\u00843\u008a\u00e5\u0084\u0086\u00d1\u00a2%\u0010pm\u00e6w\u00c3F\u00ba\u001e\u00a8\u00bfP\u00b6\u001f\u00d7\u00b8\u00d6\u0010\u00c9E\u008a\u008fp\bZ~9j\u0012k5\u00e4\u000e\u00c8P\u00cd\u00b0\u008a\u00b7\u000e\u00d8\u00e7\u00e4\u001d\u00d0\u00ef4H,\u00f6\u00bb\u00e5\u00c6\u0086\u0010]q)r\u009d\u000e\u00f3F\u00b0,@\u00da\u0000\u00d7\u00c4v\u00ab6\u0006+\u00b3\u00d5\u0018m\u0084\u008f\u00f9\u00c6\u009e\u00c9\u0087\u00b8*\u00e1\u00d6u`\u00fe\u00d6\u00c3\u00b5\\}\u00d2\u00c0\u00cb\u0000\u00fa\u00e5\u00a9c\u0012\u0086\u00c1\u00af\u00b4tgS\u00ebP\u00a0\u00e6U3\u0013O\u00e9\u00cc\u00bf/\u00fe92\b\u00f10'\u0097\u0098\u00d7\u0019\u00b3K,\u00ff\u00dd\u0094\u00ef\\R\u0096(Au\u00db\u00b7\u0086\u00bd`\u0004\u00f3sA\u00fedC\u009er\u000e\u00a5~s\u00d1+!\u001b\u00b0\u008cG&\u00a6T6\u00e5\u00fd\u00c1^\u009dd\u00ea\u00c21Q\u007f\u0014\u00c76M\u00e35P\u000br\u00b6\u000e\u008c\u00e5\u00df\u00c2r\r\u00b6F\n\u00f3Cyo:|\t\u00c3\u0017\u00ca\u008e\u0001\u009d\u000ea=h\u008f\u00d3\u00e11\u00b3\u00dc\u00df*\u0085\u00fb\u00abS\u00b6\u001f\u0097mE4\u00ec\u00ce\u0084\u00b2\u00de|r\u00e8DV\u00c6\u0082v~\u009f\tN\u00b9\u00c8X\u00a6%\u000b\u00b5g4\u008e\u00ff\u0084\\z PQ\u00d4b\u0081[l\u00d1\u00b1Ip\u00b6\u00af\u0004\u0018\u00b1\u00ca\u00e0\u00f8\u009c\u00b7Ba\u00e2V\u0094\u0011No\u00cc\u0086\u0015m\u00ab\u00b8]\u00f3\u0093\u00bbU5\u00e9\u00fa\u00a5\u00eb\u0002\u00a1\"\u0012\u008b\u0090\u00b6\u0017\u00e5+ \u00bdo\u00d7\u0010\u00c9v\u0003A\u00b5\u0010y(\u00d1o\u0084z\t\u000f[P\u00b0\u00ef\u00a1\u00b0|@\u00f37\u00a1\u00da\u0094\u00018c/\u00be\u00c1\u00d9\"0\u00dbs\b-TK6 0C\u00b5\u00b0\u00c4\\\u00e5\u00f0G\u009a\u00a5\u00d5g:\u001d\u00a3\u00a1\u00e8\u0086\u0087D\u00b9\u00e4/\u00bd\u009ay\u00b2\u0006\u00c8\u00a4W2\u00a3\u0013a\u00c63\u00f7ZK\u00f6Pf\u00c2w\fg\u00a8\u0090\\\u00cf\u00894{\u00bd\t(\u007f\u00bfo\u00da\u0018\"\u00b1\u00cb\u00c5\u008dT\u0085x\u0085\u00d3A\u001a\u00cb/.\u00dfR\u0097\u0086\u0016yGr[\u0093\u00e0\u00ccC\u00b5\u0013^\u00aeC\u00a4\u0003{3\r_c\u00f6[\u00ceW\u00ae\u001b\u0095\u001c\n\u00c0\u008d\u00c4\u00c2\u00a5\u009a\u00d1\u00a4\u0018.\u00f5`\u00e7T\u00e3l\u00f6\u00c6\t\u00190\u00ea\u00deAU\u0006\u001b|\u00d8_vP\u0006}\u00c2\u00b9W\u0007\u0098j4\u00a8\u00a0\u0096\u00a9?XA\u00f2\u00ff\u001d\u00d7\u00ce\u00ae\u00bc\u00e3\u00ca\u00f30\u009a\u0094\\e\u00fe\u0011i\u00e0\u00dd\u00a9\u0097z\u00fe\u0097\u00b5\u00e9\u00c9\u00c8\u00a6\u00a4&a\u00ec\u0094X\u001c\u00e3E\u00ec^\b\u00a7Q\u00c0\u00d301>c\u0083\u001a8\u00d6(.^ac\u00ccPm\u00c6K\u00e1\u00beO\u00f2+HCO\u000b\u008fJq\u0097\u00de\u00ec\u00e2X\f&\u00de\u0013\u0088\u000b:\u0007\b;3\u00b1Dz\u0089\u000b~9e\u0007\u00ae\u0091CbV\u00f4\u00acMxgR\u00cd\u000b\u0090H\u009a\u0087\rO\u00a7:\u00bf+C\u00b2k\u00d7VbWF\t\u00b1\u000f/\u00b1\u00e2\u0090\u00aa\u001f\u0010\u00a3\u00b6\u0087\r\u00bfoQ\u00b9)\u0097N O\u00d0\u00ceQX\u0096\u0094\u00cd792\u0007\u0090\u00e7\u00e1\u00e2J\u00d2.\u00e3\u00f9\u00eb\u00af\u00c3w\u0019 \u00e4\u00ed\u0083\u00deR\u0019S\u00b1N\u00ec\u0012F\u00d7]!\fY\u009f\u0011\u0013\u0095\u00b3\u00f6\u00d2\u00d5l(\u00fc\u00c3w\u0092\u0095\u00a1\u00cf-')4\u009a\u00ff\u00e6\u00f5`\u00a1|\u008f]\u00a7\u0001\u0080\f}J\u001e\u001b\u00ee\u0084\u00ddOV\u0096\u00eb\u00c8\u00de\u00eb\u00ebXN\u0096\u00f0e\u0006\u00d2\u000bU\u0086_\\\u00d8\u009e\\@\u00e5\u00c4\u008d\u000e\u0014\u00dc\u0097It\u0087\u00d8\u00d7\u00bf\u001d\u009c\u00a0\u00e0\u00c2\u00c9f\u00e7J\u00e5h,\u00c33\u001e\u00f8\u00b0\n\u0007\u00f0\u00ce\u008f\u0087\u00dd\u009e?=\u0019QQf\u008f/\u009d\u0081\u00fb\u001e\u001e\u00b6\u00f5\u000b2\u00bb\u00dbX_\u0081\u008a\u00e6\u00ce&\u0081\u001e,\u0018ib\u0084sA\u0010\u00f8D\u0097g\u00d4A\u009f\r\u001b\u00fc\u000eqb\u00e6;h0\u00d1\u00a1\u0082\u0096&\u00f5\u00d6\u0085zf\u00f3\u0017\u009f\r`\u00eb\u0019$y\u0005\u008d\u00d3'\u00fa\u00e1\u0091\u0086\n\u00e5\u00e5!\u00ebl$'\u00d0\u00f4\u00d8\u00b2\u00af\u00ea\u00b7/\u00b1\u00ba\u0093\u0096*0\u00d8\u0011\u00ed\u00d1e\u0086*\u0016r\u00ce\u00f3!\u00aeU\u00b3\u00b2'y\u00db/\u0012*$\u009bFs\u00ca^L\u001e\u00f7\u00a9&ocy9\u00b9f\u00c8\u00aeq\u0084\u00e17\u00f4\u0017\u00c3\u0010\u00bbK\u00e9\u00998\u00d9{\u008e1\u00e2Xa\u00b4\u00dd_\u001a".length();
                            var5_7 = 32;
                            var4_8 = -1;
lbl20:
                            // 2 sources

                            while (true) {
                                v3 = ++var4_8;
                                v4 = var6_5.substring(v3, v3 + var5_7);
                                v5 = -1;
                                break block10;
                                break;
                            }
lbl25:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 2.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                var6_5 = "\u00de\u00d5x \u0004P\u00e3\u0093\u00b1'U.\u00e4y\u00ef,\u0091w\u00d7^\u00ab\u00deX<\t\"KR\u00ee\u00d2\u00ddH\u00dcN\u00d72\u001b\"\u0018\u00dc\u00cbC\u000e\u001a\u00f1\u001f\u00b2\b(\u00ce\u0017\u0086\u008f\u001c\u00cd\u00aeS\u008b%\u0097\u0093\u00d8C\u00dc\u009c\u00ee\u00e2\u0084F_D\\]\u000fH\u008a\u009b\u0094 \u00d4\u00bf\u00e3~+\u00ba#w\u0006>";
                                var8_6 = "\u00de\u00d5x \u0004P\u00e3\u0093\u00b1'U.\u00e4y\u00ef,\u0091w\u00d7^\u00ab\u00deX<\t\"KR\u00ee\u00d2\u00ddH\u00dcN\u00d72\u001b\"\u0018\u00dc\u00cbC\u000e\u001a\u00f1\u001f\u00b2\b(\u00ce\u0017\u0086\u008f\u001c\u00cd\u00aeS\u008b%\u0097\u0093\u00d8C\u00dc\u009c\u00ee\u00e2\u0084F_D\\]\u000fH\u008a\u009b\u0094 \u00d4\u00bf\u00e3~+\u00ba#w\u0006>".length();
                                var5_7 = 48;
                                var4_8 = -1;
lbl34:
                                // 2 sources

                                while (true) {
                                    v6 = ++var4_8;
                                    v4 = var6_5.substring(v6, v6 + var5_7);
                                    v5 = 0;
                                    break block10;
                                    break;
                                }
                                break;
                            }
lbl39:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 2.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                break block11;
                                break;
                            }
                        }
                        var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                        switch (v5) {
                            default: {
                                ** continue;
                            }
                            ** case 0:
lbl51:
                            // 1 sources

                            ** continue;
                        }
                    }
                    2.f = var9_3;
                    2.g = new String[20];
                }

                private static MatchException a(MatchException matchException) {
                    return matchException;
                }

                private static String b(byte[] byArray) {
                    int n = 0;
                    int n2 = byArray.length;
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        char c2;
                        int n3 = 0xFF & byArray[i];
                        if (n3 < 192) {
                            cArray[n++] = (char)n3;
                            continue;
                        }
                        if (n3 < 224) {
                            c2 = (char)((char)(n3 & 0x1F) << 6);
                            n3 = byArray[++i];
                            c2 = (char)(c2 | (char)(n3 & 0x3F));
                            cArray[n++] = c2;
                            continue;
                        }
                        if (i >= n2 - 2) continue;
                        c2 = (char)((char)(n3 & 0xF) << 12);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F));
                        cArray[n++] = c2;
                    }
                    return new String(cArray, 0, n);
                }

                private static String b(int n, long l) {
                    int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x5344;
                    if (g[n2] == null) {
                        Object[] objectArray;
                        try {
                            Long l2 = Thread.currentThread().getId();
                            objectArray = (Object[])h.get(l2);
                            if (objectArray == null) {
                                objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                                h.put(l2, objectArray);
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$2", exception);
                        }
                        byte[] byArray = new byte[8];
                        byArray[0] = (byte)(l >>> 56);
                        for (int i = 1; i < 8; ++i) {
                            byArray[i] = (byte)(l << i * 8 >>> 56);
                        }
                        DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                        SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                        ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                        byte[] byArray2 = f[n2].getBytes("ISO-8859-1");
                        2.g[n2] = 2.b(((Cipher)objectArray[0]).doFinal(byArray2));
                    }
                    return g[n2];
                }

                private static Object b(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
                    int n = (Integer)objectArray[0];
                    long l = (Long)objectArray[1];
                    String string2 = 2.b(n, l);
                    MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
                    mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
                    return string2;
                }

                private static CallSite b(MethodHandles.Lookup lookup, String string, MethodType methodType) {
                    MutableCallSite mutableCallSite = new MutableCallSite(methodType);
                    try {
                        mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$2" + " : " + string + " : " + methodType.toString(), exception);
                    }
                    return mutableCallSite;
                }
            };
            NameFormat.CUSTOM = new NameFormat(){
                private static final long b;
                private static final String[] f;
                private static final String[] g;
                private static final Map h;

                @Override
                @NonNls
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    String string;
                    String string2;
                    block15: {
                        block16: {
                            String string3;
                            block17: {
                                SshConfig sshConfig;
                                int[] nArray;
                                block13: {
                                    block14: {
                                        long l = b ^ 0x75710EC9857CL;
                                        nArray = SshConfig.t();
                                        try {
                                            try {
                                                sshConfig = config;
                                                if (nArray != null) break block13;
                                                if (sshConfig != null) break block14;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw 3.b(illegalArgumentException);
                                            }
                                            3.$$$reportNull$$$0(0);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                    }
                                    sshConfig = config;
                                }
                                try {
                                    try {
                                        try {
                                            string2 = sshConfig.myCustomName;
                                            if (nArray != null) break block15;
                                            if (string2 == null) break block16;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                        string3 = config.myCustomName;
                                        if (string3 != null) break block17;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw 3.b(illegalArgumentException);
                                    }
                                    3.$$$reportNull$$$0(1);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw 3.b(illegalArgumentException);
                                }
                            }
                            return string3;
                        }
                        string2 = DESCRIPTIVE.getName(config);
                    }
                    try {
                        string = string2;
                        if (string2 == null) {
                            3.$$$reportNull$$$0(2);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 3.b(illegalArgumentException);
                    }
                    return string;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    String string;
                    String string2;
                    block15: {
                        block16: {
                            String string3;
                            block17: {
                                SshConfig sshConfig;
                                int[] nArray;
                                block13: {
                                    block14: {
                                        long l = b ^ 0x4B50936BAD7L;
                                        nArray = SshConfig.t();
                                        try {
                                            try {
                                                sshConfig = config;
                                                if (nArray != null) break block13;
                                                if (sshConfig != null) break block14;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw 3.b(illegalArgumentException);
                                            }
                                            3.$$$reportNull$$$0(3);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                    }
                                    sshConfig = config;
                                }
                                try {
                                    try {
                                        try {
                                            string2 = sshConfig.myCustomName;
                                            if (nArray != null) break block15;
                                            if (string2 == null) break block16;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                        string3 = config.myCustomName;
                                        if (string3 != null) break block17;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw 3.b(illegalArgumentException);
                                    }
                                    3.$$$reportNull$$$0(4);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw 3.b(illegalArgumentException);
                                }
                            }
                            return string3;
                        }
                        string2 = DESCRIPTIVE.getPresentableShortName(config);
                    }
                    try {
                        string = string2;
                        if (string2 == null) {
                            3.$$$reportNull$$$0(5);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 3.b(illegalArgumentException);
                    }
                    return string;
                }

                @Override
                @Nls
                @Nullable
                public String getPresentableAddition(@NotNull SshConfig config) {
                    String string;
                    block10: {
                        block11: {
                            SshConfig sshConfig;
                            int[] nArray;
                            block8: {
                                block9: {
                                    long l = b ^ 0x2F1D73BD3EC4L;
                                    nArray = SshConfig.t();
                                    try {
                                        try {
                                            sshConfig = config;
                                            if (nArray != null) break block8;
                                            if (sshConfig != null) break block9;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                        3.$$$reportNull$$$0(6);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw 3.b(illegalArgumentException);
                                    }
                                }
                                sshConfig = config;
                            }
                            try {
                                try {
                                    string = sshConfig.myCustomName;
                                    if (nArray != null) break block10;
                                    if (string == null) break block11;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw 3.b(illegalArgumentException);
                                }
                                return null;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw 3.b(illegalArgumentException);
                            }
                        }
                        string = DESCRIPTIVE.getPresentableAddition(config);
                    }
                    return string;
                }

                /*
                 * Exception decompiling
                 */
                private static /* synthetic */ void $$$reportNull$$$0(int var0) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block11: {
                        block10: {
                            3.b = com.jetbrains.gateway.ssh.deploy.e.a(267075502434579055L, -4935642824762170263L, MethodHandles.lookup().lookupClass()).a(139028788421250L);
                            3.h = new HashMap<K, V>(13);
                            var0 = 3.b ^ 84166222312561L;
                            var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                            v0 = SecretKeyFactory.getInstance("DES");
                            v1 = new byte[8];
                            v2 = v1;
                            v1[0] = (byte)(var0 >>> 56);
                            for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                                v2 = v2;
                                v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                            }
                            var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                            var9_3 = new String[10];
                            var7_4 = 0;
                            var6_5 = "S\u00de\\\u0095F]\u0018\u00d0\u00a6\u00b3$\u00f3\u00b9K3\t\u008bg\u00a2\u001c\u00ee\b%q\u00e8\u00ac\u00b87u-\u001d2\u00fc\u00ed\u00e1\u0095\u000bJ\u00d3\u00e9\u001d\u00dd\b\u0099\u00f7\u00a1\u0010M\u00fd\u0091*\u001e<\u0011\u00c5N\u00b11\u0014\u00c3\u00b7\u00a8~\u00ff\u0002\u0099\u00a8'\u0003\u0019\u0015oK\u0085\u00f7\u00ea#\u00fa\u00f8\u009d.\u00d2w\u00cbr{(\u00ae\u00f2T\u00a1FO\u008c\u00e0\u001ew\u00cf\u00ad\u00ac\u0003n\u0005bP\u00cc\u0085\u000f\u00c4\u00cc0[\u0014\u00a5wk$\u00c5\u00fd\u009f\u00bb\u00b1\u0017\u00bb7|\"p\u000b\u00b0\u008c#\u001c\u0091\u00de\u0018d\u00ab@:\u00e4M\u00e0\u00ae\u000f\u008e\u00ae\u00d4\u00d2\u0089\u009f\u00b3Q\u0095\u001c\u00ed\u00f9\u00a4\u00bc\u00b8\u0006P\u00fe\u001b={\u0085J\u0012{\u008c\u00d4\u00d1\u0013#\f\u00ca\u00ea\u00bcN\u00ff\u0082\u001b\u00d4\u0082\u0010]\u0005\u00c1`$]\u00df\u00e0\u00ef\u0089\u00a2Wc\u00cf\u0010\u00e9P\u00e3\"^\u0003\u00a0\u00ba\u0011R\u00c8\u0095\u00aaj\u009c:\u0094\u00a9(i`e^\u00af8a\u00c7\u0006<\u00f9\u00b4H\u00e5a\f_\u00e50_3\u00c9~\u0005\u008d\t\u00f9\u0004\u00f0\\o\u0095\u0019\u0004\u00e7\u008ejS\u00e0^\u00dd_\u000fWwr\u00e8\u00f7\u0011\u0002\u00fbB$2Q\u0005\u008d\u00b2\"Mn\u00fa\u0002X\u0006\u00c8[\"\u009c\u00b1\u0000\u0098\u0091O\t\u00a7\u00e6\u00d9\u009f\u00829\u000b)G\u00d6\u00b3x\u00be\u00aa\u00ce\u00d5\u0082\u0013\u00d1o\u00caB\u00c9|Bc\u00db\u00b4\u00b1\u009e\u00de\b+\u0094Q\u00cc\u00e1[\u001d\u00da]\u008dG'p_)\u0097\u00d9\u0002\u008a\u0088\u00c7\u0002<\u00ff\u00afa\u009d\f\u008a\u00f0.\u009b\u00bdNp\u00b0\u00a9eX\u00dfl\u00c2\u00c9\u00feo\u0010\u00cb\bh\u0092\u00edi%S%\u0081-^\u00da\u00939\u00d0(\u00b5c\u009a@\u001f\u00f2!\u00af\u0080\u00b9\u00ec\u00f72\u00fd\u0006\u00aeJ\u0014\u00fb\u001f9\u00c1 \u00d7:;\u001b&\\@\u009a\u00ba\u00a1\u00e8\u00fc\u00d6\u00d6fe\u00b4\u0010x\u00e7\u0099\u0087YB\u0087d\u0018\u00d3\u00d2\u0017\u0093\u00af[|";
                            var8_6 = "S\u00de\\\u0095F]\u0018\u00d0\u00a6\u00b3$\u00f3\u00b9K3\t\u008bg\u00a2\u001c\u00ee\b%q\u00e8\u00ac\u00b87u-\u001d2\u00fc\u00ed\u00e1\u0095\u000bJ\u00d3\u00e9\u001d\u00dd\b\u0099\u00f7\u00a1\u0010M\u00fd\u0091*\u001e<\u0011\u00c5N\u00b11\u0014\u00c3\u00b7\u00a8~\u00ff\u0002\u0099\u00a8'\u0003\u0019\u0015oK\u0085\u00f7\u00ea#\u00fa\u00f8\u009d.\u00d2w\u00cbr{(\u00ae\u00f2T\u00a1FO\u008c\u00e0\u001ew\u00cf\u00ad\u00ac\u0003n\u0005bP\u00cc\u0085\u000f\u00c4\u00cc0[\u0014\u00a5wk$\u00c5\u00fd\u009f\u00bb\u00b1\u0017\u00bb7|\"p\u000b\u00b0\u008c#\u001c\u0091\u00de\u0018d\u00ab@:\u00e4M\u00e0\u00ae\u000f\u008e\u00ae\u00d4\u00d2\u0089\u009f\u00b3Q\u0095\u001c\u00ed\u00f9\u00a4\u00bc\u00b8\u0006P\u00fe\u001b={\u0085J\u0012{\u008c\u00d4\u00d1\u0013#\f\u00ca\u00ea\u00bcN\u00ff\u0082\u001b\u00d4\u0082\u0010]\u0005\u00c1`$]\u00df\u00e0\u00ef\u0089\u00a2Wc\u00cf\u0010\u00e9P\u00e3\"^\u0003\u00a0\u00ba\u0011R\u00c8\u0095\u00aaj\u009c:\u0094\u00a9(i`e^\u00af8a\u00c7\u0006<\u00f9\u00b4H\u00e5a\f_\u00e50_3\u00c9~\u0005\u008d\t\u00f9\u0004\u00f0\\o\u0095\u0019\u0004\u00e7\u008ejS\u00e0^\u00dd_\u000fWwr\u00e8\u00f7\u0011\u0002\u00fbB$2Q\u0005\u008d\u00b2\"Mn\u00fa\u0002X\u0006\u00c8[\"\u009c\u00b1\u0000\u0098\u0091O\t\u00a7\u00e6\u00d9\u009f\u00829\u000b)G\u00d6\u00b3x\u00be\u00aa\u00ce\u00d5\u0082\u0013\u00d1o\u00caB\u00c9|Bc\u00db\u00b4\u00b1\u009e\u00de\b+\u0094Q\u00cc\u00e1[\u001d\u00da]\u008dG'p_)\u0097\u00d9\u0002\u008a\u0088\u00c7\u0002<\u00ff\u00afa\u009d\f\u008a\u00f0.\u009b\u00bdNp\u00b0\u00a9eX\u00dfl\u00c2\u00c9\u00feo\u0010\u00cb\bh\u0092\u00edi%S%\u0081-^\u00da\u00939\u00d0(\u00b5c\u009a@\u001f\u00f2!\u00af\u0080\u00b9\u00ec\u00f72\u00fd\u0006\u00aeJ\u0014\u00fb\u001f9\u00c1 \u00d7:;\u001b&\\@\u009a\u00ba\u00a1\u00e8\u00fc\u00d6\u00d6fe\u00b4\u0010x\u00e7\u0099\u0087YB\u0087d\u0018\u00d3\u00d2\u0017\u0093\u00af[|".length();
                            var5_7 = 104;
                            var4_8 = -1;
lbl20:
                            // 2 sources

                            while (true) {
                                v3 = ++var4_8;
                                v4 = var6_5.substring(v3, v3 + var5_7);
                                v5 = -1;
                                break block10;
                                break;
                            }
lbl25:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 3.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                var6_5 = "\u00f8\u0087p\u0014\u00f9>\u00a6;\u0000\u0003\u0004\u0006%\u00c8\u00c1\u00b4\u0099\u0099\n\u001c\u00d0\u00a6\u0098\u0085\u00a6\u00d8\u0001JVU\u00e6Es\u00aa\u001d\u009a\u0018\tS\u009a(`\u00fa\u00b4\u0090_L0T\u00cc\u0004C\u0095\u0013\u0010\u00b7k\u00d2\u0014\u0012!.Cm&-\u00f9]\u00d3^~\u00bc\u00c9Ti\u0018\u00f1\u0093\u00af\u00e5\u0083";
                                var8_6 = "\u00f8\u0087p\u0014\u00f9>\u00a6;\u0000\u0003\u0004\u0006%\u00c8\u00c1\u00b4\u0099\u0099\n\u001c\u00d0\u00a6\u0098\u0085\u00a6\u00d8\u0001JVU\u00e6Es\u00aa\u001d\u009a\u0018\tS\u009a(`\u00fa\u00b4\u0090_L0T\u00cc\u0004C\u0095\u0013\u0010\u00b7k\u00d2\u0014\u0012!.Cm&-\u00f9]\u00d3^~\u00bc\u00c9Ti\u0018\u00f1\u0093\u00af\u00e5\u0083".length();
                                var5_7 = 40;
                                var4_8 = -1;
lbl34:
                                // 2 sources

                                while (true) {
                                    v6 = ++var4_8;
                                    v4 = var6_5.substring(v6, v6 + var5_7);
                                    v5 = 0;
                                    break block10;
                                    break;
                                }
                                break;
                            }
lbl39:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 3.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                break block11;
                                break;
                            }
                        }
                        var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                        switch (v5) {
                            default: {
                                ** continue;
                            }
                            ** case 0:
lbl51:
                            // 1 sources

                            ** continue;
                        }
                    }
                    3.f = var9_3;
                    3.g = new String[10];
                }

                private static IllegalArgumentException b(IllegalArgumentException illegalArgumentException) {
                    return illegalArgumentException;
                }

                private static String b(byte[] byArray) {
                    int n = 0;
                    int n2 = byArray.length;
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        char c2;
                        int n3 = 0xFF & byArray[i];
                        if (n3 < 192) {
                            cArray[n++] = (char)n3;
                            continue;
                        }
                        if (n3 < 224) {
                            c2 = (char)((char)(n3 & 0x1F) << 6);
                            n3 = byArray[++i];
                            c2 = (char)(c2 | (char)(n3 & 0x3F));
                            cArray[n++] = c2;
                            continue;
                        }
                        if (i >= n2 - 2) continue;
                        c2 = (char)((char)(n3 & 0xF) << 12);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F));
                        cArray[n++] = c2;
                    }
                    return new String(cArray, 0, n);
                }

                private static String b(int n, long l) {
                    int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x44B5;
                    if (g[n2] == null) {
                        Object[] objectArray;
                        try {
                            Long l2 = Thread.currentThread().getId();
                            objectArray = (Object[])h.get(l2);
                            if (objectArray == null) {
                                objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                                h.put(l2, objectArray);
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$3", exception);
                        }
                        byte[] byArray = new byte[8];
                        byArray[0] = (byte)(l >>> 56);
                        for (int i = 1; i < 8; ++i) {
                            byArray[i] = (byte)(l << i * 8 >>> 56);
                        }
                        DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                        SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                        ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                        byte[] byArray2 = f[n2].getBytes("ISO-8859-1");
                        3.g[n2] = 3.b(((Cipher)objectArray[0]).doFinal(byArray2));
                    }
                    return g[n2];
                }

                private static Object b(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
                    int n = (Integer)objectArray[0];
                    long l = (Long)objectArray[1];
                    String string2 = 3.b(n, l);
                    MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
                    mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
                    return string2;
                }

                private static CallSite b(MethodHandles.Lookup lookup, String string, MethodType methodType) {
                    MutableCallSite mutableCallSite = new MutableCallSite(methodType);
                    try {
                        mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$3" + " : " + string + " : " + methodType.toString(), exception);
                    }
                    return mutableCallSite;
                }
            };
            NameFormat.$VALUES = NameFormat.$values();
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void $$$reportNull$$$0(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }

        private static String a(byte[] byArray) {
            int n = 0;
            int n2 = byArray.length;
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                char c2;
                int n3 = 0xFF & byArray[i];
                if (n3 < 192) {
                    cArray[n++] = (char)n3;
                    continue;
                }
                if (n3 < 224) {
                    c2 = (char)((char)(n3 & 0x1F) << 6);
                    n3 = byArray[++i];
                    c2 = (char)(c2 | (char)(n3 & 0x3F));
                    cArray[n++] = c2;
                    continue;
                }
                if (i >= n2 - 2) continue;
                c2 = (char)((char)(n3 & 0xF) << 12);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F));
                cArray[n++] = c2;
            }
            return new String(cArray, 0, n);
        }

        private static String a(int n, long l) {
            int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x6F7D;
            if (d[n2] == null) {
                Object[] objectArray;
                try {
                    Long l2 = Thread.currentThread().getId();
                    objectArray = (Object[])e.get(l2);
                    if (objectArray == null) {
                        objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                        e.put(l2, objectArray);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat", exception);
                }
                byte[] byArray = new byte[8];
                byArray[0] = (byte)(l >>> 56);
                for (int i = 1; i < 8; ++i) {
                    byArray[i] = (byte)(l << i * 8 >>> 56);
                }
                DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                byte[] byArray2 = c[n2].getBytes("ISO-8859-1");
                NameFormat.d[n2] = NameFormat.a(((Cipher)objectArray[0]).doFinal(byArray2));
            }
            return d[n2];
        }

        private static Object a(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
            int n = (Integer)objectArray[0];
            long l = (Long)objectArray[1];
            String string2 = NameFormat.a(n, l);
            MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
            mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
            return string2;
        }

        private static CallSite a(MethodHandles.Lookup lookup, String string, MethodType methodType) {
            MutableCallSite mutableCallSite = new MutableCallSite(methodType);
            try {
                mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
            }
            catch (Exception exception) {
                throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat" + " : " + string + " : " + methodType.toString(), exception);
            }
            return mutableCallSite;
        }

        /*
         * Works around MethodHandle LDC.
         */
        static MethodHandle cfr_ldc_0() {
            try {
                return MethodHandles.lookup().findStatic(NameFormat.class, "a", MethodType.fromMethodDescriptorString("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/invoke/MutableCallSite;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null));
            }
            catch (NoSuchMethodException | IllegalAccessException except) {
                throw new IllegalArgumentException(except);
            }
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    public static class AuthData
    implements Cloneable {
        private String myPassword;
        private boolean mySavePassword;
        private String myPassphrase;
        private boolean mySavePassphrase;
        private static final long a;
        private static final String[] b;
        private static final String[] c;
        private static final Map d;

        @Contract(value="!null, null->fail")
        public void setPasswordAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            block7: {
                boolean bl;
                AuthData authData;
                block8: {
                    block9: {
                        int[] nArray;
                        block6: {
                            long l = a ^ 0x7D2FCE21349AL;
                            int[] nArray2 = SshConfig.t();
                            this.clean();
                            nArray = nArray2;
                            try {
                                try {
                                    if (nArray != null) break block6;
                                    if (credentials == null) break block7;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw AuthData.a(illegalStateException);
                                }
                                this.setPassword(credentials.getPasswordAsString());
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                        }
                        try {
                            authData = this;
                            bl = memoryOnly;
                            if (nArray != null) break block8;
                            if (bl) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                authData.setSavePassword(bl);
            }
        }

        @Contract(value="!null, null->fail")
        public void setKeyAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            block7: {
                boolean bl;
                AuthData authData;
                block8: {
                    block9: {
                        int[] nArray;
                        block6: {
                            long l = a ^ 0x623BE6A52FC0L;
                            int[] nArray2 = SshConfig.t();
                            this.clean();
                            nArray = nArray2;
                            try {
                                try {
                                    if (nArray != null) break block6;
                                    if (credentials == null) break block7;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw AuthData.a(illegalStateException);
                                }
                                this.setPassphrase(credentials.getPasswordAsString());
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                        }
                        try {
                            authData = this;
                            bl = memoryOnly;
                            if (nArray != null) break block8;
                            if (bl) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                authData.setSavePassphrase(bl);
            }
        }

        private void clean() {
            this.myPassword = null;
            this.mySavePassword = false;
            this.myPassphrase = null;
            this.mySavePassphrase = false;
        }

        public boolean equals(Object o) {
            boolean bl;
            block33: {
                block30: {
                    int[] nArray;
                    block32: {
                        AuthData authData;
                        block31: {
                            boolean bl2;
                            block29: {
                                Object object;
                                block27: {
                                    block28: {
                                        Object object2;
                                        block24: {
                                            block25: {
                                                long l = a ^ 0x7079EE49A4BFL;
                                                nArray = SshConfig.t();
                                                try {
                                                    try {
                                                        object2 = this;
                                                        if (nArray != null) break block24;
                                                        if (object2 != o) break block25;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw AuthData.a(illegalStateException);
                                                    }
                                                    return true;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw AuthData.a(illegalStateException);
                                                }
                                            }
                                            object2 = o;
                                        }
                                        try {
                                            block26: {
                                                try {
                                                    try {
                                                        if (object2 == null) break block26;
                                                        object = this.getClass();
                                                        if (nArray != null) break block27;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw AuthData.a(illegalStateException);
                                                    }
                                                    if (object == o.getClass()) break block28;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw AuthData.a(illegalStateException);
                                                }
                                            }
                                            return false;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw AuthData.a(illegalStateException);
                                        }
                                    }
                                    object = o;
                                }
                                authData = (AuthData)object;
                                try {
                                    try {
                                        try {
                                            bl = this.mySavePassword;
                                            bl2 = authData.mySavePassword;
                                            if (nArray != null) break block29;
                                            if (bl != bl2) break block30;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw AuthData.a(illegalStateException);
                                        }
                                        bl = this.mySavePassphrase;
                                        if (nArray != null) break block31;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw AuthData.a(illegalStateException);
                                    }
                                    bl2 = authData.mySavePassphrase;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw AuthData.a(illegalStateException);
                                }
                            }
                            try {
                                if (bl != bl2) break block30;
                                bl = Objects.equals(this.myPassword, authData.myPassword);
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                        }
                        try {
                            try {
                                if (nArray != null) break block32;
                                if (!bl) break block30;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                            bl = Objects.equals(this.myPassphrase, authData.myPassphrase);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                    }
                    try {
                        if (nArray != null) break block33;
                        if (!bl) break block30;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw AuthData.a(illegalStateException);
                    }
                    bl = true;
                    break block33;
                }
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return Objects.hash(this.getPassword(), this.isSavePassword(), this.getPassphrase(), this.isSavePassphrase());
        }

        public String getPassword() {
            return this.myPassword;
        }

        public void setPassword(String password) {
            this.myPassword = password;
        }

        public boolean isSavePassword() {
            return this.mySavePassword;
        }

        public void setSavePassword(boolean savePassword) {
            this.mySavePassword = savePassword;
        }

        public String getPassphrase() {
            return this.myPassphrase;
        }

        public void setPassphrase(String passphrase) {
            this.myPassphrase = passphrase;
        }

        public boolean isSavePassphrase() {
            return this.mySavePassphrase;
        }

        public void setSavePassphrase(boolean savePassphrase) {
            this.mySavePassphrase = savePassphrase;
        }

        public AuthData clone() {
            try {
                return (AuthData)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        /*
         * Exception decompiling
         */
        public boolean hasNoCredentials(@NotNull AuthType authType, @NotNull String keyPath) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @NotNull
        public static AuthData create(@Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase) {
            AuthData authData;
            block5: {
                int n;
                block4: {
                    long l = a ^ 0x5C360253A97DL;
                    AuthData authData2 = new AuthData();
                    int[] nArray = SshConfig.t();
                    authData2.setPassword(password);
                    authData2.setSavePassword(savePassword);
                    int[] nArray2 = nArray;
                    try {
                        try {
                            authData2.setPassphrase(passphrase);
                            authData = authData2;
                            n = savePassphrase;
                            if (nArray2 != null) break block4;
                            authData.setSavePassphrase(n != 0);
                            authData = authData2;
                            if (authData != null) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        n = 2;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw AuthData.a(illegalStateException);
                    }
                }
                AuthData.$$$reportNull$$$0(n);
            }
            return authData;
        }

        @NotNull
        public static AuthData create(@NotNull RemoteCredentials credentials) {
            RemoteCredentials remoteCredentials;
            block4: {
                block5: {
                    long l = a ^ 0x7504E1EC03EBL;
                    int[] nArray = SshConfig.t();
                    try {
                        try {
                            remoteCredentials = credentials;
                            if (nArray != null) break block4;
                            if (remoteCredentials != null) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        AuthData.$$$reportNull$$$0(3);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw AuthData.a(illegalStateException);
                    }
                }
                remoteCredentials = credentials;
            }
            return AuthData.create(remoteCredentials.getPassword(), credentials.getPassphrase(), credentials.isStorePassword(), credentials.isStorePassphrase());
        }

        /*
         * Exception decompiling
         */
        @NotNull
        public static AuthData create(@NotNull AuthType authType, @Nullable Credentials credentials, boolean saveCredentialsInPermanentStore) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void $$$reportNull$$$0(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Unable to fully structure code
         */
        static {
            block11: {
                block10: {
                    AuthData.a = com.jetbrains.gateway.ssh.deploy.e.a(3729150372271690898L, -716101867319046633L, MethodHandles.lookup().lookupClass()).a(200555403502381L);
                    AuthData.d = new HashMap<K, V>(13);
                    var0 = AuthData.a ^ 57813496047667L;
                    var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                    v0 = SecretKeyFactory.getInstance("DES");
                    v1 = new byte[8];
                    v2 = v1;
                    v1[0] = (byte)(var0 >>> 56);
                    for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                        v2 = v2;
                        v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                    }
                    var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                    var9_3 = new String[10];
                    var7_4 = 0;
                    var6_5 = "u\u00f6\u0081K\u0010z\u0089\u00db\u0018\")\u00b0\u00d4\u00cc\u0090'M\u0095\u0095\u00af\u00de\u00fb7b\u00b4\u008f\u00a8P\u00c1\u000b\t\u00bdPm\u00d0\u00c2\b\u00bdg\u00f9\u00ec\u00efV\u009d\u001d\u00d1\u00b6\u0015T\u0000B$\u00bd.Z\u00f2\u00bb\n\u0017\u00b7S\u001b-\u00e0G\u00d5I:I\u00dejZ\u00f8{\u00db<\u00d1\u0081\f\u00d6\u0016\u00d8U\u00f4@3O\u00fc\u00b0ZoH\u001d\u0091\u00191\u00ef\u0093\u008c;\u0088p\u0088\u00a5H]\u00c4\u0096\u00d6c\u0081\u00b2R\u00fb\u0091\u00d9\u00c3\u00e57\u000b1\u0085\u00b7\u0099\u00a1\u00842\u00f6\u00e5]\u00d6\u0017\u009c\u0010\u00a5\u00f2x\u0094q+\u00e1C\u00ca\u00be\u00a7k\u0083\u00d4G'\u0006\u0004*\u009a\u00bb\u000b\u00c6h\u00ec\u008aH\u00a0~\u00ae\u0080\u00c7\u009byE\u0017\u00c4\u00eb\u00b1r\u00fd\"\u001a\u0018\u00f0\u00f0\u00c3Fp\u00a7\u00c3\u00cf_7\u0010\u00a0\u0018#(\u00d9_\u00c1\u00cd\u00a0\u009b1\u00df\u0013\u0010\u001b\u00f6\u0091b\u0085\u00f5\u00de\u00ac4\u00bd[\u00d8H\u00e3O\u008fX\u009c3\u00d3\u00b8\u0080\u00c5\u00cc\u00f2\u00ee\u00b2?\u0087H\u00ddU-\u0015\u0011/\u0003r\u0086\u00a3\u00b2R\u00ce\u00a9k-&\u000fV\u009e\u0002Q\u008d\u0098\u00c9j\u00ec\u00ed_\u00c9\u00e8\u009f9h\u00b8'\u00e5\u00a8\u0015\u00b5+\u00e6\u009d\u00d75S\u0014\u0000\u0018SeN\u00c7\u001a\u00a4\u00eeT\u00deR\u00ab\u0085\u00bc\u000b\u00e6\u00f4\u00c6d\u007f\u0088\u00ae\u00f6\u0012\u00da\u0082\u0096 \u00f5\"\u00d3\u00d2\u0090,?o\u0086\u0007>^\u009b2\u0000dQ\u00a2\n\u0002\u0092\u00d7{\u00a5\u00dc\u00c0j\u00d2T\u00e0\u0010+XQ\u0082\u00d1\u00f6\u00e4x!1\u00be\u0099\u00f0\u00df\u00b7v:\u00efG9\u00afQ\u00a7\u00f0a\u00een \u00b0\u00ff\u0091\u001b\u00abe]=\u00e3\u009e\u00f1\u0011\u0085!\u000e\u00d4\u00ea\u00ee\u00d3i\u0090\u001d\u00f3\u000b\u00d7FA\u00c6\u00f4\u00ac\u00bf\u008d\u00eb\u00f7),\u000b\u0081\u00bb\u008aR\u00f8\u00a2\u00b8\u0015{\u00b3\u00ea\u008a\u009f/\u0095\u00d2\u00d9\u009f\u0016{[\u00171\u009b\u00c3\u0010\u00c4\u00a4L\u00c7\r\u0081\u0083\n\u00d8\u00a8\u00d2/\u0004w\u00e1L";
                    var8_6 = "u\u00f6\u0081K\u0010z\u0089\u00db\u0018\")\u00b0\u00d4\u00cc\u0090'M\u0095\u0095\u00af\u00de\u00fb7b\u00b4\u008f\u00a8P\u00c1\u000b\t\u00bdPm\u00d0\u00c2\b\u00bdg\u00f9\u00ec\u00efV\u009d\u001d\u00d1\u00b6\u0015T\u0000B$\u00bd.Z\u00f2\u00bb\n\u0017\u00b7S\u001b-\u00e0G\u00d5I:I\u00dejZ\u00f8{\u00db<\u00d1\u0081\f\u00d6\u0016\u00d8U\u00f4@3O\u00fc\u00b0ZoH\u001d\u0091\u00191\u00ef\u0093\u008c;\u0088p\u0088\u00a5H]\u00c4\u0096\u00d6c\u0081\u00b2R\u00fb\u0091\u00d9\u00c3\u00e57\u000b1\u0085\u00b7\u0099\u00a1\u00842\u00f6\u00e5]\u00d6\u0017\u009c\u0010\u00a5\u00f2x\u0094q+\u00e1C\u00ca\u00be\u00a7k\u0083\u00d4G'\u0006\u0004*\u009a\u00bb\u000b\u00c6h\u00ec\u008aH\u00a0~\u00ae\u0080\u00c7\u009byE\u0017\u00c4\u00eb\u00b1r\u00fd\"\u001a\u0018\u00f0\u00f0\u00c3Fp\u00a7\u00c3\u00cf_7\u0010\u00a0\u0018#(\u00d9_\u00c1\u00cd\u00a0\u009b1\u00df\u0013\u0010\u001b\u00f6\u0091b\u0085\u00f5\u00de\u00ac4\u00bd[\u00d8H\u00e3O\u008fX\u009c3\u00d3\u00b8\u0080\u00c5\u00cc\u00f2\u00ee\u00b2?\u0087H\u00ddU-\u0015\u0011/\u0003r\u0086\u00a3\u00b2R\u00ce\u00a9k-&\u000fV\u009e\u0002Q\u008d\u0098\u00c9j\u00ec\u00ed_\u00c9\u00e8\u009f9h\u00b8'\u00e5\u00a8\u0015\u00b5+\u00e6\u009d\u00d75S\u0014\u0000\u0018SeN\u00c7\u001a\u00a4\u00eeT\u00deR\u00ab\u0085\u00bc\u000b\u00e6\u00f4\u00c6d\u007f\u0088\u00ae\u00f6\u0012\u00da\u0082\u0096 \u00f5\"\u00d3\u00d2\u0090,?o\u0086\u0007>^\u009b2\u0000dQ\u00a2\n\u0002\u0092\u00d7{\u00a5\u00dc\u00c0j\u00d2T\u00e0\u0010+XQ\u0082\u00d1\u00f6\u00e4x!1\u00be\u0099\u00f0\u00df\u00b7v:\u00efG9\u00afQ\u00a7\u00f0a\u00een \u00b0\u00ff\u0091\u001b\u00abe]=\u00e3\u009e\u00f1\u0011\u0085!\u000e\u00d4\u00ea\u00ee\u00d3i\u0090\u001d\u00f3\u000b\u00d7FA\u00c6\u00f4\u00ac\u00bf\u008d\u00eb\u00f7),\u000b\u0081\u00bb\u008aR\u00f8\u00a2\u00b8\u0015{\u00b3\u00ea\u008a\u009f/\u0095\u00d2\u00d9\u009f\u0016{[\u00171\u009b\u00c3\u0010\u00c4\u00a4L\u00c7\r\u0081\u0083\n\u00d8\u00a8\u00d2/\u0004w\u00e1L".length();
                    var5_7 = 104;
                    var4_8 = -1;
lbl20:
                    // 2 sources

                    while (true) {
                        v3 = ++var4_8;
                        v4 = var6_5.substring(v3, v3 + var5_7);
                        v5 = -1;
                        break block10;
                        break;
                    }
lbl25:
                    // 1 sources

                    while (true) {
                        var9_3[var7_4++] = AuthData.a(var10_9).intern();
                        if ((var4_8 += var5_7) < var8_6) {
                            var5_7 = var6_5.charAt(var4_8);
                            ** continue;
                        }
                        var6_5 = "\u00a8\u008c\u00fe\u00d2\u009b\u009aJ\u00f6\u00d0b\u0084Pw\u00f8\u009d\u008a\u00b4\u00c5\u00c1[\u001b\u000eF\u0005c \u0091\u009b\u00f8*\u00cf\u00dd\u008e2\r\u00c6w+\u0094\u0006\u0010\u00cf\u00f8\u008f\u00b9\u00bfJ\u0000\u000eft\f\u00b0\b\u00c7\u00ac\u009b";
                        var8_6 = "\u00a8\u008c\u00fe\u00d2\u009b\u009aJ\u00f6\u00d0b\u0084Pw\u00f8\u009d\u008a\u00b4\u00c5\u00c1[\u001b\u000eF\u0005c \u0091\u009b\u00f8*\u00cf\u00dd\u008e2\r\u00c6w+\u0094\u0006\u0010\u00cf\u00f8\u008f\u00b9\u00bfJ\u0000\u000eft\f\u00b0\b\u00c7\u00ac\u009b".length();
                        var5_7 = 40;
                        var4_8 = -1;
lbl34:
                        // 2 sources

                        while (true) {
                            v6 = ++var4_8;
                            v4 = var6_5.substring(v6, v6 + var5_7);
                            v5 = 0;
                            break block10;
                            break;
                        }
                        break;
                    }
lbl39:
                    // 1 sources

                    while (true) {
                        var9_3[var7_4++] = AuthData.a(var10_9).intern();
                        if ((var4_8 += var5_7) < var8_6) {
                            var5_7 = var6_5.charAt(var4_8);
                            ** continue;
                        }
                        break block11;
                        break;
                    }
                }
                var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                switch (v5) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl51:
                    // 1 sources

                    ** continue;
                }
            }
            AuthData.b = var9_3;
            AuthData.c = new String[10];
        }

        private static IllegalStateException a(IllegalStateException illegalStateException) {
            return illegalStateException;
        }

        private static String a(byte[] byArray) {
            int n = 0;
            int n2 = byArray.length;
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                char c2;
                int n3 = 0xFF & byArray[i];
                if (n3 < 192) {
                    cArray[n++] = (char)n3;
                    continue;
                }
                if (n3 < 224) {
                    c2 = (char)((char)(n3 & 0x1F) << 6);
                    n3 = byArray[++i];
                    c2 = (char)(c2 | (char)(n3 & 0x3F));
                    cArray[n++] = c2;
                    continue;
                }
                if (i >= n2 - 2) continue;
                c2 = (char)((char)(n3 & 0xF) << 12);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F));
                cArray[n++] = c2;
            }
            return new String(cArray, 0, n);
        }

        private static String a(int n, long l) {
            int n2 = n ^ (int)(l & 0x7FFFL) ^ 0xB0D;
            if (c[n2] == null) {
                Object[] objectArray;
                try {
                    Long l2 = Thread.currentThread().getId();
                    objectArray = (Object[])d.get(l2);
                    if (objectArray == null) {
                        objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                        d.put(l2, objectArray);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$AuthData", exception);
                }
                byte[] byArray = new byte[8];
                byArray[0] = (byte)(l >>> 56);
                for (int i = 1; i < 8; ++i) {
                    byArray[i] = (byte)(l << i * 8 >>> 56);
                }
                DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                byte[] byArray2 = b[n2].getBytes("ISO-8859-1");
                AuthData.c[n2] = AuthData.a(((Cipher)objectArray[0]).doFinal(byArray2));
            }
            return c[n2];
        }

        private static Object a(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
            int n = (Integer)objectArray[0];
            long l = (Long)objectArray[1];
            String string2 = AuthData.a(n, l);
            MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
            mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
            return string2;
        }

        private static CallSite a(MethodHandles.Lookup lookup, String string, MethodType methodType) {
            MutableCallSite mutableCallSite = new MutableCallSite(methodType);
            try {
                mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
            }
            catch (Exception exception) {
                throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$AuthData" + " : " + string + " : " + methodType.toString(), exception);
            }
            return mutableCallSite;
        }

        /*
         * Works around MethodHandle LDC.
         */
        static MethodHandle cfr_ldc_0() {
            try {
                return MethodHandles.lookup().findStatic(AuthData.class, "a", MethodType.fromMethodDescriptorString("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/invoke/MutableCallSite;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null));
            }
            catch (NoSuchMethodException | IllegalAccessException except) {
                throw new IllegalArgumentException(except);
            }
        }
    }
}

