/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonTokenSets;
import com.intellij.json.editor.JsonTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public JsonQuoteHandler() {
        super(JsonTokenSets.STRING_LITERALS);
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        IElementType tokenType;
        if (iterator == null) {
            JsonQuoteHandler.$$$reportNull$$$0(0);
        }
        if (offset == 0) {
            return null;
        }
        if (iterator.getStart() == offset) {
            iterator.retreat();
        }
        if ((tokenType = iterator.getTokenType()) != JsonElementTypes.SINGLE_QUOTED_STRING && tokenType != JsonElementTypes.DOUBLE_QUOTED_STRING) {
            return null;
        }
        if (offset != iterator.getStart() + 1) {
            return null;
        }
        if (JsonQuoteHandler.previousTokenIsValidEscapeSequence(iterator)) {
            return null;
        }
        if (tokenType == JsonElementTypes.DOUBLE_QUOTED_STRING) {
            return "\"";
        }
        return "'";
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        return super.isOpeningQuote(iterator, offset) && !JsonQuoteHandler.previousTokenIsValidEscapeSequence(iterator);
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull PsiFile file, @NotNull CharSequence closingQuote) {
        if (editor == null) {
            JsonQuoteHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JsonQuoteHandler.$$$reportNull$$$0(2);
        }
        if (closingQuote == null) {
            JsonQuoteHandler.$$$reportNull$$$0(3);
        }
        this.insertClosingQuote(editor, offset, closingQuote);
        JsonTypedHandler.processPairedBracesComma(closingQuote.charAt(0), editor, file);
    }

    private static boolean previousTokenIsValidEscapeSequence(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            JsonQuoteHandler.$$$reportNull$$$0(4);
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
            IElementType prev = iterator.getTokenType();
            if (prev == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingQuote";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/JsonQuoteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getClosingQuote";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insertClosingQuote";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "previousTokenIsValidEscapeSequence";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

