/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageCollectorBean;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/service/fus/collectors/UsageCollectors;", "", "<init>", "()V", "APPLICATION_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/internal/statistic/service/fus/collectors/UsageCollectorBean;", "PROJECT_EP_NAME", "COUNTER_EP_NAME", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsageCollectorEP;", "getApplicationCollectors", "", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "invoker", "Lcom/intellij/internal/statistic/service/fus/collectors/UsagesCollectorConsumer;", "allowedOnStartupOnly", "", "getApplicationCollectors$intellij_platform_statistics", "getAllApplicationCollectors", "getProjectCollectors", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "getProjectCollectors$intellij_platform_statistics", "isValidCollector", "item", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "isCalledFromPlugin", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class UsageCollectors {
    @NotNull
    public static final UsageCollectors INSTANCE = new UsageCollectors();
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final ExtensionPointName<UsageCollectorBean> APPLICATION_EP_NAME = new ExtensionPointName("com.intellij.statistics.applicationUsagesCollector");
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final ExtensionPointName<UsageCollectorBean> PROJECT_EP_NAME = new ExtensionPointName("com.intellij.statistics.projectUsagesCollector");
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final ExtensionPointName<CounterUsageCollectorEP> COUNTER_EP_NAME = new ExtensionPointName("com.intellij.statistics.counterUsagesCollector");

    private UsageCollectors() {
    }

    @NotNull
    public final Collection<ApplicationUsagesCollector> getApplicationCollectors$intellij_platform_statistics(@NotNull UsagesCollectorConsumer invoker, boolean allowedOnStartupOnly) {
        Intrinsics.checkNotNullParameter((Object)invoker, (String)"invoker");
        if (this.isCalledFromPlugin(invoker)) {
            return CollectionsKt.emptyList();
        }
        if (!allowedOnStartupOnly) {
            return this.getAllApplicationCollectors();
        }
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)APPLICATION_EP_NAME.getExtensionList()), UsageCollectors::getApplicationCollectors$lambda$0), UsageCollectors::getApplicationCollectors$lambda$1), UsageCollectors::getApplicationCollectors$lambda$2));
    }

    private final Collection<ApplicationUsagesCollector> getAllApplicationCollectors() {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)APPLICATION_EP_NAME.getExtensionList()), UsageCollectors::getAllApplicationCollectors$lambda$0), UsageCollectors::getAllApplicationCollectors$lambda$1));
    }

    @NotNull
    public final Collection<ProjectUsagesCollector> getProjectCollectors$intellij_platform_statistics(@NotNull UsagesCollectorConsumer invoker) {
        Intrinsics.checkNotNullParameter((Object)invoker, (String)"invoker");
        if (this.isCalledFromPlugin(invoker)) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)PROJECT_EP_NAME.getExtensionList()), UsageCollectors::getProjectCollectors$lambda$0), UsageCollectors::getProjectCollectors$lambda$1));
    }

    private final boolean isValidCollector(FeatureUsagesCollector item) {
        boolean valid = item.isValid();
        if (!valid) {
            Logger.getInstance(UsageCollectors.class).info(item + " is !valid -> skipped from extension points list");
        }
        return valid;
    }

    private final boolean isCalledFromPlugin(UsagesCollectorConsumer invoker) {
        return invoker.getClass().getClassLoader() instanceof PluginAwareClassLoader;
    }

    private static final boolean getApplicationCollectors$lambda$0(UsageCollectorBean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.allowOnStartup, (Object)true);
    }

    private static final ApplicationUsagesCollector getApplicationCollectors$lambda$1(UsageCollectorBean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FeatureUsagesCollector featureUsagesCollector = it.getCollector();
        Intrinsics.checkNotNull((Object)featureUsagesCollector, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector");
        return (ApplicationUsagesCollector)featureUsagesCollector;
    }

    private static final boolean getApplicationCollectors$lambda$2(ApplicationUsagesCollector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.isValidCollector(it);
    }

    private static final ApplicationUsagesCollector getAllApplicationCollectors$lambda$0(UsageCollectorBean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FeatureUsagesCollector featureUsagesCollector = it.getCollector();
        Intrinsics.checkNotNull((Object)featureUsagesCollector, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector");
        return (ApplicationUsagesCollector)featureUsagesCollector;
    }

    private static final boolean getAllApplicationCollectors$lambda$1(ApplicationUsagesCollector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.isValidCollector(it);
    }

    private static final ProjectUsagesCollector getProjectCollectors$lambda$0(UsageCollectorBean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FeatureUsagesCollector featureUsagesCollector = it.getCollector();
        Intrinsics.checkNotNull((Object)featureUsagesCollector, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector");
        return (ProjectUsagesCollector)featureUsagesCollector;
    }

    private static final boolean getProjectCollectors$lambda$1(ProjectUsagesCollector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.isValidCollector(it);
    }
}

