/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/plugins/PluginCompatibilityUtils;", "", "<init>", "()V", "isLegacyPluginWithoutPlatformAliasDependencies", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "hasJavaOrPlatformAliasDependency", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginCompatibilityUtils {
    @NotNull
    public static final PluginCompatibilityUtils INSTANCE = new PluginCompatibilityUtils();

    private PluginCompatibilityUtils() {
    }

    public final boolean isLegacyPluginWithoutPlatformAliasDependencies(@NotNull IdeaPluginDescriptorImpl descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return !descriptor.isBundled() && descriptor.getPackagePrefix() == null && !descriptor.isImplementationDetail() && IdeaPluginDescriptorImplKt.getContentModules(descriptor).isEmpty() && descriptor.getModuleDependencies().getModules().isEmpty() && descriptor.getModuleDependencies().getPlugins().isEmpty() && !Intrinsics.areEqual((Object)descriptor.getPluginId(), (Object)PluginManagerCore.CORE_ID) && !Intrinsics.areEqual((Object)descriptor.getPluginId(), (Object)PluginManagerCore.JAVA_PLUGIN_ID) && !this.hasJavaOrPlatformAliasDependency(descriptor);
    }

    private final boolean hasJavaOrPlatformAliasDependency(IdeaPluginDescriptorImpl descriptor) {
        for (PluginDependency dependency : descriptor.getDependencies()) {
            PluginId dependencyPluginId = dependency.getPluginId();
            if (!Intrinsics.areEqual((Object)PluginManagerCore.JAVA_PLUGIN_ID, (Object)dependencyPluginId) && !Intrinsics.areEqual((Object)PluginManagerCore.JAVA_PLUGIN_ALIAS_ID, (Object)dependencyPluginId) && !PluginManagerCore.looksLikePlatformPluginAlias(dependencyPluginId)) continue;
            return true;
        }
        return false;
    }
}

