/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CharTable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeUtil {
    private static final Logger LOG = Logger.getInstance(ChangeUtil.class);

    public static void encodeInformation(@NotNull TreeElement element) {
        if (element == null) {
            ChangeUtil.$$$reportNull$$$0(0);
        }
        ChangeUtil.encodeInformation(element, element);
    }

    private static void encodeInformation(@NotNull TreeElement element, @NotNull ASTNode original) {
        if (element == null) {
            ChangeUtil.$$$reportNull$$$0(1);
        }
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(2);
        }
        DebugUtil.performPsiModification(null, () -> ChangeUtil.encodeInformation(element, original, new HashMap<Object, Object>()));
    }

    private static void encodeInformation(@NotNull TreeElement element, @NotNull ASTNode original, @NotNull Map<Object, Object> state2) {
        if (element == null) {
            ChangeUtil.$$$reportNull$$$0(3);
        }
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(4);
        }
        if (state2 == null) {
            ChangeUtil.$$$reportNull$$$0(5);
        }
        for (TreeCopyHandler handler : TreeCopyHandler.EP_NAME.getExtensionList()) {
            try {
                handler.encodeInformation(element, original, state2);
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        }
        if (original instanceof CompositeElement) {
            TreeElement child = element.getFirstChildNode();
            ASTNode child1 = original.getFirstChildNode();
            while (child != null) {
                ChangeUtil.encodeInformation(child, child1, state2);
                child = child.getTreeNext();
                child1 = child1.getTreeNext();
            }
        }
    }

    @NotNull
    public static TreeElement decodeInformation(@NotNull TreeElement element) {
        if (element == null) {
            ChangeUtil.$$$reportNull$$$0(6);
        }
        TreeElement treeElement = (TreeElement)DebugUtil.performPsiModification(null, () -> ChangeUtil.decodeInformation(element, new HashMap<Object, Object>()));
        if (treeElement == null) {
            ChangeUtil.$$$reportNull$$$0(7);
        }
        return treeElement;
    }

    @NotNull
    private static TreeElement decodeInformation(@NotNull TreeElement element, @NotNull Map<Object, Object> state2) {
        if (element == null) {
            ChangeUtil.$$$reportNull$$$0(8);
        }
        if (state2 == null) {
            ChangeUtil.$$$reportNull$$$0(9);
        }
        for (TreeElement child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = ChangeUtil.decodeInformation(child, state2);
        }
        for (TreeCopyHandler handler : TreeCopyHandler.EP_NAME.getExtensionList()) {
            TreeElement treeElement = handler.decodeInformation(element, state2);
            if (treeElement == null) continue;
            TreeElement treeElement2 = treeElement;
            if (treeElement2 == null) {
                ChangeUtil.$$$reportNull$$$0(10);
            }
            return treeElement2;
        }
        TreeElement treeElement = element;
        if (treeElement == null) {
            ChangeUtil.$$$reportNull$$$0(11);
        }
        return treeElement;
    }

    @NotNull
    public static LeafElement copyLeafWithText(@NotNull LeafElement original, @NotNull String text) {
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(12);
        }
        if (text == null) {
            ChangeUtil.$$$reportNull$$$0(13);
        }
        LeafElement element = ASTFactory.leaf(original.getElementType(), text);
        original.copyCopyableDataTo(element);
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        LeafElement leafElement = element;
        if (leafElement == null) {
            ChangeUtil.$$$reportNull$$$0(14);
        }
        return leafElement;
    }

    @NotNull
    public static TreeElement copyElement(@NotNull TreeElement original, @Nullable CharTable table) {
        CompositeElement treeParent;
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(15);
        }
        return ChangeUtil.copyElement(original, (treeParent = original.getTreeParent()) == null ? null : treeParent.getPsi(), table);
    }

    @NotNull
    public static TreeElement copyElement(@NotNull TreeElement original, @Nullable PsiElement context, @Nullable CharTable table) {
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(16);
        }
        TreeElement element = (TreeElement)original.clone();
        PsiManagerEx manager = original.getManager();
        DummyHolderFactory.createHolder(manager, element, context, table).getTreeElement();
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        TreeElement treeElement = element;
        if (treeElement == null) {
            ChangeUtil.$$$reportNull$$$0(17);
        }
        return treeElement;
    }

    private static void saveIndentationToCopy(@Nullable TreeElement original, @Nullable TreeElement element) {
        if (original == null || element == null || CodeEditUtil.isNodeGenerated(original)) {
            return;
        }
        int indentation = CodeEditUtil.getOldIndentation(original);
        if (indentation < 0) {
            CodeEditUtil.saveWhitespacesInfo(original);
        }
        CodeEditUtil.setOldIndentation(element, CodeEditUtil.getOldIndentation(original));
        if (indentation < 0) {
            CodeEditUtil.setOldIndentation(original, -1);
        }
    }

    @NotNull
    public static TreeElement copyToElement(@NotNull PsiElement original) {
        DummyHolder holder;
        FileElement holderElement;
        TreeElement treeElement;
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(18);
        }
        LOG.assertTrue((treeElement = ChangeUtil.generateTreeElement(original, (holderElement = (holder = DummyHolderFactory.createHolder(original.getManager(), null, original.getLanguage())).getTreeElement()).getCharTable(), original.getManager())) != null, (Object)("original element class: " + original.getClass().getName() + ", language: " + original.getLanguage()));
        holderElement.rawAddChildren(treeElement);
        TreeUtil.clearCaches(holderElement);
        ChangeUtil.saveIndentationToCopy((TreeElement)original.getNode(), treeElement);
        TreeElement treeElement2 = treeElement;
        if (treeElement2 == null) {
            ChangeUtil.$$$reportNull$$$0(19);
        }
        return treeElement2;
    }

    @Nullable
    public static TreeElement generateTreeElement(@Nullable PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (table == null) {
            ChangeUtil.$$$reportNull$$$0(20);
        }
        if (manager == null) {
            ChangeUtil.$$$reportNull$$$0(21);
        }
        if (original == null) {
            return null;
        }
        PsiUtilCore.ensureValid((PsiElement)original);
        if (SourceTreeToPsiMap.hasTreeElement(original)) {
            return ChangeUtil.copyElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(original), table);
        }
        return TreeGenerator.EP_NAME.getExtensionList().stream().map(generator -> generator.generateTreeFor(original, table, manager)).filter(Predicates.nonNull()).findFirst().orElse(null);
    }

    public static void prepareAndRunChangeAction(final @NotNull ChangeAction action2, final @NotNull TreeElement changedElement) {
        if (action2 == null) {
            ChangeUtil.$$$reportNull$$$0(22);
        }
        if (changedElement == null) {
            ChangeUtil.$$$reportNull$$$0(23);
        }
        final FileElement changedFile = TreeUtil.getFileElement(changedElement);
        PsiManagerEx manager = changedFile.getManager();
        final PomModel model = PomManager.getModel((Project)manager.getProject());
        model.runTransaction((PomTransaction)new PomTransactionBase(changedElement.getPsi()){

            @NotNull
            public PomModelEvent runInner() {
                TreeChangeEventImpl destinationTreeChange = new TreeChangeEventImpl(model.getModelAspect(TreeAspect.class), changedFile);
                PomModelEvent event = new PomModelEvent(model, (PomChangeSet)destinationTreeChange);
                action2.makeChange(destinationTreeChange);
                changedElement.clearCaches();
                if (changedElement instanceof CompositeElement) {
                    ((CompositeElement)changedElement).subtreeChanged();
                }
                PomModelEvent pomModelEvent = event;
                if (pomModelEvent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pomModelEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/ChangeUtil$1", "runInner"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/ChangeUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/ChangeUtil";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeInformation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyLeafWithText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "encodeInformation";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "decodeInformation";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyLeafWithText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyToElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generateTreeElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "prepareAndRunChangeAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ChangeAction {
        public void makeChange(@NotNull TreeChangeEvent var1);
    }
}

