/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.GroupedComboBoxRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FontFamilyCombo
extends AbstractFontCombo<MyFontItem> {
    public static final int ITEM_WIDTH = 230;
    private final boolean myIsPrimary;

    FontFamilyCombo(boolean isPrimary) {
        super(new MyModel(!isPrimary));
        this.setSwingPopup(false);
        this.myIsPrimary = isPrimary;
        ClientProperty.put((JComponent)((Object)this), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        this.setRenderer(new GroupedComboBoxRenderer<MyFontItem>((JComponent)((Object)this)){

            @Override
            public void customize(@NotNull SimpleColoredComponent item, MyFontItem value, int index, boolean isSelected, boolean hasFocus) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value != null) {
                    if (value instanceof MyWarningItem) {
                        item.append(value.getFamilyName(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                        return;
                    }
                    SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (index > -1 && value.myFont != null) {
                        if (value.myFontCanDisplayName) {
                            item.setFont(value.myFont);
                        } else if (FontFamilyCombo.this.myIsPrimary) {
                            attributes = SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
                        }
                    } else {
                        item.setFont((Font)JBUI.Fonts.label());
                    }
                    item.append(value.getFamilyName(), attributes);
                }
            }

            @Override
            @Nullable
            public ListSeparator separatorFor(MyFontItem value) {
                ComboBoxModel comboBoxModel = FontFamilyCombo.this.getModel();
                if (comboBoxModel instanceof MyModel) {
                    MyModel m = (MyModel)comboBoxModel;
                    if (!m.myItems.isEmpty() && ContainerUtil.find(m.myItems, item -> item.myIsMonospaced) == value) {
                        return new ListSeparator(ApplicationBundle.message((String)"settings.editor.font.monospaced", (Object[])new Object[0]));
                    }
                    if (!m.myItems.isEmpty() && ContainerUtil.find(m.myItems, item -> !item.myIsMonospaced && !(item instanceof MyNoFontItem)) == value) {
                        return new ListSeparator(ApplicationBundle.message((String)"settings.editor.font.proportional", (Object[])new Object[0]));
                    }
                }
                return null;
            }

            @Override
            public int getMaxWidth() {
                return 230;
            }

            @Override
            @NotNull
            public Component getListCellRendererComponent(@Nullable JList<? extends MyFontItem> list2, MyFontItem value, int index, boolean isSelected, boolean cellHasFocus) {
                final Component component2 = super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
                if (index != -1 || !((MyModel)FontFamilyCombo.this.dataModel).isUpdating()) {
                    Component component3 = component2;
                    if (component3 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component3;
                }
                CellRendererPanel panel2 = new CellRendererPanel(new BorderLayout()){

                    public AccessibleContext getAccessibleContext() {
                        return component2.getAccessibleContext();
                    }
                };
                component2.setBackground(null);
                panel2.add(component2, "Center");
                JBLabel progressIcon = new JBLabel((Icon)AnimatedIcon.Default.INSTANCE);
                panel2.add((Component)progressIcon, "East");
                CellRendererPanel cellRendererPanel = panel2;
                if (cellRendererPanel == null) {
                    1.$$$reportNull$$$0(2);
                }
                return cellRendererPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getListCellRendererComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "customize";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    @Override
    @NlsSafe
    @Nullable
    public String getFontName() {
        Object selectedItem = this.getModel().getSelectedItem();
        return selectedItem instanceof MyFontItem ? ((MyFontItem)selectedItem).getFamilyName() : null;
    }

    @Override
    public void setFontName(@NlsSafe @Nullable String fontName) {
        this.getModel().setSelectedItem(fontName);
    }

    @Override
    public boolean isNoFontSelected() {
        return this.getModel().getSelectedItem() instanceof MyNoFontItem;
    }

    @Override
    public void setMonospacedOnly(boolean isMonospacedOnly) {
    }

    @Override
    public boolean isMonospacedOnly() {
        return false;
    }

    @Override
    public boolean isMonospacedOnlySupported() {
        return false;
    }

    private static final class MyModel
    extends AbstractListModel<MyFontItem>
    implements ComboBoxModel<MyFontItem> {
        private static final String[] KNOWN_MONOSPACED_FAMILIES = new String[]{"Consolas", "DejaVu Sans Mono", "Droid Sans Mono", "JetBrains Mono", "Fira Code", "Inconsolata", "Menlo", "Monospaced", "Source Code Pro"};
        private boolean myIsUpdating = true;
        private final Set<String> myMonospacedFamilies = new HashSet<String>();
        private final List<MyFontItem> myItems = new ArrayList<MyFontItem>();
        @Nullable
        private final MyNoFontItem myNoFontItem;
        @Nullable
        private MyFontItem mySelectedItem;

        private MyModel(boolean withNoneItem) {
            this.myMonospacedFamilies.addAll(Arrays.asList(KNOWN_MONOSPACED_FAMILIES));
            if (withNoneItem) {
                this.myNoFontItem = new MyNoFontItem();
                this.myItems.add(this.myNoFontItem);
            } else {
                this.myNoFontItem = null;
            }
            FontFamilyService.getAvailableFamilies().forEach(name2 -> this.myItems.add(new MyFontItem((String)name2, this.myMonospacedFamilies.contains(name2))));
            Collections.sort(this.myItems, new MyFontItemComparator());
            this.retrieveFontInfo();
        }

        public boolean isUpdating() {
            return this.myIsUpdating;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == null) {
                this.mySelectedItem = this.myNoFontItem;
            } else if (anItem instanceof String) {
                this.mySelectedItem = (MyFontItem)ContainerUtil.find(this.myItems, item -> item.isSelectable() && item.myFamilyName.equals(anItem));
                if (this.mySelectedItem == null) {
                    this.mySelectedItem = new MyWarningItem((String)anItem);
                }
            } else if (anItem instanceof MyFontItem) {
                this.mySelectedItem = (MyFontItem)anItem;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        @Nullable
        public MyFontItem getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public int getSize() {
            return this.myItems.size();
        }

        @Override
        public MyFontItem getElementAt(int index) {
            return this.myItems.get(index);
        }

        private void retrieveFontInfo() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (MyFontItem item : this.myItems) {
                    if (FontFamilyService.isMonospaced((String)item.myFamilyName)) {
                        this.myMonospacedFamilies.add(item.myFamilyName);
                    }
                    item.myFont = JBUI.Fonts.create((String)item.myFamilyName, (int)FontPreferences.DEFAULT_FONT_SIZE);
                    item.myFontCanDisplayName = item.myFont.canDisplayUpTo(item.myFamilyName) == -1;
                }
                this.updateMonospacedInfo();
            });
        }

        private void updateMonospacedInfo() {
            ApplicationManager.getApplication().invokeLater(() -> {
                for (MyFontItem item2 : this.myItems) {
                    item2.myIsMonospaced = this.myMonospacedFamilies.contains(item2.myFamilyName);
                }
                if (this.myNoFontItem == null) {
                    this.myItems.removeIf(item -> !item.myFontCanDisplayName);
                }
                this.myIsUpdating = false;
                Collections.sort(this.myItems, new MyFontItemComparator());
                this.fireContentsChanged(this, -1, -1);
            }, ModalityState.any());
        }
    }

    protected static class MyFontItem {
        @NotNull
        private final String myFamilyName;
        private boolean myIsMonospaced;
        private boolean myFontCanDisplayName;
        @Nullable
        private Font myFont;

        public MyFontItem(@NotNull String familyName, boolean isMonospaced) {
            if (familyName == null) {
                MyFontItem.$$$reportNull$$$0(0);
            }
            this.myFamilyName = familyName;
            this.myIsMonospaced = isMonospaced;
        }

        public String toString() {
            return this.myFamilyName;
        }

        @NlsSafe
        @NotNull
        public String getFamilyName() {
            String string = this.myFamilyName;
            if (string == null) {
                MyFontItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSelectable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyFontItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyFontItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyNoFontItem
    extends MyFontItem {
        private MyNoFontItem() {
            super("<None>", false);
        }
    }

    private static final class MyFontItemComparator
    implements Comparator<MyFontItem> {
        private MyFontItemComparator() {
        }

        @Override
        public int compare(MyFontItem item1, MyFontItem item2) {
            if (item1 instanceof MyNoFontItem) {
                return -1;
            }
            if (item2 instanceof MyNoFontItem) {
                return 1;
            }
            if (item1.myIsMonospaced && !item2.myIsMonospaced) {
                return -1;
            }
            if (!item1.myIsMonospaced && item2.myIsMonospaced) {
                return 1;
            }
            return item1.myFamilyName.compareTo(item2.myFamilyName);
        }

        @Override
        public boolean equals(Object obj2) {
            return false;
        }
    }

    private static final class MyWarningItem
    extends MyFontItem {
        private MyWarningItem(@NotNull String missingName) {
            if (missingName == null) {
                MyWarningItem.$$$reportNull$$$0(0);
            }
            super(ApplicationBundle.message((String)"settings.editor.font.missing.custom.font", (Object[])new Object[]{missingName}), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missingName", "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyWarningItem", "<init>"));
        }
    }
}

