/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.localConsents;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.gdpr.ConfirmedConsent;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.DataSharingLocalSettingsChangeListener;
import com.intellij.ide.gdpr.Version;
import com.intellij.ide.gdpr.localConsents.LocalConsentOptions;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001b\u0012\u0004\u0012\u00020\u00160\u001aJ&\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001b\u0012\u0004\u0012\u00020\u00160\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bJ\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020!2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020%0+H\u0002J\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001b2\b\u0010.\u001a\u0004\u0018\u00010!H\u0002J \u0010/\u001a\u001a\u0012\u0004\u0012\u00020!\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u000f0000H\u0002J\u0014\u00102\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020%00H\u0002J<\u00103\u001a\u00020\u00162\u001e\u00104\u001a\u001a\u0012\u0004\u0012\u00020!\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u000f00002\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020%00H\u0002J\b\u00106\u001a\u00020(H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u00067"}, d2={"Lcom/intellij/ide/gdpr/localConsents/LocalConsentOptions;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "backend", "Lcom/intellij/ide/gdpr/ConsentOptions$IOBackend;", "getBackend", "()Lcom/intellij/ide/gdpr/ConsentOptions$IOBackend;", "backend$delegate", "Lkotlin/Lazy;", "condTraceDataCollectionNonComLocalConsent", "Ljava/util/function/Predicate;", "Lcom/intellij/ide/gdpr/Consent;", "condTraceDataCollectionComLocalConsent", "getTraceDataCollectionNonComPermission", "Lcom/intellij/ide/gdpr/ConsentOptions$Permission;", "setTraceDataCollectionNonComPermission", "", "permitted", "", "getTraceDataCollectionComPermission", "setTraceDataCollectionComPermission", "getLocalConsents", "Lkotlin/Pair;", "", "filter", "setLocalConsents", "confirmedByUser", "getPermission", "localConsentId", "", "setPermission", "allowed", "getConfirmedLocalConsent", "Lcom/intellij/ide/gdpr/ConfirmedConsent;", "getDefaultLocalConsent", "getConfirmedLocalConsentsFile", "Ljava/nio/file/Path;", "confirmedLocalConsentsToExternalString", "consents", "", "fromJson", "Lcom/intellij/ide/gdpr/ConsentAttributes;", "json", "loadBundledLocalConsents", "", "Ljava/util/Locale;", "loadConfirmedLocalConsents", "needReconfirm", "defaults", "confirmed", "getConfirmedLocalConsentsFileForTests", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalConsentOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalConsentOptions.kt\ncom/intellij/ide/gdpr/localConsents/LocalConsentOptions\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n540#2:219\n525#2,6:220\n1021#3,2:226\n296#3,2:228\n*S KotlinDebug\n*F\n+ 1 LocalConsentOptions.kt\ncom/intellij/ide/gdpr/localConsents/LocalConsentOptions\n*L\n78#1:219\n78#1:220,6\n92#1:226,2\n177#1:228,2\n*E\n"})
public final class LocalConsentOptions {
    @NotNull
    public static final LocalConsentOptions INSTANCE = new LocalConsentOptions();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy backend$delegate;

    private LocalConsentOptions() {
    }

    private final ConsentOptions.IOBackend getBackend() {
        Lazy lazy = backend$delegate;
        return (ConsentOptions.IOBackend)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final Predicate<Consent> condTraceDataCollectionNonComLocalConsent() {
        return LocalConsentOptions::condTraceDataCollectionNonComLocalConsent$lambda$0;
    }

    @JvmStatic
    @NotNull
    public static final Predicate<Consent> condTraceDataCollectionComLocalConsent() {
        return LocalConsentOptions::condTraceDataCollectionComLocalConsent$lambda$0;
    }

    @NotNull
    public final ConsentOptions.Permission getTraceDataCollectionNonComPermission() {
        return this.getPermission("ai.trace.data.collection.and.use.noncom.policy");
    }

    public final void setTraceDataCollectionNonComPermission(boolean permitted) {
        this.setPermission("ai.trace.data.collection.and.use.noncom.policy", permitted);
    }

    @NotNull
    public final ConsentOptions.Permission getTraceDataCollectionComPermission() {
        return this.getPermission("ai.trace.data.collection.and.use.com.policy");
    }

    public final void setTraceDataCollectionComPermission(boolean permitted) {
        this.setPermission("ai.trace.data.collection.and.use.com.policy", permitted);
    }

    @NotNull
    public final Pair<List<Consent>, Boolean> getLocalConsents() {
        return this.getLocalConsents(LocalConsentOptions::getLocalConsents$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<List<Consent>, Boolean> getLocalConsents(@NotNull Predicate<Consent> filter2) {
        Object object;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Map<String, ConfirmedConsent> confirmed2 = this.loadConfirmedLocalConsents();
        List result2 = new ArrayList();
        Object $this$filter$iv = this.loadBundledLocalConsents();
        boolean $i$f$filter = false;
        Map<String, Map<Locale, Consent>> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            object = element$iv$iv;
            boolean bl = false;
            Map consents = (Map)object.getValue();
            Consent consent = (Consent)consents.get(ConsentOptions.getDefaultLocale());
            if (!(consent != null && filter2.test(consent))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map bundled = destination$iv$iv;
        $this$filter$iv = bundled.entrySet().iterator();
        while ($this$filter$iv.hasNext()) {
            Map localeMap = (Map)((Map.Entry)$this$filter$iv.next()).getValue();
            Consent base = (Consent)localeMap.get(ConsentOptions.getDefaultLocale());
            Consent localized = (Consent)localeMap.get(ConsentOptions.getCurrentLocale());
            if (base == null) continue;
            ConfirmedConsent confirmedLocalConsent = confirmed2.get(base.getId());
            Consent consent = localized;
            if (consent == null) {
                consent = base;
            }
            Consent localConsent = consent;
            ConfirmedConsent confirmedConsent = confirmedLocalConsent;
            object = confirmedConsent == null ? localConsent : localConsent.derive(confirmedConsent.isAccepted());
            Intrinsics.checkNotNull((Object)object);
            result2.add(object);
        }
        List $this$sortBy$iv = result2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Consent it = (Consent)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getId());
                    it = (Consent)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
                }
            });
        }
        boolean confirmationEnabled = Boolean.parseBoolean(System.getProperty("jb.consents.confirmation.enabled", "true")) && !AppMode.isRemoteDevHost();
        return new Pair((Object)result2, (Object)(confirmationEnabled && this.needReconfirm(bundled, confirmed2) ? 1 : 0));
    }

    public final void setLocalConsents(@NotNull List<Consent> confirmedByUser) {
        Intrinsics.checkNotNullParameter(confirmedByUser, (String)"confirmedByUser");
        if (confirmedByUser.isEmpty()) {
            return;
        }
        try {
            Map allAccepted = MapsKt.toMutableMap(this.loadConfirmedLocalConsents());
            long acceptanceTime = System.currentTimeMillis();
            for (Consent consent : confirmedByUser) {
                allAccepted.put(consent.getId(), new ConfirmedConsent(consent.getId(), Version.UNKNOWN, consent.isAccepted(), acceptanceTime));
            }
            this.getBackend().writeConfirmedConsents(this.confirmedLocalConsentsToExternalString(allAccepted.values()));
            ConsentOptions.updateConsentListeners();
        }
        catch (Exception e) {
            LOG.info("Unable to save local consents", (Throwable)e);
        }
    }

    private final ConsentOptions.Permission getPermission(String localConsentId) {
        ConfirmedConsent confirmedLocalConsent = this.getConfirmedLocalConsent(localConsentId);
        return confirmedLocalConsent == null ? ConsentOptions.Permission.UNDEFINED : (confirmedLocalConsent.isAccepted() ? ConsentOptions.Permission.YES : ConsentOptions.Permission.NO);
    }

    private final boolean setPermission(String localConsentId, boolean allowed) {
        Consent defLocalConsent = this.getDefaultLocalConsent(localConsentId);
        if (defLocalConsent != null) {
            this.setLocalConsents(CollectionsKt.listOf((Object)defLocalConsent.derive(allowed)));
            return true;
        }
        return false;
    }

    private final ConfirmedConsent getConfirmedLocalConsent(String localConsentId) {
        return this.loadConfirmedLocalConsents().get(localConsentId);
    }

    private final Consent getDefaultLocalConsent(String localConsentId) {
        Map<String, Map<Locale, Consent>> defaultLocalConsents = this.loadBundledLocalConsents();
        Map<Locale, Consent> map2 = defaultLocalConsents.get(localConsentId);
        if (map2 == null) {
            return null;
        }
        Map<Locale, Consent> localConsentMap = map2;
        Consent consent = localConsentMap.get(ConsentOptions.getDefaultLocale());
        if (consent == null) {
            consent = localConsentMap.get(ConsentOptions.getCurrentLocale());
        }
        return consent;
    }

    private final Path getConfirmedLocalConsentsFile() {
        Path path = PathManager.getCommonDataPath().resolve(ApplicationNamesInfo.getInstance().getLowercaseProductName()).resolve("localConsents/accepted");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final String confirmedLocalConsentsToExternalString(Collection<ConfirmedConsent> consents) {
        return CollectionsKt.joinToString$default((Iterable)consents, (CharSequence)";", null, null, (int)0, null, (Function1)confirmedLocalConsentsToExternalString.1.INSTANCE, (int)30, null);
    }

    private final List<ConsentAttributes> fromJson(String json) {
        Object object = json;
        if (object == null || object.length() == 0) {
            return CollectionsKt.emptyList();
        }
        try {
            object = ConsentAttributes.Companion.readListFromJson(json);
        }
        catch (Throwable e) {
            LOG.info(e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<Locale, Consent>> loadBundledLocalConsents() {
        Map result2 = new LinkedHashMap();
        List<ConsentAttributes> localizedAttributes = this.fromJson(this.getBackend().readLocalizedBundledConsents());
        for (ConsentAttributes attributes : this.fromJson(this.getBackend().readBundledConsents())) {
            Object v0;
            String attributesId;
            Map map2;
            block3: {
                void $this$firstOrNull$iv;
                if (attributes.consentId == null) continue;
                map2 = new LinkedHashMap();
                map2.put(ConsentOptions.getDefaultLocale(), new Consent(attributes));
                Iterable iterable = localizedAttributes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ConsentAttributes localizedAttributes2 = (ConsentAttributes)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)localizedAttributes2.consentId, (Object)attributesId)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            ConsentAttributes consentAttributes = v0;
            if (consentAttributes != null) {
                ConsentAttributes localizedAttr = consentAttributes;
                boolean bl = false;
                map2.put(ConsentOptions.getCurrentLocale(), new Consent(localizedAttr));
            }
            result2.put(attributesId, map2);
        }
        return result2;
    }

    private final Map<String, ConfirmedConsent> loadConfirmedLocalConsents() {
        Map result2 = new LinkedHashMap();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.getBackend().readConfirmedConsents(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                ConfirmedConsent confirmedLocalConsent = ConfirmedConsent.fromString(tokenizer.nextToken());
                if (confirmedLocalConsent == null) continue;
                result2.put(confirmedLocalConsent.getId(), confirmedLocalConsent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result2;
    }

    private final boolean needReconfirm(Map<String, ? extends Map<Locale, Consent>> defaults, Map<String, ConfirmedConsent> confirmed2) {
        for (Map<Locale, Consent> map2 : defaults.values()) {
            Consent defConsent;
            if (map2.get(ConsentOptions.getDefaultLocale()) == null) continue;
            if (confirmed2.get(defConsent.getId()) == null) {
                return true;
            }
            if (!Boolean.parseBoolean("test.force.reconfirm.consents")) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    @NotNull
    public final Path getConfirmedLocalConsentsFileForTests() {
        return this.getConfirmedLocalConsentsFile();
    }

    private static final backend.2.1 backend_delegate$lambda$0() {
        Path path = INSTANCE.getConfirmedLocalConsentsFile();
        return new ConsentOptions.IOBackendImpl(path){

            public void writeDefaultConsents(String data2) {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                throw new UnsupportedOperationException("There are no default local consents");
            }

            public String readDefaultConsents() {
                throw new UnsupportedOperationException("There are no default local consents");
            }

            public void writeConfirmedConsents(String data2) {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                super.writeConfirmedConsents(data2);
                if (LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                    ((DataSharingLocalSettingsChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DataSharingLocalSettingsChangeListener.TOPIC)).consentWritten();
                }
            }
        };
    }

    private static final boolean condTraceDataCollectionNonComLocalConsent$lambda$0(Consent localConsent) {
        Intrinsics.checkNotNullParameter((Object)localConsent, (String)"localConsent");
        return Intrinsics.areEqual((Object)"ai.trace.data.collection.and.use.noncom.policy", (Object)localConsent.getId());
    }

    private static final boolean condTraceDataCollectionComLocalConsent$lambda$0(Consent localConsent) {
        Intrinsics.checkNotNullParameter((Object)localConsent, (String)"localConsent");
        return Intrinsics.areEqual((Object)"ai.trace.data.collection.and.use.com.policy", (Object)localConsent.getId());
    }

    private static final boolean getLocalConsents$lambda$0(Consent consent) {
        Intrinsics.checkNotNullParameter((Object)consent, (String)"<unused var>");
        return true;
    }

    static {
        Logger logger2 = Logger.getInstance(LocalConsentOptions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        backend$delegate = LazyKt.lazy(LocalConsentOptions::backend_delegate$lambda$0);
    }
}

