/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.LookAndFeelThemeAdapter;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.segmentedActionBar.SegmentedActionToolbarComponent;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DarculaButtonUI
extends BasicButtonUI {
    final Rectangle viewRect = new Rectangle();
    final Rectangle textRect = new Rectangle();
    final Rectangle iconRect = new Rectangle();
    protected static JBValue HELP_BUTTON_DIAMETER = new JBValue.Float(22.0f);
    protected static JBValue HORIZONTAL_PADDING = new JBValue.Float(14.0f);
    public static final Key<Boolean> DEFAULT_STYLE_KEY = Key.create((String)"JButton.styleDefault");
    @ApiStatus.Internal
    public static final Key<Boolean> AVOID_EXTENDING_BORDER_GRAPHICS = Key.create((String)"JButton.avoidExtendingBorderGraphics");

    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c) {
        return c instanceof AbstractButton && "square".equals(((AbstractButton)c).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && (((JButton)c).isDefaultButton() || ComponentUtil.getClientProperty((JComponent)c, DEFAULT_STYLE_KEY) == Boolean.TRUE);
    }

    public static boolean isSmallVariant(Component c) {
        if (!(c instanceof AbstractButton)) {
            return false;
        }
        AbstractButton b = (AbstractButton)c;
        boolean smallVariant = b.getClientProperty("ActionToolbar.smallVariant") == Boolean.TRUE;
        ComboBoxAction a = (ComboBoxAction)b.getClientProperty("styleCombo");
        return smallVariant || a != null && a.isSmallVariant();
    }

    public static boolean isTag(Component c) {
        return c instanceof AbstractButton && ((AbstractButton)c).getClientProperty("styleTag") != null;
    }

    public static boolean isComboAction(Component c) {
        return c instanceof AbstractButton && ((JComponent)c).getClientProperty("styleCombo") != null;
    }

    public static boolean isGotItButton(Component c) {
        return c instanceof AbstractButton && ((JComponent)c).getClientProperty("gotItButton") == Boolean.TRUE;
    }

    public static boolean isContrastGotIt(Component c) {
        AbstractButton button2;
        return c instanceof AbstractButton && (button2 = (AbstractButton)c).getClientProperty("gotItButton.contrast") == Boolean.TRUE;
    }

    public static boolean isContrastGotItOnlyButton(Component c) {
        AbstractButton button2;
        return c instanceof AbstractButton && (button2 = (AbstractButton)c).getClientProperty("gotItButton.contrast.only.button") == Boolean.TRUE;
    }

    @Nullable
    static Insets getCustomButtonInsets(Component c) {
        if (!(c instanceof AbstractButton)) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        Object maybeInsets = b.getClientProperty("customButtonInsets");
        if (!(maybeInsets instanceof Insets)) {
            return null;
        }
        return (Insets)maybeInsets;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(this.textIconGap());
        b.setMargin((Insets)JBInsets.emptyInsets());
    }

    protected int textIconGap() {
        return JBUIScale.scale((int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean paintDecorations(Graphics2D g, JComponent c) {
        if (!((AbstractButton)c).isContentAreaFilled()) {
            return true;
        }
        Rectangle r = new Rectangle(c.getSize());
        if (SegmentedActionToolbarComponent.Companion.isCustomBar(c)) {
            return SegmentedActionToolbarComponent.Companion.paintButtonDecorations(g, c, this.getBackground(c, r));
        }
        JBInsets.removeFrom((Rectangle)r, (Insets)(DarculaButtonUI.isSmallVariant(c) || DarculaButtonUI.isGotItButton(c) ? c.getInsets() : JBUI.insets((int)1)));
        if (UIUtil.isHelpButton((Component)c)) {
            g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd()));
            int diam = HELP_BUTTON_DIAMETER.get();
            int x = r.x + (r.width - diam) / 2;
            int y = r.x + (r.height - diam) / 2;
            g.fill(new Ellipse2D.Float(x, y, diam, diam));
            AllIcons.Actions.Help.paintIcon(c, g, x + JBUIScale.scale((int)3), y + JBUIScale.scale((int)3));
            return false;
        }
        if (!c.isEnabled()) {
            return true;
        }
        InternalUICustomization service = InternalUICustomization.getInstance();
        Graphics2D g2 = (Graphics2D)(service != null ? service.transformButtonGraphics(g.create()) : g.create());
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float bw = DarculaButtonUI.isSmallVariant(c) || DarculaButtonUI.isGotItButton(c) ? 0.0f : DarculaUIUtil.BW.getFloat();
            float arc = DarculaButtonUI.isTag(c) ? (float)r.height - bw * 2.0f : DarculaUIUtil.BUTTON_ARC.getFloat();
            Paint paint = this.getBackground(c, r);
            if (paint != null) {
                if (!c.hasFocus() && !DarculaButtonUI.isSmallVariant(c) && UIManager.getBoolean("Button.paintShadow")) {
                    JBColor shadowColor = JBColor.namedColor((String)"Button.shadowColor", (Color)JBColor.namedColor((String)"Button.darcula.shadowColor", (Color)new JBColor(new Color(-1499027917, true), new Color(909522560, true))));
                    int shadowWidth = JBUIScale.scale((int)JBUI.getInt((String)"Button.shadowWidth", (int)2));
                    g2.setColor((Color)(DarculaButtonUI.isDefaultButton(c) ? JBColor.namedColor((String)"Button.default.shadowColor", (Color)shadowColor) : shadowColor));
                    g2.fill(new RoundRectangle2D.Float(bw, bw + (float)shadowWidth, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
                }
                Color outlineFocusColor = (Color)c.getClientProperty("JButton.outlineFocusColor");
                Integer outlineFocusSize = (Integer)c.getClientProperty("JButton.outlineFocusSize");
                if (outlineFocusColor != null && outlineFocusSize != null && c.hasFocus()) {
                    g2.setPaint(outlineFocusColor);
                    g2.fill(new RoundRectangle2D.Float(bw - (float)outlineFocusSize.intValue(), bw - (float)outlineFocusSize.intValue(), (float)r.width - bw * 2.0f + (float)(outlineFocusSize * 2), (float)r.height - bw * 2.0f + (float)(outlineFocusSize * 2), arc + (float)outlineFocusSize.intValue(), arc + (float)outlineFocusSize.intValue()));
                }
                g2.setPaint(paint);
                g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            }
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    protected Paint getBackground(JComponent c, Rectangle r) {
        Color backgroundColor = (Color)c.getClientProperty("JButton.backgroundColor");
        return backgroundColor != null ? backgroundColor : (DarculaButtonUI.isDefaultButton(c) ? this.getDefaultButtonPaint(c, r) : (DarculaButtonUI.isSmallVariant(c) ? JBColor.namedColor((String)"ComboBoxButton.background", (Color)JBColor.namedColor((String)"Button.darcula.smallComboButtonBackground", (Color)UIUtil.getPanelBackground())) : (DarculaButtonUI.isGotItButton(c) ? UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)DarculaButtonUI.getGotItButtonColorStart(c), (float)0.0f, (float)r.height, (Color)DarculaButtonUI.getGotItButtonColorEnd(c)) : this.getButtonPaint(c, r))));
    }

    private Paint getDefaultButtonPaint(JComponent c, Rectangle r) {
        Paint maybePaint;
        InternalUICustomization service = InternalUICustomization.getInstance();
        Paint paint = UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getDefaultButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getDefaultButtonColorEnd());
        if (service != null && (maybePaint = service.getCustomDefaultButtonFillPaint(c, r, paint)) != null) {
            paint = maybePaint;
        }
        return paint;
    }

    private Paint getButtonPaint(JComponent c, Rectangle r) {
        InternalUICustomization service = InternalUICustomization.getInstance();
        Paint paint = UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd());
        if (service != null) {
            return service.getCustomButtonFillPaint(c, r, paint);
        }
        return paint;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.paintDecorations((Graphics2D)g, c)) {
            this.paintContents(g, (AbstractButton)c);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text2) {
        if (UIUtil.isHelpButton((Component)c)) {
            return;
        }
        AbstractButton button2 = (AbstractButton)c;
        ButtonModel model2 = button2.getModel();
        g.setColor(this.getButtonTextColor(button2));
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)c, (Graphics)g);
        if (model2.isEnabled()) {
            UIUtilities.drawStringUnderlineCharAt((JComponent)c, (Graphics)g, (String)text2, (int)this.getMnemonicIndex(button2), (int)(textRect.x + this.getTextShiftOffset()), (int)(textRect.y + metrics.getAscent() + this.getTextShiftOffset()));
        } else {
            this.paintDisabledText(g, text2, c, textRect, metrics);
        }
    }

    protected int getMnemonicIndex(AbstractButton b) {
        return LookAndFeelThemeAdapter.isAltPressed() ? b.getDisplayedMnemonicIndex() : -1;
    }

    protected Color getButtonTextColor(AbstractButton button2) {
        Color textColor = (Color)button2.getClientProperty("JButton.textColor");
        return textColor != null ? textColor : DarculaUIUtil.getButtonTextColor(button2);
    }

    public static Color getDisabledTextColor() {
        return UIManager.getColor("Button.disabledText");
    }

    protected void paintDisabledText(Graphics g, String text2, JComponent c, Rectangle textRect, FontMetrics metrics) {
        g.setColor(UIManager.getColor("Button.disabledText"));
        UIUtilities.drawStringUnderlineCharAt((JComponent)c, (Graphics)g, (String)text2, (int)-1, (int)(textRect.x + this.getTextShiftOffset()), (int)(textRect.y + metrics.getAscent() + this.getTextShiftOffset()));
    }

    protected void paintContents(Graphics g, AbstractButton b) {
        if (b instanceof JBOptionButton) {
            return;
        }
        FontMetrics fm = UIUtilities.getFontMetrics((JComponent)b, (Graphics)g);
        boolean isDotButton = DarculaButtonUI.isSquare(b) && b.getIcon() == AllIcons.General.Ellipsis;
        @NlsSafe String text2 = isDotButton ? "..." : b.getText();
        Icon icon2 = isDotButton ? null : b.getIcon();
        text2 = this.layout(b, text2, icon2, fm, b.getWidth(), b.getHeight());
        if (DarculaButtonUI.isSquare(b)) {
            if (b.getIcon() == AllIcons.General.Ellipsis) {
                UISettings.setupAntialiasing((Graphics)g);
                this.paintText(g, b, this.textRect, text2);
            } else if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
        } else {
            if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
            if (text2 != null && !text2.isEmpty()) {
                View v = (View)b.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.textRect);
                } else {
                    UISettings.setupAntialiasing((Graphics)g);
                    this.paintText(g, b, this.textRect, text2);
                }
            }
        }
    }

    protected Dimension getDarculaButtonSize(JComponent c, Dimension prefSize) {
        Insets i2 = c.getInsets();
        prefSize = (Dimension)ObjectUtils.notNull((Object)prefSize, (Object)JBUI.emptySize());
        if (UIUtil.isHelpButton((Component)c) || DarculaButtonUI.isSquare(c)) {
            int helpDiam = HELP_BUTTON_DIAMETER.get();
            return new Dimension(Math.max(prefSize.width, helpDiam + i2.left + i2.right), Math.max(prefSize.height, helpDiam + i2.top + i2.bottom));
        }
        Dimension minimumSize = JBUI.CurrentTheme.Button.minimumSize();
        int width = DarculaButtonUI.isComboAction(c) ? prefSize.width : Math.max(HORIZONTAL_PADDING.get() * 2 + prefSize.width, minimumSize.width + i2.left + i2.right);
        int height = Math.max(prefSize.height, (DarculaButtonUI.isSmallVariant(c) ? ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height : JBUI.CurrentTheme.Button.minimumSize().height) + i2.top + i2.bottom);
        return new Dimension(width, height);
    }

    @Override
    public final Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        int textIconGap = StringUtil.isEmpty((String)b.getText()) || b.getIcon() == null ? 0 : b.getIconTextGap();
        Dimension size2 = BasicGraphicsUtils.getPreferredButtonSize(b, textIconGap);
        return this.getDarculaButtonSize(c, size2);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.setupDefaultButton(c, g);
        super.update(g, c);
    }

    protected void setupDefaultButton(JComponent button2, Graphics g) {
        Font f = button2.getFont();
        if (!SystemInfo.isMac && f instanceof FontUIResource && DarculaButtonUI.isDefaultButton(button2)) {
            g.setFont(f.deriveFont(1));
        }
    }

    protected Color getButtonColorStart() {
        return JBUI.CurrentTheme.Button.buttonColorStart();
    }

    protected Color getButtonColorEnd() {
        return JBUI.CurrentTheme.Button.buttonColorEnd();
    }

    protected Color getDefaultButtonColorStart() {
        return JBUI.CurrentTheme.Button.defaultButtonColorStart();
    }

    protected Color getDefaultButtonColorEnd() {
        return JBUI.CurrentTheme.Button.defaultButtonColorEnd();
    }

    private static Color getGotItButtonColorStart(Component c) {
        if (DarculaButtonUI.isContrastGotIt(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrast();
        }
        if (DarculaButtonUI.isContrastGotItOnlyButton(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrastOnlyButton();
        }
        return JBColor.namedColor((String)"GotItTooltip.Button.startBackground", (Color)JBUI.CurrentTheme.Button.buttonColorStart());
    }

    private static Color getGotItButtonColorEnd(Component c) {
        if (DarculaButtonUI.isContrastGotIt(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrast();
        }
        if (DarculaButtonUI.isContrastGotItOnlyButton(c)) {
            return JBUI.CurrentTheme.GotItTooltip.buttonBackgroundContrastOnlyButton();
        }
        return JBColor.namedColor((String)"GotItTooltip.Button.endBackground", (Color)JBUI.CurrentTheme.Button.buttonColorEnd());
    }

    String layout(AbstractButton b, @Nls String text2, Icon icon2, FontMetrics fm, int width, int height) {
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.viewRect.setBounds(0, 0, width, height);
        this.modifyViewRect(b, this.viewRect);
        return SwingUtilities.layoutCompoundLabel(b, fm, text2, icon2, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, StringUtil.isEmpty((String)text2) || icon2 == null ? 0 : b.getIconTextGap());
    }

    @ApiStatus.Internal
    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getInsets());
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getMargin());
    }
}

