/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.view.CharacterGrid;
import com.intellij.openapi.editor.impl.view.CharacterGridIterator;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.WrapElementMeasuringIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SoftWrapEngine {
    private static final int BASIC_LOOK_BACK_LENGTH = 10;
    private final EditorImpl myEditor;
    private final Document myDocument;
    private final CharSequence myText;
    private final EditorView myView;
    private final SoftWrapsStorage myStorage;
    private final CachingSoftWrapDataMapper myDataMapper;
    private final int myVisibleWidth;
    private final int myMaxWidthAtWrap;
    private final int mySoftWrapWidth;
    private final IncrementalCacheUpdateEvent myEvent;
    private final int myRelativeIndent;
    private LineWrapPositionStrategy myLineWrapPositionStrategy;

    public SoftWrapEngine(@NotNull EditorImpl editor2, @NotNull SoftWrapPainter painter, @NotNull SoftWrapsStorage storage, @NotNull CachingSoftWrapDataMapper dataMapper, @NotNull IncrementalCacheUpdateEvent event, @Nullable LineWrapPositionStrategy lineWrapStrategy, int visibleWidth, int relativeIndent) {
        if (editor2 == null) {
            SoftWrapEngine.$$$reportNull$$$0(0);
        }
        if (painter == null) {
            SoftWrapEngine.$$$reportNull$$$0(1);
        }
        if (storage == null) {
            SoftWrapEngine.$$$reportNull$$$0(2);
        }
        if (dataMapper == null) {
            SoftWrapEngine.$$$reportNull$$$0(3);
        }
        if (event == null) {
            SoftWrapEngine.$$$reportNull$$$0(4);
        }
        this.myEditor = editor2;
        this.myDocument = editor2.getDocument();
        this.myText = this.myDocument.getImmutableCharSequence();
        this.myView = editor2.myView;
        this.myStorage = storage;
        this.myDataMapper = dataMapper;
        this.myVisibleWidth = visibleWidth;
        this.myMaxWidthAtWrap = visibleWidth - painter.getMinDrawingWidth(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        this.mySoftWrapWidth = painter.getMinDrawingWidth(SoftWrapDrawingType.AFTER_SOFT_WRAP);
        this.myEvent = event;
        this.myRelativeIndent = relativeIndent;
        this.myLineWrapPositionStrategy = lineWrapStrategy;
    }

    public void generate() {
        int startOffset = this.myEvent.getStartOffset();
        int minEndOffset = this.myEvent.getMandatoryEndOffset();
        int maxEndOffset = this.getEndOffsetUpperEstimate();
        List<Inlay<?>> inlineInlays = this.myEditor.getInlayModel().getInlineElementsInRange(startOffset, maxEndOffset);
        List afterLineEndInlays = ContainerUtil.filter(this.myEditor.getInlayModel().getAfterLineEndElementsInRange(DocumentUtil.getLineStartOffset((int)startOffset, (Document)this.myDocument), maxEndOffset), inlay -> !inlay.getProperties().isSoftWrappingDisabled());
        CharacterGrid grid = this.myEditor.getCharacterGrid();
        if (grid != null && inlineInlays.isEmpty() && afterLineEndInlays.isEmpty()) {
            this.generateGridSoftWraps(grid, startOffset, minEndOffset, maxEndOffset);
            return;
        }
        SoftWrap lastSoftWrap = null;
        boolean minWrapOffsetAtFolding = false;
        int minWrapOffset = -1;
        int maxWrapOffset = -1;
        float nonWhitespaceStartX = 0.0f;
        int nonWhitespaceStartOffset = -1;
        float x = startOffset == 0 ? this.myView.getPrefixTextWidthInPixels() : ((lastSoftWrap = this.myStorage.getSoftWrap(startOffset)) == null ? 0.0f : (float)lastSoftWrap.getIndentInPixels());
        WrapElementMeasuringIterator it = new WrapElementMeasuringIterator(this.myView, startOffset, maxEndOffset, inlineInlays, afterLineEndInlays);
        while (!it.atEnd()) {
            if (it.isLineBreak()) {
                minWrapOffset = -1;
                maxWrapOffset = -1;
                x = 0.0f;
                lastSoftWrap = null;
                nonWhitespaceStartOffset = -1;
                if (it.getElementEndOffset() > minEndOffset) {
                    this.myEvent.setActualEndOffset(it.getElementEndOffset());
                    return;
                }
            } else {
                if (this.myRelativeIndent >= 0 && nonWhitespaceStartOffset == -1 && !it.isWhitespace()) {
                    nonWhitespaceStartX = x;
                    nonWhitespaceStartOffset = it.getElementStartOffset();
                }
                x = it.getElementEndX(x);
                if (minWrapOffset < 0 || x <= (float)this.myMaxWidthAtWrap && it.isFoldRegion()) {
                    minWrapOffset = it.getElementEndOffset();
                    minWrapOffsetAtFolding = it.isFoldRegion();
                } else {
                    if (x > (float)this.myMaxWidthAtWrap && maxWrapOffset < 0 && (maxWrapOffset = it.getElementStartOffset()) > minWrapOffset && it.isFoldRegion()) {
                        minWrapOffset = maxWrapOffset;
                    }
                    if (x > (float)this.myVisibleWidth) {
                        int wrapOffset = (lastSoftWrap = this.createSoftWrap(lastSoftWrap, minWrapOffset, maxWrapOffset, minWrapOffsetAtFolding, nonWhitespaceStartOffset, nonWhitespaceStartX)).getStart();
                        if (wrapOffset > minEndOffset && this.myDataMapper.matchesOldSoftWrap(lastSoftWrap, this.myEvent.getLengthDiff())) {
                            this.myEvent.setActualEndOffset(wrapOffset);
                            return;
                        }
                        minWrapOffset = -1;
                        maxWrapOffset = -1;
                        x = lastSoftWrap.getIndentInPixels();
                        if (wrapOffset <= it.getElementStartOffset()) {
                            it.retreat(wrapOffset);
                            continue;
                        }
                    }
                }
            }
            it.advance();
        }
        this.myEvent.setActualEndOffset(maxEndOffset);
    }

    private SoftWrap createSoftWrap(SoftWrap lastSoftWrap, int minWrapOffset, int maxWrapOffset, boolean preferMinOffset, int nonWhitespaceStartOffset, float nonWhitespaceStartX) {
        int wrapOffset = minWrapOffset >= maxWrapOffset ? minWrapOffset : this.calcSoftWrapOffset(minWrapOffset, maxWrapOffset, preferMinOffset);
        int indentInColumns = 1;
        int indentInPixels = this.mySoftWrapWidth;
        if (this.myRelativeIndent >= 0) {
            if (lastSoftWrap == null) {
                if (nonWhitespaceStartOffset >= 0 && nonWhitespaceStartOffset < wrapOffset) {
                    indentInColumns += this.myEditor.offsetToLogicalPosition((int)nonWhitespaceStartOffset).column;
                    indentInPixels = (int)((float)indentInPixels + nonWhitespaceStartX);
                }
                indentInColumns += this.myRelativeIndent;
                indentInPixels = (int)((float)indentInPixels + (float)this.myRelativeIndent * this.myView.getPlainSpaceWidth());
            } else {
                indentInColumns = lastSoftWrap.getIndentInColumns();
                indentInPixels = lastSoftWrap.getIndentInPixels();
            }
        }
        SoftWrapImpl result2 = new SoftWrapImpl(new TextChangeImpl((CharSequence)("\n" + StringUtil.repeatSymbol((char)' ', (int)(indentInColumns - 1))), wrapOffset), indentInColumns, indentInPixels);
        this.myStorage.storeOrReplace(result2);
        return result2;
    }

    private int calcSoftWrapOffset(int minOffset, int maxOffset, boolean preferMinOffset) {
        int position2;
        if (this.myLineWrapPositionStrategy == null) {
            this.myLineWrapPositionStrategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor((Editor)this.myEditor);
        }
        if (!this.myEditor.getState().getDisableDefaultSoftWrapsCalculation() && (position2 = SoftWrapEngine.findWrapPosition(this.myText, maxOffset, minOffset, this.myLineWrapPositionStrategy)) != -1) {
            return position2;
        }
        int wrapOffset = this.myLineWrapPositionStrategy.calculateWrapPosition(this.myDocument, this.myEditor.getProject(), minOffset - 1, maxOffset + 1, maxOffset + 1, false, true);
        if (wrapOffset < 0) {
            return preferMinOffset ? minOffset : maxOffset;
        }
        if (wrapOffset < minOffset) {
            return minOffset;
        }
        if (wrapOffset > maxOffset) {
            return maxOffset;
        }
        if (DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)wrapOffset)) {
            return wrapOffset - 1;
        }
        return wrapOffset;
    }

    @ApiStatus.Internal
    public static int findWrapPosition(CharSequence text2, int maxOffset, int minOffset, LineWrapPositionStrategy strategy) {
        if (strategy.canWrapLineAtOffset(text2, maxOffset)) {
            return maxOffset;
        }
        int offset = maxOffset;
        for (int i2 = 0; i2 < 10 && offset >= minOffset; ++i2) {
            int prevOffset = Character.offsetByCodePoints(text2, offset, -1);
            if (strategy.canWrapLineAtOffset(text2, prevOffset)) {
                return offset;
            }
            offset = prevOffset;
        }
        return -1;
    }

    private int getEndOffsetUpperEstimate() {
        int endOffsetUpperEstimate = EditorUtil.getNotFoldedLineEndOffset(this.myEditor, this.myEvent.getMandatoryEndOffset());
        int line = this.myDocument.getLineNumber(endOffsetUpperEstimate);
        if (line < this.myDocument.getLineCount() - 1) {
            endOffsetUpperEstimate = this.myDocument.getLineStartOffset(line + 1);
        }
        return endOffsetUpperEstimate;
    }

    private void generateGridSoftWraps(CharacterGrid grid, int startOffset, int minEndOffset, int maxEndOffset) {
        int widthInColumns = grid.getColumns();
        int endOffset = maxEndOffset;
        int wrappedSoFar = 0;
        CharacterGridIterator it = grid.iterator(startOffset, maxEndOffset);
        while (!it.isAtEnd()) {
            int cellStartOffset = it.getCellStartOffset();
            int cellEndOffset = it.getCellEndOffset();
            int cellStartColumn = it.getCellStartColumn() - wrappedSoFar;
            int cellEndColumn = it.getCellEndColumn() - wrappedSoFar;
            if (it.isLineBreak()) {
                wrappedSoFar = 0;
                if (cellEndOffset > minEndOffset) {
                    endOffset = cellEndOffset;
                    break;
                }
            } else if (cellEndColumn > widthInColumns) {
                wrappedSoFar += cellStartColumn;
                SoftWrapImpl softWrap = this.createGridSoftWrap(cellStartOffset);
                if (cellStartOffset > minEndOffset && this.myDataMapper.matchesOldSoftWrap(softWrap, this.myEvent.getLengthDiff())) {
                    endOffset = cellStartOffset;
                    break;
                }
            }
            it.advance();
        }
        this.myEvent.setActualEndOffset(endOffset);
    }

    @NotNull
    private SoftWrapImpl createGridSoftWrap(int offset) {
        SoftWrapImpl result2 = new SoftWrapImpl(new TextChangeImpl((CharSequence)"\n", offset), 1, this.mySoftWrapWidth);
        this.myStorage.storeOrReplace(result2);
        SoftWrapImpl softWrapImpl = result2;
        if (softWrapImpl == null) {
            SoftWrapEngine.$$$reportNull$$$0(5);
        }
        return softWrapImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataMapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/SoftWrapEngine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/SoftWrapEngine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createGridSoftWrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

