/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.LanguageSyntaxHighlighters;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterLanguageFactory;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001#B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u0010J*\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00160\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001bH\u0014J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001eH\u0014J\b\u0010\"\u001a\u00020\u0012H\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "connection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "asyncLoader", "Lcom/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/util/messages/SimpleMessageBusConnection;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader;)V", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/vfs/VirtualFile;)V", "updateHighlightersOnExtensionChange", "", "T", "epName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/KeyedLazyInstance;", "checkUpdateHighlighters", "key", "", "updateSynchronously", "", "updateHighlighters", "createHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "forceEmpty", "setupHighlighter", "highlighter", "updateHighlightersSynchronously", "MyFileTypeListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class EditorHighlighterUpdater {
    @JvmField
    @NotNull
    protected final Project project;
    @JvmField
    @NotNull
    protected final EditorEx editor;
    @Nullable
    private final VirtualFile file;
    @Nullable
    private final AsyncEditorLoader asyncLoader;

    public EditorHighlighterUpdater(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull SimpleMessageBusConnection connection, @NotNull EditorEx editor2, @Nullable VirtualFile file2, @Nullable AsyncEditorLoader asyncLoader) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.project = project2;
        this.editor = editor2;
        this.file = file2;
        this.asyncLoader = asyncLoader;
        Topic topic = FileTypeManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new MyFileTypeListener());
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                this.updateHighlighters();
            }

            public void exitDumbMode() {
                this.updateHighlighters();
            }
        });
        ExtensionPointName extensionPointName = LanguageSyntaxHighlighters.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"EP_NAME");
        this.updateHighlightersOnExtensionChange(parentDisposable, extensionPointName);
        ExtensionPointName extensionPointName2 = SyntaxHighlighterLanguageFactory.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName2, (String)"EP_NAME");
        this.updateHighlightersOnExtensionChange(parentDisposable, extensionPointName2);
        ExtensionPointName extensionPointName3 = FileTypeEditorHighlighterProviders.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName3, (String)"EP_NAME");
        this.updateHighlightersOnExtensionChange(parentDisposable, extensionPointName3);
        SyntaxHighlighter.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedFactoryEPBean>(){

            public void extensionAdded(KeyedFactoryEPBean extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String string = extension.key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                this.checkUpdateHighlighters(string, false);
            }

            public void extensionRemoved(KeyedFactoryEPBean extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String string = extension.key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                this.checkUpdateHighlighters(string, true);
            }
        }, parentDisposable);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                ClassLoader pluginClassLoader;
                IdeaPluginDescriptor loadedPluginDescriptor;
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                IdeaPluginDescriptor ideaPluginDescriptor = loadedPluginDescriptor = PluginManagerCore.getPlugin((PluginId)pluginDescriptor.getPluginId());
                ClassLoader classLoader = pluginClassLoader = ideaPluginDescriptor != null ? ideaPluginDescriptor.getPluginClassLoader() : null;
                if (file != null && pluginClassLoader instanceof PluginAwareClassLoader) {
                    FileType fileType2 = file.getFileType();
                    Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
                    FileType fileType3 = fileType2;
                    if (fileType3.getClass().getClassLoader() == pluginClassLoader || fileType3 instanceof LanguageFileType && fileType3.getClass().getClassLoader() == pluginClassLoader) {
                        this.setupHighlighter(this.createHighlighter(true));
                    }
                }
            }
        });
    }

    public EditorHighlighterUpdater(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull EditorEx editor2, @Nullable VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this(project2, parentDisposable, (SimpleMessageBusConnection)project2.getMessageBus().connect(parentDisposable), editor2, file2, null);
    }

    private final <T> void updateHighlightersOnExtensionChange(Disposable parentDisposable, ExtensionPointName<KeyedLazyInstance<T>> epName) {
        epName.addExtensionPointListener(new ExtensionPointListener<KeyedLazyInstance<T>>(this){
            final /* synthetic */ EditorHighlighterUpdater this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionAdded(KeyedLazyInstance<T> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String string = extension.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                EditorHighlighterUpdater.access$checkUpdateHighlighters(this.this$0, string, false);
            }

            public void extensionRemoved(KeyedLazyInstance<T> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String string = extension.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                EditorHighlighterUpdater.access$checkUpdateHighlighters(this.this$0, string, true);
            }
        }, parentDisposable);
    }

    private final void checkUpdateHighlighters(String key, boolean updateSynchronously) {
        if (this.file != null) {
            boolean needUpdate;
            FileType fileType2 = this.file.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
            FileType fileType3 = fileType2;
            boolean bl = needUpdate = Intrinsics.areEqual((Object)fileType3.getName(), (Object)key) || fileType3 instanceof LanguageFileType && Intrinsics.areEqual((Object)((LanguageFileType)fileType3).getLanguage().getID(), (Object)key);
            if (!needUpdate) {
                return;
            }
        }
        if (updateSynchronously && ApplicationManager.getApplication().isDispatchThread()) {
            this.updateHighlightersSynchronously();
        } else {
            this.updateHighlighters();
        }
    }

    public final void updateHighlighters() {
        if (this.project.isDisposed() || this.editor.isDisposed()) {
            return;
        }
        if (this.asyncLoader != null && !this.asyncLoader.isLoaded()) {
            return;
        }
        Object[] objectArray = new Object[]{EditorHighlighterUpdater.class, this.editor};
        ReadAction.nonBlocking(() -> EditorHighlighterUpdater.updateHighlighters$lambda$0(this)).expireWith((Disposable)this.project).expireWhen(() -> EditorHighlighterUpdater.updateHighlighters$lambda$1(this)).coalesceBy(objectArray).finishOnUiThread(ModalityState.any(), arg_0 -> EditorHighlighterUpdater.updateHighlighters$lambda$2((Function1)new Function1<EditorHighlighter, Unit>((Object)this){

            public final void invoke(EditorHighlighter p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((EditorHighlighterUpdater)this.receiver).setupHighlighter(p0);
            }
        }, arg_0)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    @NotNull
    protected EditorHighlighter createHighlighter(boolean forceEmpty) {
        EditorHighlighter highlighter = this.file != null && !forceEmpty ? EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(this.project, this.file) : (EditorHighlighter)new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), HighlighterColors.TEXT);
        highlighter.setText(this.editor.getDocument().getImmutableCharSequence());
        return highlighter;
    }

    protected void setupHighlighter(@NotNull EditorHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.editor.setHighlighter(highlighter);
    }

    private final void updateHighlightersSynchronously() {
        if (!(this.project.isDisposed() || this.editor.isDisposed() || this.asyncLoader != null && !this.asyncLoader.isLoaded())) {
            this.setupHighlighter(this.createHighlighter(false));
        }
    }

    private static final EditorHighlighter updateHighlighters$lambda$0(EditorHighlighterUpdater this$0) {
        return this$0.createHighlighter(false);
    }

    private static final boolean updateHighlighters$lambda$1(EditorHighlighterUpdater this$0) {
        return this$0.file != null && !this$0.file.isValid() || this$0.editor.isDisposed();
    }

    private static final void updateHighlighters$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater$MyFileTypeListener;", "Lcom/intellij/openapi/fileTypes/FileTypeListener;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater;)V", "fileTypesChanged", "", "event", "Lcom/intellij/openapi/fileTypes/FileTypeEvent;", "intellij.platform.ide.impl"})
    private final class MyFileTypeListener
    implements FileTypeListener {
        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ThreadingAssertions.assertEventDispatchThread();
            FileType type = event.getRemovedFileType();
            if (type != null && !(type instanceof AbstractFileType)) {
                EditorHighlighterUpdater.this.updateHighlightersSynchronously();
            } else {
                EditorHighlighterUpdater.this.updateHighlighters();
            }
        }
    }
}

